/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;

public class KotlinRunConfigurationEditor
extends SettingsEditor<KotlinRunConfiguration>
implements PanelWithAnchor {
    private JPanel mainPanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> mainClass;
    private CommonJavaParametersPanel commonProgramParameters;
    private LabeledComponent<ModuleDescriptionsComboBox> moduleChooser;
    private JrePathEditor jrePathEditor;
    private LabeledComponent<ShortenCommandLineModeCombo> shortenClasspathModeCombo;
    private final ConfigurationModuleSelector moduleSelector;
    private JComponent anchor;
    private final Project project;

    private static ClassBrowser createApplicationClassBrowser(Project project2, ConfigurationModuleSelector moduleSelector) {
        final ClassFilter applicationClass = new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return aClass instanceof KtLightClass && ConfigurationUtil.MAIN_CLASS.value((Object)aClass) && this.findMainMethod(aClass) != null;
            }

            @Nullable
            private PsiMethod findMainMethod(PsiClass aClass) {
                return (PsiMethod)ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)aClass));
            }
        };
        return new ClassBrowser.MainClassBrowser(project2, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            protected ClassFilter createFilter(Module module2) {
                return applicationClass;
            }
        };
    }

    public KotlinRunConfigurationEditor(Project project2) {
        this.project = project2;
        this.$$$setupUI$$$();
        this.moduleSelector = new ConfigurationModuleSelector(project2, (ModuleDescriptionsComboBox)this.moduleChooser.getComponent());
        this.jrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies((ModuleDescriptionsComboBox)((ModuleDescriptionsComboBox)this.moduleChooser.getComponent()), (boolean)false));
        this.commonProgramParameters.setModuleContext(this.moduleSelector.getModule());
        ((ModuleDescriptionsComboBox)this.moduleChooser.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinRunConfigurationEditor.this.commonProgramParameters.setModuleContext(KotlinRunConfigurationEditor.this.moduleSelector.getModule());
            }
        });
        KotlinRunConfigurationEditor.createApplicationClassBrowser(project2, this.moduleSelector).setField((ComponentWithBrowseButton)this.mainClass.getComponent());
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.mainClass, this.commonProgramParameters, this.jrePathEditor, this.jrePathEditor, this.moduleChooser, this.shortenClasspathModeCombo});
        this.shortenClasspathModeCombo.setComponent((JComponent)new ShortenCommandLineModeCombo(project2, this.jrePathEditor, (ModuleDescriptionsComboBox)this.moduleChooser.getComponent()));
    }

    protected void applyEditorTo(KotlinRunConfiguration configuration2) {
        this.commonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.applyTo((ModuleBasedConfiguration)configuration2);
        String className2 = ((EditorTextFieldWithBrowseButton)this.mainClass.getComponent()).getText();
        PsiClass aClass = this.moduleSelector.findClass(className2);
        configuration2.setRunClass(aClass != null ? JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass) : className2);
        configuration2.setAlternativeJrePath(this.jrePathEditor.getJrePathOrName());
        configuration2.setAlternativeJrePathEnabled(this.jrePathEditor.isAlternativeJreSelected());
        configuration2.setShortenCommandLine(((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).getSelectedItem());
    }

    protected void resetEditorFrom(KotlinRunConfiguration configuration2) {
        this.commonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration2);
        this.moduleSelector.reset((ModuleBasedConfiguration)configuration2);
        String runClass = configuration2.getRunClass();
        ((EditorTextFieldWithBrowseButton)this.mainClass.getComponent()).setText(runClass != null ? runClass.replaceAll("\\$", "\\.") : "");
        this.jrePathEditor.setPathOrName(configuration2.getAlternativeJrePath(), configuration2.isAlternativeJrePathEnabled());
        ((ShortenCommandLineModeCombo)this.shortenClasspathModeCombo.getComponent()).setSelectedItem((Object)configuration2.getShortenCommandLine());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel2 = this.mainPanel;
        if (jPanel2 == null) {
            KotlinRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return jPanel2;
    }

    private void createUIComponents() {
        this.mainClass = new LabeledComponent();
        this.mainClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.project, true, (declaration2, place) -> {
            KtLightClass aClass;
            if (declaration2 instanceof KtLightClass && ConfigurationUtil.MAIN_CLASS.value((Object)(aClass = (KtLightClass)declaration2)) && (PsiMethodUtil.findMainMethod((PsiClass)aClass) != null || place.getParent() != null) && this.moduleSelector.findClass(((PsiClass)declaration2).getQualifiedName()) != null) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }));
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mainClass.setAnchor(anchor);
        this.commonProgramParameters.setAnchor(anchor);
        this.jrePathEditor.setAnchor(anchor);
        this.moduleChooser.setAnchor(anchor);
        this.shortenClasspathModeCombo.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent2;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent3 = this.mainClass;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.main.class.label"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(-1, 20), null));
        this.commonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel2.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.moduleChooser = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.jrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel2.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.shortenClasspathModeCombo = labeledComponent = new LabeledComponent();
        labeledComponent.setEnabled(true);
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", KotlinRunConfigurationEditor.class).getString("application.configuration.shorten.command.line.label"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/KotlinRunConfigurationEditor", "createEditor"));
    }
}

