/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getPlatform", "Companion", "kotlin.core"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final StringEventField systemField;
    private static final StringEventField platformField;
    private static final BooleanEventField isMPPBuild;
    private static final PrimitiveEventField<PluginInfo> pluginInfoField;
    private static final VarargEventId buildEvent;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Set metrics = new LinkedHashSet();
        List list2 = ProjectFacetManager.getInstance((Project)project2).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ProjectFacetManager.getI\u2026(KotlinFacetType.TYPE_ID)");
        List modulesWithFacet = list2;
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)KotlinPluginUtil.INSTANCE.getKOTLIN_PLUGIN_ID());
        Collection collection = modulesWithFacet;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                Module module2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"it");
                String buildSystem2 = this.getBuildSystemType(module2);
                String platform2 = this.getPlatform(it);
                metrics.add(buildEvent.metric(new EventPair[]{systemField.with((Object)buildSystem2), platformField.with((Object)platform2), isMPPBuild.with((Object)(MultiplatformUtilKt.isMPPModule(it) || MultiplatformUtilKt.isNewMPPModule(it) ? 1 : 0)), pluginInfoField.with((Object)pluginInfo)}));
            }
        }
        return metrics;
    }

    private final String getPlatform(Module it) {
        Object object;
        if (JvmPlatformKt.isJvm((TargetPlatform)PlatformKt.getPlatform(it))) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            object = StringsKt.contains$default((CharSequence)string, (CharSequence)"android", (boolean)false, (int)2, null) ? "jvm.android" : "jvm";
        } else if (JsPlatformKt.isJs((TargetPlatform)PlatformKt.getPlatform(it))) {
            object = "js";
        } else if (TargetPlatformKt.isCommon((TargetPlatform)PlatformKt.getPlatform(it))) {
            object = "common";
        } else if (NativePlatformKt.isNative((TargetPlatform)PlatformKt.getPlatform(it))) {
            Object object2 = PlatformKt.getPlatform(it);
            if (object2 == null || (object2 = object2.getComponentPlatforms()) == null || (object2 = (SimplePlatform)CollectionsKt.first((Iterable)((Iterable)object2))) == null || (object2 = object2.getTargetName()) == null) {
                object2 = "unknown";
            }
            object = "native." + (String)object2;
        } else {
            object = "unknown";
        }
        return object;
    }

    private final String getBuildSystemType(Module it) {
        String string;
        BuildSystemType buildSystem2 = BuildSystemTypeKt.getBuildSystemType(it);
        if (buildSystem2 == BuildSystemType.JPS) {
            string = "JPS";
        } else {
            String string2 = buildSystem2.toString();
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string = "Maven";
            } else {
                string2 = buildSystem2.toString();
                String string4 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase()");
                string = StringsKt.contains$default((CharSequence)string4, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("kotlin.project.configuration", 6);
        systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])new String[]{"JPS", "Maven", "Gradle", "unknown"}));
        platformField = EventFields.String((String)"platform", (List)ProjectConfigurationCollector.Companion.composePlatformFields());
        isMPPBuild = EventFields.Boolean((String)"isMPP");
        pluginInfoField = EventFields.PluginInfo;
        buildEvent = GROUP.registerVarargEvent("Build", new EventField[]{(EventField)systemField, (EventField)platformField, (EventField)isMPPBuild, (EventField)pluginInfoField});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "isMPPBuild", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "platformField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "systemField", "composePlatformFields", "", "", "kotlin.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<String> composePlatformFields() {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new List[2];
            objectArray[0] = CollectionsKt.listOf((Object[])new String[]{"jvm", "jvm.android", "js", "common", "native.unknown", "unknown"});
            Iterable iterable = KonanTarget.Companion.getPredefinedTargets().keySet();
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            boolean $i$f$map = false;
            void var3_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = "native." + (String)it;
                collection.add((CallSite)((Object)string2));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray3));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

