/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.sh.run.ShRunConfigurationProducer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

final class ShRunFileAction
extends DumbAwareAction {
    static final String ID = "runShellFileAction";

    ShRunFileAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ShRunConfiguration runConfiguration;
        PsiFile file;
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(0);
        }
        if ((file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext(), (String)e.getPlace());
        ShRunConfigurationProducer configProducer = (ShRunConfigurationProducer)RunConfigurationProducer.getInstance(ShRunConfigurationProducer.class);
        RunnerAndConfigurationSettings configurationSettings = configProducer.findExistingConfiguration(context);
        if (configurationSettings == null) {
            configurationSettings = RunManager.getInstance((Project)project).createConfiguration(file.getName(), ShConfigurationType.class);
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
            runConfiguration.setScriptPath(virtualFile.getPath());
            runConfiguration.setExecuteScriptFile(true);
            runConfiguration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
            if (file instanceof ShFile) {
                @NlsSafe String defaultShell = (String)ObjectUtils.notNull((Object)ShConfigurationType.getDefaultShell(), (Object)"/bin/sh");
                String shebang = ShShebangParserUtil.getShebangExecutable((ShFile)file);
                if (shebang != null) {
                    Pair<String, String> result = ShRunFileAction.parseInterpreterAndOptions(shebang);
                    runConfiguration.setInterpreterPath((String)result.first);
                    runConfiguration.setInterpreterOptions((String)result.second);
                } else {
                    runConfiguration.setInterpreterPath(defaultShell);
                }
            } else {
                runConfiguration.setInterpreterPath("");
            }
        } else {
            runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)runConfiguration);
        if (builder != null) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(ShRunFileAction.isEnabled(e));
    }

    @NotNull
    private static Pair<String, String> parseInterpreterAndOptions(@NotNull String shebang) {
        String shebangParam;
        String[] splitShebang;
        if (shebang == null) {
            ShRunFileAction.$$$reportNull$$$0(2);
        }
        if ((splitShebang = shebang.split(" ")).length > 1 && !(shebangParam = splitShebang[splitShebang.length - 1]).contains("/") && !shebangParam.contains("\\")) {
            Pair pair = Pair.create((Object)shebang.substring(0, shebang.length() - shebangParam.length() - 1), (Object)shebangParam);
            if (pair == null) {
                ShRunFileAction.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)shebang, (Object)"");
        if (pair == null) {
            ShRunFileAction.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        PsiFile file;
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(5);
        }
        if (e.getProject() != null && (file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null) {
            if (file instanceof ShFile) {
                return true;
            }
            PsiElement firstChild = file.findElementAt(0);
            return firstChild instanceof PsiComment && firstChild.getText().startsWith("#!");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shebang";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunFileAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInterpreterAndOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseInterpreterAndOptions";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

