/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.ListEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.RegexpIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDataType;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0007J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0007J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J?\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001f2\u0006\u0010 \u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J.\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J2\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventsSchemeBuilder;", "", "()V", "classValidationRuleNames", "", "", "classValidationRules", "", "pluginInfoFields", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDescriptor;", "getPluginInfoFields", "()Ljava/util/Set;", "buildEventsScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "pluginId", "buildFieldDescriptors", "fieldName", "validationRules", "fieldDataType", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDataType;", "buildFields", "events", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "eventName", "groupId", "buildObjectEvenScheme", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;Ljava/lang/String;Ljava/lang/String;)Ljava/util/Set;", "collectGroupsFromExtensions", "", "groupType", "collectors", "", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "defineDataType", "values", "name", "fieldSchema", "field", "validateGroupId", "", "collector", "validateRegexp", "regexp", "intellij.platform.statistics"})
public final class EventsSchemeBuilder {
    @NotNull
    private static final Set<FieldDescriptor> pluginInfoFields;
    private static final Set<String> classValidationRuleNames;
    private static final List<String> classValidationRules;
    @NotNull
    public static final EventsSchemeBuilder INSTANCE;

    @NotNull
    public final Set<FieldDescriptor> getPluginInfoFields() {
        return pluginInfoFields;
    }

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName, String eventName, String groupId) {
        Set<FieldDescriptor> set;
        if (StringsKt.contains$default((CharSequence)field.getName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            throw (Throwable)new IllegalStateException("Field name should not contains dots, because dots are used to express hierarchy. Group=" + groupId + ", event=" + eventName + ", field=" + field.getName());
        }
        EventField<?> eventField = field;
        if (Intrinsics.areEqual(eventField, EventFields.PluginInfo) || Intrinsics.areEqual(eventField, EventFields.PluginInfoFromInstance) || Intrinsics.areEqual(eventField, EventFields.PluginInfoByDescriptor)) {
            set = pluginInfoFields;
        } else if (eventField instanceof ObjectEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ObjectListEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectListEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ListEventField) {
            if (field instanceof StringListEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringListEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            set = this.buildFieldDescriptors(fieldName, ((ListEventField)field).getValidationRule(), FieldDataType.ARRAY);
        } else if (eventField instanceof PrimitiveEventField) {
            if (field instanceof StringEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            if (field instanceof RegexpIntEventField) {
                this.validateRegexp(((RegexpIntEventField)field).getRegexp());
            }
            set = this.buildFieldDescriptors(fieldName, ((PrimitiveEventField)field).getValidationRule(), FieldDataType.PRIMITIVE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final Set<FieldDescriptor> buildFieldDescriptors(String fieldName, List<String> validationRules, FieldDataType fieldDataType) {
        boolean bl;
        Set fields;
        block4: {
            fields = SetsKt.mutableSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toSet((Iterable)validationRules), fieldDataType)});
            Iterable $this$any$iv = validationRules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!classValidationRules.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            fields.addAll((Collection)pluginInfoFields);
        }
        return fields;
    }

    private final void validateRegexp(String regexp) {
        if (Intrinsics.areEqual((Object)regexp, (Object)".*")) {
            throw (Throwable)new IllegalStateException("Regexp should be more strict to prevent accidentally reporting sensitive data.");
        }
        Pattern.compile(regexp);
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, EventField<?>[] fields, String eventName, String groupId) {
        Set fieldsDescriptors = new LinkedHashSet();
        for (EventField<?> eventField : fields) {
            fieldsDescriptors.addAll((Collection)this.fieldSchema(eventField, fieldName + "." + eventField.getName(), eventName, groupId));
        }
        return fieldsDescriptors;
    }

    @JvmStatic
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme() {
        return EventsSchemeBuilder.buildEventsScheme(null);
    }

    @JvmStatic
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme(@Nullable String pluginId) {
        List result = new ArrayList();
        List<FeatureUsagesCollector> list = FUCounterUsageLogger.instantiateCounterCollectors(pluginId);
        Intrinsics.checkNotNullExpressionValue(list, (String)"FUCounterUsageLogger.ins\u2026unterCollectors(pluginId)");
        List<FeatureUsagesCollector> counterCollectors = list;
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("counter", (Collection<? extends FeatureUsagesCollector>)counterCollectors));
        ArrayList stateCollectors = new ArrayList();
        ApplicationUsagesCollector.EP_NAME.processWithPluginDescriptor(new BiConsumer(pluginId, stateCollectors){
            final /* synthetic */ String $pluginId;
            final /* synthetic */ ArrayList $stateCollectors;

            public final void accept(ApplicationUsagesCollector collector, PluginDescriptor descriptor) {
                block3: {
                    block2: {
                        if (this.$pluginId == null) break block2;
                        PluginDescriptor pluginDescriptor = descriptor;
                        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"descriptor");
                        PluginId pluginId = pluginDescriptor.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
                        if (!Intrinsics.areEqual((Object)this.$pluginId, (Object)pluginId.getIdString())) break block3;
                    }
                    this.$stateCollectors.add(collector);
                }
            }
            {
                this.$pluginId = string;
                this.$stateCollectors = arrayList;
            }
        });
        ProjectUsagesCollector.EP_NAME.processWithPluginDescriptor(new BiConsumer(pluginId, stateCollectors){
            final /* synthetic */ String $pluginId;
            final /* synthetic */ ArrayList $stateCollectors;

            public final void accept(ProjectUsagesCollector collector, PluginDescriptor descriptor) {
                block3: {
                    block2: {
                        if (this.$pluginId == null) break block2;
                        PluginDescriptor pluginDescriptor = descriptor;
                        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"descriptor");
                        PluginId pluginId = pluginDescriptor.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"descriptor.pluginId");
                        if (!Intrinsics.areEqual((Object)this.$pluginId, (Object)pluginId.getIdString())) break block3;
                    }
                    this.$stateCollectors.add(collector);
                }
            }
            {
                this.$pluginId = string;
                this.$stateCollectors = arrayList;
            }
        });
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("state", stateCollectors));
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    T receiver = a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((GroupDescriptor)receiver).getId());
                    receiver = b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string = ((GroupDescriptor)receiver).getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GroupDescriptor> collectGroupsFromExtensions(@NotNull String groupType, @NotNull Collection<? extends FeatureUsagesCollector> collectors) {
        Intrinsics.checkNotNullParameter((Object)groupType, (String)"groupType");
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        List result = new ArrayList();
        for (FeatureUsagesCollector featureUsagesCollector : collectors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            Object $this$getOrPut$iv$iv$iv;
            boolean bl;
            void $this$groupByTo$iv$iv;
            EventLogGroup group;
            Class<?> collectorClass = featureUsagesCollector.getClass().getEnclosingClass() != null ? featureUsagesCollector.getClass().getEnclosingClass() : featureUsagesCollector.getClass();
            this.validateGroupId(featureUsagesCollector);
            if (featureUsagesCollector.getGroup() == null) {
                continue;
            }
            Object $this$groupBy$iv = group.getEvents();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv) {
                Object object;
                BaseEventId it = (BaseEventId)t;
                bl = false;
                String key$iv$iv = it.getEventId();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(t);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                void eventName;
                void $dstr$eventName$events;
                list$iv$iv = entry;
                Object object = destination$iv$iv;
                bl = false;
                void var18_20 = $dstr$eventName$events;
                $this$getOrPut$iv$iv$iv = (String)var18_20.getKey();
                var18_20 = $dstr$eventName$events;
                List events = (List)var18_20.getValue();
                EventDescriptor eventDescriptor = new EventDescriptor((String)eventName, INSTANCE.buildFields(events, (String)eventName, group.getId()));
                object.add(eventDescriptor);
            }
            Set eventsDescriptors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String string = group.getId();
            int n = group.getVersion();
            Class<?> clazz = collectorClass;
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"collectorClass");
            String string2 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collectorClass.name");
            GroupDescriptor groupDescriptor = new GroupDescriptor(string, groupType, n, eventsDescriptors, string2);
            result.add(groupDescriptor);
        }
        return result;
    }

    private final void validateGroupId(FeatureUsagesCollector collector) {
        try {
            collector.getGroupId();
        }
        catch (IllegalStateException e) {
            throw (Throwable)new IllegalStateException(e.getMessage() + " in " + collector.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FieldDescriptor> buildFields(List<? extends BaseEventId> events, String eventName, String groupId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        String key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Object list$iv$iv;
        boolean bl;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = events;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            it = (BaseEventId)t;
            bl = false;
            list$iv$iv = ((BaseEventId)it).getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            EventField field = (EventField)t;
            bl = false;
            list$iv$iv = INSTANCE.fieldSchema(field, field.getName(), eventName, groupId);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (FieldDescriptor)t;
            bl = false;
            key$iv$iv = ((FieldDescriptor)it).getPath();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            void name;
            void $dstr$name$values;
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            key$iv$iv = $dstr$name$values;
            $this$getOrPut$iv$iv$iv = (String)key$iv$iv.getKey();
            key$iv$iv = $dstr$name$values;
            List values = (List)key$iv$iv.getValue();
            FieldDataType type = INSTANCE.defineDataType(values, (String)name, eventName, groupId);
            value$iv$iv$iv = values;
            void var17_24 = name;
            boolean $i$f$flatMap2 = false;
            void var19_27 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                FieldDescriptor it2 = (FieldDescriptor)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv2 = it2.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            FieldDataType fieldDataType = type;
            Set set = CollectionsKt.toSet((Iterable)list);
            void var31_39 = var17_24;
            FieldDescriptor fieldDescriptor = new FieldDescriptor((String)var31_39, set, fieldDataType);
            object.add(fieldDescriptor);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final FieldDataType defineDataType(List<FieldDescriptor> values, String name, String eventName, String groupId) {
        boolean bl;
        FieldDataType dataType;
        block4: {
            dataType = ((FieldDescriptor)CollectionsKt.first(values)).getDataType();
            Iterable $this$any$iv = values;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FieldDescriptor it = (FieldDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDataType() != dataType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new IllegalStateException("Field couldn't have multiple types (group=" + groupId + ", event=" + eventName + ", field=" + name + ")");
        }
        return dataType;
    }

    private EventsSchemeBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        EventsSchemeBuilder eventsSchemeBuilder;
        INSTANCE = eventsSchemeBuilder = new EventsSchemeBuilder();
        pluginInfoFields = SetsKt.setOf((Object[])new FieldDescriptor[]{new FieldDescriptor("plugin", SetsKt.setOf((Object)"{util#plugin}"), null, 4, null), new FieldDescriptor("plugin_type", SetsKt.setOf((Object)"{util#plugin_type}"), null, 4, null), new FieldDescriptor("plugin_version", SetsKt.setOf((Object)"{util#plugin_version}"), null, 4, null)});
        classValidationRuleNames = SetsKt.setOf((Object[])new String[]{"class_name", "dialog_class", "quick_fix_class_name", "run_config_factory", "tip_info", "run_config_factory", "run_config_id", "facets_type", "registry_key"});
        Iterable $this$map$iv = classValidationRuleNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = "{util#" + (String)it + "}";
            collection.add(string2);
        }
        classValidationRules = (List)destination$iv$iv;
    }
}

