/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerContributor;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerGoToAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDeclaredDependency", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "getModule", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Module;", "getParentModule", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "getUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Artifact;", "update", "intellij.gradle.common"})
public final class GradleDependencyAnalyzerGoToAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DeclaredDependency declaredDependency = this.getDeclaredDependency(e);
        if (declaredDependency == null) {
            return;
        }
        DeclaredDependency dependency = declaredDependency;
        PsiElement psiElement = dependency.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        PsiNavigationSupport navigationSupport = PsiNavigationSupport.getInstance();
        Navigatable navigatable = navigationSupport.getDescriptor(psiElement2);
        if (navigatable == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"navigationSupport.getDes\u2026tor(psiElement) ?: return");
        Navigatable navigatable2 = navigatable;
        if (navigatable2.canNavigate()) {
            navigatable2.navigate(true);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectSystemId systemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(Intrinsics.areEqual((Object)systemId, (Object)GradleConstants.SYSTEM_ID) && this.getDeclaredDependency(e) != null);
    }

    private final DeclaredDependency getDeclaredDependency(AnActionEvent e) {
        Object v4;
        block5: {
            Iterable iterable;
            Project project = e.getProject();
            if (project == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return null");
            Project project2 = project;
            DependencyAnalyzerDependency dependencyAnalyzerDependency = (DependencyAnalyzerDependency)e.getData(DependencyAnalyzerView.Companion.getDEPENDENCY());
            if (dependencyAnalyzerDependency == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)dependencyAnalyzerDependency, (String)"e.getData(DependencyAnal\u2026EPENDENCY) ?: return null");
            DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
            UnifiedCoordinates unifiedCoordinates = this.getUnifiedCoordinates(dependency);
            if (unifiedCoordinates == null) {
                return null;
            }
            UnifiedCoordinates coordinates = unifiedCoordinates;
            Module module = this.getParentModule(project2, dependency);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            DependencyModifierService dependencyModifierService = DependencyModifierService.Companion.getInstance(project2);
            Iterable iterable2 = iterable = (Iterable)dependencyModifierService.declaredDependencies(module2);
            for (Object t : iterable2) {
                DeclaredDependency it = (DeclaredDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCoordinates(), (Object)coordinates)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        return v4;
    }

    private final UnifiedCoordinates getUnifiedCoordinates(DependencyAnalyzerDependency dependency) {
        UnifiedCoordinates unifiedCoordinates;
        DependencyAnalyzerDependency.Data data = dependency.getData();
        if (data instanceof DependencyAnalyzerDependency.Data.Artifact) {
            unifiedCoordinates = this.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Artifact)data);
        } else if (data instanceof DependencyAnalyzerDependency.Data.Module) {
            unifiedCoordinates = this.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Module)data);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unifiedCoordinates;
    }

    private final UnifiedCoordinates getUnifiedCoordinates(DependencyAnalyzerDependency.Data.Artifact data) {
        return new UnifiedCoordinates(data.getGroupId(), data.getArtifactId(), data.getVersion());
    }

    private final UnifiedCoordinates getUnifiedCoordinates(DependencyAnalyzerDependency.Data.Module data) {
        ModuleData moduleData = (ModuleData)data.getUserData(GradleDependencyAnalyzerContributor.Companion.getMODULE_DATA$intellij_gradle_common());
        if (moduleData == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)moduleData, (String)"data.getUserData(MODULE_DATA) ?: return null");
        ModuleData moduleData2 = moduleData;
        return new UnifiedCoordinates(moduleData2.getGroup(), moduleData2.getExternalName(), moduleData2.getVersion());
    }

    private final Module getParentModule(Project project, DependencyAnalyzerDependency dependency) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = dependency.getParent();
        Object object = dependencyAnalyzerDependency != null ? dependencyAnalyzerDependency.getData() : null;
        if (!(object instanceof DependencyAnalyzerDependency.Data.Module)) {
            object = null;
        }
        DependencyAnalyzerDependency.Data.Module module = (DependencyAnalyzerDependency.Data.Module)object;
        if (module == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data.Module parentData = module;
        return this.getModule(project, parentData);
    }

    private final Module getModule(Project project, DependencyAnalyzerDependency.Data.Module data) {
        ModuleData moduleData = (ModuleData)data.getUserData(GradleDependencyAnalyzerContributor.Companion.getMODULE_DATA$intellij_gradle_common());
        if (moduleData == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)moduleData, (String)"data.getUserData(MODULE_DATA) ?: return null");
        ModuleData moduleData2 = moduleData;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleData2.getIdeGrouping());
    }

    public GradleDependencyAnalyzerGoToAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setIcon((Icon)null);
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setText(ExternalSystemBundle.message((String)"external.system.dependency.analyzer.go.to", (Object[])new Object[]{"build.gradle"}));
    }
}

