/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.plugins.github.authentication.GHOAuthCredentialsAcquirer;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "()V", "name", "", "getName", "()Ljava/lang/String;", "authorize", "Ljava/util/concurrent/CompletableFuture;", "revokeToken", "", "token", "Companion", "GHOAuthRequest", "intellij.vcs.github"})
public final class GHOAuthService
extends OAuthServiceBase<Credentials> {
    private static final String SERVICE_NAME = "github/oauth";
    @NotNull
    private static final Url SERVICE_URL;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return SERVICE_NAME;
    }

    @NotNull
    public final CompletableFuture<Credentials> authorize() {
        return this.authorize(new GHOAuthRequest());
    }

    public void revokeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = "Not yet implemented";
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)string));
    }

    static {
        Companion = new Companion(null);
        SERVICE_URL = Urls.newFromEncoded((String)"https://account.jetbrains.com/github/oauth/intellij");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$GHOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "()V", "authUrlWithParameters", "Lcom/intellij/util/Url;", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "codeChallenge", "", "codeVerifier", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "port", "", "getPort", "()I", "Companion", "intellij.vcs.github"})
    private static final class GHOAuthRequest
    implements OAuthRequest<Credentials> {
        private final String codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
        private final String codeChallenge;
        @NotNull
        private final OAuthCredentialsAcquirer<Credentials> credentialsAcquirer;
        @NotNull
        private final Url authUrlWithParameters;
        @NotNull
        public static final Companion Companion = new Companion(null);

        private final int getPort() {
            return BuiltInServerManager.Companion.getInstance().getPort();
        }

        @NotNull
        public Url getAuthorizationCodeUrl() {
            return Urls.newFromEncoded((String)("http://127.0.0.1:" + this.getPort() + "/api/github/oauth/authorization_code"));
        }

        @NotNull
        public OAuthCredentialsAcquirer<Credentials> getCredentialsAcquirer() {
            return this.credentialsAcquirer;
        }

        @NotNull
        public Url getAuthUrlWithParameters() {
            return this.authUrlWithParameters;
        }

        public GHOAuthRequest() {
            Base64.Encoder encoder = Base64.getEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"Base64.getEncoder()");
            this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
            this.credentialsAcquirer = new GHOAuthCredentialsAcquirer(this.codeVerifier);
            Url url = GHOAuthRequest.Companion.getAUTHORIZE_URL().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"code_challenge", (Object)this.codeChallenge), TuplesKt.to((Object)"callback_url", (Object)this.getAuthorizationCodeUrl().toExternalForm())}));
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"AUTHORIZE_URL.addParamet\u2026l.toExternalForm()\n    ))");
            this.authUrlWithParameters = url;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$GHOAuthRequest$Companion;", "", "()V", "AUTHORIZE_URL", "Lcom/intellij/util/Url;", "getAUTHORIZE_URL", "()Lcom/intellij/util/Url;", "intellij.vcs.github"})
        public static final class Companion {
            private final Url getAUTHORIZE_URL() {
                Url url = GHOAuthService.Companion.getSERVICE_URL().resolve("authorize");
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"SERVICE_URL.resolve(\"authorize\")");
                return url;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$Companion;", "", "()V", "SERVICE_NAME", "", "SERVICE_URL", "Lcom/intellij/util/Url;", "getSERVICE_URL", "()Lcom/intellij/util/Url;", "instance", "Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "getInstance", "()Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHOAuthService getInstance() {
            boolean $i$f$service = false;
            Class<GHOAuthService> serviceClass$iv = GHOAuthService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
            }
            return (GHOAuthService)((Object)object);
        }

        @NotNull
        public final Url getSERVICE_URL() {
            return SERVICE_URL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

