/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.GHCompletableFutureLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingPanelFactory;
import org.jetbrains.plugins.github.pullrequest.ui.GHSimpleLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRListComponent;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRRepositorySelectorComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabComponentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabControllerImpl$ComponentController$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowViewType;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRViewComponentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRViewComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.create.GHPRCreateComponentHolder;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u000267B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020.H\u0016J(\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*H\u0002J\b\u00105\u001a\u00020.H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R/\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0013\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabControllerImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabController;", "project", "Lcom/intellij/openapi/project/Project;", "authManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "repositoryManager", "Lorg/jetbrains/plugins/github/util/GHProjectRepositoriesManager;", "dataContextRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "projectSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "tab", "Lcom/intellij/ui/content/Content;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/util/GHProjectRepositoriesManager;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;Lcom/intellij/ui/content/Content;)V", "componentController", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentController;", "getComponentController", "()Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentController;", "<set-?>", "Lcom/intellij/openapi/Disposable;", "contentDisposable", "getContentDisposable", "()Lcom/intellij/openapi/Disposable;", "setContentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "contentDisposable$delegate", "Lkotlin/properties/ReadWriteProperty;", "currentAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "currentRepository", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "initialView", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;", "getInitialView", "()Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;", "setInitialView", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;)V", "mainPanel", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "showingSelectors", "", "Ljava/lang/Boolean;", "canResetRemoteOrAccount", "resetRemoteAndAccount", "", "showPullRequestsComponent", "repositoryMapping", "account", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "force", "showSelectors", "ComponentController", "Updater", "intellij.vcs.github"})
public final class GHPRToolWindowTabControllerImpl
implements GHPRToolWindowTabController {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private GHGitRepositoryMapping currentRepository;
    private GithubAccount currentAccount;
    private final JComponent mainPanel;
    private final ReadWriteProperty contentDisposable$delegate;
    private Boolean showingSelectors;
    @NotNull
    private GHPRToolWindowViewType initialView;
    private final Project project;
    private final GithubAuthenticationManager authManager;
    private final GHProjectRepositoriesManager repositoryManager;
    private final GHPRDataContextRepository dataContextRepository;
    private final GithubPullRequestsProjectUISettings projectSettings;
    private final Content tab;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(GHPRToolWindowTabControllerImpl.class, "contentDisposable", "getContentDisposable()Lcom/intellij/openapi/Disposable;", 0))};
    }

    private final Disposable getContentDisposable() {
        return (Disposable)this.contentDisposable$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setContentDisposable(Disposable disposable) {
        this.contentDisposable$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)disposable);
    }

    @Override
    @NotNull
    public GHPRToolWindowViewType getInitialView() {
        return this.initialView;
    }

    @Override
    public void setInitialView(@NotNull GHPRToolWindowViewType gHPRToolWindowViewType) {
        Intrinsics.checkNotNullParameter((Object)((Object)gHPRToolWindowViewType), (String)"<set-?>");
        this.initialView = gHPRToolWindowViewType;
    }

    @Override
    @Nullable
    public GHPRToolWindowTabComponentController getComponentController() {
        for (Component component2 : this.mainPanel.getComponents()) {
            GHPRToolWindowTabComponentController controller = (GHPRToolWindowTabComponentController)UIUtil.getClientProperty((Object)component2, GHPRToolWindowTabComponentController.Companion.getKEY());
            if (controller == null) continue;
            return controller;
        }
        return null;
    }

    private final void showSelectors() {
        JComponent jComponent;
        if (Intrinsics.areEqual((Object)this.showingSelectors, (Object)true)) {
            return;
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        this.setContentDisposable(disposable2);
        this.tab.setDisplayName(GithubBundle.message("toolwindow.stripe.Pull_Requests", new Object[0]));
        JComponent component2 = new GHPRRepositorySelectorComponentFactory(this.project, this.authManager, this.repositoryManager).create(disposable2, (Function2<? super GHGitRepositoryMapping, ? super GithubAccount, Unit>)((Function2)new Function2<GHGitRepositoryMapping, GithubAccount, Unit>(this){
            final /* synthetic */ GHPRToolWindowTabControllerImpl this$0;

            public final void invoke(@NotNull GHGitRepositoryMapping repo, @NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                GHPRToolWindowTabControllerImpl.access$setCurrentRepository$p(this.this$0, repo);
                GHPRToolWindowTabControllerImpl.access$setCurrentAccount$p(this.this$0, account);
                GithubApiRequestExecutor.WithTokenAuth withTokenAuth = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account, GHPRToolWindowTabControllerImpl.access$getMainPanel$p(this.this$0));
                if (withTokenAuth == null) {
                    return;
                }
                GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
                GHPRToolWindowTabControllerImpl.access$getProjectSettings$p(this.this$0).setSelectedRepoAndAccount((Pair<GHGitRepositoryMapping, GithubAccount>)TuplesKt.to((Object)repo, (Object)((Object)account)));
                GHPRToolWindowTabControllerImpl.access$showPullRequestsComponent(this.this$0, repo, account, requestExecutor, false);
                GHUIUtil.INSTANCE.focusPanel(GHPRToolWindowTabControllerImpl.access$getMainPanel$p(this.this$0));
            }
            {
                this.this$0 = gHPRToolWindowTabControllerImpl;
                super(2);
            }
        }));
        JComponent $this$with = jComponent = this.mainPanel;
        boolean bl = false;
        $this$with.removeAll();
        $this$with.add((Component)component2, "North");
        $this$with.revalidate();
        $this$with.repaint();
        this.showingSelectors = true;
    }

    private final void showPullRequestsComponent(GHGitRepositoryMapping repositoryMapping, GithubAccount account, GithubApiRequestExecutor requestExecutor, boolean force) {
        JComponent jComponent;
        GHCompletableFutureLoadingModel<GHPRDataContext> gHCompletableFutureLoadingModel;
        if (Intrinsics.areEqual((Object)this.showingSelectors, (Object)false) && !force) {
            return;
        }
        this.tab.setDisplayName(GithubBundle.message("toolwindow.stripe.Pull_Requests", new Object[0]));
        GHRepositoryCoordinates repository = repositoryMapping.getGhRepositoryCoordinates();
        GitRemoteUrlCoordinates remote = repositoryMapping.getGitRemoteUrlCoordinates();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
        Disposable disposable2 = disposable;
        this.setContentDisposable(new Disposable(this, disposable2, repository){
            final /* synthetic */ GHPRToolWindowTabControllerImpl this$0;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ GHRepositoryCoordinates $repository;

            public final void dispose() {
                Disposer.dispose((Disposable)this.$disposable);
                GHPRToolWindowTabControllerImpl.access$getDataContextRepository$p(this.this$0).clearContext(this.$repository);
            }
            {
                this.this$0 = gHPRToolWindowTabControllerImpl;
                this.$disposable = disposable;
                this.$repository = gHRepositoryCoordinates;
            }
        });
        GHCompletableFutureLoadingModel<GHPRDataContext> $this$apply = gHCompletableFutureLoadingModel = new GHCompletableFutureLoadingModel<GHPRDataContext>(disposable2);
        boolean bl = false;
        $this$apply.setFuture(this.dataContextRepository.acquireContext(repository, remote, account, requestExecutor));
        GHCompletableFutureLoadingModel<GHPRDataContext> loadingModel = gHCompletableFutureLoadingModel;
        GHSimpleLoadingModel gHSimpleLoadingModel = loadingModel;
        String string = GithubBundle.message("cannot.load.data.from.github", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"ca\u2026t.load.data.from.github\")");
        JComponent panel2 = new GHLoadingPanelFactory(gHSimpleLoadingModel, null, string, new GHApiLoadingErrorHandler(this.project, account, (Function0<Unit>)((Function0)new Function0<Unit>(this, repository, loadingModel, remote, account, requestExecutor){
            final /* synthetic */ GHPRToolWindowTabControllerImpl this$0;
            final /* synthetic */ GHRepositoryCoordinates $repository;
            final /* synthetic */ GHCompletableFutureLoadingModel $loadingModel;
            final /* synthetic */ GitRemoteUrlCoordinates $remote;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;

            public final void invoke() {
                GHPRDataContextRepository contextRepository = GHPRToolWindowTabControllerImpl.access$getDataContextRepository$p(this.this$0);
                contextRepository.clearContext(this.$repository);
                this.$loadingModel.setFuture(contextRepository.acquireContext(this.$repository, this.$remote, this.$account, this.$requestExecutor));
            }
            {
                this.this$0 = gHPRToolWindowTabControllerImpl;
                this.$repository = gHRepositoryCoordinates;
                this.$loadingModel = gHCompletableFutureLoadingModel;
                this.$remote = gitRemoteUrlCoordinates;
                this.$account = githubAccount;
                this.$requestExecutor = githubApiRequestExecutor;
                super(0);
            }
        }))).create((Function2)new Function2<JPanel, GHPRDataContext, JComponent>(this, disposable2){
            final /* synthetic */ GHPRToolWindowTabControllerImpl this$0;
            final /* synthetic */ Disposable $disposable;

            @NotNull
            public final JComponent invoke(@NotNull JPanel parent, @NotNull GHPRDataContext result) {
                ComponentController componentController;
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Wrapper wrapper = new Wrapper();
                ComponentController it = componentController = this.this$0.new ComponentController(result, wrapper, this.$disposable);
                boolean bl = false;
                UIUtil.putClientProperty((JComponent)parent, GHPRToolWindowTabComponentController.Companion.getKEY(), (Object)it);
                this.this$0.setInitialView(GHPRToolWindowViewType.LIST);
                return (JComponent)wrapper;
            }
            {
                this.this$0 = gHPRToolWindowTabControllerImpl;
                this.$disposable = disposable;
                super(2);
            }
        });
        JComponent $this$with = jComponent = this.mainPanel;
        boolean bl2 = false;
        $this$with.removeAll();
        $this$with.add((Component)panel2, "Center");
        $this$with.revalidate();
        $this$with.repaint();
        this.showingSelectors = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canResetRemoteOrAccount() {
        void $this$filterTo$iv$iv;
        if (this.currentRepository == null) {
            return false;
        }
        if (this.currentAccount == null) {
            return false;
        }
        GHGitRepositoryMapping singleRepo = (GHGitRepositoryMapping)CollectionsKt.singleOrNull((Iterable)this.repositoryManager.getKnownRepositories());
        if (singleRepo == null) {
            return true;
        }
        Iterable $this$filter$iv = this.authManager.getAccounts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GithubAccount it = (GithubAccount)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.getServer().equals(singleRepo.getGhRepositoryCoordinates().getServerPath(), true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchingAccounts = (List)destination$iv$iv;
        return matchingAccounts.size() != 1;
    }

    @Override
    public void resetRemoteAndAccount() {
        this.currentRepository = null;
        this.currentAccount = null;
        this.projectSettings.setSelectedRepoAndAccount((Pair<GHGitRepositoryMapping, GithubAccount>)((Pair)null));
        new Updater().update();
    }

    /*
     * WARNING - void declaration
     */
    public GHPRToolWindowTabControllerImpl(@NotNull Project project, @NotNull GithubAuthenticationManager authManager, @NotNull GHProjectRepositoriesManager repositoryManager, @NotNull GHPRDataContextRepository dataContextRepository, @NotNull GithubPullRequestsProjectUISettings projectSettings, @NotNull Content tab) {
        void $this$apply;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)authManager, (String)"authManager");
        Intrinsics.checkNotNullParameter((Object)repositoryManager, (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)dataContextRepository, (String)"dataContextRepository");
        Intrinsics.checkNotNullParameter((Object)projectSettings, (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this.project = project;
        this.authManager = authManager;
        this.repositoryManager = repositoryManager;
        this.dataContextRepository = dataContextRepository;
        this.projectSettings = projectSettings;
        this.tab = tab;
        JComponent jComponent2 = jComponent = this.tab.getComponent();
        GHPRToolWindowTabControllerImpl gHPRToolWindowTabControllerImpl = this;
        boolean bl = false;
        $this$apply.setLayout(new BorderLayout());
        $this$apply.setBackground(UIUtil.getListBackground());
        Unit unit = Unit.INSTANCE;
        JComponent jComponent3 = jComponent;
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"tab.component.apply {\n  \u2026l.getListBackground()\n  }");
        gHPRToolWindowTabControllerImpl.mainPanel = jComponent3;
        jComponent = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        this.contentDisposable$delegate = (ReadWriteProperty)new ObservableProperty<Disposable>(initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GHPRToolWindowTabControllerImpl this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = gHPRToolWindowTabControllerImpl;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Disposable disposable = (Disposable)newValue;
                Disposable disposable2 = (Disposable)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                if (oldValue2 != null) {
                    Disposer.dispose((Disposable)oldValue2);
                }
                if (newValue2 != null) {
                    Disposable disposable3 = GHPRToolWindowTabControllerImpl.access$getTab$p(this.this$0).getDisposer();
                    Intrinsics.checkNotNull((Object)disposable3);
                    Disposer.register((Disposable)disposable3, (Disposable)newValue2);
                }
            }
        };
        this.initialView = GHPRToolWindowViewType.LIST;
        Disposable disposable = this.tab.getDisposer();
        Intrinsics.checkNotNull((Object)disposable);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"tab.disposer!!");
        this.authManager.addListener(disposable, (AccountsListener<GithubAccount>)((AccountsListener)new AccountsListener<GithubAccount>(){

            public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ 1 this$0;

                    public final void run() {
                        new Updater().update();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, new Condition(this){
                    final /* synthetic */ 1 this$0;

                    public final boolean value(Object it) {
                        Disposable disposable = GHPRToolWindowTabControllerImpl.access$getTab$p(this.this$0.this).getDisposer();
                        Intrinsics.checkNotNull((Object)disposable);
                        return Disposer.isDisposed((Disposable)disposable);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(collection, (String)"new");
                AccountsListener.DefaultImpls.onAccountListChanged((AccountsListener)this, old, collection);
            }
        }));
        Disposable disposable2 = this.tab.getDisposer();
        Intrinsics.checkNotNull((Object)disposable2);
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"tab.disposer!!");
        this.repositoryManager.addRepositoryListChangedListener(disposable2, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                new Updater().update();
            }
        }));
        new Updater().update();
    }

    public static final /* synthetic */ JComponent access$getMainPanel$p(GHPRToolWindowTabControllerImpl $this) {
        return $this.mainPanel;
    }

    public static final /* synthetic */ GHPRDataContextRepository access$getDataContextRepository$p(GHPRToolWindowTabControllerImpl $this) {
        return $this.dataContextRepository;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabControllerImpl$Updater;", "", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabControllerImpl;)V", "accounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "repos", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "guessAndSetRepoAndAccount", "Lkotlin/Pair;", "resetIfMissing", "", "update", "", "intellij.vcs.github"})
    private final class Updater {
        private final Set<GHGitRepositoryMapping> repos;
        private final Set<GithubAccount> accounts;

        /*
         * WARNING - void declaration
         */
        public final void update() {
            block5: {
                Unit unit;
                block4: {
                    Unit unit2;
                    Unit unit3;
                    boolean wasReset = this.resetIfMissing();
                    unit = this.guessAndSetRepoAndAccount();
                    if (unit == null) break block4;
                    Unit $dstr$repo$account = unit3 = unit;
                    boolean bl = false;
                    GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)$dstr$repo$account.component1();
                    GithubAccount account = (GithubAccount)((Object)$dstr$repo$account.component2());
                    try {
                        void repo;
                        GithubApiRequestExecutor.WithTokenAuth requestExecutor = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account);
                        GHPRToolWindowTabControllerImpl.this.showPullRequestsComponent((GHGitRepositoryMapping)repo, account, requestExecutor, wasReset);
                        unit2 = Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        unit2 = null;
                    }
                    if ((unit = unit2) != null) break block5;
                }
                GHPRToolWindowTabControllerImpl.this.showSelectors();
                unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<GHGitRepositoryMapping, GithubAccount> guessAndSetRepoAndAccount() {
            GHGitRepositoryMapping repo;
            Pair<GHGitRepositoryMapping, GithubAccount> saved = GHPRToolWindowTabControllerImpl.this.projectSettings.getSelectedRepoAndAccount();
            if (saved != null) {
                GHPRToolWindowTabControllerImpl.this.currentRepository = (GHGitRepositoryMapping)saved.getFirst();
                GHPRToolWindowTabControllerImpl.this.currentAccount = (GithubAccount)((Object)saved.getSecond());
                return saved;
            }
            if (GHPRToolWindowTabControllerImpl.this.currentRepository == null && this.repos.size() == 1) {
                GHPRToolWindowTabControllerImpl.this.currentRepository = (GHGitRepositoryMapping)CollectionsKt.single((Iterable)this.repos);
            }
            if ((repo = GHPRToolWindowTabControllerImpl.this.currentRepository) != null && GHPRToolWindowTabControllerImpl.this.currentAccount == null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.accounts;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GithubAccount it = (GithubAccount)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!it.getServer().equals(repo.getGhRepositoryCoordinates().getServerPath(), true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matchingAccounts = (List)destination$iv$iv;
                if (matchingAccounts.size() == 1) {
                    GHPRToolWindowTabControllerImpl.this.currentAccount = (GithubAccount)((Object)CollectionsKt.single((List)matchingAccounts));
                }
            }
            GithubAccount account = GHPRToolWindowTabControllerImpl.this.currentAccount;
            return repo != null && account != null ? TuplesKt.to((Object)repo, (Object)((Object)account)) : null;
        }

        private final boolean resetIfMissing() {
            GithubAccount account;
            boolean wasReset = false;
            GHGitRepositoryMapping repo = GHPRToolWindowTabControllerImpl.this.currentRepository;
            if (repo != null && !this.repos.contains(repo)) {
                GHPRToolWindowTabControllerImpl.this.currentRepository = null;
                GHPRToolWindowTabControllerImpl.this.currentAccount = null;
                wasReset = true;
            }
            if ((account = GHPRToolWindowTabControllerImpl.this.currentAccount) != null && !this.accounts.contains((Object)account)) {
                GHPRToolWindowTabControllerImpl.this.currentAccount = null;
                wasReset = true;
            }
            return wasReset;
        }

        public Updater() {
            this.repos = GHPRToolWindowTabControllerImpl.this.repositoryManager.getKnownRepositories();
            this.accounts = GHPRToolWindowTabControllerImpl.this.authManager.getAccounts();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J0\u0010(\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010)\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0004\u0012\u00020\u001e\u0018\u00010*H\u0016R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabControllerImpl$ComponentController;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentController;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabControllerImpl;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lcom/intellij/ui/components/panels/Wrapper;Lcom/intellij/openapi/Disposable;)V", "createComponentHolder", "Lcom/intellij/openapi/util/ClearableLazyValue;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/create/GHPRCreateComponentHolder;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentDisposable", "currentPullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "currentView", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;", "getCurrentView", "()Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;", "setCurrentView", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowViewType;)V", "listComponent", "Ljavax/swing/JComponent;", "getListComponent", "()Ljavax/swing/JComponent;", "listComponent$delegate", "Lkotlin/Lazy;", "createPullRequest", "", "requestFocus", "", "openNewPullRequestDiff", "openPullRequestDiff", "id", "openPullRequestTimeline", "refreshList", "resetNewPullRequestView", "viewList", "viewPullRequest", "onShown", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRViewComponentController;", "intellij.vcs.github"})
    private final class ComponentController
    implements GHPRToolWindowTabComponentController {
        private final Lazy listComponent$delegate;
        private final ClearableLazyValue<GHPRCreateComponentHolder> createComponentHolder;
        public GHPRToolWindowViewType currentView;
        private Disposable currentDisposable;
        private GHPRIdentifier currentPullRequest;
        private final GHPRDataContext dataContext;
        private final Wrapper wrapper;
        private final Disposable parentDisposable;

        private final JComponent getListComponent() {
            Lazy lazy = this.listComponent$delegate;
            ComponentController componentController = this;
            Object var3_3 = null;
            return (JComponent)lazy.getValue();
        }

        @Override
        @NotNull
        public GHPRToolWindowViewType getCurrentView() {
            GHPRToolWindowViewType gHPRToolWindowViewType = this.currentView;
            if (gHPRToolWindowViewType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentView");
            }
            return gHPRToolWindowViewType;
        }

        public void setCurrentView(@NotNull GHPRToolWindowViewType gHPRToolWindowViewType) {
            Intrinsics.checkNotNullParameter((Object)((Object)gHPRToolWindowViewType), (String)"<set-?>");
            this.currentView = gHPRToolWindowViewType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void createPullRequest(boolean requestFocus) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GHPRToolWindowTabControllerImpl.this.repositoryManager.getKnownRepositories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GHRepositoryCoordinates gHRepositoryCoordinates = ((GHGitRepositoryMapping)receiver).getGhRepositoryCoordinates();
                collection.add(gHRepositoryCoordinates);
            }
            List allRepos = (List)destination$iv$iv;
            GHPRToolWindowTabControllerImpl.this.tab.setDisplayName(GithubBundle.message("tab.title.pull.requests.new", GHUIUtil.getRepositoryDisplayName$default(GHUIUtil.INSTANCE, allRepos, this.dataContext.getRepositoryDataService().getRepositoryCoordinates(), false, 4, null)));
            Disposable disposable = this.currentDisposable;
            if (disposable != null) {
                Disposable disposable2;
                Disposable it = disposable2 = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.currentPullRequest = null;
            this.setCurrentView(GHPRToolWindowViewType.NEW);
            this.wrapper.setContent(((GHPRCreateComponentHolder)this.createComponentHolder.getValue()).getComponent());
            this.wrapper.repaint();
            if (requestFocus) {
                JComponent jComponent = this.wrapper.getTargetComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"wrapper.targetComponent");
                GHUIUtil.INSTANCE.focusPanel(jComponent);
            }
        }

        @Override
        public void resetNewPullRequestView() {
            ((GHPRCreateComponentHolder)this.createComponentHolder.getValue()).resetModel();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void viewList(boolean requestFocus) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GHPRToolWindowTabControllerImpl.this.repositoryManager.getKnownRepositories();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GHRepositoryCoordinates gHRepositoryCoordinates = ((GHGitRepositoryMapping)receiver).getGhRepositoryCoordinates();
                collection.add(gHRepositoryCoordinates);
            }
            List allRepos = (List)destination$iv$iv;
            GHPRToolWindowTabControllerImpl.this.tab.setDisplayName(GithubBundle.message("tab.title.pull.requests.at", GHUIUtil.getRepositoryDisplayName$default(GHUIUtil.INSTANCE, allRepos, this.dataContext.getRepositoryDataService().getRepositoryCoordinates(), false, 4, null)));
            Disposable disposable = this.currentDisposable;
            if (disposable != null) {
                Disposable disposable2;
                Disposable it = disposable2 = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.currentPullRequest = null;
            this.setCurrentView(GHPRToolWindowViewType.LIST);
            this.wrapper.setContent(this.getListComponent());
            this.wrapper.repaint();
            if (requestFocus) {
                JComponent jComponent = this.wrapper.getTargetComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"wrapper.targetComponent");
                GHUIUtil.INSTANCE.focusPanel(jComponent);
            }
        }

        @Override
        public void refreshList() {
            this.dataContext.getListLoader().reset();
            this.dataContext.getRepositoryDataService().resetData();
        }

        @Override
        public void viewPullRequest(@NotNull GHPRIdentifier id, boolean requestFocus, @Nullable Function1<? super GHPRViewComponentController, Unit> onShown) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GHPRToolWindowTabControllerImpl.this.tab.setDisplayName(GithubBundle.message("pull.request.num", id.getNumber()));
            if (Intrinsics.areEqual((Object)this.currentPullRequest, (Object)id) ^ true) {
                Disposable it;
                Disposable disposable;
                Disposable disposable2 = this.currentDisposable;
                if (disposable2 != null) {
                    it = disposable = disposable2;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
                it = disposable = Disposer.newDisposable((String)"Pull request component disposable");
                ComponentController componentController = this;
                boolean bl = false;
                Disposer.register((Disposable)this.parentDisposable, (Disposable)it);
                Unit unit = Unit.INSTANCE;
                componentController.currentDisposable = disposable;
                this.currentPullRequest = id;
                this.setCurrentView(GHPRToolWindowViewType.DETAILS);
                ActionManager actionManager = ActionManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"ActionManager.getInstance()");
                Project project = GHPRToolWindowTabControllerImpl.this.project;
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this;
                Disposable disposable3 = this.currentDisposable;
                Intrinsics.checkNotNull((Object)disposable3);
                JComponent pullRequestComponent = new GHPRViewComponentFactory(actionManager, project, this.dataContext, gHPRToolWindowTabComponentController, id, disposable3).create();
                this.wrapper.setContent(pullRequestComponent);
                this.wrapper.repaint();
            }
            if (onShown != null) {
                onShown.invoke(UIUtil.getClientProperty((Object)this.wrapper.getTargetComponent(), GHPRViewComponentController.Companion.getKEY()));
            }
            if (requestFocus) {
                JComponent jComponent = this.wrapper.getTargetComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"wrapper.targetComponent");
                GHUIUtil.INSTANCE.focusPanel(jComponent);
            }
        }

        @Override
        public void openPullRequestTimeline(@NotNull GHPRIdentifier id, boolean requestFocus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.dataContext.getFilesManager().createAndOpenTimelineFile(id, requestFocus);
        }

        @Override
        public void openPullRequestDiff(@NotNull GHPRIdentifier id, boolean requestFocus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.dataContext.getFilesManager().createAndOpenDiffFile(id, requestFocus);
        }

        @Override
        public void openNewPullRequestDiff(boolean requestFocus) {
            this.dataContext.getFilesManager().openNewPRDiffFile(requestFocus);
        }

        public ComponentController(@NotNull GHPRDataContext dataContext, @NotNull Wrapper wrapper, Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.dataContext = dataContext;
            this.wrapper = wrapper;
            this.parentDisposable = parentDisposable;
            this.listComponent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JComponent>(this){
                final /* synthetic */ ComponentController this$0;

                @NotNull
                public final JComponent invoke() {
                    return GHPRListComponent.INSTANCE.create(GHPRToolWindowTabControllerImpl.access$getProject$p(this.this$0.GHPRToolWindowTabControllerImpl.this), ComponentController.access$getDataContext$p(this.this$0), ComponentController.access$getParentDisposable$p(this.this$0));
                }
                {
                    this.this$0 = componentController;
                    super(0);
                }
            }));
            ClearableLazyValue clearableLazyValue = ClearableLazyValue.create((Supplier)new Supplier(this){
                final /* synthetic */ ComponentController this$0;

                public final GHPRCreateComponentHolder get() {
                    ActionManager actionManager = ActionManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"ActionManager.getInstance()");
                    return new GHPRCreateComponentHolder(actionManager, GHPRToolWindowTabControllerImpl.access$getProject$p(this.this$0.GHPRToolWindowTabControllerImpl.this), GHPRToolWindowTabControllerImpl.access$getProjectSettings$p(this.this$0.GHPRToolWindowTabControllerImpl.this), GHPRToolWindowTabControllerImpl.access$getRepositoryManager$p(this.this$0.GHPRToolWindowTabControllerImpl.this), ComponentController.access$getDataContext$p(this.this$0), this.this$0, ComponentController.access$getParentDisposable$p(this.this$0));
                }
                {
                    this.this$0 = componentController;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue, (String)"ClearableLazyValue.creat\u2026  parentDisposable)\n    }");
            this.createComponentHolder = clearableLazyValue;
            switch (GHPRToolWindowTabControllerImpl$ComponentController$WhenMappings.$EnumSwitchMapping$0[GHPRToolWindowTabControllerImpl.this.getInitialView().ordinal()]) {
                case 1: {
                    this.createPullRequest(false);
                    break;
                }
                default: {
                    this.viewList(false);
                }
            }
            DataManager.registerDataProvider((JComponent)((JComponent)this.wrapper), (DataProvider)new DataProvider(){

                @Nullable
                public final Object getData(@NotNull String dataId) {
                    Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                    return GHPRActionKeys.getPULL_REQUESTS_TAB_CONTROLLER().is(dataId) ? this : null;
                }
            });
        }

        public static final /* synthetic */ GHPRDataContext access$getDataContext$p(ComponentController $this) {
            return $this.dataContext;
        }

        public static final /* synthetic */ Disposable access$getParentDisposable$p(ComponentController $this) {
            return $this.parentDisposable;
        }
    }
}

