/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.compiler.progress.BuildIssueContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.SetupModuleSdkQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.UpdateSourceLevelQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/JpsLanguageLevelQuickFix;", "Lcom/intellij/compiler/progress/BuildIssueContributor;", "()V", "matchersList", "", "", "createBuildIssue", "Lcom/intellij/build/issue/BuildIssue;", "project", "Lcom/intellij/openapi/project/Project;", "moduleNames", "", "title", "message", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "navigatable", "Lcom/intellij/pom/Navigatable;", "getBuildIssueSourceVersionGreat", "sourceLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "moduleProjectLanguageLevel", "errorMessage", "moduleRootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getBuildIssueSourceVersionLess", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getLanguageLevelFromError", "intellij.maven"})
public final class JpsLanguageLevelQuickFix
implements BuildIssueContributor {
    private final List<List<String>> matchersList = CollectionsKt.listOf((Object[])new List[]{CollectionsKt.listOf((Object[])new String[]{"source release", "requires target release"}), CollectionsKt.listOf((Object[])new String[]{"release version", "not supported"}), CollectionsKt.listOf((Object)"invalid source release:"), CollectionsKt.listOf((Object)"invalid target release")});

    @Nullable
    public BuildIssue createBuildIssue(@NotNull Project project2, @NotNull Collection<String> moduleNames, @NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @Nullable VirtualFile virtualFile, @Nullable Navigatable navigatable) {
        Sdk sdk;
        ModuleRootManager moduleRootManager;
        MavenProject mavenProject2;
        block12: {
            block11: {
                Sdk sdk2;
                MavenProjectsManager mavenManager;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                if (project2.isDisposed()) {
                    return null;
                }
                MavenProjectsManager mavenProjectsManager = mavenManager = MavenProjectsManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"mavenManager");
                if (!mavenProjectsManager.isMavenizedProject()) {
                    return null;
                }
                if (moduleNames.size() != 1) {
                    return null;
                }
                String moduleName = (String)CollectionsKt.first((Iterable)moduleNames);
                Module module = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
                if (module == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleManager.getInstanc\u2026oduleName) ?: return null");
                Module module2 = module;
                MavenProject mavenProject3 = mavenManager.findProject(module2);
                if (mavenProject3 == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject3, (String)"mavenManager.findProject(module) ?: return null");
                mavenProject2 = mavenProject3;
                ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module2);
                if (moduleRootManager2 == null) {
                    return null;
                }
                moduleRootManager = moduleRootManager2;
                Sdk moduleJdk = moduleRootManager.getSdk();
                sdk = moduleJdk;
                if (sdk == null) break block11;
                Sdk it = sdk2 = sdk;
                boolean bl = false;
                sdk = LanguageLevel.parse((String)it.getVersionString());
                if (sdk != null) break block12;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"moduleJdk?.let { Languag\u2026nString) } ?: return null");
        Sdk moduleProjectLanguageLevel = sdk;
        LanguageLevel languageLevel = this.getLanguageLevelFromError(message);
        if (languageLevel == null) {
            return null;
        }
        LanguageLevel sourceLanguageLevel = languageLevel;
        if (sourceLanguageLevel.isLessThan((LanguageLevel)moduleProjectLanguageLevel)) {
            return this.getBuildIssueSourceVersionLess(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, mavenProject2, moduleRootManager);
        }
        return this.getBuildIssueSourceVersionGreat(sourceLanguageLevel, (LanguageLevel)moduleProjectLanguageLevel, message, moduleRootManager);
    }

    @Nullable
    public final LanguageLevel getLanguageLevelFromError(@NotNull String message) {
        LanguageLevel languageLevel;
        String $this$mapTo$iv$iv;
        List it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$filter$iv = this.matchersList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                it = (List)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = it;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (StringsKt.contains$default((CharSequence)message, (CharSequence)it2, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = message;
            int n = StringsKt.indexOf$default((CharSequence)message, (String)((String)CollectionsKt.first((List)it)), (int)0, (boolean)false, (int)6, null);
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            collection.add(string3);
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (string == null) {
            return null;
        }
        String targetMessage = string;
        CharSequence charSequence = targetMessage;
        String $i$f$map22 = "[^.0123456789]";
        $i$f$map22 = new Regex($i$f$map22);
        $this$mapTo$iv$iv = " ";
        charSequence = $i$f$map22.replace(charSequence, $this$mapTo$iv$iv);
        String string4 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)charSequence)).toString(), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
        if (string4 != null) {
            CharSequence it3 = charSequence = string4;
            boolean bl = false;
            languageLevel = LanguageLevel.parse((String)it3);
        } else {
            languageLevel = null;
        }
        return languageLevel;
    }

    private final BuildIssue getBuildIssueSourceVersionGreat(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, ModuleRootManager moduleRootManager) {
        Module module = moduleRootManager.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"moduleRootManager.module");
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleRootManager.module.name");
        String moduleName = string;
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        List quickFixes = CollectionsKt.listOf((Object)setupModuleSdkQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.great", moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<SetupModuleSdkQuickFix> quickFixes;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<SetupModuleSdkQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$errorMessage = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    private final BuildIssue getBuildIssueSourceVersionLess(LanguageLevel sourceLanguageLevel, LanguageLevel moduleProjectLanguageLevel, String errorMessage, MavenProject mavenProject2, ModuleRootManager moduleRootManager) {
        Module module = moduleRootManager.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"moduleRootManager.module");
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleRootManager.module.name");
        String moduleName = string;
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.header", moduleName, moduleProjectLanguageLevel.toJavaVersion(), sourceLanguageLevel.toJavaVersion()));
        SetupModuleSdkQuickFix setupModuleSdkQuickFix = new SetupModuleSdkQuickFix(moduleName, moduleRootManager.isSdkInherited());
        quickFixes.add(setupModuleSdkQuickFix);
        issueDescription.append("\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part1", sourceLanguageLevel.toJavaVersion(), setupModuleSdkQuickFix.getId()));
        UpdateSourceLevelQuickFix updateSourceLevelQuickFix = new UpdateSourceLevelQuickFix(mavenProject2);
        quickFixes.add(updateSourceLevelQuickFix);
        issueDescription.append("\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.source.version.less.part2", moduleProjectLanguageLevel.toJavaVersion(), updateSourceLevelQuickFix.getId()));
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$errorMessage = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }
}

