/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.archetype.MavenCatalog;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenArchetypeManager {
    private static final String ELEMENT_ARCHETYPES = "archetypes";
    private static final String ELEMENT_ARCHETYPE = "archetype";
    private static final String ELEMENT_GROUP_ID = "groupId";
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ELEMENT_DESCRIPTION = "description";
    @NotNull
    private final Project myProject;

    public static MavenArchetypeManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenArchetypeManager.$$$reportNull$$$0(0);
        }
        return (MavenArchetypeManager)project2.getService(MavenArchetypeManager.class);
    }

    public MavenArchetypeManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenArchetypeManager.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
    }

    public Collection<MavenArchetype> getArchetypes(@NotNull MavenCatalog catalog) {
        if (catalog == null) {
            MavenArchetypeManager.$$$reportNull$$$0(2);
        }
        if (catalog instanceof MavenCatalog.System.Internal) {
            return this.getInnerArchetypes();
        }
        if (catalog instanceof MavenCatalog.System.DefaultLocal) {
            return this.getLocalArchetypes();
        }
        if (catalog instanceof MavenCatalog.System.MavenCentral) {
            return this.getRemoteArchetypes(((MavenCatalog.System.MavenCentral)catalog).getUrl());
        }
        if (catalog instanceof MavenCatalog.Local) {
            return this.getInnerArchetypes(((MavenCatalog.Local)catalog).getPath());
        }
        if (catalog instanceof MavenCatalog.Remote) {
            return this.getRemoteArchetypes(((MavenCatalog.Remote)catalog).getUrl());
        }
        return Collections.emptyList();
    }

    public Set<MavenArchetype> getArchetypes() {
        MavenIndicesManager indicesManager = MavenIndicesManager.getInstance(this.myProject);
        HashSet<MavenArchetype> result = new HashSet<MavenArchetype>(this.getInnerArchetypes());
        result.addAll(MavenArchetypeManager.loadUserArchetypes(this.getUserArchetypesFile()));
        if (!indicesManager.isInit()) {
            indicesManager.updateIndicesListSync();
        }
        MavenIndexHolder indexHolder = indicesManager.getIndex();
        for (MavenIndex index : indexHolder.getIndices()) {
            result.addAll(index.getArchetypes());
        }
        for (MavenArchetypesProvider each : MavenArchetypesProvider.EP_NAME.getExtensionList()) {
            result.addAll(each.getArchetypes());
        }
        return result;
    }

    public Collection<MavenArchetype> getLocalArchetypes() {
        MavenIndex localIndex;
        MavenIndicesManager indicesManager = MavenIndicesManager.getInstance(this.myProject);
        if (!indicesManager.isInit()) {
            indicesManager.updateIndicesListSync();
        }
        if ((localIndex = indicesManager.getIndex().getLocalIndex()) == null) {
            return Collections.emptySet();
        }
        return localIndex.getArchetypes();
    }

    public Collection<MavenArchetype> getInnerArchetypes() {
        return this.executeWithMavenEmbedderWrapper(wrapper -> wrapper.getArchetypes());
    }

    public Collection<MavenArchetype> getInnerArchetypes(Path path) {
        return this.executeWithMavenEmbedderWrapper(wrapper -> wrapper.getInnerArchetypes(path));
    }

    public Collection<MavenArchetype> getRemoteArchetypes(URL url) {
        return this.getRemoteArchetypes(url.toExternalForm());
    }

    public Collection<MavenArchetype> getRemoteArchetypes(String url) {
        return this.executeWithMavenEmbedderWrapper(wrapper -> wrapper.getRemoteArchetypes(url));
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2, @Nullable String url) {
        Map map;
        if (groupId == null) {
            MavenArchetypeManager.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            MavenArchetypeManager.$$$reportNull$$$0(4);
        }
        if (version2 == null) {
            MavenArchetypeManager.$$$reportNull$$$0(5);
        }
        if ((map = this.executeWithMavenEmbedderWrapperNullable(wrapper -> wrapper.resolveAndGetArchetypeDescriptor(groupId, artifactId, version2, Collections.emptyList(), url))) != null) {
            this.addToLocalIndex(groupId, artifactId, version2);
        }
        return map;
    }

    private void addToLocalIndex(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2) {
        if (groupId == null) {
            MavenArchetypeManager.$$$reportNull$$$0(6);
        }
        if (artifactId == null) {
            MavenArchetypeManager.$$$reportNull$$$0(7);
        }
        if (version2 == null) {
            MavenArchetypeManager.$$$reportNull$$$0(8);
        }
        MavenId mavenId = new MavenId(groupId, artifactId, version2);
        MavenIndex localIndex = MavenIndicesManager.getInstance(this.myProject).getIndex().getLocalIndex();
        if (localIndex == null) {
            return;
        }
        Path artifactPath = MavenUtil.getArtifactPath(Path.of(localIndex.getRepositoryPathOrUrl(), new String[0]), mavenId, "jar", null);
        if (artifactPath != null && artifactPath.toFile().exists()) {
            MavenIndicesManager.getInstance(this.myProject).addArtifactIndexAsync(mavenId, artifactPath.toFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <R> R executeWithMavenEmbedderWrapper(Function<MavenEmbedderWrapper, R> function) {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenEmbeddersManager manager = projectsManager.getEmbeddersManager();
        String baseDir = "";
        List<MavenProject> projects = projectsManager.getRootProjects();
        if (!projects.isEmpty()) {
            baseDir = MavenUtil.getBaseDir(projects.get(0).getDirectoryFile()).toString();
        }
        MavenEmbedderWrapper mavenEmbedderWrapper = manager.getEmbedder(MavenEmbeddersManager.FOR_POST_PROCESSING, baseDir, baseDir);
        R r = function.apply(mavenEmbedderWrapper);
        R r2 = r;
        if (r2 == null) {
            MavenArchetypeManager.$$$reportNull$$$0(9);
        }
        return r2;
        finally {
            manager.release(mavenEmbedderWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <R> R executeWithMavenEmbedderWrapperNullable(Function<MavenEmbedderWrapper, R> function) {
        MavenEmbeddersManager manager = MavenProjectsManager.getInstance(this.myProject).getEmbeddersManager();
        MavenEmbedderWrapper mavenEmbedderWrapper = manager.getEmbedder(MavenEmbeddersManager.FOR_POST_PROCESSING, "", "");
        try {
            R r = function.apply(mavenEmbedderWrapper);
            return r;
        }
        finally {
            manager.release(mavenEmbedderWrapper);
        }
    }

    @NotNull
    static List<MavenArchetype> loadUserArchetypes(@NotNull Path userArchetypesPath) {
        ArrayList<MavenArchetype> arrayList;
        block8: {
            if (userArchetypesPath == null) {
                MavenArchetypeManager.$$$reportNull$$$0(10);
            }
            if (PathKt.exists((Path)userArchetypesPath)) break block8;
            List<MavenArchetype> list = Collections.emptyList();
            if (list == null) {
                MavenArchetypeManager.$$$reportNull$$$0(11);
            }
            return list;
        }
        try {
            LinkedHashSet<MavenArchetype> result = new LinkedHashSet<MavenArchetype>();
            List children = JDOMUtil.load((Path)userArchetypesPath).getChildren(ELEMENT_ARCHETYPE);
            for (int i = children.size() - 1; i >= 0; --i) {
                Element each = (Element)children.get(i);
                String groupId = each.getAttributeValue(ELEMENT_GROUP_ID);
                String artifactId = each.getAttributeValue(ELEMENT_ARTIFACT_ID);
                String version2 = each.getAttributeValue(ELEMENT_VERSION);
                String repository = each.getAttributeValue(ELEMENT_REPOSITORY);
                String description = each.getAttributeValue(ELEMENT_DESCRIPTION);
                if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId) || StringUtil.isEmptyOrSpaces((String)version2)) continue;
                result.add(new MavenArchetype(groupId, artifactId, version2, repository, description));
            }
            ArrayList<MavenArchetype> listResult = new ArrayList<MavenArchetype>(result);
            Collections.reverse(listResult);
            arrayList = listResult;
        }
        catch (IOException | JDOMException e) {
            MavenLog.LOG.warn(e);
            List<MavenArchetype> list = Collections.emptyList();
            if (list == null) {
                MavenArchetypeManager.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (arrayList == null) {
            MavenArchetypeManager.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static void addArchetype(@NotNull MavenArchetype archetype, @NotNull Path userArchetypesPath) {
        ArrayList<MavenArchetype> archetypes;
        int idx;
        if (archetype == null) {
            MavenArchetypeManager.$$$reportNull$$$0(14);
        }
        if (userArchetypesPath == null) {
            MavenArchetypeManager.$$$reportNull$$$0(15);
        }
        if ((idx = (archetypes = new ArrayList<MavenArchetype>(MavenArchetypeManager.loadUserArchetypes(userArchetypesPath))).indexOf(archetype)) >= 0) {
            archetypes.set(idx, archetype);
        } else {
            archetypes.add(archetype);
        }
        MavenArchetypeManager.saveUserArchetypes(archetypes, userArchetypesPath);
    }

    @NotNull
    private Path getUserArchetypesFile() {
        Path path = MavenIndicesManager.getInstance(this.myProject).getIndicesDir().resolve("UserArchetypes.xml");
        if (path == null) {
            MavenArchetypeManager.$$$reportNull$$$0(16);
        }
        return path;
    }

    private static void saveUserArchetypes(List<MavenArchetype> userArchetypes, @NotNull Path userArchetypesPath) {
        if (userArchetypesPath == null) {
            MavenArchetypeManager.$$$reportNull$$$0(17);
        }
        Element root = new Element(ELEMENT_ARCHETYPES);
        for (MavenArchetype each : userArchetypes) {
            Element childElement = new Element(ELEMENT_ARCHETYPE);
            childElement.setAttribute(ELEMENT_GROUP_ID, each.groupId);
            childElement.setAttribute(ELEMENT_ARTIFACT_ID, each.artifactId);
            childElement.setAttribute(ELEMENT_VERSION, each.version);
            if (each.repository != null) {
                childElement.setAttribute(ELEMENT_REPOSITORY, each.repository);
            }
            if (each.description != null) {
                childElement.setAttribute(ELEMENT_DESCRIPTION, each.description);
            }
            root.addContent(childElement);
        }
        try {
            JdomKt.write((Parent)root, (Path)userArchetypesPath);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalog";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_GROUP_ID;
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_ARTIFACT_ID;
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_VERSION;
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenArchetypeManager";
                break;
            }
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userArchetypesPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_ARCHETYPE;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenArchetypeManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithMavenEmbedderWrapper";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUserArchetypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserArchetypesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArchetypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToLocalIndex";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadUserArchetypes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addArchetype";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveUserArchetypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

