/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.VersionUpdatedException;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public final class MavenIndex
implements MavenSearchIndex {
    private static final String DATA_DIR_PREFIX = "data";
    private static final String ARTIFACT_IDS_MAP_FILE = "artifactIds-map.dat";
    private static final String VERSIONS_MAP_FILE = "versions-map.dat";
    private static final String ARCHETYPES_MAP_FILE = "archetypes-map.dat";
    private final MavenIndexerWrapper myNexusIndexer;
    private final File myDir;
    @Deprecated(forRemoval=true)
    private final Set<String> myRegisteredRepositoryIds;
    private final String myRepositoryPathOrUrl;
    private final MavenSearchIndex.Kind myKind;
    private volatile Long myUpdateTimestamp;
    private volatile IndexData myData;
    private volatile String myFailureMessage;
    private volatile boolean isBroken;
    private volatile boolean isClose;
    private String myDataDirName;
    private final MavenSearchIndex.IndexListener myListener;
    private final Lock indexUpdateLock = new ReentrantLock();

    public MavenIndex(MavenIndexerWrapper indexer, MavenIndexUtils.IndexPropertyHolder propertyHolder, MavenSearchIndex.IndexListener listener2) throws MavenIndexException {
        this.myNexusIndexer = indexer;
        this.myListener = listener2;
        this.myDir = propertyHolder.dir;
        this.myKind = propertyHolder.kind;
        this.myRegisteredRepositoryIds = propertyHolder.repositoryIds;
        this.myRepositoryPathOrUrl = propertyHolder.repositoryPathOrUrl;
        this.myUpdateTimestamp = propertyHolder.updateTimestamp;
        this.myDataDirName = propertyHolder.dataDirName;
        this.myFailureMessage = propertyHolder.failureMessage;
        this.open();
    }

    public String getDataDirName() {
        return this.myDataDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws MavenIndexException {
        try {
            try {
                this.doOpen();
            }
            catch (Exception e) {
                boolean versionUpdated;
                if (e instanceof ProcessCanceledException) {
                    MavenLog.LOG.error("PCE should not be thrown", new Attachment[]{new Attachment("pce", (Throwable)e)});
                }
                if (!(versionUpdated = e.getCause() instanceof VersionUpdatedException)) {
                    MavenLog.LOG.warn((Throwable)e);
                }
                try {
                    this.doOpen();
                }
                catch (Exception e2) {
                    throw new MavenIndexException("Cannot open index " + this.myDir.getPath(), e2);
                }
                this.markAsBroken();
            }
        }
        finally {
            this.save();
        }
    }

    private void doOpen() throws Exception {
        MavenLog.LOG.debug("open index " + this);
        ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            MavenIndex mavenIndex = this;
            synchronized (mavenIndex) {
                File dataDir;
                if (this.myDataDirName == null) {
                    dataDir = this.createNewDataDir();
                    this.myDataDirName = dataDir.getName();
                } else {
                    dataDir = new File(this.myDir, this.myDataDirName);
                    dataDir.mkdirs();
                }
                if (this.myData != null) {
                    this.myData.close(true);
                }
                if (this.isClose) {
                    return null;
                }
                this.myData = new IndexData(dataDir);
                return null;
            }
        });
    }

    private void cleanupBrokenData() {
        this.close(true);
        File currentDataDir = this.getCurrentDataDir();
        File currentDataContextDir = this.getCurrentDataContextDir();
        File[] files = currentDataDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (FileUtil.filesEqual((File)file, (File)currentDataContextDir)) continue;
                FileUtil.delete((File)file);
            }
        } else {
            FileUtil.delete((File)currentDataDir);
        }
    }

    public synchronized void finalClose(boolean releaseIndexContext) {
        this.isClose = true;
        this.close(releaseIndexContext);
    }

    @Override
    public void close(boolean releaseIndexContext) {
        IndexData data = this.myData;
        try {
            if (data != null) {
                data.close(releaseIndexContext);
            }
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myData = null;
    }

    private synchronized void save() {
        this.myDir.mkdirs();
        MavenIndexUtils.saveIndexProperty(this);
    }

    @Override
    public String getRepositoryId() {
        return StringUtil.join(this.myRegisteredRepositoryIds, (String)",");
    }

    @Override
    public File getRepositoryFile() {
        return this.myKind == MavenSearchIndex.Kind.LOCAL ? new File(this.myRepositoryPathOrUrl) : null;
    }

    @Override
    public String getRepositoryUrl() {
        return this.myKind == MavenSearchIndex.Kind.REMOTE ? this.myRepositoryPathOrUrl : null;
    }

    @Override
    public String getRepositoryPathOrUrl() {
        return this.myRepositoryPathOrUrl;
    }

    @Override
    public MavenSearchIndex.Kind getKind() {
        return this.myKind;
    }

    @Override
    public long getUpdateTimestamp() {
        return this.myUpdateTimestamp == null ? -1L : this.myUpdateTimestamp;
    }

    @Override
    public String getFailureMessage() {
        return this.myFailureMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrRepair(boolean fullUpdate, @Nullable MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        try {
            this.indexUpdateLock.lock();
            MavenLog.LOG.debug("start update index " + this);
            File newDataDir = this.createNewDataDir();
            File newDataContextDir = MavenIndex.getDataContextDir(newDataDir);
            File currentDataContextDir = this.getCurrentDataContextDir();
            boolean reuseExistingContext = fullUpdate ? this.myKind != MavenSearchIndex.Kind.LOCAL && this.hasValidContext(currentDataContextDir) : this.hasValidContext(currentDataContextDir);
            boolean bl = fullUpdate = fullUpdate || !reuseExistingContext && this.myKind == MavenSearchIndex.Kind.LOCAL;
            if (reuseExistingContext) {
                try {
                    FileUtil.copyDir((File)currentDataContextDir, (File)newDataContextDir);
                }
                catch (IOException e) {
                    throw new MavenIndexException(e);
                }
            }
            if (fullUpdate) {
                MavenIndexId mavenIndexId = this.getMavenIndexId(newDataContextDir, "update");
                try {
                    this.updateNexusContext(mavenIndexId, settings, progress);
                }
                finally {
                    this.myNexusIndexer.releaseIndex(mavenIndexId);
                }
            }
            this.updateIndexData(progress, newDataDir, fullUpdate);
            this.isBroken = false;
            this.myFailureMessage = null;
            MavenLog.LOG.debug("finish update index " + this);
        }
        catch (MavenProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleUpdateException(e);
        }
        finally {
            this.indexUpdateLock.unlock();
        }
        this.save();
    }

    private boolean hasValidContext(@NotNull File contextDir) {
        if (contextDir == null) {
            MavenIndex.$$$reportNull$$$0(0);
        }
        return contextDir.isDirectory() && this.myNexusIndexer.indexExists(contextDir);
    }

    private void handleUpdateException(Exception e) {
        String failureMessage = e.getMessage();
        if (failureMessage != null && failureMessage.contains("nexus-maven-repository-index.properties") && failureMessage.contains("FileNotFoundException")) {
            failureMessage = "Repository is non-nexus repo, or is not indexed";
            MavenLog.LOG.debug("Failed to update Maven indices for: " + this.myRegisteredRepositoryIds + " " + this.myRepositoryPathOrUrl, (Throwable)e);
        } else {
            MavenLog.LOG.warn("Failed to update Maven indices for: " + this.myRegisteredRepositoryIds + " " + this.myRepositoryPathOrUrl, (Throwable)e);
        }
        this.myFailureMessage = failureMessage;
    }

    private MavenIndexId getMavenIndexId(File contextDir, String suffix) throws MavenServerIndexerException {
        String indexId = this.myDir.getName() + "-" + suffix;
        File repositoryFile = this.getRepositoryFile();
        return new MavenIndexId(indexId, this.getRepositoryId(), repositoryFile == null ? null : repositoryFile.getAbsolutePath(), this.getRepositoryUrl(), contextDir.getAbsolutePath());
    }

    private void updateNexusContext(@NotNull MavenIndexId indexId, @Nullable MavenGeneralSettings settings, @NotNull MavenProgressIndicator progress) throws MavenServerIndexerException, MavenProcessCanceledException {
        if (indexId == null) {
            MavenIndex.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            MavenIndex.$$$reportNull$$$0(2);
        }
        this.myNexusIndexer.updateIndex(indexId, settings, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexData(MavenProgressIndicator progress, File newDataDir, boolean fullUpdate) throws MavenIndexException {
        IndexData newData = new IndexData(newDataDir);
        try {
            this.doUpdateIndexData(newData, progress);
            newData.flush();
        }
        catch (Throwable e) {
            newData.close(true);
            FileUtil.delete((File)newDataDir);
            if (e instanceof MavenServerIndexerException) {
                throw new MavenIndexException(e);
            }
            if (e instanceof IOException) {
                throw new MavenIndexException(e);
            }
            throw new RuntimeException(e);
        }
        MavenIndex mavenIndex = this;
        synchronized (mavenIndex) {
            if (this.isClose) {
                newData.close(false);
                return;
            }
            if (this.myData != null) {
                this.myData.close(true);
            }
            this.myData = newData;
            this.myDataDirName = newDataDir.getName();
            if (fullUpdate) {
                this.myUpdateTimestamp = System.currentTimeMillis();
            }
            for (File each : FileUtil.notNullize((File[])this.myDir.listFiles())) {
                if (!each.getName().startsWith(DATA_DIR_PREFIX) || each.getName().equals(this.myDataDirName)) continue;
                FileUtil.delete((File)each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndexData(IndexData data, MavenProgressIndicator progress) throws IOException, MavenServerIndexerException {
        HashMap groupToArtifactMap = new HashMap();
        HashMap groupWithArtifactToVersionMap = new HashMap();
        HashMap archetypeIdToDescriptionMap = new HashMap();
        progress.pushState();
        progress.setIndeterminate(true);
        try {
            StringBuilder builder = new StringBuilder();
            MavenIndicesProcessor mavenIndicesProcessor = artifacts -> {
                for (IndexedMavenId id : artifacts) {
                    if ("pom.lastUpdated".equals(id.packaging)) continue;
                    builder.setLength(0);
                    builder.append(id.groupId).append(":").append(id.artifactId);
                    String ga = builder.toString();
                    MavenIndex.getOrCreate(groupToArtifactMap, id.groupId).add(id.artifactId);
                    MavenIndex.getOrCreate(groupWithArtifactToVersionMap, ga).add(id.version);
                    if (!"maven-archetype".equals(id.packaging)) continue;
                    builder.setLength(0);
                    builder.append(id.version).append(":").append(StringUtil.notNullize((String)id.description));
                    MavenIndex.getOrCreate(archetypeIdToDescriptionMap, ga).add(builder.toString());
                }
            };
            this.myNexusIndexer.processArtifacts(data.mavenIndexId, mavenIndicesProcessor);
            MavenIndex.persist(groupToArtifactMap, data.groupToArtifactMap);
            MavenIndex.persist(groupWithArtifactToVersionMap, data.groupWithArtifactToVersionMap);
            MavenIndex.persist(archetypeIdToDescriptionMap, data.archetypeIdToDescriptionMap);
        }
        finally {
            progress.popState();
        }
    }

    private static <T> Set<T> getOrCreate(Map<String, Set<T>> map, String key) {
        return map.computeIfAbsent(key, k -> new TreeSet());
    }

    private static <T> void persist(Map<String, T> map, PersistentHashMap<String, T> persistentMap) throws IOException {
        for (Map.Entry<String, T> each : map.entrySet()) {
            persistentMap.put((Object)each.getKey(), each.getValue());
        }
    }

    public File getDir() {
        return this.myDir;
    }

    @TestOnly
    private synchronized File getCurrentDataDir() {
        return new File(this.myDir, this.myDataDirName);
    }

    private File getCurrentDataContextDir() {
        return new File(this.getCurrentDataDir(), "context");
    }

    private static File getDataContextDir(File dataDir) {
        return new File(dataDir, "context");
    }

    @NotNull
    private File createNewDataDir() {
        File file = MavenIndices.createNewDir(this.myDir, DATA_DIR_PREFIX, 100);
        if (file == null) {
            MavenIndex.$$$reportNull$$$0(3);
        }
        return file;
    }

    public boolean tryAddArtifact(File artifactFile) {
        return this.doIndexAndRecoveryTask(() -> {
            boolean locked = this.indexUpdateLock.tryLock();
            if (!locked) {
                return false;
            }
            try {
                IndexData indexData = this.myData;
                IndexedMavenId id = indexData.addArtifact(artifactFile);
                if (id == null) {
                    Boolean bl = true;
                    return bl;
                }
                String groupWithArtifact = id.groupId + ":" + id.artifactId;
                MavenIndex.addToCache(indexData.groupToArtifactMap, id.groupId, id.artifactId);
                MavenIndex.addToCache(indexData.groupWithArtifactToVersionMap, groupWithArtifact, id.version);
                if ("maven-archetype".equals(id.packaging)) {
                    MavenIndex.addToCache(indexData.archetypeIdToDescriptionMap, groupWithArtifact, id.version + ":" + StringUtil.notNullize((String)id.description));
                }
                indexData.flush();
                Boolean bl = true;
                return bl;
            }
            finally {
                this.indexUpdateLock.unlock();
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToCache(PersistentHashMap<String, Set<String>> cache, String key, String value) throws IOException {
        PersistentHashMap<String, Set<String>> persistentHashMap = cache;
        synchronized (persistentHashMap) {
            TreeSet<String> values = (TreeSet<String>)cache.get((Object)key);
            if (values == null) {
                values = new TreeSet<String>();
            }
            if (values.add(value)) {
                cache.put((Object)key, values);
            }
        }
    }

    public Collection<String> getGroupIds() {
        return this.doIndexTask(() -> this.getGroupIdsRaw(), Collections.emptySet());
    }

    public Set<String> getArtifactIds(String groupId) {
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupToArtifactMap.get((Object)groupId))), Collections.emptySet());
    }

    @TestOnly
    public synchronized void printInfo() {
        this.doIndexTask(() -> {
            MavenLog.LOG.debug("BaseFile: " + this.myData.groupToArtifactMap);
            MavenLog.LOG.debug("All data objects: " + this.getGroupIdsRaw());
            return null;
        }, null);
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        String ga = groupId + ":" + artifactId;
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)this.myData.groupWithArtifactToVersionMap.get((Object)ga))), Collections.emptySet());
    }

    public boolean hasGroupId(String groupId) {
        if (this.isBroken) {
            return false;
        }
        IndexData indexData = this.myData;
        return this.doIndexTask(() -> indexData.groupToArtifactMap.containsMapping((Object)groupId), false);
    }

    public boolean hasArtifactId(String groupId, String artifactId) {
        if (this.isBroken) {
            return false;
        }
        IndexData indexData = this.myData;
        String key = groupId + ":" + artifactId;
        return this.doIndexTask(() -> indexData.groupWithArtifactToVersionMap.containsMapping((Object)key), false);
    }

    public boolean hasVersion(String groupId, String artifactId, String version2) {
        if (this.isBroken) {
            return false;
        }
        String groupWithArtifactWithVersion = groupId + ":" + artifactId + ":" + version2;
        String groupWithArtifact = groupWithArtifactWithVersion.substring(0, groupWithArtifactWithVersion.length() - version2.length() - 1);
        IndexData indexData = this.myData;
        return this.doIndexTask(() -> ContainerUtil.notNullize((Set)((Set)indexData.groupWithArtifactToVersionMap.get((Object)groupWithArtifact))).contains(version2), false);
    }

    public Set<MavenArtifactInfo> search(String pattern, int maxResult) {
        return this.doIndexAndRecoveryTask(() -> this.myData.search(pattern, maxResult), Collections.emptySet());
    }

    public Set<MavenArchetype> getArchetypes() {
        return this.doIndexAndRecoveryTask(() -> {
            HashSet<MavenArchetype> archetypes = new HashSet<MavenArchetype>();
            IndexData indexData = this.myData;
            for (String ga : indexData.archetypeIdToDescriptionMap.getAllKeysWithExistingMapping()) {
                List gaParts = StringUtil.split((String)ga, (String)":");
                String groupId = (String)gaParts.get(0);
                String artifactId = (String)gaParts.get(1);
                for (String vd : (Set)indexData.archetypeIdToDescriptionMap.get((Object)ga)) {
                    int index = vd.indexOf(58);
                    if (index == -1) continue;
                    String version2 = vd.substring(0, index);
                    String description = vd.substring(index + 1);
                    archetypes.add(new MavenArchetype(groupId, artifactId, version2, this.myRepositoryPathOrUrl, description));
                }
            }
            return archetypes;
        }, Collections.emptySet());
    }

    private <T> T doIndexTask(IndexTask<T> task, T defaultValue) {
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                MavenLog.LOG.warn((Throwable)e);
                this.markAsBroken();
            }
        }
        return defaultValue;
    }

    private <T> T doIndexAndRecoveryTask(IndexTask<T> task, T defaultValue) {
        if (!this.isBroken) {
            try {
                return task.doTask();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e1) {
                MavenLog.LOG.warn((Throwable)e1);
                this.cleanupBrokenData();
                try {
                    this.open();
                }
                catch (MavenIndexException e2) {
                    MavenLog.LOG.warn((Throwable)e2);
                }
            }
        }
        this.markAsBroken();
        return defaultValue;
    }

    private void markAsBroken() {
        if (this.isClose) {
            return;
        }
        if (!this.isBroken) {
            MavenLog.LOG.info("index is broken " + this);
            this.myListener.indexIsBroken(this);
        }
        this.isBroken = true;
    }

    @NotNull
    private Collection<String> getGroupIdsRaw() throws IOException {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.myData.groupToArtifactMap.processKeysWithExistingMapping((Processor)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            MavenIndex.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String normalizePathOrUrl(@NotNull String pathOrUrl) {
        if (pathOrUrl == null) {
            MavenIndex.$$$reportNull$$$0(5);
        }
        String string = MavenIndexUtils.normalizePathOrUrl(pathOrUrl);
        if (string == null) {
            MavenIndex.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String toString() {
        return "MavenIndex{myKind=" + this.myKind + "', myRepositoryPathOrUrl='" + this.myRepositoryPathOrUrl + ", ids=" + this.myRegisteredRepositoryIds + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOrUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDataDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupIdsRaw";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePathOrUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasValidContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateNexusContext";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathOrUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SetDescriptor
    implements DataExternalizer<Set<String>> {
        private SetDescriptor() {
        }

        public void save(@NotNull DataOutput s, Set<String> set) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(0);
            }
            s.writeInt(set.size());
            for (String each : set) {
                s.writeUTF(each);
            }
        }

        public Set<String> read(@NotNull DataInput s) throws IOException {
            if (s == null) {
                SetDescriptor.$$$reportNull$$$0(1);
            }
            int count = s.readInt();
            TreeSet<String> result = new TreeSet<String>();
            try {
                while (count-- > 0) {
                    result.add(s.readUTF());
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "s";
            objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndex$SetDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class IndexData {
        final PersistentHashMap<String, Set<String>> groupToArtifactMap;
        final PersistentHashMap<String, Set<String>> groupWithArtifactToVersionMap;
        final PersistentHashMap<String, Set<String>> archetypeIdToDescriptionMap;
        final MavenIndexId mavenIndexId;

        IndexData(File dir2) throws MavenIndexException {
            try {
                this.groupToArtifactMap = this.createPersistentMap(new File(dir2, MavenIndex.ARTIFACT_IDS_MAP_FILE));
                this.groupWithArtifactToVersionMap = this.createPersistentMap(new File(dir2, MavenIndex.VERSIONS_MAP_FILE));
                this.archetypeIdToDescriptionMap = this.createPersistentMap(new File(dir2, MavenIndex.ARCHETYPES_MAP_FILE));
                this.mavenIndexId = MavenIndex.this.getMavenIndexId(MavenIndex.getDataContextDir(dir2), dir2.getName());
            }
            catch (IOException | MavenServerIndexerException e) {
                this.close(true);
                throw new MavenIndexException(e);
            }
        }

        private PersistentHashMap<String, Set<String>> createPersistentMap(File f) throws IOException {
            return new PersistentHashMap(f.toPath(), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new SetDescriptor());
        }

        void close(boolean releaseIndexContext) throws MavenIndexException {
            MavenIndexException[] exceptions;
            block4: {
                exceptions = new MavenIndexException[1];
                try {
                    if (releaseIndexContext) {
                        MavenIndex.this.myNexusIndexer.releaseIndex(this.mavenIndexId);
                    }
                }
                catch (MavenServerIndexerException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block4;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
            this.safeClose((Closeable)this.groupToArtifactMap, exceptions);
            this.safeClose((Closeable)this.groupWithArtifactToVersionMap, exceptions);
            this.safeClose((Closeable)this.archetypeIdToDescriptionMap, exceptions);
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }

        private void safeClose(@Nullable Closeable enumerator, MavenIndexException[] exceptions) {
            block3: {
                try {
                    if (enumerator != null) {
                        enumerator.close();
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn((Throwable)e);
                    if (exceptions[0] != null) break block3;
                    exceptions[0] = new MavenIndexException(e);
                }
            }
        }

        void flush() {
            this.groupToArtifactMap.force();
            this.groupWithArtifactToVersionMap.force();
            this.archetypeIdToDescriptionMap.force();
        }

        IndexedMavenId addArtifact(File artifactFile) throws MavenServerIndexerException {
            return MavenIndex.this.myNexusIndexer.addArtifact(this.mavenIndexId, artifactFile);
        }

        Set<MavenArtifactInfo> search(String pattern, int maxResult) throws MavenServerIndexerException {
            return MavenIndex.this.myNexusIndexer.search(this.mavenIndexId, pattern, maxResult);
        }
    }

    @FunctionalInterface
    private static interface IndexTask<T> {
        public T doTask() throws Exception;
    }
}

