/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Deprecated(forRemoval=true)
public class MavenConsoleImpl
extends MavenConsole {
    private static final Key<MavenConsoleImpl> CONSOLE_KEY = Key.create((String)"MAVEN_CONSOLE_KEY");
    private static final String CONSOLE_FILTER_REGEXP = "(?:^|(?:\\[\\w+\\]\\s*)( /)?)$FILE_PATH$:\\[$LINE$,$COLUMN$]";
    @NlsContexts.TabTitle
    private final String myTitle;
    private final Project myProject;
    private final ConsoleView myConsoleView;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final Pair<MavenRunnerParameters, MavenRunnerSettings> myParametersAndSettings;

    public MavenConsoleImpl(@NlsContexts.TabTitle String title, Project project2) {
        this(title, project2, null);
    }

    public MavenConsoleImpl(@NlsContexts.TabTitle String title, Project project2, Pair<MavenRunnerParameters, MavenRunnerSettings> parametersAndSettings) {
        super(MavenConsoleImpl.getGeneralSettings(project2).getLoggingLevel(), MavenConsoleImpl.getGeneralSettings(project2).isPrintErrorStackTraces());
        this.myTitle = title;
        this.myProject = project2;
        this.myConsoleView = this.createConsoleView();
        this.myParametersAndSettings = parametersAndSettings;
    }

    private static MavenGeneralSettings getGeneralSettings(Project project2) {
        return MavenProjectsManager.getInstance(project2).getGeneralSettings();
    }

    public ConsoleView createConsoleView() {
        return MavenConsoleImpl.createConsoleBuilder(this.myProject).getConsole();
    }

    public static TextConsoleBuilder createConsoleBuilder(Project project2) {
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        return builder;
    }

    @Override
    public boolean canPause() {
        return this.myConsoleView.canPause();
    }

    @Override
    public boolean isOutputPaused() {
        return this.myConsoleView.isOutputPaused();
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
        this.myConsoleView.setOutputPaused(outputPaused);
    }

    public Pair<MavenRunnerParameters, MavenRunnerSettings> getParametersAndSettings() {
        return this.myParametersAndSettings;
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsoleView.attachToProcess(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                MavenConsoleImpl.this.ensureAttachedToToolWindow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenConsoleImpl$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type2) {
        ConsoleViewContentType contentType;
        this.ensureAttachedToToolWindow();
        switch (type2) {
            case SYSTEM: {
                contentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                break;
            }
            case ERROR: {
                contentType = ConsoleViewContentType.ERROR_OUTPUT;
                break;
            }
            default: {
                contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        this.myConsoleView.print(text, contentType);
    }

    private void ensureAttachedToToolWindow() {
        if (!this.isOpen.compareAndSet(false, true)) {
            return;
        }
        MavenUtil.invokeLater(this.myProject, () -> {
            MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
            Content content = ContentFactory.SERVICE.getInstance().createContent(this.myConsoleView.getComponent(), this.myTitle, true);
            content.putUserData(CONSOLE_KEY, (Object)this);
            messageView.getContentManager().addContent(content);
            messageView.getContentManager().setSelectedContent(content);
            for (Content each : messageView.getContentManager().getContents()) {
                MavenConsoleImpl console2;
                if (each.isPinned() || each == content || (console2 = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY)) == null || !this.myTitle.equals(console2.myTitle) || !console2.isFinished()) continue;
                messageView.getContentManager().removeContent(each, true);
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages");
            if (!toolWindow.isActive()) {
                toolWindow.activate(null, false);
            }
        });
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
        for (Content each : messageView.getContentManager().getContents()) {
            MavenConsoleImpl console2 = (MavenConsoleImpl)each.getUserData(CONSOLE_KEY);
            if (console2 == null) continue;
            messageView.getContentManager().removeContent(each, true);
            return;
        }
    }
}

