/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.importing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.BTWMavenConsole;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectResolver;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.ImportPaths;
import org.jetbrains.idea.maven.project.importing.MavenImportFlow;
import org.jetbrains.idea.maven.project.importing.MavenImportStatusListener;
import org.jetbrains.idea.maven.project.importing.MavenImportedContext;
import org.jetbrains.idea.maven.project.importing.MavenInitialImportContext;
import org.jetbrains.idea.maven.project.importing.MavenPluginResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenReadContext;
import org.jetbrains.idea.maven.project.importing.MavenResolvedContext;
import org.jetbrains.idea.maven.project.importing.MavenSourcesGeneratedContext;
import org.jetbrains.idea.maven.project.importing.RootPath;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@IntellijInternalApi
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015JD\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002JJ\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00192\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\u0019J2\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u00042\u0010\b\u0002\u0010-\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\n2\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\nJ\u000e\u0010/\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020,J\u000e\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u00104\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u00105\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b072\u0006\u00108\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00109\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;H\u0002J\u000e\u0010<\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020,\u00a8\u0006="}, d2={"Lorg/jetbrains/idea/maven/project/importing/MavenImportFlow;", "", "()V", "addManagedFiles", "Lorg/jetbrains/idea/maven/project/importing/MavenInitialImportContext;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitToWorkspaceModel", "Lorg/jetbrains/idea/maven/project/importing/MavenImportedContext;", "context", "Lorg/jetbrains/idea/maven/project/importing/MavenResolvedContext;", "configureMavenProject", "", "downloadArtifacts", "Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadResult;", "sources", "", "javadocs", "downloadSpecificArtifacts", "mavenProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenArtifacts", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "loadOrCreateProjectTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "prepareNewImport", "importPaths", "Lorg/jetbrains/idea/maven/project/importing/ImportPaths;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "enabledProfiles", "", "disabledProfiles", "readMavenFiles", "Lorg/jetbrains/idea/maven/project/importing/MavenReadContext;", "ignorePaths", "ignorePatterns", "resolveDependencies", "resolveFolders", "Lorg/jetbrains/idea/maven/project/importing/MavenSourcesGeneratedContext;", "resolvePlugins", "Lorg/jetbrains/idea/maven/project/importing/MavenPluginResolvedContext;", "runImportExtensions", "runPostImportTasks", "searchForMavenFiles", "", "path", "shouldScheduleProject", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "updateProjectManager", "intellij.maven"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class MavenImportFlow {
    @NotNull
    public final MavenInitialImportContext addManagedFiles(@NotNull Project project2, @NotNull MavenProgressIndicator indicator, @NotNull List<? extends VirtualFile> files) {
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        ArrayList allFiles = new ArrayList(mavenProjectsManager.getProjectsFiles());
        allFiles.addAll(files);
        MavenProjectsManager mavenProjectsManager2 = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"MavenProjectsManager.getInstance(project)");
        MavenExplicitProfiles mavenExplicitProfiles = mavenProjectsManager2.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"MavenProjectsManager.get\u2026project).explicitProfiles");
        MavenExplicitProfiles profiles2 = mavenExplicitProfiles;
        ImportPaths importPaths = new FilesList(allFiles);
        MavenGeneralSettings mavenGeneralSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"manager.generalSettings");
        MavenImportingSettings mavenImportingSettings = manager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"manager.importingSettings");
        return new MavenInitialImportContext(project2, importPaths, profiles2, mavenGeneralSettings, mavenImportingSettings, indicator);
    }

    @NotNull
    public final MavenInitialImportContext prepareNewImport(@NotNull Project project2, @NotNull MavenProgressIndicator indicator, @NotNull ImportPaths importPaths, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenImportingSettings importingSettings, @NotNull Collection<String> enabledProfiles, @NotNull Collection<String> disabledProfiles) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)importPaths, (String)"importPaths");
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter(enabledProfiles, (String)"enabledProfiles");
        Intrinsics.checkNotNullParameter(disabledProfiles, (String)"disabledProfiles");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Boolean isVeryNewProject = (Boolean)project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT);
        if (Intrinsics.areEqual((Object)isVeryNewProject, (Object)true)) {
            ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)externalStorageConfigurationManager, (String)"ExternalStorageConfigura\u2026ager.getInstance(project)");
            externalStorageConfigurationManager.setEnabled(true);
        }
        MavenExplicitProfiles profiles2 = new MavenExplicitProfiles(enabledProfiles, disabledProfiles);
        return new MavenInitialImportContext(project2, importPaths, profiles2, generalSettings, importingSettings, indicator);
    }

    @NotNull
    public final MavenReadContext readMavenFiles(@NotNull MavenInitialImportContext context, @Nullable List<String> ignorePaths, @Nullable List<String> ignorePatterns) {
        List<String> curr;
        List<String> it;
        List<String> list;
        List<VirtualFile> list2;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MavenProjectsManager projectManager = MavenProjectsManager.getInstance(context.getProject());
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = projectManager;
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenProjectsTree projectsTree = this.loadOrCreateProjectTree(mavenProjectsManager);
        MavenProjectsManager.applyStateToTree(projectsTree, projectManager);
        MavenProjectsManager mavenProjectsManager2 = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager2, (String)"MavenProjectsManager.getInstance(context.project)");
        MavenProjectsTree mavenProjectsTree = mavenProjectsManager2.getProjectsTree();
        List<VirtualFile> rootFiles = mavenProjectsTree != null ? mavenProjectsTree.getRootProjectsFiles() : null;
        HashSet pomFiles = new HashSet();
        List<VirtualFile> list3 = rootFiles;
        if (list3 != null) {
            List<VirtualFile> list4 = list3;
            it2 = list4;
            boolean bl = false;
            pomFiles.addAll(CollectionsKt.filterNotNull((Iterable)((Iterable)it2)));
        }
        it2 = context.getPaths();
        if (it2 instanceof FilesList) {
            list2 = ((FilesList)context.getPaths()).getPoms();
        } else if (it2 instanceof RootPath) {
            list2 = this.searchForMavenFiles(((RootPath)context.getPaths()).getPath(), context.getIndicator());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<VirtualFile> newPomFiles = list2;
        pomFiles.addAll(CollectionsKt.filterNotNull((Iterable)newPomFiles));
        projectsTree.addManagedFilesWithProfiles(CollectionsKt.toList((Iterable)pomFiles), context.getProfiles());
        HashSet toResolve = new HashSet();
        HashSet errorsSet = new HashSet();
        Disposable disposable = Disposer.newDisposable((String)"MavenImportFlow:readMavenFiles:treeListener");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"\u2026MavenFiles:treeListener\")");
        Disposable d = disposable;
        Disposer.register((Disposable)projectManager, (Disposable)d);
        projectsTree.addListener(new MavenProjectsTree.Listener(toResolve, projectsTree, errorsSet){
            final /* synthetic */ HashSet $toResolve;
            final /* synthetic */ MavenProjectsTree $projectsTree;
            final /* synthetic */ HashSet $errorsSet;

            /*
             * WARNING - void declaration
             */
            public void projectsUpdated(@NotNull List<com.intellij.openapi.util.Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(updated, (String)"updated");
                Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
                List<MavenProject> allUpdated = MavenUtil.collectFirsts(updated);
                this.$toResolve.addAll((Collection)allUpdated);
                for (MavenProject mavenProject2 : this.$projectsTree.getDependentProjects((Collection<MavenProject>)allUpdated)) {
                    this.$toResolve.add(mavenProject2);
                }
                this.$toResolve.addAll((Collection)this.$projectsTree.getDependentProjects(ContainerUtil.concat(allUpdated, deleted)));
                Iterable iterable = this.$toResolve;
                HashSet hashSet = this.$errorsSet;
                boolean $i$f$filter = false;
                Iterable iterable2 = iterable;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    MavenProject it = (MavenProject)element$iv$iv;
                    boolean bl = false;
                    if (!it.hasReadingProblems()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                hashSet.addAll(list);
                this.$toResolve.removeIf(readMavenFiles.projectsUpdated.2.INSTANCE);
            }
            {
                this.$toResolve = $captured_local_variable$0;
                this.$projectsTree = $captured_local_variable$1;
                this.$errorsSet = $captured_local_variable$2;
            }
        }, d);
        List<String> list5 = ignorePaths;
        if (list5 != null) {
            it = list = list5;
            boolean bl = false;
            curr = projectsTree.getIgnoredFilesPaths();
            curr.addAll((Collection<String>)it);
            projectsTree.setIgnoredFilesPatterns(curr);
        }
        List<String> list6 = ignorePatterns;
        if (list6 != null) {
            it = list = list6;
            boolean bl = false;
            curr = projectsTree.getIgnoredFilesPatterns();
            curr.addAll((Collection<String>)it);
            projectsTree.setIgnoredFilesPatterns(curr);
        }
        projectsTree.updateAll(true, context.getGeneralSettings(), context.getIndicator());
        Disposer.dispose((Disposable)d);
        return new MavenReadContext(context.getProject(), projectsTree, toResolve, errorsSet, context);
    }

    public static /* synthetic */ MavenReadContext readMavenFiles$default(MavenImportFlow mavenImportFlow, MavenInitialImportContext mavenInitialImportContext, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        return mavenImportFlow.readMavenFiles(mavenInitialImportContext, list, list2);
    }

    private final List<VirtualFile> searchForMavenFiles(VirtualFile path, MavenProgressIndicator indicator) {
        indicator.setText(MavenProjectBundle.message("maven.locating.files", new Object[0]));
        List<VirtualFile> list = FileFinder.findPomFiles(path.getChildren(), LookForNestedToggleAction.isSelected(), indicator);
        Intrinsics.checkNotNullExpressionValue(list, (String)"FileFinder.findPomFiles(\u2026.isSelected(), indicator)");
        return list;
    }

    private final MavenProjectsTree loadOrCreateProjectTree(MavenProjectsManager projectManager) {
        Path file = projectManager.getProjectsTreeFile();
        try {
            Path path = file;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            if (PathKt.exists((Path)path)) {
                MavenProjectsTree mavenProjectsTree = MavenProjectsTree.read(projectManager.getProject(), file);
                if (mavenProjectsTree == null) {
                    mavenProjectsTree = new MavenProjectsTree(projectManager.getProject());
                }
                return mavenProjectsTree;
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
        }
        return new MavenProjectsTree(projectManager.getProject());
    }

    @NotNull
    public final MavenResolvedContext resolveDependencies(@NotNull MavenReadContext context) {
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        MavenProjectResolver resolver = new MavenProjectResolver(context.getProjectsTree());
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(context.getProject(), context.getInitialContext().getGeneralSettings().getOutputLevel(), context.getInitialContext().getGeneralSettings().isPrintErrorStackTraces());
        ResolveContext resolveContext = new ResolveContext();
        Disposable disposable = Disposer.newDisposable((String)"MavenImportFlow:resolveDependencies:treeListener");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"\u2026pendencies:treeListener\")");
        Disposable d = disposable;
        Disposer.register((Disposable)projectManager, (Disposable)d);
        ArrayList projectsToImport = new ArrayList();
        ArrayList nativeProjectStorage = new ArrayList();
        context.getProjectsTree().addListener(new MavenProjectsTree.Listener(this, projectsToImport, nativeProjectStorage){
            final /* synthetic */ MavenImportFlow this$0;
            final /* synthetic */ ArrayList $projectsToImport;
            final /* synthetic */ ArrayList $nativeProjectStorage;

            public void projectResolved(@NotNull com.intellij.openapi.util.Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                if (nativeMavenProject != null) {
                    Object object = projectWithChanges.first;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectWithChanges.first");
                    MavenProject mavenProject2 = (MavenProject)object;
                    Object object2 = projectWithChanges.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectWithChanges.second");
                    if (MavenImportFlow.access$shouldScheduleProject(this.this$0, mavenProject2, (MavenProjectChanges)object2)) {
                        this.$projectsToImport.add(projectWithChanges.first);
                    }
                    this.$nativeProjectStorage.add(TuplesKt.to((Object)projectWithChanges.first, (Object)nativeMavenProject));
                }
            }
            {
                this.this$0 = this$0;
                this.$projectsToImport = $captured_local_variable$1;
                this.$nativeProjectStorage = $captured_local_variable$2;
            }
        }, d);
        resolver.resolve(context.getProject(), context.getToResolve(), context.getInitialContext().getGeneralSettings(), embeddersManager, consoleToBeRemoved, resolveContext, context.getInitialContext().getIndicator());
        Disposer.dispose((Disposable)d);
        Project project2 = context.getProject();
        Collection collection = (Collection)resolveContext.getUserData(MavenProjectResolver.UNRESOLVED_ARTIFACTS);
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return new MavenResolvedContext(project2, collection, projectsToImport, nativeProjectStorage, context);
    }

    @NotNull
    public final MavenPluginResolvedContext resolvePlugins(@NotNull MavenResolvedContext context) {
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        MavenProjectResolver resolver = new MavenProjectResolver(context.getReadContext().getProjectsTree());
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(context.getProject(), context.getInitialContext().getGeneralSettings().getOutputLevel(), context.getInitialContext().getGeneralSettings().isPrintErrorStackTraces());
        HashSet unresolvedPlugins = new HashSet();
        Iterable $this$forEach$iv = context.getNativeProjectHolder();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            unresolvedPlugins.addAll(resolver.resolvePlugins((MavenProject)it.getFirst(), (NativeMavenProjectHolder)it.getSecond(), embeddersManager, consoleToBeRemoved, context.getInitialContext().getIndicator(), false, projectManager.getForceUpdateSnapshots()));
        }
        projectManager.setForceUpdateSnapshots(false);
        return new MavenPluginResolvedContext(context.getProject(), unresolvedPlugins, context);
    }

    @NotNull
    public final MavenArtifactDownloader.DownloadResult downloadArtifacts(@NotNull MavenResolvedContext context, boolean sources, boolean javadocs) {
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!sources && !javadocs) {
            return new MavenArtifactDownloader.DownloadResult();
        }
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        MavenProjectResolver resolver = new MavenProjectResolver(context.getReadContext().getProjectsTree());
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(context.getProject(), context.getInitialContext().getGeneralSettings().getOutputLevel(), context.getInitialContext().getGeneralSettings().isPrintErrorStackTraces());
        MavenArtifactDownloader.DownloadResult downloadResult = resolver.downloadSourcesAndJavadocs(context.getProject(), (Collection<MavenProject>)context.getProjectsToImport(), null, sources, javadocs, embeddersManager, consoleToBeRemoved, context.getInitialContext().getIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)downloadResult, (String)"resolver.downloadSources\u2026initialContext.indicator)");
        return downloadResult;
    }

    @NotNull
    public final MavenArtifactDownloader.DownloadResult downloadSpecificArtifacts(@NotNull Project project2, @NotNull Collection<? extends MavenProject> mavenProjects, @Nullable Collection<? extends MavenArtifact> mavenArtifacts, boolean sources, boolean javadocs, @NotNull MavenProgressIndicator indicator) {
        MavenGeneralSettings settings;
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(mavenProjects, (String)"mavenProjects");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!sources && !javadocs) {
            return new MavenArtifactDownloader.DownloadResult();
        }
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        MavenProjectResolver resolver = new MavenProjectResolver(projectManager.getProjectsTree());
        MavenWorkspaceSettingsComponent mavenWorkspaceSettingsComponent = MavenWorkspaceSettingsComponent.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenWorkspaceSettingsComponent, (String)"MavenWorkspaceSettingsCo\u2026nent.getInstance(project)");
        MavenGeneralSettings mavenGeneralSettings = settings = mavenWorkspaceSettingsComponent.getSettings().getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"settings");
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(project2, mavenGeneralSettings.getOutputLevel(), settings.isPrintErrorStackTraces());
        MavenArtifactDownloader.DownloadResult downloadResult = resolver.downloadSourcesAndJavadocs(project2, mavenProjects, mavenArtifacts, sources, javadocs, embeddersManager, consoleToBeRemoved, indicator);
        Intrinsics.checkNotNullExpressionValue((Object)downloadResult, (String)"resolver.downloadSources\u2026leToBeRemoved, indicator)");
        return downloadResult;
    }

    @NotNull
    public final MavenSourcesGeneratedContext resolveFolders(@NotNull MavenResolvedContext context) {
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        MavenProjectResolver resolver = new MavenProjectResolver(context.getReadContext().getProjectsTree());
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(context.getProject(), context.getInitialContext().getGeneralSettings().getOutputLevel(), context.getInitialContext().getGeneralSettings().isPrintErrorStackTraces());
        Disposable disposable = Disposer.newDisposable((String)"MavenImportFlow:resolveFolders:treeListener");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"\u2026lveFolders:treeListener\")");
        Disposable d = disposable;
        HashSet projectsToImport = new HashSet(context.getProjectsToImport());
        ArrayList<MavenProject> projectsFoldersResolved = new ArrayList<MavenProject>();
        Disposer.register((Disposable)projectManager, (Disposable)d);
        context.getReadContext().getProjectsTree().addListener(new MavenProjectsTree.Listener(this, projectsToImport, projectsFoldersResolved){
            final /* synthetic */ MavenImportFlow this$0;
            final /* synthetic */ HashSet $projectsToImport;
            final /* synthetic */ ArrayList $projectsFoldersResolved;

            public void foldersResolved(@NotNull com.intellij.openapi.util.Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                Object object = projectWithChanges.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectWithChanges.first");
                MavenProject mavenProject2 = (MavenProject)object;
                Object object2 = projectWithChanges.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectWithChanges.second");
                if (MavenImportFlow.access$shouldScheduleProject(this.this$0, mavenProject2, (MavenProjectChanges)object2)) {
                    this.$projectsToImport.add(projectWithChanges.first);
                }
                if (((MavenProjectChanges)projectWithChanges.second).hasChanges()) {
                    this.$projectsFoldersResolved.add(projectWithChanges.first);
                }
            }
            {
                this.this$0 = this$0;
                this.$projectsToImport = $captured_local_variable$1;
                this.$projectsFoldersResolved = $captured_local_variable$2;
            }
        }, d);
        Iterable $this$forEach$iv = context.getProjectsToImport();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProject it = (MavenProject)element$iv;
            boolean bl = false;
            resolver.resolveFolders(it, context.getInitialContext().getImportingSettings(), embeddersManager, consoleToBeRemoved, context.getInitialContext().getIndicator());
        }
        Disposer.dispose((Disposable)d);
        return new MavenSourcesGeneratedContext(context, projectsFoldersResolved);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MavenImportedContext commitToWorkspaceModel(@NotNull MavenResolvedContext context) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IdeModifiableModelsProvider ideModifiableModelsProvider = ProjectDataManager.getInstance().createModifiableModelsProvider(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ideModifiableModelsProvider, (String)"ProjectDataManager.getIn\u2026Provider(context.project)");
        IdeModifiableModelsProvider modelsProvider = ideModifiableModelsProvider;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Iterable iterable = context.getProjectsToImport();
        MavenProjectsTree mavenProjectsTree = context.getReadContext().getProjectsTree();
        Project project2 = context.getProject();
        MavenProjectImporter.Companion companion = MavenProjectImporter.Companion;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject2 = (MavenProject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)MavenProjectChanges.ALL);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        MavenProjectImporter projectImporter = companion.createImporter(project2, mavenProjectsTree, MapsKt.toMap((Iterable)collection), false, modelsProvider, context.getInitialContext().getImportingSettings(), null);
        List<MavenProjectsProcessorTask> postImportTasks = projectImporter.importProject();
        List<Module> modulesCreated = projectImporter.getCreatedModules();
        return new MavenImportedContext(context.getProject(), modulesCreated, postImportTasks, context.getReadContext());
    }

    /*
     * WARNING - void declaration
     */
    public final void configureMavenProject(@NotNull MavenImportedContext context) {
        void $this$mapTo$iv$iv;
        List<MavenProject> projects;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context.getProject());
        List<MavenProject> list = projects = context.getReadContext().getProjectsTree().getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"projects");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject2 = (MavenProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)projectsManager.findModule((MavenProject)it));
            collection.add(pair);
        }
        Map moduleMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        MavenProjectImporterBase.configureMavenProjects((Collection<MavenProject>)context.getReadContext().getProjectsTree().getProjects(), moduleMap, context.getProject(), context.getReadContext().getIndicator());
    }

    public final void updateProjectManager(@NotNull MavenReadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MavenProjectsManager projectManager = MavenProjectsManager.getInstance(context.getProject());
        projectManager.addManagedFilesWithProfiles(context.getProjectsTree().getProjectsFiles(), context.getInitialContext().getProfiles(), null);
        projectManager.setProjectsTree(context.getProjectsTree());
    }

    public final void runImportExtensions(@NotNull MavenImportedContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MavenImportStatusListener.EP_NAME.forEachExtensionSafe(new Consumer(context){
            final /* synthetic */ MavenImportedContext $context;

            public final void accept(MavenImportStatusListener it) {
                it.importFinished(this.$context);
            }
            {
                this.$context = mavenImportedContext;
            }
        });
    }

    public final void runPostImportTasks(@NotNull MavenImportedContext context) {
        MavenProjectsManager projectManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        MavenProjectsManager mavenProjectsManager = projectManager = MavenProjectsManager.getInstance(context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectManager");
        MavenEmbeddersManager embeddersManager = mavenProjectsManager.getEmbeddersManager();
        BTWMavenConsole consoleToBeRemoved = new BTWMavenConsole(context.getProject(), context.getReadContext().getInitialContext().getGeneralSettings().getOutputLevel(), context.getReadContext().getInitialContext().getGeneralSettings().isPrintErrorStackTraces());
        List<MavenProjectsProcessorTask> list = context.getPostImportTasks();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenProjectsProcessorTask it = (MavenProjectsProcessorTask)element$iv;
                boolean bl = false;
                it.perform(context.getProject(), embeddersManager, consoleToBeRemoved, context.getReadContext().getIndicator());
            }
        }
    }

    private final boolean shouldScheduleProject(MavenProject project2, MavenProjectChanges changes) {
        return !project2.hasReadingProblems() && changes.hasChanges();
    }

    public static final /* synthetic */ boolean access$shouldScheduleProject(MavenImportFlow $this, MavenProject project2, MavenProjectChanges changes) {
        return $this.shouldScheduleProject(project2, changes);
    }
}

