/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionConverter;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDistributionsCache {
    private final ConcurrentMap<String, String> myWorkingDirToMultimoduleMap = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<String, String> myVmSettingsMap = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<String, MavenDistribution> myMultimoduleDirToWrapperedMavenDistributionsMap = new ConcurrentHashMap<String, MavenDistribution>();
    private final Project myProject;
    private final ClearableLazyValue<MavenDistribution> mySettingsDistribution = ClearableLazyValue.create(() -> this.getSettingsDistribution());

    public MavenDistributionsCache(Project project2) {
        this.myProject = project2;
    }

    public static MavenDistributionsCache getInstance(Project project2) {
        return (MavenDistributionsCache)project2.getService(MavenDistributionsCache.class);
    }

    public void cleanCaches() {
        this.mySettingsDistribution.drop();
        this.myWorkingDirToMultimoduleMap.clear();
        this.myMultimoduleDirToWrapperedMavenDistributionsMap.clear();
        this.myVmSettingsMap.clear();
    }

    @NotNull
    public MavenDistribution getSettingsDistribution() {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        MavenDistribution distribution = new MavenDistributionConverter().fromString(settings.getGeneralSettings().getMavenHome());
        if (distribution == null) {
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.generalSettings.getMavenHome()));
            return MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        MavenDistribution mavenDistribution = distribution;
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(0);
        }
        return mavenDistribution;
    }

    @NotNull
    public String getVmOptions(@Nullable String workingDirectory) {
        String vmOptions = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getImportingSettings().getVmOptionsForImporter();
        if (workingDirectory == null || !StringUtil.isEmptyOrSpaces((String)vmOptions)) {
            String string = vmOptions;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(1);
            }
            return string;
        }
        String multiModuleDir = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        String string = this.myVmSettingsMap.computeIfAbsent(multiModuleDir, MavenExternalParameters::readJvmConfigOptions);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public MavenDistribution getMavenDistribution(@Nullable String workingDirectory) {
        if (!this.useWrapper() || workingDirectory == null) {
            MavenDistribution mavenDistribution = (MavenDistribution)this.mySettingsDistribution.getValue();
            if (mavenDistribution == null) {
                MavenDistributionsCache.$$$reportNull$$$0(3);
            }
            return mavenDistribution;
        }
        String multiModuleDir = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        MavenDistribution mavenDistribution = this.myMultimoduleDirToWrapperedMavenDistributionsMap.computeIfAbsent(multiModuleDir, this::getWrapperDistribution);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(4);
        }
        return mavenDistribution;
    }

    void addWrapper(@NotNull String workingDirectory, @NotNull MavenDistribution distribution) {
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(5);
        }
        if (distribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(6);
        }
        this.myMultimoduleDirToWrapperedMavenDistributionsMap.put(workingDirectory, distribution);
    }

    @NotNull
    private MavenDistribution getWrapperDistribution(@NotNull String multiModuleDir) {
        String distributionUrl;
        if (multiModuleDir == null) {
            MavenDistributionsCache.$$$reportNull$$$0(7);
        }
        MavenDistribution mavenDistribution = (distributionUrl = this.getWrapperDistributionUrl(multiModuleDir)) == null ? MavenDistributionsCache.resolveEmbeddedMavenHome() : MavenDistributionsCache.getMavenWrapper(distributionUrl);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(8);
        }
        return mavenDistribution;
    }

    @Nullable
    public MavenDistribution getWrapper(@NotNull String workingDirectory) {
        String multiModuleDir;
        String distributionUrl;
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(9);
        }
        return (distributionUrl = this.getWrapperDistributionUrl(multiModuleDir = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory))) != null ? MavenWrapperSupport.getCurrentDistribution(distributionUrl) : null;
    }

    private static MavenDistribution getMavenWrapper(String distributionUrl) {
        MavenDistribution distribution = MavenWrapperSupport.getCurrentDistribution(distributionUrl);
        if (distribution == null) {
            distribution = MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        return distribution;
    }

    @NotNull
    public static LocalMavenDistribution resolveEmbeddedMavenHome() {
        Path pluginFileOrDir = Path.of(PathUtil.getJarPathForClass(MavenServerManager.class), new String[0]);
        Path root = pluginFileOrDir.getParent();
        if (Files.isDirectory(pluginFileOrDir, new LinkOption[0])) {
            Path parentPath = MavenUtil.getMavenPluginParentFile().toPath();
            Path mavenPath = parentPath.resolve("maven36-server-impl/lib/maven3");
            if (Files.isDirectory(mavenPath, new LinkOption[0])) {
                return new LocalMavenDistribution(mavenPath, "Bundled (Maven 3)");
            }
        } else {
            return new LocalMavenDistribution(root.resolve("maven3"), "Bundled (Maven 3)");
        }
        throw new RuntimeException("run \"Download Bundled Maven\" run configuration. Cannot resolve embedded maven home without it");
    }

    @Nullable
    String getWrapperDistributionUrl(String multimoduleDirectory) {
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(multimoduleDirectory);
        if (baseDir == null) {
            return null;
        }
        String distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(baseDir);
        if (distributionUrl == null) {
            MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
            MavenProjectsManager.getInstance(this.myProject).getSyncConsole().addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.getGeneralSettings().getMavenHome()));
        }
        return distributionUrl;
    }

    @NotNull
    private String resolveMultimoduleDirectory(@NotNull String workingDirectory) {
        MavenProjectsManager manager;
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(10);
        }
        if (!(manager = MavenProjectsManager.getInstance(this.myProject)).isMavenizedProject()) {
            String string = FileUtil.toSystemIndependentName((String)this.calculateMultimoduleDirUpToFileTree(workingDirectory));
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)manager.getRootProjects().stream().map(p -> p.getDirectory()).filter(rpDirectory -> FileUtil.isAncestor((String)rpDirectory, (String)workingDirectory, (boolean)false)).findFirst().orElseGet(() -> this.calculateMultimoduleDirUpToFileTree(workingDirectory)));
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String calculateMultimoduleDirUpToFileTree(String directory) {
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(directory);
        if (path == null) {
            String string = directory;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(13);
            }
            return string;
        }
        Collection knownWorkingDirs = this.myWorkingDirToMultimoduleMap.values();
        for (String known : knownWorkingDirs) {
            if (!FileUtil.isAncestor((String)known, (String)directory, (boolean)false)) continue;
            String string = known;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = MavenUtil.getVFileBaseDir(path).getPath();
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getMultimoduleDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(16);
        }
        String string = this.myWorkingDirToMultimoduleMap.computeIfAbsent(workingDirectory, this::resolveMultimoduleDirectory);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(17);
        }
        return string;
    }

    private boolean useWrapper() {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        return MavenUtil.isWrapper(settings.getGeneralSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsDistribution";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenDistribution";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperDistribution";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMultimoduleDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMultimoduleDirUpToFileTree";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperDistribution";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveMultimoduleDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMultimoduleDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

