/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.FilePosition;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenWrapperMapping;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport;", "", "()V", "downloadAndInstallMaven", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDistName", "distUrl", "getMd5Hash", "string", "getZipFile", "Ljava/io/File;", "distributionUrl", "makeMavenBinRunnable", "", "mavenHome", "unpackZipFile", "zipFile", "unzip", "zip", "Companion", "intellij.maven"})
public final class MavenWrapperSupport {
    @NotNull
    private static final String DISTRIBUTION_URL_PROPERTY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final MavenDistribution downloadAndInstallMaven(@NotNull String urlString, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        MavenDistribution current = Companion.getCurrentDistribution(urlString);
        if (current != null) {
            return current;
        }
        File zipFile = this.getZipFile(urlString);
        if (!zipFile.isFile()) {
            File partFile;
            block6: {
                partFile = new File(zipFile.getParentFile(), zipFile.getName() + ".part-" + System.currentTimeMillis());
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    ProgressIndicator progressIndicator2;
                    ProgressIndicator $this$apply = progressIndicator2 = progressIndicator;
                    boolean bl = false;
                    $this$apply.setText(SyncBundle.message("maven.sync.wrapper.downloading.from", urlString));
                }
                try {
                    HttpRequests.request((String)urlString).forceHttps(false).connectTimeout(30000).readTimeout(30000).saveToFile(partFile, indicator);
                }
                catch (Throwable t) {
                    if (!(t instanceof ControlFlowException)) break block6;
                    throw (Throwable)new RuntimeException(SyncBundle.message("maven.sync.wrapper.downloading.canceled", new Object[0]));
                }
            }
            FileUtil.rename((File)partFile, (File)zipFile);
        }
        if (!zipFile.isFile()) {
            throw (Throwable)new RuntimeException(SyncBundle.message("cannot.download.zip.from", urlString));
        }
        File home = this.unpackZipFile(zipFile, indicator).getCanonicalFile();
        Map map = MavenWrapperMapping.Companion.getInstance().getMyState$intellij_maven().mapping;
        File file = home;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"home");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"home.absolutePath");
        map.put(urlString, string);
        Path path = home.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"home.toPath()");
        return new LocalMavenDistribution(path, urlString);
    }

    private final File unpackZipFile(File zipFile, ProgressIndicator indicator) {
        this.unzip(zipFile, indicator);
        Object[] dirs2 = zipFile.getParentFile().listFiles(unpackZipFile.dirs.1.INSTANCE);
        if (dirs2 == null || dirs2.length != 1) {
            MavenLog.LOG.warn("Expected exactly 1 top level dir in Maven distribution, found: " + (dirs2 != null ? ArraysKt.asList((Object[])dirs2) : null));
            throw (Throwable)new IllegalStateException(SyncBundle.message("zip.is.not.correct", zipFile.getAbsoluteFile()));
        }
        Object mavenHome = dirs2[0];
        if (!SystemInfo.isWindows) {
            this.makeMavenBinRunnable((File)mavenHome);
        }
        Object object = mavenHome;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mavenHome");
        return object;
    }

    private final void makeMavenBinRunnable(File mavenHome) {
        File mvnExe = new File(mavenHome, "bin/mvn").getCanonicalFile();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
        Files.setPosixFilePermissions(mvnExe.toPath(), permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unzip(File zip, ProgressIndicator indicator) {
        File unpackDir;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2;
            ProgressIndicator $this$apply = progressIndicator2 = progressIndicator;
            boolean bl = false;
            $this$apply.setText(SyncBundle.message("maven.sync.wrapper.unpacking", new Object[0]));
        }
        File file = unpackDir = zip.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"unpackDir");
        String destinationCanonicalPath = file.getCanonicalPath();
        boolean errorUnpacking = true;
        try {
            Closeable closeable = new ZipFile(zip);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
                Enumeration<? extends ZipEntry> entries = enumeration;
                while (entries.hasMoreElements()) {
                    String canonicalPath;
                    ZipEntry entry;
                    if (entries.nextElement() == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.util.zip.ZipEntry");
                    }
                    File destFile = new File(unpackDir, entry.getName());
                    String string = canonicalPath = destFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalPath");
                    String string2 = destinationCanonicalPath;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destinationCanonicalPath");
                    if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                        FileUtil.delete((File)zip);
                        throw (Throwable)new RuntimeException("Directory traversal attack detected, zip file is malicious and IDEA dropped it");
                    }
                    if (entry.isDirectory()) {
                        destFile.mkdirs();
                        continue;
                    }
                    destFile.getParentFile().mkdirs();
                    Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(destFile));
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream it = (BufferedOutputStream)closeable2;
                        boolean bl2 = false;
                        int n = StreamUtil.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)it);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zipFile = Unit.INSTANCE;
            }
            catch (Throwable zipFile) {
                throwable = zipFile;
                throw zipFile;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            errorUnpacking = false;
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                Closeable $this$apply = closeable = progressIndicator3;
                boolean bl = false;
                $this$apply.setText(SyncBundle.message("maven.sync.wrapper.unpacked.into", destinationCanonicalPath));
            }
        }
        catch (Throwable throwable) {
            if (errorUnpacking) {
                ProgressIndicator progressIndicator4 = indicator;
                if (progressIndicator4 != null) {
                    ProgressIndicator $this$apply;
                    ProgressIndicator $this$apply2 = $this$apply = progressIndicator4;
                    boolean bl = false;
                    $this$apply2.setText(SyncBundle.message("maven.sync.wrapper.failure", new Object[0]));
                }
                File[] fileArray = zip.getParentFile().listFiles(new FileFilter(zip){
                    final /* synthetic */ File $zip;

                    public final boolean accept(File it) {
                        File file = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                        return Intrinsics.areEqual((Object)file.getName(), (Object)this.$zip.getName()) ^ true;
                    }
                    {
                        this.$zip = file;
                    }
                });
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    for (File element$iv : $this$forEach$iv) {
                        File it = element$iv;
                        boolean bl = false;
                        FileUtil.delete((File)it);
                    }
                }
            }
            throw throwable;
        }
    }

    private final File getZipFile(String distributionUrl) {
        String baseName = this.getDistName(distributionUrl);
        String string = FileUtil.getNameWithoutExtension((String)baseName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getNameWithoutExtension(baseName)");
        String distName = string;
        String md5Hash = this.getMd5Hash(distributionUrl);
        File file = MavenUtil.resolveM2Dir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"MavenUtil.resolveM2Dir()");
        File m2dir = file;
        File distsDir = new File(m2dir, "wrapper/dists");
        File file2 = new File(new File(new File(distsDir, distName), md5Hash), baseName).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"File(File(File(distsDir,\u2026), baseName).absoluteFile");
        return file2;
    }

    private final String getDistName(String distUrl) {
        String string;
        int p = StringsKt.lastIndexOf$default((CharSequence)distUrl, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (p < 0) {
            string = distUrl;
        } else {
            String string2 = distUrl;
            int n = p + 1;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            string = string3;
        }
        return string;
    }

    private final String getMd5Hash(String string) {
        String string2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string3 = string;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            messageDigest.update(bytes);
            String string4 = new BigInteger(1, messageDigest.digest()).toString(32);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"BigInteger(1, messageDigest.digest()).toString(32)");
            string2 = string4;
        }
        catch (Exception var4) {
            throw (Throwable)new RuntimeException("Could not hash input string.", var4);
        }
        return string2;
    }

    static {
        Companion = new Companion(null);
        DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    }

    @JvmStatic
    @Nullable
    public static final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir) {
        return Companion.getWrapperDistributionUrl(baseDir);
    }

    @JvmStatic
    public static final void showUnsecureWarning(@NotNull MavenSyncConsole console2, @Nullable VirtualFile mavenProjectMultimodulePath) {
        Companion.showUnsecureWarning(console2, mavenProjectMultimodulePath);
    }

    @JvmStatic
    @Nullable
    public static final MavenDistribution getCurrentDistribution(@NotNull String urlString) {
        return Companion.getCurrentDistribution(urlString);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getWrapperProperties(@Nullable VirtualFile baseDir) {
        return Companion.getWrapperProperties(baseDir);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0019\u0010\r\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion;", "", "()V", "DISTRIBUTION_URL_PROPERTY", "", "getDISTRIBUTION_URL_PROPERTY", "()Ljava/lang/String;", "getCurrentDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "getWrapperDistributionUrl", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWrapperProperties", "Lorg/jetbrains/annotations/Nullable;", "showUnsecureWarning", "", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "mavenProjectMultimodulePath", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final String getDISTRIBUTION_URL_PROPERTY() {
            return DISTRIBUTION_URL_PROPERTY;
        }

        @JvmStatic
        @Nullable
        public final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir) {
            VirtualFile virtualFile = this.getWrapperProperties(baseDir);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile wrapperProperties = virtualFile;
            Properties properties = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(wrapperProperties.contentsToByteArray(true));
            properties.load(stream);
            return properties.getProperty(this.getDISTRIBUTION_URL_PROPERTY());
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @JvmStatic
        public final void showUnsecureWarning(@NotNull MavenSyncConsole console2, @Nullable VirtualFile mavenProjectMultimodulePath) {
            FilePosition filePosition;
            int n;
            VirtualFile properties;
            block4: {
                Iterator iterator;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
                        properties = this.getWrapperProperties(mavenProjectMultimodulePath);
                        Object object = properties;
                        if (object == null || (object = object.getInputStream()) == null) break block5;
                        Object object2 = object;
                        Charset charset = properties.getCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"properties.charset");
                        Charset charset2 = charset;
                        Object object3 = object2;
                        Reader reader = new InputStreamReader((InputStream)object3, charset2);
                        int n2 = 8192;
                        object = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
                        if (object == null) break block5;
                        Object object4 = object;
                        boolean $i$f$indexOfFirst = false;
                        boolean bl = false;
                        iterator = object4.iterator();
                        break block6;
                    }
                    n = -1;
                    break block4;
                }
                while (iterator.hasNext()) {
                    void var7_14;
                    Object item$iv = iterator.next();
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)Companion.getDISTRIBUTION_URL_PROPERTY(), (boolean)false, (int)2, null)) {
                        n = var7_14;
                        break block4;
                    }
                    void var10_20 = var7_14;
                    var7_14 = var10_20 + true;
                }
                n = -1;
            }
            int line = n;
            VirtualFile virtualFile = properties;
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3 = virtualFile2 = virtualFile;
                boolean bl = false;
                filePosition = new FilePosition(virtualFile3.toNioPath().toFile(), line, 0);
            } else {
                filePosition = null;
            }
            FilePosition filePosition2 = filePosition;
            String string = SyncBundle.message("maven.sync.wrapper.http.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SyncBundle.message(\"mave\u2026sync.wrapper.http.title\")");
            String string2 = SyncBundle.message("maven.sync.wrapper.http.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SyncBundle.message(\"mave\u2026rapper.http.description\")");
            console2.addWarning(string, string2, filePosition2);
        }

        @JvmStatic
        @Nullable
        public final MavenDistribution getCurrentDistribution(@NotNull String urlString) {
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            MavenWrapperMapping mapping = MavenWrapperMapping.Companion.getInstance();
            String cachedHome = mapping.getMyState$intellij_maven().mapping.get(urlString);
            if (cachedHome != null) {
                Path path;
                Path path2 = path = Path.of(cachedHome, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (PathKt.isDirectory((Path)path2)) {
                    return new LocalMavenDistribution(path, urlString);
                }
                mapping.getMyState$intellij_maven().mapping.remove(urlString);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final VirtualFile getWrapperProperties(@Nullable VirtualFile baseDir) {
            VirtualFile virtualFile = baseDir;
            return virtualFile != null && (virtualFile = virtualFile.findChild(".mvn")) != null && (virtualFile = virtualFile.findChild("wrapper")) != null ? virtualFile.findChild("maven-wrapper.properties") : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

