/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.KeepAliveInputStream;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.TeeOutputStream;

public class SSHExec
extends SSHBase {
    private static final int BUFFER_SIZE = 8192;
    private static final int RETRY_INTERVAL = 500;
    private String command = null;
    private long maxwait = 0L;
    private Thread thread = null;
    private String outputProperty = null;
    private String errorProperty = null;
    private String resultProperty = null;
    private File outputFile = null;
    private File errorFile = null;
    private String inputProperty = null;
    private String inputString = null;
    private File inputFile = null;
    private boolean append = false;
    private boolean appenderr = false;
    private boolean usePty = false;
    private boolean useSystemIn = false;
    private Resource commandResource = null;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";
    private boolean suppressSystemOut = false;
    private boolean suppressSystemErr = false;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCommandResource(String f) {
        this.commandResource = new FileResource(new File(f));
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setErrorOutput(File output) {
        this.errorFile = output;
    }

    public void setInput(File input) {
        this.inputFile = input;
    }

    public void setInputProperty(String inputProperty) {
        this.inputProperty = inputProperty;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setErrAppend(boolean appenderr) {
        this.appenderr = appenderr;
    }

    public void setOutputproperty(String property) {
        this.outputProperty = property;
    }

    public void setErrorproperty(String property) {
        this.errorProperty = property;
    }

    public void setResultproperty(String property) {
        this.resultProperty = property;
    }

    public void setUsePty(boolean b) {
        this.usePty = b;
    }

    public void setUseSystemIn(boolean useSystemIn) {
        this.useSystemIn = useSystemIn;
    }

    public void setSuppressSystemOut(boolean suppressSystemOut) {
        this.suppressSystemOut = suppressSystemOut;
    }

    public void setSuppressSystemErr(boolean suppressSystemErr) {
        this.suppressSystemErr = suppressSystemErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        block30: {
            if (this.getHost() == null) {
                throw new BuildException("Host is required.");
            }
            if (this.getUserInfo().getName() == null) {
                throw new BuildException("Username is required.");
            }
            if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null) {
                throw new BuildException("Password or Keyfile is required.");
            }
            if (this.command == null && this.commandResource == null) {
                throw new BuildException("Command or commandResource is required.");
            }
            int numberOfInputs = (this.inputFile != null ? 1 : 0) + (this.inputProperty != null ? 1 : 0) + (this.inputString != null ? 1 : 0);
            if (numberOfInputs > 1) {
                throw new BuildException("You can't specify more than one of inputFile, inputProperty and inputString.");
            }
            if (this.inputFile != null && !this.inputFile.exists()) {
                throw new BuildException("The input file %s does not exist.", this.inputFile.getAbsolutePath());
            }
            Session session = null;
            StringBuilder output = new StringBuilder();
            try {
                session = this.openSession();
                if (this.command != null) {
                    this.log("cmd : " + this.command, 2);
                    this.executeCommand(session, this.command, output);
                    break block30;
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.commandResource.getInputStream()));){
                    Session s = session;
                    br.lines().forEach(cmd -> {
                        this.log("cmd : " + cmd, 2);
                        output.append((String)cmd).append(" : ");
                        this.executeCommand(s, (String)cmd, output);
                        output.append("\n");
                    });
                }
                catch (IOException e) {
                    if (this.getFailonerror()) {
                        throw new BuildException(e);
                    }
                    this.log("Caught exception: " + e.getMessage(), 0);
                }
            }
            catch (JSchException e) {
                if (this.getFailonerror()) {
                    throw new BuildException(e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
            finally {
                if (this.outputProperty != null) {
                    this.getProject().setNewProperty(this.outputProperty, output.toString());
                }
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Session session, String cmd, StringBuilder sb) throws BuildException {
        String inputData;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream errout = new ByteArrayOutputStream();
        OutputStream teeErr = this.suppressSystemErr ? errout : new TeeOutputStream(errout, KeepAliveOutputStream.wrapSystemErr());
        OutputStream tee = this.suppressSystemOut ? out : new TeeOutputStream(out, KeepAliveOutputStream.wrapSystemOut());
        InputStream istream = null;
        if (this.inputFile != null) {
            try {
                istream = Files.newInputStream(this.inputFile.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.log("Failed to read " + this.inputFile + " because of: " + e.getMessage(), 1);
            }
        }
        if (this.inputProperty != null && (inputData = this.getProject().getProperty(this.inputProperty)) != null) {
            istream = new ByteArrayInputStream(inputData.getBytes());
        }
        if (this.inputString != null) {
            istream = new ByteArrayInputStream(this.inputString.getBytes());
        }
        if (this.useSystemIn) {
            istream = KeepAliveInputStream.wrapSystemIn();
        }
        try {
            session.setTimeout((int)this.maxwait);
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(cmd);
            channel.setOutputStream(tee);
            channel.setExtOutputStream(tee);
            channel.setErrStream(teeErr);
            if (istream != null) {
                channel.setInputStream(istream);
            }
            channel.setPty(this.usePty);
            channel.connect();
            this.thread = new Thread(() -> {
                while (!channel.isClosed()) {
                    if (this.thread == null) {
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            });
            this.thread.start();
            this.thread.join(this.maxwait);
            if (this.thread.isAlive()) {
                this.thread = null;
                if (this.getFailonerror()) {
                    throw new BuildException(TIMEOUT_MESSAGE);
                }
                this.log(TIMEOUT_MESSAGE, 0);
            } else {
                if (this.outputFile != null) {
                    this.writeToFile(out.toString(), this.append, this.outputFile);
                }
                if (this.errorProperty != null) {
                    this.getProject().setNewProperty(this.errorProperty, errout.toString());
                }
                if (this.errorFile != null) {
                    this.writeToFile(errout.toString(), this.appenderr, this.errorFile);
                }
                int ec = channel.getExitStatus();
                if (this.resultProperty != null) {
                    this.getProject().setNewProperty(this.resultProperty, Integer.toString(ec));
                }
                if (ec != 0) {
                    String msg = "Remote command failed with exit status " + ec;
                    if (this.getFailonerror()) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (JSchException e) {
            if (e.getMessage().contains("session is down")) {
                if (this.getFailonerror()) {
                    throw new BuildException(TIMEOUT_MESSAGE, e);
                }
                this.log(TIMEOUT_MESSAGE, 0);
            } else {
                if (this.getFailonerror()) {
                    throw new BuildException(e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
        catch (Exception e) {
            if (this.getFailonerror()) {
                throw new BuildException(e);
            }
            this.log("Caught exception: " + e.getMessage(), 0);
        }
        finally {
            sb.append(out.toString());
            FileUtils.close(istream);
        }
    }

    private void writeToFile(String from, boolean append, File to) throws IOException {
        try (FileWriter out = new FileWriter(to.getAbsolutePath(), append);){
            int bytesRead;
            StringReader in = new StringReader(from);
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
    }
}

