/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.ArchiveData;
import com.intellij.indexing.shared.platform.hash.ArchiveDataCache;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexCrcArchiveHash;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexCrcArchiveHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "()V", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "computeHash", "", "content", "Lcom/intellij/util/indexing/IndexedFile;", "getArchiveFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "archiveEntry", "fs", "Lcom/intellij/openapi/vfs/newvfs/ArchiveFileSystem;", "intellij.indexing.shared"})
public final class SharedIndexCrcArchiveHashProvider
implements SharedIndexContentHashProvider {
    @Override
    @NotNull
    public SharedIndexContentHash getInfo() {
        return SharedIndexCrcArchiveHash.INSTANCE;
    }

    @Override
    @Nullable
    public byte[] computeHash(@NotNull IndexedFile content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"content.file");
        VirtualFile file = virtualFile;
        VirtualFileSystem virtualFileSystem = file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"file.fileSystem");
        VirtualFileSystem fs = virtualFileSystem;
        if (!(fs instanceof ArchiveFileSystem) || !(fs instanceof IntegrityCheckCapableFileSystem)) {
            return null;
        }
        VirtualFile virtualFile2 = this.getArchiveFile(file, (ArchiveFileSystem)fs);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile archiveFile = virtualFile2;
        long crc = 0L;
        ArchiveData archiveData = null;
        try {
            boolean $i$f$service2 = false;
            Object serviceClass$iv = ArchiveDataCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + ((Class)serviceClass$iv).getName() + " (classloader=" + ((Class)serviceClass$iv).getClassLoader() + ")");
            }
            ArchiveData archiveData2 = (ArchiveData)((ArchiveDataCache)object).getOrComputeValue(archiveFile);
            if (archiveData2 == null) {
                return null;
            }
            archiveData = archiveData2;
            if (ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue()) {
                crc = ((ArchiveFileSystem)fs).getTimeStamp(file);
            } else {
                Map $i$f$service2 = (Map)archiveData.getCrcs().getValue();
                serviceClass$iv = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)archiveFile);
                Long l = (Long)$i$f$service2.get(serviceClass$iv);
                if (l == null) {
                    return null;
                }
                crc = l;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (crc == 0L) {
            return null;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        String fileName = string;
        String string2 = archiveData.getName() + ":" + fileName + ":" + crc;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] message = byArray;
        return IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, (byte[])message);
    }

    private final VirtualFile getArchiveFile(VirtualFile archiveEntry, ArchiveFileSystem fs) {
        VirtualFile virtualFile = fs.getRootByEntry(archiveEntry);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"fs.getRootByEntry(archiveEntry) ?: return null");
        VirtualFile localFile = virtualFile;
        boolean bl = Intrinsics.areEqual((Object)localFile.getFileSystem(), (Object)fs);
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return localFile;
    }
}

