/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryBytesSource;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrExpression;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrStatement;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.library.encodings.WobblyTF8;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "bytesSource", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryBytesSource;", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryBytesSource;)V", "debugInfo", "", "index", "", "declaration", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "expressionBody", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrExpression;", "signature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "statementBody", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrStatement;", "string", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrType;", "Companion", "ir.serialization.common"})
public final class IrLibraryFileFromBytes
extends IrLibraryFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrLibraryBytesSource bytesSource;
    @NotNull
    private static final ExtensionRegistryLite extensionRegistryLite;

    public IrLibraryFileFromBytes(@NotNull IrLibraryBytesSource bytesSource) {
        Intrinsics.checkNotNullParameter((Object)bytesSource, (String)"bytesSource");
        this.bytesSource = bytesSource;
    }

    @Override
    @NotNull
    public IrDeclaration declaration(int index) {
        IrDeclaration irDeclaration = IrDeclaration.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.irDeclaration(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue((Object)irDeclaration, (String)"parseFrom(bytesSource.ir\u2026m, extensionRegistryLite)");
        return irDeclaration;
    }

    @Override
    @NotNull
    public IrType type(int index) {
        IrType irType = IrType.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.type(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue((Object)irType, (String)"parseFrom(bytesSource.ty\u2026m, extensionRegistryLite)");
        return irType;
    }

    @Override
    @NotNull
    public IdSignature signature(int index) {
        IdSignature idSignature = IdSignature.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.signature(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue((Object)idSignature, (String)"parseFrom(bytesSource.si\u2026m, extensionRegistryLite)");
        return idSignature;
    }

    @Override
    @NotNull
    public String string(int index) {
        return WobblyTF8.INSTANCE.decode(this.bytesSource.string(index));
    }

    @Override
    @NotNull
    public IrExpression expressionBody(int index) {
        IrExpression irExpression = IrExpression.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.body(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue((Object)irExpression, (String)"parseFrom(bytesSource.bo\u2026m, extensionRegistryLite)");
        return irExpression;
    }

    @Override
    @NotNull
    public IrStatement statementBody(int index) {
        IrStatement irStatement = IrStatement.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(this.bytesSource.body(index)), extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue((Object)irStatement, (String)"parseFrom(bytesSource.bo\u2026m, extensionRegistryLite)");
        return irStatement;
    }

    @Override
    @Nullable
    public String debugInfo(int index) {
        String string;
        byte[] byArray = this.bytesSource.debugInfo(index);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            string = WobblyTF8.INSTANCE.decode(it);
        } else {
            string = null;
        }
        return string;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)extensionRegistryLite, (String)"newInstance()");
        IrLibraryFileFromBytes.extensionRegistryLite = extensionRegistryLite;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes$Companion;", "", "()V", "extensionRegistryLite", "Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "getExtensionRegistryLite", "()Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionRegistryLite getExtensionRegistryLite() {
            return extensionRegistryLite;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

