/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class NewExprent
extends Exprent {
    private InvocationExprent constructor;
    private final VarType newType;
    private final List<Exprent> lstDims;
    private List<Exprent> lstArrayElements = new ArrayList<Exprent>();
    private boolean directArrayInit;
    private boolean isVarArgParam;
    private boolean anonymous;
    private boolean lambda;
    private boolean enumConst;

    public NewExprent(VarType newType, ListStack<Exprent> stack, int arrayDim, Set<Integer> bytecodeOffsets) {
        this(newType, NewExprent.getDimensions(arrayDim, stack), bytecodeOffsets);
    }

    public NewExprent(VarType newType, List<Exprent> lstDims, Set<Integer> bytecodeOffsets) {
        super(10);
        ClassesProcessor.ClassNode node;
        this.newType = newType;
        this.lstDims = lstDims;
        this.anonymous = false;
        this.lambda = false;
        if (newType.getType() == 8 && newType.getArrayDim() == 0 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newType.getValue())) != null && (node.type == 2 || node.type == 8)) {
            this.anonymous = true;
            if (node.type == 8) {
                this.lambda = true;
            }
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static List<Exprent> getDimensions(int arrayDim, ListStack<Exprent> stack) {
        ArrayList<Exprent> lstDims = new ArrayList<Exprent>();
        for (int i = 0; i < arrayDim; ++i) {
            lstDims.add(0, stack.pop());
        }
        return lstDims;
    }

    @Override
    public VarType getExprType() {
        return this.anonymous ? DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)this.newType.getValue()).anonymousClassType : this.newType;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.newType.getArrayDim() != 0) {
            for (Exprent dim : this.lstDims) {
                result.addMinTypeExprent(dim, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(dim, VarType.VARTYPE_INT);
            }
            if (this.newType.getArrayDim() == 1) {
                VarType leftType = this.newType.decreaseArrayDim();
                for (Exprent element : this.lstArrayElements) {
                    result.addMinTypeExprent(element, VarType.getMinTypeInFamily(leftType.getTypeFamily()));
                    result.addMaxTypeExprent(element, leftType);
                }
            }
        } else if (this.constructor != null) {
            return this.constructor.checkExprTypeBounds();
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.newType.getArrayDim() != 0) {
            lst.addAll(this.lstDims);
            lst.addAll(this.lstArrayElements);
        } else if (this.constructor != null) {
            Exprent constructor = this.constructor.getInstance();
            if (constructor != null) {
                lst.add(constructor);
            }
            lst.addAll(this.constructor.getParameters());
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstDims) {
            lst.add(expr.copy());
        }
        NewExprent ret = new NewExprent(this.newType, lst, this.bytecode);
        ret.setConstructor(this.constructor == null ? null : (InvocationExprent)this.constructor.copy());
        ret.setLstArrayElements(this.lstArrayElements);
        ret.setDirectArrayInit(this.directArrayInit);
        ret.setAnonymous(this.anonymous);
        ret.setEnumConst(this.enumConst);
        return ret;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.anonymous) {
            boolean selfReference;
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.getValue());
            boolean bl = selfReference = DecompilerContext.getProperty("CURRENT_CLASS_NODE") == child;
            if (!(this.enumConst || this.lambda && !DecompilerContext.getOption("lac"))) {
                String enclosing = null;
                if (!this.lambda && this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(child.anonymousClassType.getValue(), this.constructor.getParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                if (selfReference) {
                    buf.append("<anonymous constructor>");
                } else {
                    GenericClassDescriptor descriptor;
                    String typename = ExprProcessor.getCastTypeName(child.anonymousClassType, Collections.emptyList());
                    if (enclosing != null) {
                        ClassesProcessor.ClassNode anonymousNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(child.anonymousClassType.getValue());
                        typename = anonymousNode != null ? anonymousNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                    }
                    if ((descriptor = ClassWriter.getGenericClassDescriptor(child.classStruct)) != null) {
                        if (descriptor.superinterfaces.isEmpty()) {
                            buf.append(GenericMain.getGenericCastTypeName(descriptor.superclass, Collections.emptyList()));
                        } else {
                            if (descriptor.superinterfaces.size() > 1 && !this.lambda) {
                                DecompilerContext.getLogger().writeMessage("Inconsistent anonymous class signature: " + child.classStruct.qualifiedName, IFernflowerLogger.Severity.WARN);
                            }
                            buf.append(GenericMain.getGenericCastTypeName(descriptor.superinterfaces.get(0), Collections.emptyList()));
                        }
                    } else {
                        buf.append(typename);
                    }
                }
            }
            buf.append('(');
            if (!this.lambda && this.constructor != null) {
                List<Exprent> parameters = this.constructor.getParameters();
                List<VarVersionPair> mask = child.getWrapper().getMethodWrapper((String)"<init>", (String)this.constructor.getStringDescriptor()).synthParameters;
                if (mask == null) {
                    InvocationExprent superCall = child.superInvocation;
                    mask = ExprUtil.getSyntheticParametersMask(superCall.getClassName(), superCall.getStringDescriptor(), parameters.size());
                }
                int start = this.enumConst ? 2 : 0;
                boolean firstParam = true;
                for (int i = start; i < parameters.size(); ++i) {
                    if (mask != null && mask.get(i) != null) continue;
                    if (!firstParam) {
                        buf.append(", ");
                    }
                    ExprProcessor.getCastedExprent(parameters.get(i), this.constructor.getDescriptor().params[i], buf, indent, true, tracer);
                    firstParam = false;
                }
            }
            buf.append(')');
            if (this.enumConst && buf.length() == 2) {
                buf.setLength(0);
            }
            if (this.lambda) {
                if (!DecompilerContext.getOption("lac")) {
                    buf.setLength(0);
                }
                Exprent methodObject = this.constructor == null ? null : this.constructor.getInstance();
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classLambdaToJava(child, clsBuf, methodObject, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            } else if (!selfReference) {
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classToJava(child, clsBuf, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            }
        } else if (this.directArrayInit) {
            VarType leftType = this.newType.decreaseArrayDim();
            buf.append('{');
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
            }
            buf.append('}');
        } else if (this.newType.getArrayDim() == 0) {
            if (!this.enumConst) {
                String enclosing = null;
                if (this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(this.newType.getValue(), this.constructor.getParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                String typename = ExprProcessor.getTypeName(this.newType, Collections.emptyList());
                if (enclosing != null) {
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.getValue());
                    typename = newNode != null ? newNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.append(typename);
            }
            if (this.constructor != null) {
                int start;
                List<Exprent> parameters = this.constructor.getParameters();
                List<VarVersionPair> mask = ExprUtil.getSyntheticParametersMask(this.constructor.getClassName(), this.constructor.getStringDescriptor(), parameters.size());
                int n = start = this.enumConst ? 2 : 0;
                if (!this.enumConst || start < parameters.size()) {
                    buf.append('(');
                    boolean firstParam = true;
                    for (int i = start; i < parameters.size(); ++i) {
                        if (mask != null && mask.get(i) != null) continue;
                        Exprent expr = parameters.get(i);
                        VarType leftType = this.constructor.getDescriptor().params[i];
                        if (i == parameters.size() - 1 && expr.getExprType() == VarType.VARTYPE_NULL && NewExprent.probablySyntheticParameter(leftType.getValue())) break;
                        if (!firstParam) {
                            buf.append(", ");
                        }
                        ExprProcessor.getCastedExprent(expr, leftType, buf, indent, true, false, true, true, tracer);
                        firstParam = false;
                    }
                    buf.append(')');
                }
            }
        } else if (this.isVarArgParam) {
            VarType elementType;
            VarType leftType = this.newType.decreaseArrayDim();
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                Exprent element = this.lstArrayElements.get(i);
                if (element.type == 10) {
                    ((NewExprent)element).setDirectArrayInit(false);
                }
                ExprProcessor.getCastedExprent(element, leftType, buf, indent, false, tracer);
            }
            if (this.lstArrayElements.size() == 1 && (elementType = this.lstArrayElements.get(0).getExprType()).getType() == 8 && elementType.getValue().equals("java/lang/Object") && elementType.getArrayDim() >= 1) {
                buf.prepend("(Object)");
            }
        } else {
            buf.append("new ").append(ExprProcessor.getTypeName(this.newType, Collections.emptyList()));
            if (this.lstArrayElements.isEmpty()) {
                for (int i = 0; i < this.newType.getArrayDim(); ++i) {
                    buf.append('[');
                    if (i < this.lstDims.size()) {
                        buf.append(this.lstDims.get(i).toJava(indent, tracer));
                    }
                    buf.append(']');
                }
            } else {
                for (int i = 0; i < this.newType.getArrayDim(); ++i) {
                    buf.append("[]");
                }
                VarType leftType = this.newType.decreaseArrayDim();
                buf.append('{');
                for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
                }
                buf.append('}');
            }
        }
        return buf;
    }

    private static boolean probablySyntheticParameter(String className) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(className);
        return node != null && node.type == 2;
    }

    private static String getQualifiedNewInstance(String classname, List<Exprent> lstParams, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
        if (node != null && node.type != 0 && node.type != 4 && (node.access & 8) == 0 && !lstParams.isEmpty()) {
            Exprent enclosing = lstParams.get(0);
            boolean isQualifiedNew = false;
            if (enclosing.type == 12) {
                VarExprent varEnclosing = (VarExprent)enclosing;
                StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                String this_classname = varEnclosing.getProcessor().getThisVars().get(new VarVersionPair(varEnclosing));
                if (!current_class.qualifiedName.equals(this_classname)) {
                    isQualifiedNew = true;
                }
            } else {
                isQualifiedNew = true;
            }
            if (isQualifiedNew) {
                return enclosing.toJava(indent, tracer).toString();
            }
        }
        return null;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        int i;
        if (oldExpr == this.constructor) {
            this.constructor = (InvocationExprent)newExpr;
        }
        if (this.constructor != null) {
            this.constructor.replaceExprent(oldExpr, newExpr);
        }
        for (i = 0; i < this.lstDims.size(); ++i) {
            if (oldExpr != this.lstDims.get(i)) continue;
            this.lstDims.set(i, newExpr);
        }
        for (i = 0; i < this.lstArrayElements.size(); ++i) {
            if (oldExpr != this.lstArrayElements.get(i)) continue;
            this.lstArrayElements.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewExprent)) {
            return false;
        }
        NewExprent ne = (NewExprent)o;
        return Objects.equals(this.newType, ne.getNewType()) && InterpreterUtil.equalLists(this.lstDims, ne.getLstDims()) && Objects.equals(this.constructor, ne.getConstructor()) && this.directArrayInit == ne.directArrayInit && InterpreterUtil.equalLists(this.lstArrayElements, ne.getLstArrayElements());
    }

    public InvocationExprent getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExprent constructor) {
        this.constructor = constructor;
    }

    public List<Exprent> getLstDims() {
        return this.lstDims;
    }

    public VarType getNewType() {
        return this.newType;
    }

    public List<Exprent> getLstArrayElements() {
        return this.lstArrayElements;
    }

    public void setLstArrayElements(List<Exprent> lstArrayElements) {
        this.lstArrayElements = lstArrayElements;
    }

    public void setDirectArrayInit(boolean directArrayInit) {
        this.directArrayInit = directArrayInit;
    }

    public void setVarArgParam(boolean isVarArgParam) {
        this.isVarArgParam = isVarArgParam;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setEnumConst(boolean enumConst) {
        this.enumConst = enumConst;
    }
}

