/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.tasks;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyDuplicatePublicationTracker;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class PublishToIvyRepository
extends DefaultTask {
    private IvyPublicationInternal publication;
    private IvyArtifactRepository repository;
    private final Property<Credentials> credentials = this.getProject().getObjects().property(Credentials.class);

    public PublishToIvyRepository() {
        this.getInputs().files(() -> {
            IvyPublicationInternal publicationInternal = this.getPublicationInternal();
            return publicationInternal == null ? null : publicationInternal.getPublishableArtifacts().getFiles();
        }).withPropertyName("publication.publishableFiles").withPathSensitivity(PathSensitivity.NAME_ONLY);
    }

    @Internal
    public IvyPublication getPublication() {
        return this.publication;
    }

    public void setPublication(IvyPublication publication) {
        this.publication = PublishToIvyRepository.toPublicationInternal(publication);
    }

    private IvyPublicationInternal getPublicationInternal() {
        return PublishToIvyRepository.toPublicationInternal(this.getPublication());
    }

    private static IvyPublicationInternal toPublicationInternal(IvyPublication publication) {
        if (publication == null) {
            return null;
        }
        if (publication instanceof IvyPublicationInternal) {
            return (IvyPublicationInternal)publication;
        }
        throw new InvalidUserDataException(String.format("publication objects must implement the '%s' interface, implementation '%s' does not", IvyPublicationInternal.class.getName(), publication.getClass().getName()));
    }

    @Internal
    public IvyArtifactRepository getRepository() {
        return this.repository;
    }

    @Nested
    @Optional
    Property<Credentials> getCredentials() {
        return this.credentials;
    }

    public void setRepository(IvyArtifactRepository repository) {
        this.repository = repository;
        this.credentials.set(((AuthenticationSupportedInternal)((Object)repository)).getConfiguredCredentials());
    }

    @TaskAction
    public void publish() {
        IvyPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        IvyArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.getDuplicatePublicationTracker().checkCanPublish(publicationInternal, repository.getUrl(), repository.getName());
        this.doPublish(publicationInternal, repository);
    }

    @Inject
    protected IvyPublisher getIvyPublisher() {
        throw new UnsupportedOperationException();
    }

    private void doPublish(final IvyPublicationInternal publication, final IvyArtifactRepository repository) {
        new PublishOperation(publication, repository.getName()){

            @Override
            protected void publish() {
                IvyNormalizedPublication normalizedPublication = publication.asNormalisedPublication();
                IvyPublisher publisher = PublishToIvyRepository.this.getIvyPublisher();
                publisher.publish(normalizedPublication, repository);
            }
        }.run();
    }

    @Inject
    protected IvyDuplicatePublicationTracker getDuplicatePublicationTracker() {
        throw new UnsupportedOperationException();
    }
}

