/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;

@NotThreadSafe
public class ConfigureDelegate
extends GroovyObjectSupport {
    protected final DynamicObject _owner;
    protected final DynamicObject _delegate;
    private boolean _configuring;

    public ConfigureDelegate(Closure configureClosure, Object delegate) {
        this._owner = DynamicObjectUtil.asDynamicObject(configureClosure.getOwner());
        this._delegate = DynamicObjectUtil.asDynamicObject(delegate);
    }

    public String toString() {
        return this._delegate.toString();
    }

    protected DynamicInvokeResult _configure(String name, Object[] params) {
        return DynamicInvokeResult.notFound();
    }

    protected DynamicInvokeResult _configure(String name) {
        return DynamicInvokeResult.notFound();
    }

    public Object invokeMethod(String name, Object paramsObj) {
        Object[] params = (Object[])paramsObj;
        boolean isAlreadyConfiguring = this._configuring;
        this._configuring = true;
        try {
            DynamicInvokeResult result2 = this._delegate.tryInvokeMethod(name, params);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            MissingMethodException failure = null;
            if (!isAlreadyConfiguring) {
                try {
                    result2 = this._configure(name, params);
                }
                catch (MissingMethodException e) {
                    failure = e;
                }
                if (result2.isFound()) {
                    Object object = result2.getValue();
                    return object;
                }
            }
            if ((result2 = this._owner.tryInvokeMethod(name, params)).isFound()) {
                Object object = result2.getValue();
                return object;
            }
            if (failure != null) {
                throw failure;
            }
            throw this._delegate.methodMissingException(name, params);
        }
        finally {
            this._configuring = isAlreadyConfiguring;
        }
    }

    public void setProperty(String property, Object newValue) {
        DynamicInvokeResult result2 = this._delegate.trySetProperty(property, newValue);
        if (result2.isFound()) {
            return;
        }
        result2 = this._owner.trySetProperty(property, newValue);
        if (result2.isFound()) {
            return;
        }
        throw this._delegate.setMissingProperty(property);
    }

    public Object getProperty(String name) {
        boolean isAlreadyConfiguring = this._configuring;
        this._configuring = true;
        try {
            DynamicInvokeResult result2 = this._delegate.tryGetProperty(name);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            result2 = this._owner.tryGetProperty(name);
            if (result2.isFound()) {
                Object object = result2.getValue();
                return object;
            }
            if (!isAlreadyConfiguring && (result2 = this._configure(name)).isFound()) {
                Object object = result2.getValue();
                return object;
            }
            throw this._delegate.getMissingProperty(name);
        }
        finally {
            this._configuring = isAlreadyConfiguring;
        }
    }
}

