/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.internal;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.specs.Spec;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.language.BinaryCollection;
import org.gradle.language.BinaryProvider;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultBinaryCollection<T extends SoftwareComponent>
implements BinaryCollection<T> {
    private final Class<T> elementType;
    private final Set<T> elements = new LinkedHashSet<T>();
    private List<SingleElementProvider<?>> pending = new LinkedList();
    private State state = State.Collecting;
    private ImmutableActionSet<T> knownActions = ImmutableActionSet.empty();
    private ImmutableActionSet<T> configureActions = ImmutableActionSet.empty();
    private ImmutableActionSet<T> finalizeActions = ImmutableActionSet.empty();

    @Inject
    public DefaultBinaryCollection(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public <S> BinaryProvider<S> get(Class<S> type, Spec<? super S> spec) {
        SingleElementProvider<S> provider = new SingleElementProvider<S>(type, spec);
        if (this.state == State.Collecting) {
            this.pending.add(provider);
        } else {
            provider.selectNow();
        }
        return provider;
    }

    @Override
    public BinaryProvider<T> getByName(String name) {
        return this.get(this.elementType, element -> element.getName().equals(name));
    }

    @Override
    public BinaryProvider<T> get(Spec<? super T> spec) {
        return this.get(this.elementType, spec);
    }

    @Override
    public void whenElementKnown(Action<? super T> action) {
        if (this.state != State.Collecting) {
            throw new IllegalStateException("Cannot add actions to this collection as it has already been realized.");
        }
        this.knownActions = this.knownActions.add(action);
    }

    @Override
    public <S> void whenElementKnown(Class<S> type, Action<? super S> action) {
        this.whenElementKnown(new TypeFilteringAction(type, action));
    }

    @Override
    public void whenElementFinalized(Action<? super T> action) {
        if (this.state == State.Finalized) {
            for (SoftwareComponent element : this.elements) {
                action.execute(element);
            }
        } else {
            this.finalizeActions = this.finalizeActions.add(action);
        }
    }

    @Override
    public <S> void whenElementFinalized(Class<S> type, Action<? super S> action) {
        this.whenElementFinalized(new TypeFilteringAction(type, action));
    }

    @Override
    public void configureEach(Action<? super T> action) {
        if (this.state != State.Collecting) {
            throw new IllegalStateException("Cannot add actions to this collection as it has already been realized.");
        }
        this.configureActions = this.configureActions.add(action);
    }

    @Override
    public <S> void configureEach(Class<S> type, Action<? super S> action) {
        this.configureEach(new TypeFilteringAction(type, action));
    }

    public void add(T element) {
        if (this.state != State.Collecting) {
            throw new IllegalStateException("Cannot add an element to this collection as it has already been realized.");
        }
        this.elements.add(element);
    }

    public void realizeNow() {
        if (this.state != State.Collecting) {
            throw new IllegalStateException("Cannot realize this collection as it has already been realized.");
        }
        this.state = State.Realizing;
        for (SoftwareComponent softwareComponent : this.elements) {
            this.knownActions.execute(softwareComponent);
        }
        this.knownActions = ImmutableActionSet.empty();
        for (SingleElementProvider singleElementProvider : this.pending) {
            singleElementProvider.selectNow();
        }
        this.pending = null;
        for (SoftwareComponent softwareComponent : this.elements) {
            this.configureActions.execute(softwareComponent);
        }
        this.configureActions = ImmutableActionSet.empty();
        this.state = State.Finalized;
        for (SoftwareComponent softwareComponent : this.elements) {
            this.finalizeActions.execute(softwareComponent);
        }
        this.finalizeActions = ImmutableActionSet.empty();
    }

    @Override
    public Set<T> get() {
        if (this.state != State.Finalized) {
            throw new IllegalStateException("Cannot query the elements of this container as the elements have not been created yet.");
        }
        return ImmutableSet.copyOf(this.elements);
    }

    private static class TypeFilteringAction<T extends SoftwareComponent, S>
    implements Action<T> {
        private final Class<S> type;
        private final Action<? super S> action;

        TypeFilteringAction(Class<S> type, Action<? super S> action) {
            this.type = type;
            this.action = action;
        }

        @Override
        public void execute(T t) {
            if (this.type.isInstance(t)) {
                this.action.execute(this.type.cast(t));
            }
        }
    }

    private class SingleElementProvider<S>
    extends AbstractMinimalProvider<S>
    implements BinaryProvider<S> {
        private final Class<S> type;
        private Spec<? super S> spec;
        private S match;
        private boolean ambiguous;

        SingleElementProvider(Class<S> type, Spec<? super S> spec) {
            this.type = type;
            this.spec = spec;
        }

        void selectNow() {
            for (SoftwareComponent element : DefaultBinaryCollection.this.elements) {
                if (!this.type.isInstance(element) || !this.spec.isSatisfiedBy(this.type.cast(element))) continue;
                if (this.match != null) {
                    this.ambiguous = true;
                    this.match = null;
                    break;
                }
                this.match = this.type.cast(element);
            }
            this.spec = null;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            return this.type;
        }

        @Override
        public void configure(Closure<?> closure) {
            this.configure(ConfigureUtil.configureUsing(closure));
        }

        @Override
        public void configure(Action<? super S> action) {
            DefaultBinaryCollection.this.configureEach(t -> {
                if (this.match == t) {
                    action.execute((S)this.match);
                }
            });
        }

        @Override
        public void whenFinalized(Action<? super S> action) {
            DefaultBinaryCollection.this.whenElementFinalized(t -> {
                if (this.match == t) {
                    action.execute((S)this.match);
                }
            });
        }

        @Override
        protected ValueSupplier.Value<S> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            if (this.ambiguous) {
                throw new IllegalStateException("Found multiple elements");
            }
            return ValueSupplier.Value.ofNullable(this.match);
        }
    }

    private static enum State {
        Collecting,
        Realizing,
        Finalized;

    }
}

