/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlinx.datetime.MathJvmKt;
import kotlinx.datetime.serializers.DateBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.DateTimeUnitSerializer;
import kotlinx.datetime.serializers.DayBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.MonthBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.TimeBasedDateTimeUnitSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=DateTimeUnitSerializer.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000b2\u00020\u0001:\u0005\u000b\f\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0004J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0004J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006H\u00a6\u0002\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lkotlinx/datetime/DateTimeUnit;", "", "()V", "formatToString", "", "value", "", "unit", "", "times", "scalar", "Companion", "DateBased", "DayBased", "MonthBased", "TimeBased", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "kotlinx-datetime"})
public abstract class DateTimeUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TimeBased NANOSECOND = new TimeBased(1L);
    @NotNull
    private static final TimeBased MICROSECOND = NANOSECOND.times(1000);
    @NotNull
    private static final TimeBased MILLISECOND = MICROSECOND.times(1000);
    @NotNull
    private static final TimeBased SECOND = MILLISECOND.times(1000);
    @NotNull
    private static final TimeBased MINUTE = SECOND.times(60);
    @NotNull
    private static final TimeBased HOUR = MINUTE.times(60);
    @NotNull
    private static final DayBased DAY = new DayBased(1);
    @NotNull
    private static final DayBased WEEK = DAY.times(7);
    @NotNull
    private static final MonthBased MONTH = new MonthBased(1);
    @NotNull
    private static final MonthBased QUARTER = MONTH.times(3);
    @NotNull
    private static final MonthBased YEAR = MONTH.times(12);
    @NotNull
    private static final MonthBased CENTURY = YEAR.times(100);

    private DateTimeUnit() {
    }

    @NotNull
    public abstract DateTimeUnit times(int var1);

    @NotNull
    protected final String formatToString(int value, @NotNull String unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value == 1 ? unit : "" + value + '-' + unit;
    }

    @NotNull
    protected final String formatToString(long value, @NotNull String unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value == 1L ? unit : "" + value + '-' + unit;
    }

    public /* synthetic */ DateTimeUnit(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable(with=TimeBasedDateTimeUnitSerializer.class)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016R#\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lkotlinx/datetime/DateTimeUnit$TimeBased;", "Lkotlinx/datetime/DateTimeUnit;", "nanoseconds", "", "(J)V", "duration", "Lkotlin/time/Duration;", "getDuration-UwyO8pc$annotations", "()V", "getDuration-UwyO8pc", "()J", "getNanoseconds", "unitName", "", "unitScale", "equals", "", "other", "", "hashCode", "", "times", "scalar", "toString", "Companion", "kotlinx-datetime"})
    public static final class TimeBased
    extends DateTimeUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long nanoseconds;
        @NotNull
        private final String unitName;
        private final long unitScale;

        public TimeBased(long nanoseconds) {
            super(null);
            this.nanoseconds = nanoseconds;
            boolean bl = this.nanoseconds > 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unit duration must be positive, but was " + this.getNanoseconds() + " ns.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (this.nanoseconds % 3600000000000L == 0L) {
                this.unitName = "HOUR";
                this.unitScale = this.nanoseconds / 3600000000000L;
            } else if (this.nanoseconds % 60000000000L == 0L) {
                this.unitName = "MINUTE";
                this.unitScale = this.nanoseconds / 60000000000L;
            } else if (this.nanoseconds % (long)1000000000 == 0L) {
                this.unitName = "SECOND";
                this.unitScale = this.nanoseconds / (long)1000000000;
            } else if (this.nanoseconds % (long)1000000 == 0L) {
                this.unitName = "MILLISECOND";
                this.unitScale = this.nanoseconds / (long)1000000;
            } else if (this.nanoseconds % (long)1000 == 0L) {
                this.unitName = "MICROSECOND";
                this.unitScale = this.nanoseconds / (long)1000;
            } else {
                this.unitName = "NANOSECOND";
                this.unitScale = this.nanoseconds;
            }
        }

        public final long getNanoseconds() {
            return this.nanoseconds;
        }

        @Override
        @NotNull
        public TimeBased times(int scalar) {
            return new TimeBased(MathJvmKt.safeMultiply(this.nanoseconds, (long)scalar));
        }

        public final long getDuration-UwyO8pc() {
            return Duration.Companion.nanoseconds-UwyO8pc(this.nanoseconds);
        }

        @ExperimentalTime
        public static /* synthetic */ void getDuration-UwyO8pc$annotations() {
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof TimeBased && this.nanoseconds == ((TimeBased)other).nanoseconds;
        }

        public int hashCode() {
            return (int)this.nanoseconds ^ (int)(this.nanoseconds >> 32);
        }

        @NotNull
        public String toString() {
            return this.formatToString(this.unitScale, this.unitName);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lkotlinx/datetime/DateTimeUnit$TimeBased$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "kotlinx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TimeBased> serializer() {
                return TimeBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=DateBasedDateTimeUnitSerializer.class)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b7\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002Z>\b\u0007\u0010\u0004\"\u00020\u00052\u00020\u0005B0\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\"\b\t\u0012\u001e\b\u000bB\u001a\b\n\u0012\f\b\u000b\u0012\b\b\fJ\u0004\b\b(\f\u0012\b\b\r\u0012\u0004\b\b(\u000eZ>\b\u0007\u0010\u000f\"\u00020\u00102\u00020\u0010B0\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0011\u0012\"\b\t\u0012\u001e\b\u000bB\u001a\b\n\u0012\f\b\u000b\u0012\b\b\fJ\u0004\b\b(\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0082\u0001\u0002\u0005\u0010\u00a8\u0006\u0013"}, d2={"Lkotlinx/datetime/DateTimeUnit$DateBased;", "Lkotlinx/datetime/DateTimeUnit;", "()V", "Companion", "DayBased", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "Lkotlin/Deprecated;", "message", "Use DateTimeUnit.DayBased", "replaceWith", "Lkotlin/ReplaceWith;", "imports", "kotlinx.datetime.DateTimeUnit", "expression", "DateTimeUnit.DayBased", "MonthBased", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "Use DateTimeUnit.MonthBased", "DateTimeUnit.MonthBased", "kotlinx-datetime"})
    public static abstract class DateBased
    extends DateTimeUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private DateBased() {
            super(null);
        }

        @Deprecated(message="Use DateTimeUnit.DayBased", replaceWith=@ReplaceWith(expression="DateTimeUnit.DayBased", imports={"kotlinx.datetime.DateTimeUnit"}))
        public static /* synthetic */ void DayBased$annotations() {
        }

        @Deprecated(message="Use DateTimeUnit.MonthBased", replaceWith=@ReplaceWith(expression="DateTimeUnit.MonthBased", imports={"kotlinx.datetime.DateTimeUnit"}))
        public static /* synthetic */ void MonthBased$annotations() {
        }

        public /* synthetic */ DateBased(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lkotlinx/datetime/DateTimeUnit$DateBased$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "kotlinx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DateBased> serializer() {
                return DateBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=DayBasedDateTimeUnitSerializer.class)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lkotlinx/datetime/DateTimeUnit$DayBased;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "days", "", "(I)V", "getDays", "()I", "equals", "", "other", "", "hashCode", "times", "scalar", "toString", "", "Companion", "kotlinx-datetime"})
    public static final class DayBased
    extends DateBased {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int days;

        public DayBased(int days) {
            super(null);
            this.days = days;
            boolean bl = this.days > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unit duration must be positive, but was " + this.getDays() + " days.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final int getDays() {
            return this.days;
        }

        @Override
        @NotNull
        public DayBased times(int scalar) {
            return new DayBased(MathJvmKt.safeMultiply(this.days, scalar));
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DayBased && this.days == ((DayBased)other).days;
        }

        public int hashCode() {
            return this.days ^ 0x10000;
        }

        @NotNull
        public String toString() {
            return this.days % 7 == 0 ? this.formatToString(this.days / 7, "WEEK") : this.formatToString(this.days, "DAY");
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lkotlinx/datetime/DateTimeUnit$DayBased$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "kotlinx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DayBased> serializer() {
                return DayBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=MonthBasedDateTimeUnitSerializer.class)
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lkotlinx/datetime/DateTimeUnit$MonthBased;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "months", "", "(I)V", "getMonths", "()I", "equals", "", "other", "", "hashCode", "times", "scalar", "toString", "", "Companion", "kotlinx-datetime"})
    public static final class MonthBased
    extends DateBased {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int months;

        public MonthBased(int months) {
            super(null);
            this.months = months;
            boolean bl = this.months > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Unit duration must be positive, but was " + this.getMonths() + " months.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final int getMonths() {
            return this.months;
        }

        @Override
        @NotNull
        public MonthBased times(int scalar) {
            return new MonthBased(MathJvmKt.safeMultiply(this.months, scalar));
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof MonthBased && this.months == ((MonthBased)other).months;
        }

        public int hashCode() {
            return this.months ^ 0x20000;
        }

        @NotNull
        public String toString() {
            return this.months % 1200 == 0 ? this.formatToString(this.months / 1200, "CENTURY") : (this.months % 12 == 0 ? this.formatToString(this.months / 12, "YEAR") : (this.months % 3 == 0 ? this.formatToString(this.months / 3, "QUARTER") : this.formatToString(this.months, "MONTH")));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lkotlinx/datetime/DateTimeUnit$MonthBased$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "kotlinx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<MonthBased> serializer() {
                return MonthBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u0011\u0010\u001d\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\nR\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006\u00a8\u0006$"}, d2={"Lkotlinx/datetime/DateTimeUnit$Companion;", "", "()V", "CENTURY", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "getCENTURY", "()Lkotlinx/datetime/DateTimeUnit$MonthBased;", "DAY", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "getDAY", "()Lkotlinx/datetime/DateTimeUnit$DayBased;", "HOUR", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "getHOUR", "()Lkotlinx/datetime/DateTimeUnit$TimeBased;", "MICROSECOND", "getMICROSECOND", "MILLISECOND", "getMILLISECOND", "MINUTE", "getMINUTE", "MONTH", "getMONTH", "NANOSECOND", "getNANOSECOND", "QUARTER", "getQUARTER", "SECOND", "getSECOND", "WEEK", "getWEEK", "YEAR", "getYEAR", "serializer", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeBased getNANOSECOND() {
            return NANOSECOND;
        }

        @NotNull
        public final TimeBased getMICROSECOND() {
            return MICROSECOND;
        }

        @NotNull
        public final TimeBased getMILLISECOND() {
            return MILLISECOND;
        }

        @NotNull
        public final TimeBased getSECOND() {
            return SECOND;
        }

        @NotNull
        public final TimeBased getMINUTE() {
            return MINUTE;
        }

        @NotNull
        public final TimeBased getHOUR() {
            return HOUR;
        }

        @NotNull
        public final DayBased getDAY() {
            return DAY;
        }

        @NotNull
        public final DayBased getWEEK() {
            return WEEK;
        }

        @NotNull
        public final MonthBased getMONTH() {
            return MONTH;
        }

        @NotNull
        public final MonthBased getQUARTER() {
            return QUARTER;
        }

        @NotNull
        public final MonthBased getYEAR() {
            return YEAR;
        }

        @NotNull
        public final MonthBased getCENTURY() {
            return CENTURY;
        }

        @NotNull
        public final KSerializer<DateTimeUnit> serializer() {
            return DateTimeUnitSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

