/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.course.LearningCourse;
import training.util.DataLoader;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ltraining/learn/course/LearningCourseBase;", "Ltraining/learn/course/LearningCourse;", "lang", "", "(Ljava/lang/String;)V", "getLang", "()Ljava/lang/String;", "langSupport", "Ltraining/lang/LangSupport;", "getLangSupport", "()Ltraining/lang/LangSupport;", "langSupport$delegate", "Lkotlin/Lazy;", "loadSample", "Ltraining/dsl/LessonSample;", "path", "intellij.featuresTrainer"})
public abstract class LearningCourseBase
implements LearningCourse {
    @NotNull
    private final Lazy langSupport$delegate;
    @NotNull
    private final String lang;

    @NotNull
    public final LangSupport getLangSupport() {
        Lazy lazy = this.langSupport$delegate;
        LearningCourseBase learningCourseBase = this;
        Object var3_3 = null;
        return (LangSupport)lazy.getValue();
    }

    @NotNull
    public final LessonSample loadSample(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = this.lang;
        Object object2 = ((String)object).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String).toLowerCase()");
        String string = "modules/" + (String)object2 + "/" + path;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"javaClass.classLoader");
        object = ByteStreamsKt.readBytes((InputStream)DataLoader.INSTANCE.getResourceAsStream(string, classLoader));
        object2 = Charsets.UTF_8;
        String content = new String((byte[])object, (Charset)object2);
        return LessonSampleKt.parseLessonSample(content);
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    public LearningCourseBase(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.lang = lang;
        this.langSupport$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LangSupport>(this){
            final /* synthetic */ LearningCourseBase this$0;

            @NotNull
            public final LangSupport invoke() {
                LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupportById(this.this$0.getLang());
                if (langSupport2 == null) {
                    String string = "No language with id " + this.this$0.getLang();
                    throw new IllegalStateException(string.toString());
                }
                return langSupport2;
            }
            {
                this.this$0 = learningCourseBase;
                super(0);
            }
        }));
    }
}

