/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskTestContext;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.IftModule;
import training.learn.course.LessonProperties;
import training.learn.course.LessonType;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonState;
import training.learn.lesson.LessonStateManager;
import training.statistic.LessonStartingWay;
import training.util.LessonEndInfo;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0010J\r\u00100\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b1J\u0018\u00102\u001a\u00020.2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0015\u00107\u001a\u00020.2\u0006\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J-\u0010;\u001a\u00020.2\u0006\u00103\u001a\u0002042\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0000\u00a2\u0006\u0002\b@J\r\u0010A\u001a\u00020.H\u0000\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u00020D2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010E\u001a\u00020.2\u0006\u00103\u001a\u000204H\u0017J\u000e\u0010F\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0010R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0014\u0010\u001c\u001a\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000bR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006G"}, d2={"Ltraining/learn/course/Lesson;", "", "id", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "getId", "()Ljava/lang/String;", "languageId", "getLanguageId", "lessonListeners", "", "Ltraining/learn/lesson/LessonListener;", "getLessonListeners$intellij_featuresTrainer", "()Ljava/util/List;", "lessonType", "Ltraining/learn/course/LessonType;", "getLessonType", "()Ltraining/learn/course/LessonType;", "module", "Ltraining/learn/course/IftModule;", "getModule", "()Ltraining/learn/course/IftModule;", "getName", "passed", "", "getPassed$intellij_featuresTrainer", "()Z", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "sampleFilePath", "getSampleFilePath", "suitableTips", "", "getSuitableTips", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "addLessonListener", "", "lessonListener", "isNewLesson", "isNewLesson$intellij_featuresTrainer", "onLessonEnd", "project", "Lcom/intellij/openapi/project/Project;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "onStart", "way", "Ltraining/statistic/LessonStartingWay;", "onStart$intellij_featuresTrainer", "onStop", "lessonPassed", "currentTaskIndex", "", "currentVisualIndex", "onStop$intellij_featuresTrainer", "pass", "pass$intellij_featuresTrainer", "preferredLearnWindowAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "prepare", "removeLessonListener", "intellij.featuresTrainer"})
public abstract class Lesson {
    @Nullable
    private final String sampleFilePath;
    @NotNull
    private final LessonProperties properties;
    @NotNull
    private final List<String> suitableTips;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties;
    @NotNull
    private final List<LessonListener> lessonListeners;
    @NotNull
    private final String id;
    @NotNull
    private final String name;

    @NotNull
    public abstract IftModule getModule();

    @Nullable
    public String getLanguageId() {
        LangSupport langSupport2 = this.getModule().getPrimaryLanguage();
        return langSupport2 != null ? langSupport2.getPrimaryLanguage() : null;
    }

    @NotNull
    public LessonType getLessonType() {
        return this.getModule().getModuleType();
    }

    @NotNull
    public ToolWindowAnchor preferredLearnWindowAnchor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getModule().preferredLearnWindowAnchor(project);
    }

    @Nullable
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @RequiresBackgroundThread
    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public List<String> getSuitableTips() {
        return this.suitableTips;
    }

    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
    }

    public final void addLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.add(lessonListener);
    }

    public final void removeLessonListener(@NotNull LessonListener lessonListener) {
        Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
        this.lessonListeners.remove(lessonListener);
    }

    public final boolean getPassed$intellij_featuresTrainer() {
        return LessonStateManager.INSTANCE.getStateFromBase(this.id) == LessonState.PASSED;
    }

    @NotNull
    public final List<LessonListener> getLessonListeners$intellij_featuresTrainer() {
        return this.lessonListeners;
    }

    public final void onStart$intellij_featuresTrainer(@NotNull LessonStartingWay way) {
        Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStarted(this, way);
        }
    }

    public final void onStop$intellij_featuresTrainer(@NotNull Project project, boolean lessonPassed, int currentTaskIndex, int currentVisualIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonStopped(this);
        }
        this.onLessonEnd(project, new LessonEndInfo(lessonPassed, currentTaskIndex, currentVisualIndex));
    }

    public final void pass$intellij_featuresTrainer() {
        LessonStateManager.INSTANCE.setPassed(this);
        Iterable $this$forEach$iv = this.lessonListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LessonListener it = (LessonListener)element$iv;
            boolean bl = false;
            it.lessonPassed(this);
        }
    }

    public final boolean isNewLesson$intellij_featuresTrainer() {
        String string = this.getProperties().getAvailableSince();
        if (string == null) {
            return false;
        }
        String availableSince = string;
        BuildNumber buildNumber = BuildNumber.fromString((String)availableSince);
        if (buildNumber == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(a\u2026bleSince) ?: return false");
        BuildNumber lessonVersion = buildNumber;
        BuildNumber previousOpenedVersion = CourseManager.Companion.getInstance().getPreviousOpenedVersion();
        if (previousOpenedVersion != null) {
            return previousOpenedVersion.compareTo(lessonVersion) < 0;
        }
        return UtilsKt.filterUnseenLessons(this.getModule().getLessons()).contains(this);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Lesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.name = name;
        this.properties = new LessonProperties(false, false, null, 7, null);
        this.suitableTips = CollectionsKt.emptyList();
        this.testScriptProperties = new TaskTestContext.TestScriptProperties(0, false, 3, null);
        this.lessonListeners = new ArrayList();
    }
}

