/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtilCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.learn.lesson.LessonStateManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u0001\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\u0014\u0010&\u001a\u0004\u0018\u00010\u00012\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)H\u0000\u001a\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0001\u001a\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202\u001a\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0001\u001a\u000e\u00106\u001a\b\u0012\u0004\u0012\u0002070)H\u0000\u001a\u0018\u00108\u001a\u0004\u0018\u00010\u00012\u0006\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0004\u001a\u0012\u0010;\u001a\u0004\u0018\u0001072\u0006\u00101\u001a\u000202H\u0000\u001a\b\u0010<\u001a\u0004\u0018\u00010*\u001a\b\u0010=\u001a\u0004\u0018\u00010*\u001a\u000e\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u000204\u001a\u0016\u0010@\u001a\u00020\u00042\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u000200\u001a\u0016\u0010A\u001a\u00020\u00012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020*0)H\u0007\u001a\u0010\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00101\u001a\u000202\u001a\u0014\u0010E\u001a\u0004\u0018\u00010*2\b\u00101\u001a\u0004\u0018\u000102H\u0000\u001a\u000e\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u0001\u001a\u0010\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u000200H\u0000\u001a\u0016\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M\u001a\u0016\u0010O\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M\u001a\u0014\u0010P\u001a\u00020\u0004*\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u0001\u001a\n\u0010S\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010T\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010Q\u001a\u0010\u0010U\u001a\u00020V*\b\u0012\u0004\u0012\u00020Q0W\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\" \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\n\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\"\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006\"\u0014\u0010\u0015\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\"\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"LEARNING_PANEL_OPENED_IN", "", "SHOW_NEW_LESSONS_NOTIFICATION", "adaptToNotNativeLocalization", "", "getAdaptToNotNativeLocalization", "()Z", "excludedLanguages", "", "", "featureTrainerVersion", "getFeatureTrainerVersion", "()Ljava/lang/String;", "featureTrainerVersion$delegate", "Lkotlin/Lazy;", "iftNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getIftNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "iftPluginIsUsing", "getIftPluginIsUsing", "learningPanelWasOpenedInCurrentVersion", "getLearningPanelWasOpenedInCurrentVersion", "switchOnExperimentalLessons", "getSwitchOnExperimentalLessons", "trainerPluginConfigName", "clearTrainingProgress", "", "courseCanBeUsed", "languageId", "createBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "text", "delay", "", "createNamedSingleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "name", "excludeNullCheck", "value", "filterUnseenLessons", "", "Ltraining/learn/course/Lesson;", "newLessons", "findLanguageByID", "Lcom/intellij/lang/Language;", "id", "findLanguageSupport", "Ltraining/lang/LangSupport;", "project", "Lcom/intellij/openapi/project/Project;", "getActionById", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionId", "getAllLearnToolWindows", "Ltraining/ui/LearnToolWindow;", "getFeedbackLink", "langSupport", "ownRegistry", "getLearnToolWindowForProject", "getNextLessonForCurrent", "getPreviousLessonForCurrent", "invokeActionForFocusContext", "action", "isLearningProject", "learningProgressString", "lessons", "learningToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "lessonOpenedInProject", "openLinkInBrowser", "link", "resetPrimaryLanguage", "activeLangSupport", "rigid", "Ljava/awt/Component;", "width", "", "height", "scaledRigid", "isToStringContains", "", "string", "replaceSpacesWithNonBreakSpace", "toNullableString", "wrapWithUrlPanel", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "intellij.featuresTrainer"})
public final class UtilsKt {
    private static final Map<String, String[]> excludedLanguages = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"AppCode", (Object)new String[]{"JavaScript"}), TuplesKt.to((Object)"DataSpell", (Object)new String[]{"Python"})});
    @NotNull
    public static final String trainerPluginConfigName = "ide-features-trainer.xml";
    @NotNull
    private static final Lazy featureTrainerVersion$delegate = LazyKt.lazy((Function0)featureTrainerVersion.2.INSTANCE);
    @NotNull
    public static final String SHOW_NEW_LESSONS_NOTIFICATION = "ift.show.new.lessons.notification";
    @NotNull
    public static final String LEARNING_PANEL_OPENED_IN = "ift.learning.panel.opened.in";

    @NotNull
    public static final ExecutorService createNamedSingleThreadExecutor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(name).build());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThrea\u2026NameFormat(name).build())");
        return executorService;
    }

    public static final boolean courseCanBeUsed(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        Object[] excludedCourses = excludedLanguages.get(applicationNamesInfo.getProductName());
        return excludedCourses == null || !ArraysKt.contains((Object[])excludedCourses, (Object)languageId);
    }

    @Nullable
    public static final Language findLanguageByID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = id;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        String effectiveId = Intrinsics.areEqual((Object)string2, (Object)"cpp") ? "ObjectiveC" : id;
        return Language.findLanguageByID((String)effectiveId);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return UtilsKt.createBalloon(text2, 3000L);
    }

    @NotNull
    public static final Balloon createBalloon(@Nls @NotNull String text2, long delay) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text2, null, UIUtil.getToolTipBackground(), null).setHideOnClickOutside(true).setCloseButtonEnabled(true).setHideOnKeyOutside(true).setAnimationCycle(0).setFadeoutTime(delay).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026lay)\n    .createBalloon()");
        return balloon;
    }

    @NotNull
    public static final String getFeatureTrainerVersion() {
        Lazy lazy = featureTrainerVersion$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    public static final boolean getAdaptToNotNativeLocalization() {
        return Registry.is((String)"ift.adapt.to.not.native.localization") || Intrinsics.areEqual((Object)DynamicBundle.getLocale(), (Object)Locale.ENGLISH) ^ true;
    }

    public static final void clearTrainingProgress() {
        LessonManager.Companion.getInstance().stopLesson();
        LessonStateManager.INSTANCE.resetPassedStatus();
        for (LearnToolWindow toolWindow : UtilsKt.getAllLearnToolWindows()) {
            toolWindow.reinitViews$intellij_featuresTrainer();
            toolWindow.setModulesPanel$intellij_featuresTrainer();
        }
        LearningUiManager.INSTANCE.setActiveToolWindow$intellij_featuresTrainer(null);
    }

    public static final boolean resetPrimaryLanguage(@NotNull LangSupport activeLangSupport) {
        Intrinsics.checkNotNullParameter((Object)activeLangSupport, (String)"activeLangSupport");
        LangSupport old = LangManager.Companion.getInstance().getLangSupport();
        if (Intrinsics.areEqual((Object)activeLangSupport, (Object)old) ^ true) {
            LessonManager.Companion.getInstance().stopLesson();
            LangManager.Companion.getInstance().updateLangSupport(activeLangSupport);
            LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            if (learnToolWindow != null) {
                learnToolWindow.setModulesPanel$intellij_featuresTrainer();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static final LangSupport findLanguageSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            return null;
        }
        LangSupport langSupport3 = langSupport2;
        if (UtilsKt.isLearningProject(project, langSupport3)) {
            return langSupport3;
        }
        return null;
    }

    public static final boolean isLearningProject(@NotNull Project project, @NotNull LangSupport langSupport2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        return FileUtil.pathsEqual((String)project.getBasePath(), (String)LangManager.Companion.getInstance().getLearningProjectPath(langSupport2));
    }

    @Nullable
    public static final String getFeedbackLink(@NotNull LangSupport langSupport2, boolean ownRegistry) {
        Intrinsics.checkNotNullParameter((Object)langSupport2, (String)"langSupport");
        String string = langSupport2.getPrimaryLanguage();
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        String suffix = string2;
        boolean needToShow = Registry.is((String)("ift.show.feedback.link" + (String)(ownRegistry ? "." + suffix : "")), (boolean)false);
        return needToShow ? "https://surveys.jetbrains.com/s3/features-trainer-feedback-" + suffix : null;
    }

    public static final boolean getSwitchOnExperimentalLessons() {
        return Registry.is((String)"ift.experimental.lessons", (boolean)false);
    }

    public static final void invokeActionForFocusContext(@NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
        dataManager.getDataContextFromFocusAsync().onSuccess(new Consumer(action2){
            final /* synthetic */ AnAction $action;

            public final void accept(DataContext dataContext) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this, dataContext){
                    final /* synthetic */ invokeActionForFocusContext.1 this$0;
                    final /* synthetic */ DataContext $dataContext$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$dataContext$inlined = dataContext;
                    }

                    public final void run() {
                        boolean bl = false;
                        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)this.this$0.$action, null, (String)"LearnToolwindow", (DataContext)this.$dataContext$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026_TOOLWINDOW, dataContext)");
                        AnActionEvent event = anActionEvent;
                        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)this.this$0.$action, (AnActionEvent)event);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
            {
                this.$action = anAction;
            }
        });
    }

    public static final void openLinkInBrowser(@NotNull String link) {
        Desktop desktop;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(link));
        }
    }

    @NotNull
    public static final JPanel wrapWithUrlPanel(@NotNull LinkLabel<Object> $this$wrapWithUrlPanel) {
        Intrinsics.checkNotNullParameter($this$wrapWithUrlPanel, (String)"$this$wrapWithUrlPanel");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add((Component)$this$wrapWithUrlPanel, "Center");
        jPanel.add((Component)new JLabel(AllIcons.Ide.External_link_arrow), "East");
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    @NotNull
    public static final Component rigid(int width, int height) {
        return UtilsKt.scaledRigid(JBUI.scale((int)width), JBUI.scale((int)height));
    }

    @NotNull
    public static final Component scaledRigid(int width, int height) {
        JComponent jComponent;
        Component component2 = Box.createRigidArea(new Dimension(width, height));
        if (component2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        JComponent $this$apply = jComponent = (JComponent)component2;
        boolean bl = false;
        $this$apply.setAlignmentX(0.0f);
        $this$apply.setAlignmentY(0.0f);
        return jComponent;
    }

    @Nullable
    public static final LearnToolWindow getLearnToolWindowForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        Object[] objectArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toolWindow.contentManager.contents");
        Content content = (Content)ArraysKt.singleOrNull((Object[])objectArray);
        JComponent jComponent = content != null ? content.getComponent() : null;
        JComponent jComponent2 = jComponent;
        if (!(jComponent2 instanceof LearnToolWindow)) {
            jComponent2 = null;
        }
        return (LearnToolWindow)((Object)jComponent2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<LearnToolWindow> getAllLearnToolWindows() {
        void var3_3;
        void $this$mapNotNullTo$iv$iv;
        Project[] projectArray = ProjectUtilCore.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectUtilCore.getOpenProjects()");
        Project[] $this$mapNotNull$iv = projectArray;
        boolean $i$f$mapNotNull = false;
        Project[] projectArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            LearnToolWindow learnToolWindow;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            LearnToolWindow learnToolWindow2 = UtilsKt.getLearnToolWindowForProject((Project)v1);
            if (learnToolWindow2 == null) continue;
            LearnToolWindow it$iv$iv = learnToolWindow = learnToolWindow2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final Lesson lessonOpenedInProject(@Nullable Project project) {
        return project != null && UtilsKt.getLearnToolWindowForProject(project) != null ? LessonManager.Companion.getInstance().getCurrentLesson() : null;
    }

    @Nullable
    public static final Lesson getNextLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index < 0 || index >= lessonsForModules.size() - 1) {
            return null;
        }
        return lessonsForModules.get(index + 1);
    }

    @Nullable
    public static final Lesson getPreviousLessonForCurrent() {
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return null;
        }
        Lesson lesson2 = lesson;
        List<Lesson> lessonsForModules = CourseManager.Companion.getInstance().getLessonsForModules();
        int index = lessonsForModules.indexOf(lesson2);
        if (index <= 0) {
            return null;
        }
        return lessonsForModules.get(index - 1);
    }

    @Nls
    @NotNull
    public static final String learningProgressString(@NotNull List<? extends Lesson> lessons) {
        Intrinsics.checkNotNullParameter(lessons, (String)"lessons");
        int total = lessons.size();
        int done = 0;
        for (Lesson lesson : lessons) {
            if (!lesson.getPassed$intellij_featuresTrainer()) continue;
            ++done;
        }
        return done == total ? LearnBundle.INSTANCE.message("learn.module.progress.completed", new Object[0]) : LearnBundle.INSTANCE.message("learn.module.progress", done, total);
    }

    @Nullable
    public static final ToolWindow learningToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
    }

    @Nullable
    public static final String toNullableString(@Nullable Object $this$toNullableString) {
        return $this$toNullableString == null ? null : UtilsKt.excludeNullCheck($this$toNullableString.toString());
    }

    public static final boolean isToStringContains(@Nullable Object $this$isToStringContains, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = UtilsKt.toNullableString($this$isToStringContains);
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)string, (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public static final AnAction getActionById(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (anAction == null) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String string = "No action with id " + actionId + " in " + applicationNamesInfo.getFullProductNameWithEdition();
            throw new IllegalStateException(string.toString());
        }
        return anAction;
    }

    private static final String excludeNullCheck(String value) {
        return value;
    }

    @NotNull
    public static final String replaceSpacesWithNonBreakSpace(@NotNull String $this$replaceSpacesWithNonBreakSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceSpacesWithNonBreakSpace, (String)"$this$replaceSpacesWithNonBreakSpace");
        return StringsKt.replace$default((String)$this$replaceSpacesWithNonBreakSpace, (String)" ", (String)"\u00a0", (boolean)false, (int)4, null);
    }

    public static final boolean getIftPluginIsUsing() {
        return LessonStateManager.INSTANCE.getPassedLessonsNumber() >= 5;
    }

    public static final boolean getLearningPanelWasOpenedInCurrentVersion() {
        String string = PropertiesComponent.getInstance().getValue(LEARNING_PANEL_OPENED_IN);
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertiesComponent.getI\u2026PENED_IN) ?: return false");
        String savedValue = string;
        BuildNumber buildNumber = BuildNumber.fromString((String)savedValue);
        if (buildNumber == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(savedValue) ?: return false");
        BuildNumber savedBuild = buildNumber;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        return savedBuild.compareTo(applicationInfo.getBuild()) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Lesson> filterUnseenLessons(@NotNull List<? extends Lesson> newLessons) {
        List list2;
        block16: {
            void $this$filterTo$iv$iv;
            BuildNumber maxSeenVersion;
            BuildNumber zeroBuild;
            block15: {
                Object object;
                block10: {
                    String it;
                    String string;
                    Object lesson;
                    Iterator $i$f$filter22;
                    block12: {
                        block11: {
                            String $i$f$filterTo2;
                            block9: {
                                void $this$filterTo$iv$iv2;
                                Intrinsics.checkNotNullParameter(newLessons, (String)"newLessons");
                                zeroBuild = new BuildNumber("", 0, 0);
                                Iterable $this$filter$iv = newLessons;
                                boolean $i$f$filter22 = false;
                                Iterable iterable = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$filterTo2 = false;
                                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                                    Lesson it2 = (Lesson)element$iv$iv;
                                    boolean bl = false;
                                    if (!it2.getPassed$intellij_featuresTrainer()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                $i$f$filter22 = $this$filter$iv.iterator();
                                if ($i$f$filter22.hasNext()) break block9;
                                object = null;
                                break block10;
                            }
                            lesson = (Lesson)$i$f$filter22.next();
                            boolean bl = false;
                            string = ((Lesson)lesson).getProperties().getAvailableSince();
                            if (string == null) break block11;
                            it = $i$f$filterTo2 = string;
                            boolean bl2 = false;
                            string = BuildNumber.fromString((String)it);
                            if (string != null) break block12;
                        }
                        string = zeroBuild;
                    }
                    lesson = (Comparable)((Object)string);
                    while ($i$f$filter22.hasNext()) {
                        String string2;
                        Object lesson2;
                        block14: {
                            block13: {
                                lesson2 = (Lesson)$i$f$filter22.next();
                                boolean bl = false;
                                string2 = ((Lesson)lesson2).getProperties().getAvailableSince();
                                if (string2 == null) break block13;
                                String it3 = it = string2;
                                boolean bl3 = false;
                                string2 = BuildNumber.fromString((String)it3);
                                if (string2 != null) break block14;
                            }
                            string2 = zeroBuild;
                        }
                        if (lesson.compareTo(lesson2 = (Comparable)((Object)string2)) >= 0) continue;
                        lesson = lesson2;
                    }
                    object = lesson;
                }
                maxSeenVersion = (BuildNumber)object;
                if (maxSeenVersion != null) break block15;
                list2 = newLessons;
                break block16;
            }
            Iterable $this$filter$iv = newLessons;
            boolean $i$f$filter = false;
            Iterable lesson2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String string;
                block18: {
                    block17: {
                        String string3;
                        Lesson lesson = (Lesson)element$iv$iv;
                        boolean bl = false;
                        string = lesson.getProperties().getAvailableSince();
                        if (string == null) break block17;
                        String it = string3 = string;
                        boolean bl4 = false;
                        string = BuildNumber.fromString((String)it);
                        if (string != null) break block18;
                    }
                    string = zeroBuild;
                }
                if (!(string.compareTo(maxSeenVersion) > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List unseenLessons = list2;
        return unseenLessons;
    }

    @NotNull
    public static final NotificationGroup getIftNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroup.Companion.findRegisteredGroup("IDE Features Trainer");
        if (notificationGroup == null) {
            String string = "Not found notificationGroup for IDE Features Trainer";
            throw new IllegalStateException(string.toString());
        }
        return notificationGroup;
    }
}

