/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LineChartModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<RangedContinuousSeries> mySeries;
    private boolean myFirstUpdate;
    private long myAccumulatedElapsedNs;
    private final AtomicBoolean myIsUpdating;
    @NotNull
    private final Executor myExecutor;

    public LineChartModel() {
        this(AppExecutorUtil.getAppExecutorService());
    }

    @VisibleForTesting
    public LineChartModel(@NotNull Executor executor) {
        if (executor == null) {
            LineChartModel.$$$reportNull$$$0(0);
        }
        this.mySeries = new ArrayList<RangedContinuousSeries>();
        this.myFirstUpdate = true;
        this.myAccumulatedElapsedNs = 0L;
        this.myIsUpdating = new AtomicBoolean(false);
        this.myExecutor = executor;
    }

    @Override
    public void update(long elapsedNs) {
        if (this.myIsUpdating.get()) {
            this.myAccumulatedElapsedNs += elapsedNs;
        } else {
            long totalNs = elapsedNs + this.myAccumulatedElapsedNs;
            this.myAccumulatedElapsedNs = 0L;
            this.myIsUpdating.set(true);
            CompletableFuture.runAsync(() -> {
                this.doUpdate(totalNs);
                this.myIsUpdating.set(false);
            }, this.myExecutor);
        }
    }

    private void doUpdate(long elapsedNs) {
        HashMap<Range, Double> maxPerRangeObject = new HashMap<Range, Double>();
        for (RangedContinuousSeries ranged : this.mySeries) {
            Range range = ranged.getYRange();
            double yMax = -1.7976931348623157E308;
            List seriesList = ranged.getSeries();
            if (seriesList.isEmpty()) continue;
            for (SeriesData series : seriesList) {
                double value = ((Long)series.value).longValue();
                if (!(yMax < value)) continue;
                yMax = value;
            }
            Double rangeMax = (Double)maxPerRangeObject.get(range);
            if (rangeMax != null && !(yMax > rangeMax)) continue;
            maxPerRangeObject.put(range, yMax);
        }
        boolean changed = this.myFirstUpdate;
        for (Map.Entry entry : maxPerRangeObject.entrySet()) {
            Range range = (Range)entry.getKey();
            if (!(range.getMax() < (Double)entry.getValue())) continue;
            double max = this.myFirstUpdate ? (Double)entry.getValue() : Updater.lerp(range.getMax(), (Double)entry.getValue(), 0.99f, elapsedNs, (double)((float)((Double)entry.getValue() * (double)0.001f)));
            range.setMax(max);
            changed = true;
        }
        this.myFirstUpdate = false;
        if (changed) {
            this.changed(Aspect.LINE_CHART);
        }
    }

    public void addAll(@NotNull List<RangedContinuousSeries> series) {
        if (series == null) {
            LineChartModel.$$$reportNull$$$0(1);
        }
        series.forEach(this::add);
    }

    public void add(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            LineChartModel.$$$reportNull$$$0(2);
        }
        this.mySeries.add(series);
        series.getXRange().addDependency(this).onChange(Range.Aspect.RANGE, () -> this.changed(Aspect.LINE_CHART));
    }

    public void remove(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            LineChartModel.$$$reportNull$$$0(3);
        }
        series.getXRange().removeDependencies(this);
        this.mySeries.remove(series);
    }

    @NotNull
    public List<RangedContinuousSeries> getSeries() {
        List<RangedContinuousSeries> list = this.mySeries;
        if (list == null) {
            LineChartModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/LineChartModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/LineChartModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        LINE_CHART;

    }
}

