/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.util.ExceptionWithContext;

public class MethodHandleType {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int STATIC_INVOKE = 4;
    public static final int INSTANCE_INVOKE = 5;
    private static final Map<String, Integer> methodHandleTypeNames = Maps.newHashMap();

    @Nonnull
    public static String toString(int methodHandleType) {
        switch (methodHandleType) {
            case 0: {
                return "static-put";
            }
            case 1: {
                return "static-get";
            }
            case 2: {
                return "instance-put";
            }
            case 3: {
                return "instance-get";
            }
            case 4: {
                return "static-invoke";
            }
            case 5: {
                return "instance-invoke";
            }
        }
        throw new InvalidMethodHandleTypeException(methodHandleType);
    }

    public static int getMethodHandleType(String methodHandleType) {
        Integer ret = methodHandleTypeNames.get(methodHandleType);
        if (ret == null) {
            throw new ExceptionWithContext("Invalid method handle type: %s", methodHandleType);
        }
        return ret;
    }

    static {
        methodHandleTypeNames.put("static-put", 0);
        methodHandleTypeNames.put("static-get", 1);
        methodHandleTypeNames.put("instance-put", 2);
        methodHandleTypeNames.put("instance-get", 3);
        methodHandleTypeNames.put("static-invoke", 4);
        methodHandleTypeNames.put("instance-invoke", 5);
    }

    public static class InvalidMethodHandleTypeException
    extends ExceptionWithContext {
        private final int methodHandleType;

        public InvalidMethodHandleTypeException(int methodHandleType) {
            super("Invalid method handle type: %d", methodHandleType);
            this.methodHandleType = methodHandleType;
        }

        public InvalidMethodHandleTypeException(int methodHandleType, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.methodHandleType = methodHandleType;
        }

        public int getMethodHandleType() {
            return this.methodHandleType;
        }
    }
}

