/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.IdeaClassFinder;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.ClassUtil;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.ReportBuilderFactory;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.html.HTMLReportBuilder;
import jetbrains.coverage.report.idea.IDEACoverageData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCoverageRunner
extends CoverageRunner {
    private static final String JAVA_COVERAGE_AGENT_AGENT_PATH = "java.test.agent.lib.path";

    public boolean isJdk7Compatible() {
        return true;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JavaCoverageRunner.$$$reportNull$$$0(0);
        }
        return engine instanceof JavaCoverageEngine;
    }

    public abstract void appendCoverageArgument(String var1, String @Nullable [] var2, SimpleJavaParameters var3, boolean var4, boolean var5);

    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, SimpleJavaParameters parameters, boolean collectLineInfo, boolean isSampling, String sourceMapPath, Project project) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, parameters, collectLineInfo, isSampling);
    }

    public boolean isBranchInfoAvailable(boolean sampling) {
        return !sampling;
    }

    public void generateReport(final CoverageSuitesBundle suite, final Project project) throws IOException {
        long startNs = System.nanoTime();
        ProjectData projectData = suite.getCoverageData();
        if (projectData == null) {
            return;
        }
        SaveHook.appendUnloadedFullAnalysis((ProjectData)projectData, (ClassFinder)new IdeaClassFinder(project, suite), (boolean)false, (!suite.isTracingEnabled() ? 1 : 0) != 0);
        long generationStartNs = System.nanoTime();
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        HTMLReportBuilder builder = ReportBuilderFactory.createHTMLReportBuilder();
        builder.setReportDir(new File(settings.OUTPUT_DIRECTORY));
        SourceCodeProvider sourceCodeProvider = classname -> (CharSequence)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            if (project.isDisposed()) {
                return "";
            }
            PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)classname);
            return psiClass != null ? psiClass.getNavigationElement().getContainingFile().getText() : "";
        });
        builder.generateReport(new IDEACoverageData(projectData, sourceCodeProvider){

            @Override
            @NotNull
            public Collection<ClassInfo> getClasses() {
                Collection<ClassInfo> classes = super.getClasses();
                JavaCoverageSuite javaCoverageSuite = (JavaCoverageSuite)suite.getSuites()[0];
                if (!suite.isTrackTestFolders() || javaCoverageSuite.getExcludedClassNames().length > 0 || javaCoverageSuite.getExcludedPackageNames().length > 0) {
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    GlobalSearchScope productionScope = !suite.isTrackTestFolders() ? GlobalSearchScopesCore.projectProductionScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
                    Iterator<ClassInfo> iterator = classes.iterator();
                    while (iterator.hasNext()) {
                        ClassInfo aClass = iterator.next();
                        PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                            if (project.isDisposed()) {
                                return null;
                            }
                            return psiFacade.findClass(aClass.getFQName(), productionScope);
                        });
                        if (psiClass != null && suite.getCoverageEngine().acceptedByFilters((PsiFile)ReadAction.compute(() -> psiClass.getContainingFile()), suite)) continue;
                        iterator.remove();
                    }
                }
                Collection<ClassInfo> collection = classes;
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageRunner$1", "getClasses"));
            }
        });
        long endNs = System.nanoTime();
        long timeMs = TimeUnit.NANOSECONDS.toMillis(endNs - startNs);
        long generationTimeMs = TimeUnit.NANOSECONDS.toMillis(endNs - generationStartNs);
        CoverageLogger.logHTMLReport((Project)project, (long)timeMs, (long)generationTimeMs);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath) {
        if (agentPath == null) {
            JavaCoverageRunner.$$$reportNull$$$0(1);
        }
        return JavaExecutionUtil.handleSpacesInAgentPath((String)agentPath, (String)"testAgent", (String)JAVA_COVERAGE_AGENT_AGENT_PATH);
    }

    protected static void write2file(File tempFile, @NonNls String arg) throws IOException {
        FileUtil.writeToFile((File)tempFile, (byte[])(arg + "\n").getBytes(StandardCharsets.UTF_8), (boolean)true);
    }

    @NotNull
    protected static File createTempFile() throws IOException {
        File tempFile = FileUtil.createTempFile((String)"coverage", (String)"args");
        if (tempFile.getAbsolutePath().contains(" ")) {
            String path = JavaExecutionUtil.handleSpacesInAgentPath((String)tempFile.getAbsolutePath(), (String)"coverage", (String)JAVA_COVERAGE_AGENT_AGENT_PATH);
            if (path == null) {
                throw new IOException("Cannot create temporary file without spaces in path.");
            }
            tempFile = new File(path);
        }
        File file = tempFile;
        if (file == null) {
            JavaCoverageRunner.$$$reportNull$$$0(2);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleSpacesInAgentPath";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

