/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;

public abstract class FileSetTestCase
extends TestSuite {
    private final File[] myFiles;
    protected Project myProject;
    private Pattern myPattern;

    public FileSetTestCase(@NotNull String path) {
        if (path == null) {
            FileSetTestCase.$$$reportNull$$$0(0);
        }
        File f = new File(path);
        if (f.isDirectory()) {
            this.myFiles = f.listFiles();
        } else if (f.exists()) {
            this.myFiles = new File[]{f};
        } else {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        String pattern = System.getProperty("fileset.pattern");
        this.myPattern = pattern != null ? Pattern.compile(pattern) : null;
        this.addAllTests();
    }

    protected FileSetTestCase(File @NotNull [] files) {
        if (files == null) {
            FileSetTestCase.$$$reportNull$$$0(1);
        }
        this.myFiles = files;
        this.addAllTests();
    }

    protected void setUp() {
    }

    protected void tearDown() {
        this.myProject = null;
    }

    private void addAllTests() {
        for (File file2 : this.myFiles) {
            if (!file2.isFile()) continue;
            this.addFileTest(file2);
        }
    }

    public abstract String transform(String var1, String[] var2) throws Exception;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void addFileTest(File file2) {
        if (!StringUtil.startsWithChar((CharSequence)file2.getName(), (char)'_') && !"CVS".equals(file2.getName())) {
            if (this.myPattern != null && !this.myPattern.matcher(file2.getPath()).matches()) {
                return;
            }
            ActualTest t = new ActualTest(file2, FileSetTestCase.createTestName(file2));
            this.addTest((Test)t);
        }
    }

    protected String loadFile(File testFile) throws IOException {
        return FileUtil.loadFile((File)testFile);
    }

    protected String getDelimiter() {
        return "---";
    }

    private static String createTestName(File testFile) {
        return testFile.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "files";
                break;
            }
        }
        objectArray[1] = "com/intellij/FileSetTestCase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ActualTest
    extends LightPlatformTestCase {
        private final File myTestFile;
        private final String myTestName;

        ActualTest(File testFile, String testName2) {
            this.myTestFile = testFile;
            this.myTestName = testName2;
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            FileSetTestCase.this.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            FileSetTestCase.this.tearDown();
            super.tearDown();
        }

        public int countTestCases() {
            return 1;
        }

        @Override
        protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
            int separatorIndex;
            if (testRunnable == null) {
                ActualTest.$$$reportNull$$$0(0);
            }
            String content = FileSetTestCase.this.loadFile(this.myTestFile);
            ActualTest.assertNotNull((Object)content);
            ArrayList<String> input = new ArrayList<String>();
            content = StringUtil.replace((String)content, (String)"\r", (String)"");
            int currentIndex = 0;
            String delimiter = FileSetTestCase.this.getDelimiter();
            while ((separatorIndex = content.indexOf(delimiter, currentIndex)) >= 0) {
                input.add(content.substring(currentIndex, separatorIndex));
                currentIndex = separatorIndex + delimiter.length();
                currentIndex = CharArrayUtil.shiftForward((CharSequence)content, (int)currentIndex, (String)"-\n");
            }
            ActualTest.assertFalse((String)"No data found in source file", (boolean)input.isEmpty());
            int expectedOffset = currentIndex;
            FileSetTestCase.this.myProject = this.getProject();
            String testName2 = this.myTestFile.getName();
            int dotIdx = testName2.indexOf(46);
            if (dotIdx >= 0) {
                testName2 = testName2.substring(0, dotIdx);
            }
            String transformed = FileSetTestCase.this.transform(testName2, ArrayUtilRt.toStringArray(input));
            String result = content.substring(0, expectedOffset) + transformed;
            UsefulTestCase.assertSameLinesWithFile(this.myTestFile.getAbsolutePath(), result, true);
        }

        @Override
        @NotNull
        protected String getTestName(boolean lowercaseFirstLetter) {
            return "";
        }

        public String toString() {
            return this.myTestFile.getAbsolutePath() + " ";
        }

        @Override
        protected void resetAllFields() {
        }

        public String getName() {
            return this.myTestName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/FileSetTestCase$ActualTest", "runTestRunnable"));
        }
    }
}

