/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u000eJ\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "", "()V", "isOnTeamcity", "", "totalTime", "Ljava/util/concurrent/atomic/AtomicLong;", "escape", "", "text", "escapedChar", "", "c", "printPerChunkStatistics", "", "moduleChunk", "Lorg/jetbrains/jps/ModuleChunk;", "timeToCompileNs", "", "printStatisticMessage", "key", "value", "registerStatistic", "reportTotal", "nanosToMillis", "jps-plugin"})
public final class TeamcityStatisticsLogger {
    private final boolean isOnTeamcity = System.getenv("TEAMCITY_VERSION") != null;
    @NotNull
    private final AtomicLong totalTime = new AtomicLong();

    private final char escapedChar(char c) {
        char c2 = c;
        return (char)(c2 == '\n' ? 110 : (c2 == '\r' ? 114 : (c2 == '\u0085' ? 120 : (c2 == '\u2028' ? 108 : (c2 == '\u2029' ? 112 : (c2 == '|' ? 124 : (c2 == '\'' ? 39 : (c2 == '[' ? 91 : (c2 == ']' ? 93 : 0)))))))));
    }

    private final String escape(String text) {
        StringBuilder escaped = new StringBuilder();
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        for (char c : cArray) {
            char escChar = this.escapedChar(c);
            if (escChar == '\u0000') {
                escaped.append(c);
                continue;
            }
            escaped.append('|').append(escChar);
        }
        String string2 = escaped.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escaped.toString()");
        return string2;
    }

    public final void registerStatistic(@NotNull ModuleChunk moduleChunk, long timeToCompileNs) {
        Intrinsics.checkNotNullParameter((Object)moduleChunk, (String)"moduleChunk");
        if (!this.isOnTeamcity) {
            return;
        }
        this.totalTime.addAndGet(timeToCompileNs);
        this.printPerChunkStatistics(moduleChunk, timeToCompileNs);
    }

    private final void printPerChunkStatistics(ModuleChunk moduleChunk, long timeToCompileNs) {
        this.printStatisticMessage("Kotlin Builder for " + moduleChunk.getPresentableShortName() + " compilation time, ms", String.valueOf(this.nanosToMillis(timeToCompileNs)));
    }

    public final void reportTotal() {
        if (!this.isOnTeamcity) {
            return;
        }
        this.printStatisticMessage("Kotlin Builder total compilation time, ms", String.valueOf(this.nanosToMillis(this.totalTime.get())));
    }

    private final void printStatisticMessage(String key, String value2) {
        System.out.println((Object)("##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + this.escape(value2) + "']"));
    }

    private final long nanosToMillis(long $this$nanosToMillis) {
        return TimeUnit.NANOSECONDS.toMillis($this$nanosToMillis);
    }
}

