/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class AbstractRegisterFix
implements LocalQuickFix,
DescriptorUtil.Patcher {
    protected final SmartPsiElementPointer<PsiClass> myPointer;
    protected static final Logger LOG = Logger.getInstance(AbstractRegisterFix.class);

    protected AbstractRegisterFix(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractRegisterFix.$$$reportNull$$$0(0);
        }
        this.myPointer = SmartPointerManager.createPointer((PsiElement)psiClass);
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.family", StringUtil.toLowerCase((String)this.getType()));
        if (string == null) {
            AbstractRegisterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.name", this.getType());
        if (string == null) {
            AbstractRegisterFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected abstract String getType();

    protected static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        @NonNls String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)ioExceptionPrefix);
        return message;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AbstractRegisterFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AbstractRegisterFix.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
            return;
        }
        PsiFile psiFile = this.myPointer.getContainingFile();
        PsiClass element = (PsiClass)this.myPointer.getElement();
        if (element == null) {
            LOG.info("Element is null for PsiPointer: " + this.myPointer);
            return;
        }
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        assert (module != null);
        Runnable command = () -> {
            try {
                XmlFile pluginXml = PluginModuleType.getPluginXml(module);
                if (pluginXml == null) {
                    pluginXml = DevkitActionsUtil.choosePluginModuleDescriptor(psiFile.getContainingDirectory());
                }
                if (pluginXml != null) {
                    DescriptorUtil.patchPluginXml(this, element, pluginXml);
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            catch (IncorrectOperationException e) {
                Messages.showMessageDialog((Project)project, (String)AbstractRegisterFix.filterMessage(e.getMessage()), (String)DevKitBundle.message("inspections.component.not.registered.quickfix.error", this.getType()), (Icon)Messages.getErrorIcon());
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, this.getName(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/AbstractRegisterFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

