/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface TestDataFile {
    public boolean exists();

    @Nullable
    public VirtualFile getVirtualFile();

    @NotNull
    @NlsSafe
    public String getPath();

    @NotNull
    @NlsSafe
    public String getName();

    public static class LazyResolved
    implements TestDataFile {
        private final String myPath;
        private VirtualFile myFile;
        private boolean myResolved;

        public LazyResolved(String path) {
            this.myPath = path;
        }

        private void resolve() {
            if (!this.myResolved) {
                this.myResolved = true;
                this.myFile = (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath));
            }
        }

        @Override
        public boolean exists() {
            this.resolve();
            return this.getVirtualFile() != null;
        }

        @Override
        public VirtualFile getVirtualFile() {
            this.resolve();
            return this.myFile;
        }

        @Override
        @NotNull
        public String getName() {
            String string = PathUtil.getFileName((String)this.getPath());
            if (string == null) {
                LazyResolved.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                LazyResolved.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataFile$LazyResolved";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class NonExisting
    implements TestDataFile {
        private final String myPath;

        public NonExisting(String path) {
            this.myPath = path;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return null;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                NonExisting.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = PathUtil.getFileName((String)this.getPath());
            if (string == null) {
                NonExisting.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataFile$NonExisting";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Existing
    implements TestDataFile {
        @NotNull
        private final VirtualFile myFile;

        public Existing(@NotNull VirtualFile file) {
            if (file == null) {
                Existing.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myFile.getPath();
            if (string == null) {
                Existing.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFile.getName();
            if (string == null) {
                Existing.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataFile$Existing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataFile$Existing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

