/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import com.android.ninepatch.GraphicsUtilities;
import com.google.common.io.LittleEndianDataOutputStream;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class NinePatchChunk
implements Serializable {
    private static final long serialVersionUID = -7353439224505296217L;
    private static final int[] sPaddingRect = new int[4];
    private boolean mVerticalStartWithPatch;
    private boolean mHorizontalStartWithPatch;
    private List<Rectangle> mFixed;
    private List<Rectangle> mPatches;
    private List<Rectangle> mHorizontalPatches;
    private List<Rectangle> mVerticalPatches;
    private Pair<Integer> mHorizontalPadding;
    private Pair<Integer> mVerticalPadding;
    private byte[] mSerializedChunk;

    public static NinePatchChunk create(BufferedImage image) {
        NinePatchChunk chunk = new NinePatchChunk();
        chunk.findPatches(image);
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(BufferedImage image, Graphics2D graphics2D, int x10, int y10, int scaledWidth, int scaledHeight, int destDensity, int srcDensity) {
        boolean scaling;
        boolean bl2 = scaling = destDensity != srcDensity && destDensity != 0 && srcDensity != 0;
        if (scaling) {
            try {
                graphics2D = (Graphics2D)graphics2D.create();
                float densityScale = (float)destDensity / (float)srcDensity;
                graphics2D.translate(x10, y10);
                graphics2D.scale(densityScale, densityScale);
                scaledWidth = (int)((float)scaledWidth / densityScale);
                scaledHeight = (int)((float)scaledHeight / densityScale);
                y10 = 0;
                x10 = 0;
                this.draw(image, graphics2D, x10, y10, scaledWidth, scaledHeight);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            this.draw(image, graphics2D, x10, y10, scaledWidth, scaledHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(BufferedImage image, Graphics2D graphics2D, int x10, int y10, int scaledWidth, int scaledHeight) {
        if (scaledWidth <= 1 || scaledHeight <= 1) {
            return;
        }
        Graphics2D g10 = (Graphics2D)graphics2D.create();
        g10.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            if (this.mPatches.isEmpty()) {
                g10.drawImage(image, x10, y10, scaledWidth, scaledHeight, null);
                return;
            }
            g10.translate(x10, y10);
            y10 = 0;
            x10 = 0;
            DrawingData data = this.computePatches(scaledWidth, scaledHeight);
            int fixedIndex = 0;
            int horizontalIndex = 0;
            int verticalIndex = 0;
            int patchIndex = 0;
            float vWeightSum = 1.0f;
            float vRemainder = data.mRemainderVertical;
            boolean vStretch = this.mVerticalStartWithPatch;
            while (y10 < scaledHeight - 1) {
                boolean hStretch = this.mHorizontalStartWithPatch;
                int height = 0;
                float vExtra = 0.0f;
                float hWeightSum = 1.0f;
                float hRemainder = data.mRemainderHorizontal;
                while (x10 < scaledWidth - 1) {
                    int width;
                    float extra;
                    Rectangle r10;
                    if (!vStretch) {
                        if (hStretch) {
                            r10 = this.mHorizontalPatches.get(horizontalIndex++);
                            extra = (float)r10.width / data.mHorizontalPatchesSum;
                            width = (int)(extra * hRemainder / hWeightSum);
                            hWeightSum -= extra;
                            hRemainder -= (float)width;
                            g10.drawImage(image, x10, y10, x10 + width, y10 + r10.height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                            x10 += width;
                        } else {
                            r10 = this.mFixed.get(fixedIndex++);
                            g10.drawImage(image, x10, y10, x10 + r10.width, y10 + r10.height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                            x10 += r10.width;
                        }
                        height = r10.height;
                    } else if (hStretch) {
                        r10 = this.mPatches.get(patchIndex++);
                        vExtra = (float)r10.height / data.mVerticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        extra = (float)r10.width / data.mHorizontalPatchesSum;
                        width = (int)(extra * hRemainder / hWeightSum);
                        hWeightSum -= extra;
                        hRemainder -= (float)width;
                        g10.drawImage(image, x10, y10, x10 + width, y10 + height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                        x10 += width;
                    } else {
                        r10 = this.mVerticalPatches.get(verticalIndex++);
                        vExtra = (float)r10.height / data.mVerticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        g10.drawImage(image, x10, y10, x10 + r10.width, y10 + height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                        x10 += r10.width;
                    }
                    hStretch = !hStretch;
                }
                x10 = 0;
                y10 += height;
                if (vStretch) {
                    vWeightSum -= vExtra;
                    vRemainder -= (float)height;
                }
                vStretch = !vStretch;
            }
        }
        finally {
            g10.dispose();
        }
    }

    public void getPadding(int[] padding) {
        padding[0] = (Integer)this.mHorizontalPadding.mFirst;
        padding[2] = (Integer)this.mHorizontalPadding.mSecond;
        padding[1] = (Integer)this.mVerticalPadding.mFirst;
        padding[3] = (Integer)this.mVerticalPadding.mSecond;
    }

    public int[] getPadding() {
        this.getPadding(sPaddingRect);
        return sPaddingRect;
    }

    private DrawingData computePatches(int scaledWidth, int scaledHeight) {
        int start;
        DrawingData data = new DrawingData();
        boolean measuredWidth = false;
        boolean endRow = true;
        int remainderHorizontal = 0;
        int remainderVertical = 0;
        if (!this.mFixed.isEmpty()) {
            start = this.mFixed.get((int)0).y;
            for (Rectangle rect : this.mFixed) {
                if (rect.y > start) {
                    endRow = true;
                    measuredWidth = true;
                }
                if (!measuredWidth) {
                    remainderHorizontal += rect.width;
                }
                if (!endRow) continue;
                remainderVertical += rect.height;
                endRow = false;
                start = rect.y;
            }
        } else {
            for (Rectangle rect : this.mVerticalPatches) {
                remainderHorizontal += rect.width;
            }
            for (Rectangle rect : this.mHorizontalPatches) {
                remainderVertical += rect.height;
            }
        }
        data.mRemainderHorizontal = scaledWidth - remainderHorizontal;
        data.mRemainderVertical = scaledHeight - remainderVertical;
        data.mHorizontalPatchesSum = 0.0f;
        if (!this.mHorizontalPatches.isEmpty()) {
            start = -1;
            for (Rectangle rect : this.mHorizontalPatches) {
                if (rect.x <= start) continue;
                data.mHorizontalPatchesSum += rect.width;
                start = rect.x;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.mPatches) {
                if (rect.x <= start) continue;
                data.mHorizontalPatchesSum += rect.width;
                start = rect.x;
            }
        }
        data.mVerticalPatchesSum = 0.0f;
        if (!this.mVerticalPatches.isEmpty()) {
            start = -1;
            for (Rectangle rect : this.mVerticalPatches) {
                if (rect.y <= start) continue;
                data.mVerticalPatchesSum += rect.height;
                start = rect.y;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.mPatches) {
                if (rect.y <= start) continue;
                data.mVerticalPatchesSum += rect.height;
                start = rect.y;
            }
        }
        return data;
    }

    private void findPatches(BufferedImage image) {
        int width = image.getWidth() - 2;
        int height = image.getHeight() - 2;
        int[] row = null;
        int[] column = null;
        row = GraphicsUtilities.getPixels(image, 1, 0, width, 1, row);
        column = GraphicsUtilities.getPixels(image, 0, 1, 1, height, column);
        boolean[] result2 = new boolean[1];
        Pair<List<Pair<Integer>>> left = this.getPatches(column, result2);
        this.mVerticalStartWithPatch = result2[0];
        result2 = new boolean[1];
        Pair<List<Pair<Integer>>> top = this.getPatches(row, result2);
        this.mHorizontalStartWithPatch = result2[0];
        this.mFixed = this.getRectangles((List)left.mFirst, (List)top.mFirst);
        this.mPatches = this.getRectangles((List)left.mSecond, (List)top.mSecond);
        if (!this.mFixed.isEmpty()) {
            this.mHorizontalPatches = this.getRectangles((List)left.mFirst, (List)top.mSecond);
            this.mVerticalPatches = this.getRectangles((List)left.mSecond, (List)top.mFirst);
        } else if (!((List)top.mFirst).isEmpty()) {
            this.mHorizontalPatches = new ArrayList<Rectangle>(0);
            this.mVerticalPatches = this.getVerticalRectangles(height, (List)top.mFirst);
        } else if (!((List)left.mFirst).isEmpty()) {
            this.mHorizontalPatches = this.getHorizontalRectangles(width, (List)left.mFirst);
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
        } else {
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
            this.mHorizontalPatches = this.mVerticalPatches;
        }
        row = GraphicsUtilities.getPixels(image, 1, height + 1, width, 1, row);
        column = GraphicsUtilities.getPixels(image, width + 1, 1, 1, height, column);
        Pair<List<Pair<Integer>>> bottom = this.getPatches(row, result2);
        this.mHorizontalPadding = this.getPadding((List)bottom.mFirst);
        Pair<List<Pair<Integer>>> right = this.getPatches(column, result2);
        this.mVerticalPadding = this.getPadding((List)right.mFirst);
        ArrayList<Rectangle> allRegions = new ArrayList<Rectangle>();
        allRegions.addAll(this.mHorizontalPatches);
        allRegions.addAll(this.mVerticalPatches);
        allRegions.addAll(this.mPatches);
        allRegions.addAll(this.mFixed);
        allRegions.sort(Comparator.comparingInt(rect -> rect.y).thenComparingInt(rect -> rect.x));
        int xDivsOffset = 32;
        int yDivsOffset = xDivsOffset + 4 * ((List)top.mSecond).size() * 2;
        int colorsOffset = yDivsOffset + 4 * ((List)left.mSecond).size() * 2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream oos = new LittleEndianDataOutputStream((OutputStream)baos);){
            oos.writeBoolean(true);
            oos.writeByte(((List)top.mSecond).size() * 2);
            oos.writeByte(((List)left.mSecond).size() * 2);
            oos.writeByte(allRegions.size());
            oos.writeInt(xDivsOffset);
            oos.writeInt(yDivsOffset);
            oos.writeInt(((Integer)this.mHorizontalPadding.mFirst).intValue());
            oos.writeInt(((Integer)this.mHorizontalPadding.mSecond).intValue());
            oos.writeInt(((Integer)this.mVerticalPadding.mFirst).intValue());
            oos.writeInt(((Integer)this.mVerticalPadding.mSecond).intValue());
            oos.writeInt(colorsOffset);
            for (Pair patch : (List)top.mSecond) {
                oos.writeInt(((Integer)patch.mFirst).intValue());
                oos.writeInt(((Integer)patch.mSecond).intValue());
            }
            for (Pair patch : (List)left.mSecond) {
                oos.writeInt(((Integer)patch.mFirst).intValue());
                oos.writeInt(((Integer)patch.mSecond).intValue());
            }
            for (Rectangle region : allRegions) {
                oos.writeInt(NinePatchChunk.getRegionColor(image, region));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mSerializedChunk = baos.toByteArray();
    }

    private List<Rectangle> getVerticalRectangles(int imageHeight, List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> top : topPairs) {
            int x10 = (Integer)top.mFirst;
            int width = (Integer)top.mSecond - (Integer)top.mFirst;
            rectangles.add(new Rectangle(x10, 0, width, imageHeight));
        }
        return rectangles;
    }

    private List<Rectangle> getHorizontalRectangles(int imageWidth, List<Pair<Integer>> leftPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y10 = (Integer)left.mFirst;
            int height = (Integer)left.mSecond - (Integer)left.mFirst;
            rectangles.add(new Rectangle(0, y10, imageWidth, height));
        }
        return rectangles;
    }

    private Pair<Integer> getPadding(List<Pair<Integer>> pairs) {
        if (pairs.isEmpty()) {
            return new Pair<Integer>(0, 0);
        }
        if (pairs.size() == 1) {
            if ((Integer)pairs.get((int)0).mFirst == 0) {
                return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, 0);
            }
            return new Pair<Integer>(0, (Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst);
        }
        int index = pairs.size() - 1;
        return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, (Integer)pairs.get((int)index).mSecond - (Integer)pairs.get((int)index).mFirst);
    }

    private List<Rectangle> getRectangles(List<Pair<Integer>> leftPairs, List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y10 = (Integer)left.mFirst;
            int height = (Integer)left.mSecond - (Integer)left.mFirst;
            for (Pair<Integer> top : topPairs) {
                int x10 = (Integer)top.mFirst;
                int width = (Integer)top.mSecond - (Integer)top.mFirst;
                rectangles.add(new Rectangle(x10, y10, width, height));
            }
        }
        return rectangles;
    }

    private Pair<List<Pair<Integer>>> getPatches(int[] pixels, boolean[] startWithPatch) {
        int lastIndex = 0;
        int lastPixel = pixels[0];
        boolean first = true;
        ArrayList<Pair<Integer>> fixed = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> patches = new ArrayList<Pair<Integer>>();
        for (int i10 = 0; i10 < pixels.length; ++i10) {
            int pixel = pixels[i10];
            if (pixel == lastPixel) continue;
            if (lastPixel == -16777216) {
                if (first) {
                    startWithPatch[0] = true;
                }
                patches.add(new Pair<Integer>(lastIndex, i10));
            } else {
                fixed.add(new Pair<Integer>(lastIndex, i10));
            }
            first = false;
            lastIndex = i10;
            lastPixel = pixel;
        }
        if (lastPixel == -16777216) {
            if (first) {
                startWithPatch[0] = true;
            }
            patches.add(new Pair<Integer>(lastIndex, pixels.length));
        } else {
            fixed.add(new Pair<Integer>(lastIndex, pixels.length));
        }
        if (patches.isEmpty()) {
            patches.add(new Pair<Integer>(1, pixels.length));
            startWithPatch[0] = true;
            fixed.clear();
        }
        return new Pair<List<Pair<Integer>>>(fixed, patches);
    }

    private static int getRegionColor(BufferedImage image, Rectangle region) {
        int expectedColor = image.getRGB(region.x, region.y);
        int expectedAlpha = expectedColor >> 24 & 0xFF;
        for (int y10 = region.y; y10 < region.y + region.height; ++y10) {
            for (int x10 = region.x + 1; x10 < region.x + region.width; ++x10) {
                int color = image.getRGB(x10, y10);
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0 && expectedAlpha != 0) {
                    return 1;
                }
                if (alpha == 0 || color == expectedColor) continue;
                return 1;
            }
        }
        if (expectedAlpha == 0) {
            return 0;
        }
        return expectedColor;
    }

    public byte[] getSerializedChunk() {
        return this.mSerializedChunk;
    }

    static class Pair<E>
    implements Serializable {
        private static final long serialVersionUID = -2204108979541762418L;
        E mFirst;
        E mSecond;

        Pair(E first, E second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        public String toString() {
            return "Pair[" + this.mFirst + ", " + this.mSecond + "]";
        }
    }

    static final class DrawingData {
        private int mRemainderHorizontal;
        private int mRemainderVertical;
        private float mHorizontalPatchesSum;
        private float mVerticalPatchesSum;

        DrawingData() {
        }
    }
}

