/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FilteredTreeModel<T>
extends DefaultTreeModel {
    private final Predicate<T> predicate;

    public FilteredTreeModel(TreeNode treeNode, Predicate<T> predicate) {
        super(treeNode);
        this.predicate = predicate;
    }

    @Override
    public Object getChild(Object parent, int index) {
        int n10 = super.getChildCount(parent);
        for (int i10 = 0; i10 < n10; ++i10) {
            Object result2 = super.getChild(parent, i10);
            if (!this.predicate.test(result2)) continue;
            if (index == 0) {
                return result2;
            }
            --index;
        }
        String msg = String.format(Locale.US, "Child index %1$d is higher than # of children %2$d", index, this.getChildCount(parent));
        throw new IllegalStateException(msg);
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        int n10 = super.getChildCount(parent);
        for (int i10 = 0; i10 < n10; ++i10) {
            Object result2 = super.getChild(parent, i10);
            if (!this.predicate.test(result2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index = 0;
        int n10 = super.getChildCount(parent);
        for (int i10 = 0; i10 < n10; ++i10) {
            Object result2 = super.getChild(parent, i10);
            if (!this.predicate.test(result2)) continue;
            if (result2.equals(child)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

