/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.util.DexUtil;

public final class DexFiles {
    public static final int MAX_SUPPORTED_DEX_VERSION = 38;
    private static final Opcodes DEFAULT_OPCODES = Opcodes.getDefault();

    private DexFiles() {
    }

    public static DexBackedDexFile getDexFile(Path p10) throws IOException {
        return DexFiles.getDexFile(Files.readAllBytes(p10));
    }

    public static DexBackedDexFile getDexFile(byte[] contents) {
        try {
            return new DexBackedDexFile(DEFAULT_OPCODES, contents);
        }
        catch (DexUtil.UnsupportedFile e10) {
            if (HeaderItem.getVersion((byte[])contents, (int)0) > 38) {
                contents[4] = 48;
                contents[5] = 51;
                contents[6] = 56;
                return new DexBackedDexFile(DEFAULT_OPCODES, contents);
            }
            throw e10;
        }
    }
}

