/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.reference.ImmutableTypeReference;

public class DexPackageNode
extends DexElementNode {
    private final String packageName;

    public DexPackageNode(String name, String packageName) {
        super(name, true);
        this.packageName = packageName;
    }

    @Override
    public long getSize() {
        long size = 0L;
        int n10 = this.getChildCount();
        for (int i10 = 0; i10 < n10; ++i10) {
            DexElementNode node = this.getChildAt(i10);
            size += node.getSize();
        }
        return size;
    }

    public DexClassNode getOrCreateClass(String parentPackage, String qualifiedClassName, TypeReference typeReference) {
        int i10 = qualifiedClassName.indexOf(46);
        if (i10 < 0) {
            DexClassNode node = this.getChildByType(qualifiedClassName, DexClassNode.class);
            if (node == null) {
                node = new DexClassNode(qualifiedClassName, typeReference != null ? ImmutableTypeReference.of((TypeReference)typeReference) : null);
                this.add(node);
            }
            return node;
        }
        String segment = qualifiedClassName.substring(0, i10);
        String nextSegment = qualifiedClassName.substring(i10 + 1);
        DexPackageNode packageNode = this.getChildByType(segment, DexPackageNode.class);
        if (packageNode == null) {
            packageNode = new DexPackageNode(segment, DexPackageNode.combine(parentPackage, segment));
            this.add(packageNode);
        }
        return packageNode.getOrCreateClass(DexPackageNode.combine(parentPackage, segment), nextSegment, typeReference);
    }

    @Override
    public void update() {
        super.update();
        int methodDefinitions = 0;
        int methodReferences = 0;
        boolean isRemoved = true;
        boolean isDefined = false;
        int n10 = this.getChildCount();
        for (int i10 = 0; i10 < n10; ++i10) {
            DexElementNode node = this.getChildAt(i10);
            methodDefinitions += node.getMethodDefinitionsCount();
            methodReferences += node.getMethodReferencesCount();
            if (!node.isRemoved()) {
                isRemoved = false;
            }
            if (!node.isDefined()) continue;
            isDefined = true;
        }
        this.setDefined(isDefined);
        this.setRemoved(isRemoved);
        this.setMethodDefinitionsCount(methodDefinitions);
        this.setMethodReferencesCount(methodReferences);
    }

    public String getPackageName() {
        return this.packageName;
    }
}

