/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkVerifierTracker;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallStatus;
import com.android.tools.deployer.model.Apk;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AdbClient {
    private static final Map<String, Deploy.Arch> ABI_MAP = ImmutableMap.of((Object)"arm64-v8a", (Object)((Object)Deploy.Arch.ARCH_64_BIT), (Object)"armeabi-v7a", (Object)((Object)Deploy.Arch.ARCH_32_BIT), (Object)"x86_64", (Object)((Object)Deploy.Arch.ARCH_64_BIT), (Object)"x86", (Object)((Object)Deploy.Arch.ARCH_32_BIT));
    private final IDevice device;
    private final ILogger logger;
    public static final long DEFAULT_TIMEOUT = 5L;
    public static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MINUTES;

    public AdbClient(IDevice device, ILogger logger) {
        this.device = device;
        this.logger = logger;
    }

    public SocketChannel rawExec(String executable, String[] parameters) throws AdbCommandRejectedException, IOException, TimeoutException {
        return this.device.rawExec(executable, parameters);
    }

    public byte[] shell(String[] parameters) throws IOException {
        return this.shell(parameters, null);
    }

    public byte[] shell(String[] parameters, InputStream input) throws IOException {
        return this.shell(parameters, input, 5L, DEFAULT_TIMEUNIT);
    }

    public byte[] shell(String[] parameters, InputStream input, long maxTimeOutMs, TimeUnit timeUnit) throws IOException {
        Trace ignored = Trace.begin("adb shell" + Arrays.toString(parameters));
        try {
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)receiver, maxTimeOutMs, timeUnit, input);
            byte[] byArray = receiver.toByteArray();
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e10) {
                throw new IOException(e10);
            }
        }
    }

    public byte[] binder(String[] parameters, InputStream input) throws IOException {
        this.logger.info("BINDER: " + String.join((CharSequence)" ", parameters), new Object[0]);
        Trace ignored = Trace.begin("binder" + Arrays.toString(parameters));
        try {
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeBinderCommand(parameters, receiver, 5L, TimeUnit.MINUTES, input);
            byte[] byArray = receiver.toByteArray();
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e10) {
                throw new IOException(e10);
            }
        }
    }

    public InstallResult install(List<String> apks, List<String> options, boolean reinstall) {
        List<File> files = apks.stream().map(File::new).collect(Collectors.toList());
        try {
            if (this.device.getVersion().isGreaterOrEqualThan(21)) {
                this.device.installPackages(files, reinstall, options, 5L, TimeUnit.MINUTES);
                return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
            }
            if (apks.size() != 1) {
                return new InstallResult(InstallStatus.MULTI_APKS_NO_SUPPORTED_BELOW21, "Splits are not supported below API 21");
            }
            this.device.installPackage(apks.get(0), reinstall, options.toArray(new String[0]));
            return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
        }
        catch (InstallException e10) {
            String code = e10.getErrorCode();
            if (code != null) {
                try {
                    return ApkInstaller.toInstallerResult(code, e10.getMessage());
                }
                catch (IllegalArgumentException | NullPointerException ignored) {
                    this.logger.warning("Unrecognized Installation Failure: %s\n%s\n", new Object[]{code, e10.getMessage()});
                }
            } else {
                Throwable cause = e10.getCause();
                if (cause instanceof ShellCommandUnresponsiveException) {
                    return new InstallResult(InstallStatus.SHELL_UNRESPONSIVE, e10.getMessage());
                }
                this.logger.warning("Installation Failure: %s\n", new Object[]{e10.getMessage()});
                return new InstallResult(InstallStatus.UNKNOWN_ERROR, e10.getMessage(), null);
            }
            return new InstallResult(InstallStatus.UNKNOWN_ERROR, "Unknown Error");
        }
    }

    public boolean uninstall(String packageName) {
        try {
            this.device.uninstallPackage(packageName);
            return true;
        }
        catch (InstallException installException) {
            return false;
        }
    }

    public List<String> getAbis() {
        return this.device.getAbis();
    }

    public List<Integer> getPids(String packageName) {
        if (!this.device.supportsFeature(IDevice.Feature.REAL_PKG_NAME)) {
            throw new IllegalStateException(String.format("Device %s, do not support REAL_PKG_NAME", this.device.getSerialNumber()));
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (Client client : this.device.getClients()) {
            if (!packageName.equals(client.getClientData().getPackageName())) continue;
            results.add(client.getClientData().getPid());
        }
        return results;
    }

    public Deploy.Arch getArch(List<Integer> pids) {
        Deploy.Arch result2 = Deploy.Arch.ARCH_UNKNOWN;
        for (int pid : pids) {
            Deploy.Arch curProc = this.getArch(pid);
            if (result2 == Deploy.Arch.ARCH_UNKNOWN) {
                result2 = curProc;
                continue;
            }
            if (curProc == Deploy.Arch.ARCH_UNKNOWN || result2 == curProc) continue;
            this.logger.warning("Mixed ABIs detected: %s and %s", new Object[]{result2, curProc});
        }
        return result2;
    }

    public Deploy.Arch getArchFromApk(List<Apk> apks) throws DeployerException {
        HashSet<String> appSupported = new HashSet<String>();
        for (Apk apk : apks) {
            appSupported.addAll(apk.libraryAbis);
        }
        List<String> deviceSupported = this.getAbis();
        if (deviceSupported.isEmpty()) {
            throw DeployerException.unsupportedArch();
        }
        if (appSupported.isEmpty()) {
            String abi = deviceSupported.get(0);
            return ABI_MAP.get(abi);
        }
        for (String abi : deviceSupported) {
            if (!appSupported.contains(abi)) continue;
            return ABI_MAP.get(abi);
        }
        throw DeployerException.unsupportedArch();
    }

    private Deploy.Arch getArch(int pid) {
        for (Client client : this.device.getClients()) {
            if (client.getClientData().getPid() != pid) continue;
            String abi = client.getClientData().getAbi();
            if (abi == null) {
                return Deploy.Arch.ARCH_UNKNOWN;
            }
            if (abi.startsWith("32-bit")) {
                return Deploy.Arch.ARCH_32_BIT;
            }
            if (abi.startsWith("64-bit")) {
                return Deploy.Arch.ARCH_64_BIT;
            }
            return Deploy.Arch.ARCH_UNKNOWN;
        }
        return Deploy.Arch.ARCH_UNKNOWN;
    }

    public void push(String from, String to2) throws IOException {
        try (Trace ignored = Trace.begin("adb push");){
            this.device.pushFile(from, to2);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException e10) {
            throw new IOException(e10);
        }
    }

    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    public String getSerial() {
        return this.device.getSerialNumber();
    }

    public String abortSession(String sessionId) {
        String response;
        String prefix = this.device.getVersion().isGreaterOrEqualThan(24) ? "cmd package" : "pm";
        String[] command = new String[]{prefix, "install-abandon", sessionId};
        try {
            byte[] bytes = this.shell(command);
            response = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e10) {
            response = e10.getMessage();
        }
        return response;
    }

    public String getSkipVerificationOption(String packageName) {
        return ApkVerifierTracker.getSkipVerificationInstallationFlag(this.device, packageName);
    }

    private class ByteArrayOutputReceiver
    implements IShellOutputReceiver {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private ByteArrayOutputReceiver() {
        }

        @Override
        public void addOutput(byte[] data, int offset, int length) {
            this.stream.write(data, offset, length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }

    public static class InstallResult {
        public final InstallStatus status;
        public final String reason;
        public final InstallMetrics metrics;

        InstallResult(InstallStatus status, String reason) {
            this.status = status;
            this.reason = reason;
            this.metrics = null;
        }

        InstallResult(InstallStatus status, String reason, InstallMetrics metrics) {
            this.status = status;
            this.reason = reason;
            this.metrics = metrics;
        }
    }
}

