/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.Apk;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentCacheDatabase {
    public static final int DEFAULT_SIZE = 25;
    private final Cache<String, Entry> db;
    File persistFile = null;

    public DeploymentCacheDatabase(int size) {
        this(size, null);
    }

    public DeploymentCacheDatabase(File persistFile) {
        this(25, persistFile);
    }

    public DeploymentCacheDatabase(int size, File persistFile) {
        this.db = CacheBuilder.newBuilder().maximumSize((long)size).build();
        this.persistFile = persistFile;
        if (persistFile == null) {
            return;
        }
        try (ObjectInputStream in22 = new ObjectInputStream(new FileInputStream(persistFile));){
            HashMap entries = (HashMap)in22.readObject();
            for (Map.Entry e10 : entries.entrySet()) {
                this.db.put((Object)((String)e10.getKey()), (Object)((Entry)e10.getValue()));
            }
        }
        catch (FileNotFoundException in22) {
        }
        catch (IOException | ClassNotFoundException e11) {
            e11.printStackTrace();
        }
    }

    public Entry get(String serial, String appId) {
        String key = String.format("%s:%s", serial, appId);
        return (Entry)this.db.getIfPresent((Object)key);
    }

    public boolean store(String serial, String appId, List<Apk> newInstalledApks, OverlayId overlayId) {
        String key = String.format("%s:%s", serial, appId);
        this.db.put((Object)key, (Object)new Entry(newInstalledApks, overlayId));
        this.writeToFile();
        return true;
    }

    public boolean invalidate(String serial, String appId) {
        String key = String.format("%s:%s", serial, appId);
        this.db.invalidate((Object)key);
        this.writeToFile();
        return true;
    }

    public boolean writeToFile() {
        if (this.persistFile == null) {
            return false;
        }
        if (this.persistFile.exists()) {
            this.persistFile.delete();
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.persistFile));){
            HashMap entries = Maps.newHashMap((Map)this.db.asMap());
            out.writeObject(entries);
            out.flush();
        }
        catch (IOException e10) {
            e10.printStackTrace();
        }
        return true;
    }

    public static class Entry
    implements Serializable {
        private final List<Apk> apks;
        private final OverlayId oid;

        public List<Apk> getApks() {
            return this.apks;
        }

        public OverlayId getOverlayId() {
            return this.oid;
        }

        public OverlayId.Contents getOverlayContents() {
            return this.oid.getOverlayContents();
        }

        private Entry(List<Apk> apks, OverlayId overlayId) {
            this.apks = apks;
            this.oid = overlayId;
        }
    }
}

