/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import java.util.Arrays;

public class AndroidPatternMatcher {
    public static final int PATTERN_LITERAL = 0;
    public static final int PATTERN_PREFIX = 1;
    public static final int PATTERN_SIMPLE_GLOB = 2;
    public static final int PATTERN_ADVANCED_GLOB = 3;
    private static final int TOKEN_TYPE_LITERAL = 0;
    private static final int TOKEN_TYPE_ANY = 1;
    private static final int TOKEN_TYPE_SET = 2;
    private static final int TOKEN_TYPE_INVERSE_SET = 3;
    private static final int NO_MATCH = -1;
    private static final int PARSED_TOKEN_CHAR_SET_START = -1;
    private static final int PARSED_TOKEN_CHAR_SET_INVERSE_START = -2;
    private static final int PARSED_TOKEN_CHAR_SET_STOP = -3;
    private static final int PARSED_TOKEN_CHAR_ANY = -4;
    private static final int PARSED_MODIFIER_RANGE_START = -5;
    private static final int PARSED_MODIFIER_RANGE_STOP = -6;
    private static final int PARSED_MODIFIER_ZERO_OR_MORE = -7;
    private static final int PARSED_MODIFIER_ONE_OR_MORE = -8;
    private final String mPattern;
    private final int mType;
    private final int[] mParsedPattern;
    private static final int MAX_PATTERN_STORAGE = 2048;
    private static final int[] sParsedPatternScratch = new int[2048];

    public AndroidPatternMatcher(String pattern, int type) {
        this.mPattern = pattern;
        this.mType = type;
        this.mParsedPattern = (int[])(this.mType == 3 ? AndroidPatternMatcher.parseAndVerifyAdvancedPattern(pattern) : null);
    }

    public final String getPath() {
        return this.mPattern;
    }

    public final int getType() {
        return this.mType;
    }

    public boolean match(String str) {
        return AndroidPatternMatcher.matchPattern(str, this.mPattern, this.mParsedPattern, this.mType);
    }

    public String toString() {
        String type = "? ";
        switch (this.mType) {
            case 0: {
                type = "literal ";
                break;
            }
            case 1: {
                type = "prefix ";
                break;
            }
            case 2: {
                type = "glob ";
                break;
            }
            case 3: {
                type = "advanced ";
            }
        }
        return type + this.mPattern;
    }

    static boolean matchPattern(String match2, String pattern, int[] parsedPattern, int type) {
        if (match2 == null) {
            return false;
        }
        if (type == 0) {
            return pattern.equals(match2);
        }
        if (type == 1) {
            return match2.startsWith(pattern);
        }
        if (type == 2) {
            return AndroidPatternMatcher.matchGlobPattern(pattern, match2);
        }
        if (type == 3) {
            return AndroidPatternMatcher.matchAdvancedPattern(parsedPattern, match2);
        }
        return false;
    }

    static boolean matchGlobPattern(String pattern, String match2) {
        int NP = pattern.length();
        if (NP <= 0) {
            return match2.length() <= 0;
        }
        int NM = match2.length();
        int ip2 = 0;
        int im2 = 0;
        char nextChar = pattern.charAt(0);
        while (ip2 < NP && im2 < NM) {
            boolean escaped;
            char c10 = nextChar;
            nextChar = ++ip2 < NP ? pattern.charAt(ip2) : (char)'\u0000';
            boolean bl2 = escaped = c10 == '\\';
            if (escaped) {
                c10 = nextChar;
                char c11 = nextChar = ++ip2 < NP ? pattern.charAt(ip2) : (char)'\u0000';
            }
            if (nextChar == '*') {
                if (!escaped && c10 == '.') {
                    if (ip2 >= NP - 1) {
                        return true;
                    }
                    if ((nextChar = pattern.charAt(++ip2)) == '\\') {
                        char c12 = nextChar = ++ip2 < NP ? pattern.charAt(ip2) : (char)'\u0000';
                    }
                    while (match2.charAt(im2) != nextChar && ++im2 < NM) {
                    }
                    if (im2 == NM) {
                        return false;
                    }
                    nextChar = ++ip2 < NP ? pattern.charAt(ip2) : (char)'\u0000';
                    ++im2;
                    continue;
                }
                while (match2.charAt(im2) == c10 && ++im2 < NM) {
                }
                nextChar = ++ip2 < NP ? pattern.charAt(ip2) : (char)'\u0000';
                continue;
            }
            if (c10 != '.' && match2.charAt(im2) != c10) {
                return false;
            }
            ++im2;
        }
        if (ip2 >= NP && im2 >= NM) {
            return true;
        }
        return ip2 == NP - 2 && pattern.charAt(ip2) == '.' && pattern.charAt(ip2 + 1) == '*';
    }

    static synchronized int[] parseAndVerifyAdvancedPattern(String pattern) {
        int ip2 = 0;
        int LP = pattern.length();
        int it2 = 0;
        boolean inSet = false;
        boolean inRange = false;
        boolean inCharClass = false;
        block12: while (ip2 < LP) {
            if (it2 > 2045) {
                throw new IllegalArgumentException("Pattern is too large!");
            }
            char c10 = pattern.charAt(ip2);
            boolean addToParsedPattern = false;
            switch (c10) {
                case '[': {
                    if (inSet) {
                        addToParsedPattern = true;
                        break;
                    }
                    if (pattern.charAt(ip2 + 1) == '^') {
                        AndroidPatternMatcher.sParsedPatternScratch[it2++] = -2;
                        ++ip2;
                    } else {
                        AndroidPatternMatcher.sParsedPatternScratch[it2++] = -1;
                    }
                    ++ip2;
                    inSet = true;
                    continue block12;
                }
                case ']': {
                    if (!inSet) {
                        addToParsedPattern = true;
                        break;
                    }
                    int parsedToken = sParsedPatternScratch[it2 - 1];
                    if (parsedToken == -1 || parsedToken == -2) {
                        throw new IllegalArgumentException("You must define characters in a set.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -3;
                    inSet = false;
                    inCharClass = false;
                    break;
                }
                case '{': {
                    if (inSet) break;
                    if (it2 == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it2 - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -5;
                    ++ip2;
                    inRange = true;
                    break;
                }
                case '}': {
                    if (!inRange) break;
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -6;
                    inRange = false;
                    break;
                }
                case '*': {
                    if (inSet) break;
                    if (it2 == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it2 - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -7;
                    break;
                }
                case '+': {
                    if (inSet) break;
                    if (it2 == 0 || AndroidPatternMatcher.isParsedModifier(sParsedPatternScratch[it2 - 1])) {
                        throw new IllegalArgumentException("Modifier must follow a token.");
                    }
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -8;
                    break;
                }
                case '.': {
                    if (inSet) break;
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = -4;
                    break;
                }
                case '\\': {
                    if (ip2 + 1 >= LP) {
                        throw new IllegalArgumentException("Escape found at end of pattern!");
                    }
                    c10 = pattern.charAt(++ip2);
                    addToParsedPattern = true;
                    break;
                }
                default: {
                    addToParsedPattern = true;
                }
            }
            if (inSet) {
                if (inCharClass) {
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = c10;
                    inCharClass = false;
                } else if (ip2 + 2 < LP && pattern.charAt(ip2 + 1) == '-' && pattern.charAt(ip2 + 2) != ']') {
                    inCharClass = true;
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = c10;
                    ++ip2;
                } else {
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = c10;
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = c10;
                }
            } else {
                if (inRange) {
                    int endOfSet = pattern.indexOf(125, ip2);
                    if (endOfSet < 0) {
                        throw new IllegalArgumentException("Range not ended with '}'");
                    }
                    String rangeString = pattern.substring(ip2, endOfSet);
                    int commaIndex = rangeString.indexOf(44);
                    try {
                        int rangeMin;
                        int rangeMax;
                        if (commaIndex < 0) {
                            int parsedRange;
                            rangeMin = rangeMax = (parsedRange = Integer.parseInt(rangeString));
                        } else {
                            rangeMin = Integer.parseInt(rangeString.substring(0, commaIndex));
                            rangeMax = commaIndex == rangeString.length() - 1 ? Integer.MAX_VALUE : Integer.parseInt(rangeString.substring(commaIndex + 1));
                        }
                        if (rangeMin > rangeMax) {
                            throw new IllegalArgumentException("Range quantifier minimum is greater than maximum");
                        }
                        AndroidPatternMatcher.sParsedPatternScratch[it2++] = rangeMin;
                        AndroidPatternMatcher.sParsedPatternScratch[it2++] = rangeMax;
                    }
                    catch (NumberFormatException e10) {
                        throw new IllegalArgumentException("Range number format incorrect", e10);
                    }
                    ip2 = endOfSet;
                    continue;
                }
                if (addToParsedPattern) {
                    AndroidPatternMatcher.sParsedPatternScratch[it2++] = c10;
                }
            }
            ++ip2;
        }
        if (inSet) {
            throw new IllegalArgumentException("Set was not terminated!");
        }
        return Arrays.copyOf(sParsedPatternScratch, it2);
    }

    private static boolean isParsedModifier(int parsedChar) {
        return parsedChar == -8 || parsedChar == -7 || parsedChar == -6 || parsedChar == -5;
    }

    static boolean matchAdvancedPattern(int[] parsedPattern, String match2) {
        int ip2 = 0;
        int im2 = 0;
        int LP = parsedPattern.length;
        int LM = match2.length();
        int charSetStart = 0;
        int charSetEnd = 0;
        while (ip2 < LP) {
            int minRepetition;
            int maxRepetition;
            int tokenType;
            int patternChar = parsedPattern[ip2];
            switch (patternChar) {
                case -4: {
                    tokenType = 1;
                    ++ip2;
                    break;
                }
                case -2: 
                case -1: {
                    tokenType = patternChar == -1 ? 2 : 3;
                    charSetStart = ip2 + 1;
                    while (++ip2 < LP && parsedPattern[ip2] != -3) {
                    }
                    charSetEnd = ip2 - 1;
                    ++ip2;
                    break;
                }
                default: {
                    charSetStart = ip2++;
                    tokenType = 0;
                }
            }
            if (ip2 >= LP) {
                maxRepetition = 1;
                minRepetition = 1;
            } else {
                patternChar = parsedPattern[ip2];
                switch (patternChar) {
                    case -7: {
                        minRepetition = 0;
                        maxRepetition = Integer.MAX_VALUE;
                        ++ip2;
                        break;
                    }
                    case -8: {
                        minRepetition = 1;
                        maxRepetition = Integer.MAX_VALUE;
                        ++ip2;
                        break;
                    }
                    case -5: {
                        minRepetition = parsedPattern[++ip2];
                        maxRepetition = parsedPattern[++ip2];
                        ip2 += 2;
                        break;
                    }
                    default: {
                        maxRepetition = 1;
                        minRepetition = 1;
                    }
                }
            }
            if (minRepetition > maxRepetition) {
                return false;
            }
            int matched = AndroidPatternMatcher.matchChars(match2, im2, LM, tokenType, minRepetition, maxRepetition, parsedPattern, charSetStart, charSetEnd);
            if (matched == -1) {
                return false;
            }
            im2 += matched;
        }
        return ip2 >= LP && im2 >= LM;
    }

    private static int matchChars(String match2, int im2, int lm2, int tokenType, int minRepetition, int maxRepetition, int[] parsedPattern, int tokenStart, int tokenEnd) {
        int matched;
        for (matched = 0; matched < maxRepetition && AndroidPatternMatcher.matchChar(match2, im2 + matched, lm2, tokenType, parsedPattern, tokenStart, tokenEnd); ++matched) {
        }
        return matched < minRepetition ? -1 : matched;
    }

    private static boolean matchChar(String match2, int im2, int lm2, int tokenType, int[] parsedPattern, int tokenStart, int tokenEnd) {
        if (im2 >= lm2) {
            return false;
        }
        switch (tokenType) {
            case 1: {
                return true;
            }
            case 2: {
                for (int i10 = tokenStart; i10 < tokenEnd; i10 += 2) {
                    char matchChar = match2.charAt(im2);
                    if (matchChar < parsedPattern[i10] || matchChar > parsedPattern[i10 + 1]) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                for (int i11 = tokenStart; i11 < tokenEnd; i11 += 2) {
                    char matchChar = match2.charAt(im2);
                    if (matchChar < parsedPattern[i11] || matchChar > parsedPattern[i11 + 1]) continue;
                    return false;
                }
                return true;
            }
            case 0: {
                return match2.charAt(im2) == parsedPattern[tokenStart];
            }
        }
        return false;
    }
}

