/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AutofillDetector
extends LayoutDetector {
    private static final String MESSAGE = "Missing `autofillHints` attribute";
    public static final Issue ISSUE = Issue.create("Autofill", "Use Autofill", "Specify an `autofillHints` attribute when targeting SDK version 26 or higher or explicitly specify that the view is not important for autofill. Your app can help an autofill service classify the data correctly by providing the meaning of each view that could be autofillable, such as views representing usernames, passwords, credit card fields, email addresses, etc.\n\nThe hints can have any value, but it is recommended to use predefined values like 'username' for a username or 'creditCardNumber' for a credit card number. For a list of all predefined autofill hint constants, see the `AUTOFILL_HINT_` constants in the `View` reference at https://developer.android.com/reference/android/view/View.html.\n\nYou can mark a view unimportant for autofill by specifying an `importantForAutofill` attribute on that view or a parent view. See https://developer.android.com/reference/android/view/View.html#setImportantForAutofill(int).", Category.USABILITY, 3, Severity.WARNING, new Implementation(AutofillDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/text/autofill.html");

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("EditText");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        if (xmlContext.getProject().getTargetSdk() < 26) {
            return;
        }
        String attrValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "importantForAutofill");
        if (!attrValue.isEmpty()) {
            if (attrValue.equals("no") || attrValue.equals("noExcludeDescendants")) {
                return;
            }
            if (attrValue.equals("yes") || attrValue.equals("yesExcludeDescendants")) {
                this.checkForAutofillHints(element, xmlContext);
                return;
            }
        }
        boolean checkParent = true;
        Node el2 = element.getParentNode();
        while (el2 instanceof Element && checkParent) {
            attrValue = ((Element)el2).getAttributeNS("http://schemas.android.com/apk/res/android", "importantForAutofill");
            if (!attrValue.isEmpty()) {
                checkParent = false;
                if (attrValue.equals("noExcludeDescendants") || attrValue.equals("yesExcludeDescendants")) {
                    return;
                }
            }
            el2 = el2.getParentNode();
        }
        this.checkForAutofillHints(element, xmlContext);
    }

    private void checkForAutofillHints(Element element, XmlContext xmlContext) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "autofillHints")) {
            LintFix fix = this.fix().alternatives(this.fix().set("http://schemas.android.com/apk/res/android", "autofillHints", "").caretBegin().build(), this.fix().set("http://schemas.android.com/apk/res/android", "importantForAutofill", "no").build());
            xmlContext.report(ISSUE, element, xmlContext.getNameLocation(element), MESSAGE, fix);
        }
    }
}

