/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;

class FloatRangeConstraint
extends RangeConstraint {
    final double from;
    final double to;
    final boolean fromInclusive;
    final boolean toInclusive;

    public static FloatRangeConstraint create(UAnnotation annotation) {
        assert (AnnotationDetector.FLOAT_RANGE_ANNOTATION.isEquals(annotation.getQualifiedName()));
        double from = UastLintUtils.getAnnotationDoubleValue(annotation, "from", Double.NEGATIVE_INFINITY);
        double to2 = UastLintUtils.getAnnotationDoubleValue(annotation, "to", Double.POSITIVE_INFINITY);
        boolean fromInclusive = UastLintUtils.getAnnotationBooleanValue(annotation, "fromInclusive", true);
        boolean toInclusive = UastLintUtils.getAnnotationBooleanValue(annotation, "toInclusive", true);
        return new FloatRangeConstraint(from, to2, fromInclusive, toInclusive);
    }

    @VisibleForTesting
    static FloatRangeConstraint range(double from, double to2) {
        return new FloatRangeConstraint(from, to2, true, true);
    }

    @VisibleForTesting
    static FloatRangeConstraint atLeast(double from) {
        return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, true, true);
    }

    @VisibleForTesting
    static FloatRangeConstraint atMost(double to2) {
        return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to2, true, true);
    }

    @VisibleForTesting
    static FloatRangeConstraint greaterThan(double from) {
        return new FloatRangeConstraint(from, Double.POSITIVE_INFINITY, false, true);
    }

    @VisibleForTesting
    static FloatRangeConstraint lessThan(double to2) {
        return new FloatRangeConstraint(Double.NEGATIVE_INFINITY, to2, true, false);
    }

    @VisibleForTesting
    FloatRangeConstraint(double from, double to2, boolean fromInclusive, boolean toInclusive) {
        this.from = from;
        this.to = to2;
        this.fromInclusive = fromInclusive;
        this.toInclusive = toInclusive;
    }

    public boolean isValid(double value) {
        return (this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to);
    }

    public String describe() {
        return this.describe(null, null);
    }

    public String describe(double argument) {
        return this.describe(null, argument);
    }

    public String describe(UExpression argument, Double actualValue) {
        StringBuilder sb2 = new StringBuilder(20);
        String valueString = null;
        if (argument instanceof ULiteralExpression) {
            String str = argument.asSourceString();
            if (str.endsWith("f") || str.endsWith("F")) {
                str = str.substring(0, str.length() - 1);
            }
            valueString = str;
        } else if (actualValue != null) {
            valueString = actualValue.toString();
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            double value = actualValue;
            if (this.from != Double.NEGATIVE_INFINITY) {
                if (this.to != Double.POSITIVE_INFINITY) {
                    if (this.fromInclusive && value < this.from || !this.fromInclusive && value <= this.from) {
                        sb2.append("Value must be ");
                        if (this.fromInclusive) {
                            sb2.append('\u2265');
                        } else {
                            sb2.append('>');
                        }
                        sb2.append(' ');
                        sb2.append(Double.toString(this.from));
                    } else {
                        assert (this.toInclusive && value > this.to || !this.toInclusive && value >= this.to);
                        sb2.append("Value must be ");
                        if (this.toInclusive) {
                            sb2.append('\u2264');
                        } else {
                            sb2.append('<');
                        }
                        sb2.append(' ');
                        sb2.append(Double.toString(this.to));
                    }
                } else {
                    sb2.append("Value must be ");
                    if (this.fromInclusive) {
                        sb2.append('\u2265');
                    } else {
                        sb2.append('>');
                    }
                    sb2.append(' ');
                    sb2.append(Double.toString(this.from));
                }
            } else if (this.to != Double.POSITIVE_INFINITY) {
                sb2.append("Value must be ");
                if (this.toInclusive) {
                    sb2.append('\u2264');
                } else {
                    sb2.append('<');
                }
                sb2.append(' ');
                sb2.append(Double.toString(this.to));
            }
            sb2.append(" (was ").append(valueString).append(")");
            return sb2.toString();
        }
        if (this.from != Double.NEGATIVE_INFINITY) {
            if (this.to != Double.POSITIVE_INFINITY) {
                sb2.append("Value must be ");
                if (this.fromInclusive) {
                    sb2.append('\u2265');
                } else {
                    sb2.append('>');
                }
                sb2.append(' ');
                sb2.append(Double.toString(this.from));
                sb2.append(" and ");
                if (this.toInclusive) {
                    sb2.append('\u2264');
                } else {
                    sb2.append('<');
                }
                sb2.append(' ');
                sb2.append(Double.toString(this.to));
            } else {
                sb2.append("Value must be ");
                if (this.fromInclusive) {
                    sb2.append('\u2265');
                } else {
                    sb2.append('>');
                }
                sb2.append(' ');
                sb2.append(Double.toString(this.from));
            }
        } else if (this.to != Double.POSITIVE_INFINITY) {
            sb2.append("Value must be ");
            if (this.toInclusive) {
                sb2.append('\u2264');
            } else {
                sb2.append('<');
            }
            sb2.append(' ');
            sb2.append(Double.toString(this.to));
        }
        if (valueString != null) {
            sb2.append(" (is ").append(valueString).append(')');
        }
        return sb2.toString();
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            return !(otherRange.from < this.from || otherRange.to > this.to || !this.fromInclusive && otherRange.fromInclusive && otherRange.from == this.from || !this.toInclusive && otherRange.toInclusive && otherRange.to == this.to);
        }
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return !((double)otherRange.from < this.from || (double)otherRange.to > this.to || !this.fromInclusive && (double)otherRange.from == this.from || !this.toInclusive && (double)otherRange.to == this.to);
        }
        return null;
    }

    public String toString() {
        return this.describe(null, null);
    }
}

