/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/LabelForDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "editableTextFields", "", "Lorg/w3c/dom/Element;", "labels", "", "", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableAttributes", "", "getApplicableElements", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "android.sdktools.lint-checks"})
public final class LabelForDetector
extends LayoutDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> labels;
    @Nullable
    private List<Element> editableTextFields;
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("LabelFor", "Missing accessibility label", "\n                 Editable text fields should provide an `android:hint` or, provided your `minSdkVersion` \\\n                 is at least 17, they may be referenced by a view with a `android:labelFor` attribute.\n\n                 When using `android:labelFor`, be sure to provide an `android:text` or an \\\n                 `android:contentDescription`.\n\n                 If your view is labeled but by a label in a different layout which includes this one, \\\n                 just suppress this warning from lint.\n                ", Category.A11Y, 2, Severity.WARNING, new Implementation(LabelForDetector.class, Scope.RESOURCE_FILE_SCOPE));
    @NotNull
    private static final String PREFIX = "Missing accessibility label";
    @NotNull
    private static final String PROVIDE_HINT = "where minSdk < 17, you should provide an `android:hint`";
    @NotNull
    private static final String PROVIDE_LABEL_FOR_OR_HINT = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`";
    @NotNull
    private static final String KEY_HINT = "hint";
    @NotNull
    private static final String KEY_LABEL = "label";

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"labelFor");
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"EditText", "AutoCompleteTextView", "MultiAutoCompleteTextView"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Set<String> set = this.labels;
        Set<String> labels = set == null ? SetsKt.emptySet() : set;
        List<Element> list2 = this.editableTextFields;
        List<Element> editableTextFields = list2 == null ? CollectionsKt.emptyList() : list2;
        this.labels = null;
        this.editableTextFields = null;
        for (Element element : editableTextFields) {
            String id2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            boolean hintProvided = element.hasAttributeNS("http://schemas.android.com/apk/res/android", KEY_HINT);
            boolean labelForProvided = false;
            if (labels.contains(id2)) {
                labelForProvided = true;
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)id2, (String)"id");
                if (StringsKt.startsWith$default((String)id2, (String)"@+id/", (boolean)false, (int)2, null)) {
                    labelForProvided = labels.contains(Intrinsics.stringPlus((String)"@id/", (Object)Lint.stripIdPrefix(id2)));
                } else if (StringsKt.startsWith$default((String)id2, (String)"@id/", (boolean)false, (int)2, null)) {
                    labelForProvided = labels.contains(Intrinsics.stringPlus((String)"@+id/", (Object)Lint.stripIdPrefix(id2)));
                }
            }
            if (!(hintProvided && labelForProvided || !hintProvided && !labelForProvided || labelForProvided && context2.getProject().getMinSdk() < 17)) {
                return;
            }
            Location location = Context.getLocation$default(context2, element, null, 2, null);
            Incident incident = new Incident(ISSUE, element, location, "");
            context2.report(incident, this.map().put(KEY_HINT, hintProvided).put(KEY_LABEL, labelForProvided));
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Boolean bl2 = LintMap.getBoolean$default(map, KEY_HINT, null, 2, null);
        boolean hintProvided = bl2 == null ? false : bl2;
        Boolean bl3 = LintMap.getBoolean$default(map, KEY_LABEL, null, 2, null);
        boolean labelForProvided = bl3 == null ? false : bl3;
        String message2 = "";
        int minSdk = context2.getMainProject().getMinSdk();
        if (hintProvided && labelForProvided) {
            if (minSdk >= 17) {
                message2 = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`, but not both";
            }
        } else if (!hintProvided && !labelForProvided) {
            message2 = minSdk < 17 ? PROVIDE_HINT : PROVIDE_LABEL_FOR_OR_HINT;
        } else if (labelForProvided && minSdk < 17) {
            message2 = PROVIDE_HINT;
        }
        CharSequence charSequence = message2;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            return false;
        }
        incident.setMessage(LabelForDetector.Companion.messageWithPrefix(message2));
        return true;
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        block8: {
            Element element;
            block9: {
                Attr contentDescriptionNode;
                boolean bl2;
                block7: {
                    Set set;
                    Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
                    boolean bl3 = Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"labelFor");
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (_Assertions.ENABLED && !bl3) {
                        boolean bl6 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    element = attribute.getOwnerElement();
                    Object object = this.labels;
                    if (object == null) {
                        boolean bl7 = false;
                        Set set2 = new LinkedHashSet();
                        boolean bl8 = false;
                        bl2 = false;
                        Set it2 = set2;
                        boolean bl9 = false;
                        this.labels = it2;
                        set = set2;
                    } else {
                        set = object;
                    }
                    Set labels = set;
                    object = attribute.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"attribute.value");
                    labels.add((String)object);
                    if (!Intrinsics.areEqual((Object)element.getLocalName(), (Object)"TextView")) {
                        return;
                    }
                    Attr textAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "text");
                    contentDescriptionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
                    if (textAttributeNode == null) break block7;
                    CharSequence charSequence = textAttributeNode.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"textAttributeNode.value");
                    charSequence = charSequence;
                    bl2 = false;
                    if (!(charSequence.length() == 0)) break block8;
                }
                if (contentDescriptionNode == null) break block9;
                CharSequence charSequence = contentDescriptionNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"contentDescriptionNode.value");
                charSequence = charSequence;
                bl2 = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            LintFix[] lintFixArray = new LintFix[]{LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "text", null, null, 12, null).build(), LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "contentDescription", null, null, 12, null).build()};
            LintFix fix = this.fix().alternatives(lintFixArray);
            Node node = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"element");
            context2.report(ISSUE, node, context2.getElementLocation(element, null, "http://schemas.android.com/apk/res/android", "labelFor"), LabelForDetector.Companion.messageWithPrefix("when using `android:labelFor`, you must also define an `android:text` or an `android:contentDescription`"), fix);
        }
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        List list2;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", KEY_HINT)) {
            Attr hintAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", KEY_HINT);
            object = hintAttributeNode.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"hintAttributeNode.value");
            object = (CharSequence)object;
            bl2 = false;
            if (object.length() == 0) {
                Node node = hintAttributeNode;
                Intrinsics.checkExpressionValueIsNotNull((Object)hintAttributeNode, (String)"hintAttributeNode");
                XmlContext.report$default(context2, ISSUE, node, context2.getLocation(hintAttributeNode), "Empty `android:hint` attribute", null, 16, null);
            }
        }
        if ((object = this.editableTextFields) == null) {
            bl2 = false;
            List list3 = new ArrayList();
            boolean bl3 = false;
            boolean bl4 = false;
            List it2 = list3;
            boolean bl5 = false;
            this.editableTextFields = it2;
            list2 = list3;
        } else {
            list2 = object;
        }
        List fields = list2;
        fields.add((Element)element);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/LabelForDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_HINT", "", "KEY_LABEL", "PREFIX", "PROVIDE_HINT", "PROVIDE_LABEL_FOR_OR_HINT", "messageWithPrefix", "message", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final String messageWithPrefix(String message2) {
            return Intrinsics.stringPlus((String)"Missing accessibility label: ", (Object)message2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

