/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J \u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001eH\u0016\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/LogDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "areLiteralsEqual", "", "first", "Lorg/jetbrains/uast/UExpression;", "second", "checkTagConsistent", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "logCall", "Lorg/jetbrains/uast/UCallExpression;", "isLoggableCall", "checkWithinConditional", "start", "Lorg/jetbrains/uast/UElement;", "getApplicableMethodNames", "", "", "getLastInQualifiedChain", "node", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "getTagForMethod", "method", "performsWork", "argument", "visitMethodCall", "Lcom/intellij/psi/PsiMethod;", "Issues", "android.sdktools.lint-checks"})
public final class LogDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(LogDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CONDITIONAL;
    @JvmField
    @NotNull
    public static final Issue WRONG_TAG;
    @JvmField
    @NotNull
    public static final Issue LONG_TAG;
    @NotNull
    private static final String IS_LOGGABLE = "isLoggable";
    @NotNull
    private static final String PRINTLN = "println";
    @NotNull
    public static final String LOG_CLS = "android.util.Log";

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"d", "e", "i", "v", "w", PRINTLN, IS_LOGGABLE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        String string;
        boolean withinConditional;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, LOG_CLS)) {
            return;
        }
        String string2 = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"method.name");
        String name = string2;
        boolean bl2 = withinConditional = Intrinsics.areEqual((Object)IS_LOGGABLE, (Object)name) || this.checkWithinConditional(context2, node.getUastParent(), node);
        if ((Intrinsics.areEqual((Object)"i", (Object)name) || Intrinsics.areEqual((Object)"d", (Object)name) || Intrinsics.areEqual((Object)"v", (Object)name) || Intrinsics.areEqual((Object)PRINTLN, (Object)name)) && !withinConditional && this.performsWork(node) && context2.isEnabled(CONDITIONAL)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "The log call Log.%1$s(...) should be conditional: surround with `if (Log.isLoggable(...))` or `if (BuildConfig.DEBUG) { ... }`";
            Object[] objectArray = new Object[]{node.getMethodName()};
            boolean bl3 = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            String message2 = string3;
            Location location = context2.getLocation((UElement)node);
            JavaContext.report$default(context2, CONDITIONAL, (UElement)node, location, message2, null, 16, null);
        }
        if (context2.isEnabled(LONG_TAG)) {
            UExpression argument;
            String tag;
            int tagArgumentIndex = Intrinsics.areEqual((Object)PRINTLN, (Object)name) ? 1 : 0;
            string = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.parameterList");
            String parameterList = string;
            List argumentList = node.getValueArguments();
            if (evaluator.parameterHasType(method, tagArgumentIndex, "java.lang.String") && parameterList.getParametersCount() == argumentList.size() && (tag = ConstantEvaluator.evaluateString(context2, (UElement)(argument = (UExpression)argumentList.get(tagArgumentIndex)), true)) != null && tag.length() > 23 && context2.getProject().getMinSdk() <= 23) {
                String message3 = "The logging tag can be at most 23 characters, was " + tag.length() + " (" + tag + ')';
                Incident incident = new Incident(LONG_TAG, message3, context2.getLocation((UElement)argument), node, null, 16, null);
                context2.report(incident, Constraints.minSdkLessThan(23));
            }
        }
    }

    private final String getTagForMethod(String method) {
        String string;
        switch (method) {
            case "d": {
                string = "DEBUG";
                break;
            }
            case "e": {
                string = "ERROR";
                break;
            }
            case "i": {
                string = "INFO";
                break;
            }
            case "v": {
                string = "VERBOSE";
                break;
            }
            case "w": {
                string = "WARN";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private final boolean performsWork(UCallExpression node) {
        String string = node.getMethodName();
        if (string == null) {
            return false;
        }
        String referenceName = string;
        int messageArgumentIndex = Intrinsics.areEqual((Object)PRINTLN, (Object)referenceName) ? 2 : 1;
        List arguments = node.getValueArguments();
        if (arguments.size() > messageArgumentIndex) {
            UExpression argument = (UExpression)arguments.get(messageArgumentIndex);
            return this.performsWork(argument);
        }
        return false;
    }

    private final boolean performsWork(UExpression argument) {
        if (argument instanceof ULiteralExpression) {
            return false;
        }
        if (argument instanceof UPolyadicExpression) {
            String string = UastUtils.evaluateString((UExpression)argument);
            if (string != null) {
                return false;
            }
        } else if (argument instanceof UBinaryExpression) {
            String string = UastUtils.evaluateString((UExpression)argument);
            if (string != null) {
                return false;
            }
        } else {
            if (argument instanceof USimpleNameReferenceExpression) {
                return false;
            }
            if (argument instanceof UParenthesizedExpression) {
                return this.performsWork(((UParenthesizedExpression)argument).getExpression());
            }
            if (argument instanceof UQualifiedReferenceExpression) {
                String string = UastUtils.evaluateString((UExpression)argument);
                if (string != null) {
                    return false;
                }
                PsiElement resolved = ((UQualifiedReferenceExpression)argument).resolve();
                if (resolved instanceof PsiVariable) {
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean checkWithinConditional(JavaContext context2, UElement start, UCallExpression logCall) {
        for (UElement curr = start; curr != null; curr = curr.getUastParent()) {
            if (curr instanceof UIfExpression) {
                Object value;
                UExpression condition = ((UIfExpression)curr).getCondition();
                if (condition instanceof UQualifiedReferenceExpression) {
                    condition = this.getLastInQualifiedChain((UQualifiedReferenceExpression)condition);
                }
                if (condition instanceof UCallExpression && Intrinsics.areEqual((Object)IS_LOGGABLE, (Object)((UCallExpression)condition).getMethodName())) {
                    this.checkTagConsistent(context2, logCall, (UCallExpression)condition);
                }
                return !(condition instanceof ULiteralExpression) || !Intrinsics.areEqual((Object)(value = ((ULiteralExpression)condition).getValue()), (Object)true);
            }
            if (curr instanceof UCallExpression || curr instanceof UMethod || curr instanceof UClassInitializer || curr instanceof UField || curr instanceof UClass) break;
        }
        return false;
    }

    private final void checkTagConsistent(JavaContext context2, UCallExpression logCall, UCallExpression isLoggableCall) {
        Object[] isLoggableDescription;
        Object location;
        List isLoggableArguments = isLoggableCall.getValueArguments();
        List logArguments = logCall.getValueArguments();
        if (isLoggableArguments.isEmpty() || logArguments.isEmpty()) {
            return;
        }
        UExpression isLoggableTag = (UExpression)isLoggableArguments.get(0);
        UExpression logTag = (UExpression)logArguments.get(0);
        String string = logCall.getMethodName();
        if (string == null) {
            return;
        }
        String logCallName = string;
        boolean isPrintln = Intrinsics.areEqual((Object)PRINTLN, (Object)logCallName);
        if (isPrintln && logArguments.size() > 1) {
            logTag = (UExpression)logArguments.get(1);
        }
        if (logTag != null && !this.areLiteralsEqual(isLoggableTag, logTag) && !UastLintUtils.Companion.areIdentifiersEqual(isLoggableTag, logTag)) {
            PsiNamedElement resolved1 = UastUtils.tryResolveNamed((UElement)((UElement)isLoggableTag));
            PsiNamedElement resolved2 = UastUtils.tryResolveNamed((UElement)((UElement)logTag));
            if ((resolved1 == null || resolved2 == null || !Intrinsics.areEqual((Object)resolved1, (Object)resolved2)) && context2.isEnabled(WRONG_TAG)) {
                location = context2.getLocation((UElement)logTag);
                Location alternate = context2.getLocation((UElement)isLoggableTag);
                alternate.setMessage("Conflicting tag");
                ((Location)location).setSecondary(alternate);
                isLoggableDescription = resolved1 != null ? resolved1.getName() : isLoggableTag.asRenderString();
                String logCallDescription22 = resolved2 != null ? resolved2.getName() : logTag.asRenderString();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "Mismatched tags: the `%1$s()` and `isLoggable()` calls typically should pass the same tag: `%2$s` versus `%3$s`";
                Object[] objectArray = new Object[]{logCallName, isLoggableDescription, logCallDescription22};
                boolean bl2 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                String message22 = string3;
                JavaContext.report$default(context2, WRONG_TAG, (UElement)isLoggableCall, (Location)location, message22, null, 16, null);
            }
        }
        if (logCallName.length() != 1 || isLoggableArguments.size() < 2) {
            return;
        }
        UExpression isLoggableLevel = (UExpression)isLoggableArguments.get(1);
        location = UastUtils.tryResolveNamed((UElement)((UElement)isLoggableLevel));
        if (location == null) {
            return;
        }
        Object resolved = location;
        if (resolved instanceof PsiVariable) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)resolved), PsiClass.class);
            if (containingClass == null || !Intrinsics.areEqual((Object)LOG_CLS, (Object)containingClass.getQualifiedName()) || resolved.getName() == null || Intrinsics.areEqual((Object)resolved.getName(), (Object)this.getTagForMethod(logCallName))) {
                return;
            }
            String string4 = resolved.getName();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            isLoggableDescription = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)isLoggableDescription, (String)"resolved.getName()!!");
            int logCallDescription22 = 0;
            int message22 = 1;
            boolean bl3 = false;
            String string5 = isLoggableDescription.substring(logCallDescription22, message22);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            isLoggableDescription = string5;
            Locale logCallDescription22 = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)logCallDescription22, (String)"getDefault()");
            message22 = 0;
            Object[] objectArray = isLoggableDescription;
            boolean bl4 = false;
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = objectArray.toLowerCase(logCallDescription22);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            String expectedCall = string6;
            logCallDescription22 = StringCompanionObject.INSTANCE;
            String message22 = "Mismatched logging levels: when checking `isLoggable` level `%1$s`, the corresponding log call should be `Log.%2$s`, not `Log.%3$s`";
            objectArray = new Object[]{resolved.getName(), expectedCall, logCallName};
            bl4 = false;
            String string7 = String.format(message22, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
            String message3 = string7;
            Location location2 = context2.getCallLocation(logCall, false, false);
            Location alternate = context2.getLocation((UElement)isLoggableLevel);
            alternate.setMessage("Conflicting tag");
            location2.setSecondary(alternate);
            JavaContext.report$default(context2, WRONG_TAG, (UElement)isLoggableCall, location2, message3, null, 16, null);
        }
    }

    private final UExpression getLastInQualifiedChain(UQualifiedReferenceExpression node) {
        UExpression last = node.getSelector();
        while (last instanceof UQualifiedReferenceExpression) {
            last = ((UQualifiedReferenceExpression)last).getSelector();
        }
        return last;
    }

    private final boolean areLiteralsEqual(UExpression first, UExpression second) {
        if (!(first instanceof ULiteralExpression)) {
            return false;
        }
        if (!(second instanceof ULiteralExpression)) {
            return false;
        }
        Object firstValue = ((ULiteralExpression)first).getValue();
        Object secondValue = ((ULiteralExpression)second).getValue();
        if (firstValue == null) {
            return secondValue == null;
        }
        return Intrinsics.areEqual((Object)firstValue, (Object)secondValue);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        CONDITIONAL = Issue.Companion.create$default(companion, "LogConditional", "Unconditional Logging Calls", "\n            The `BuildConfig` class provides a constant, `DEBUG`, which indicates \\\n            whether the code is being built in release mode or in debug mode. In release mode, you typically \\\n            want to strip out all the logging calls. Since the compiler will automatically remove all code \\\n            which is inside a `if (false)` check, surrounding your logging calls with a check for \\\n            `BuildConfig.DEBUG` is a good idea.\n\n            If you **really** intend for the logging to be present in release mode, you can suppress this \\\n            warning with a `@SuppressLint` annotation for the intentional logging calls.", implementation, null, category, 5, severity, false, true, null, null, 3344, null).setEnabledByDefault(false);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        WRONG_TAG = Issue.Companion.create$default(companion, "LogTagMismatch", "Mismatched Log Tags", "\n            When guarding a `Log.v(tag, ...)` call with `Log.isLoggable(tag)`, the tag passed to both calls \\\n            should be the same. Similarly, the level passed in to `Log.isLoggable` should typically match \\\n            the type of `Log` call, e.g. if checking level `Log.DEBUG`, the corresponding `Log` call should \\\n            be `Log.d`, not `Log.i`.", implementation, null, category, 5, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        LONG_TAG = Issue.Companion.create$default(companion, "LongLogTag", "Too Long Log Tags", "\n            Log tags are only allowed to be at most 23 tag characters long.", implementation, null, category, 5, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/LogDetector$Issues;", "", "()V", "CONDITIONAL", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "IS_LOGGABLE", "", "LOG_CLS", "LONG_TAG", "PRINTLN", "WRONG_TAG", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

