/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J0\u0010'\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J>\u00100\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0002J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "activities", "", "", "checkedUniquePermissions", "", "seenApplication", "seenUsesSdk", "", "usesFeatures", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "beforeCheckFile", "checkApplication", "application", "Lorg/w3c/dom/Element;", "checkDeviceAdmin", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "checkDocumentElement", "checkMergedProject", "checkMipmapIcon", "checkOverride", "attributeName", "ensureUniquePermission", "getApplicableElements", "", "hasGcmReceiver", "hasWearableGmsDependency", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "isDebugOrTestManifest", "manifestFile", "Ljava/io/File;", "lookForNonUniqueNames", "mainProject", "Lcom/android/tools/lint/detector/api/Project;", "mergedManifest", "Lorg/w3c/dom/Document;", "humanReadableName", "tagName", "manifestMergerSkips", "onlyCheckSourceManifest", "reportFromManifest", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "node", "Lorg/w3c/dom/Node;", "message", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "visitElement", "Companion", "android.sdktools.lint-checks"})
public final class ManifestDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean seenApplication;
    private int seenUsesSdk;
    @Nullable
    private Set<String> activities;
    @Nullable
    private Set<String> usesFeatures;
    private boolean checkedUniquePermissions;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ManifestDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ORDER = Issue.Companion.create("ManifestOrder", "Incorrect order of elements in manifest", "\n                The `<application>` tag should appear after the elements which declare which version you need, \\\n                which features you need, which libraries you need, and so on. In the past there have been subtle \\\n                bugs (such as themes not getting applied correctly) when the `<application>` tag appears before \\\n                some of these other elements, so it's best to order your manifest in the logical dependency \\\n                order.\n                ", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue USES_SDK;
    @JvmField
    @NotNull
    public static final Issue TARGET_NEWER;
    @JvmField
    @NotNull
    public static final Issue MULTIPLE_USES_SDK;
    @JvmField
    @NotNull
    public static final Issue WRONG_PARENT;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_ACTIVITY;
    @NotNull
    private static final String BACKUP_DOCUMENTATION_URL = "https://developer.android.com/guide/topics/data/autobackup";
    @JvmField
    @NotNull
    public static final Issue ALLOW_BACKUP;
    @JvmField
    @NotNull
    public static final Issue UNIQUE_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue SET_VERSION;
    @JvmField
    @NotNull
    public static final Issue ILLEGAL_REFERENCE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_USES_FEATURE;
    @JvmField
    @NotNull
    public static final Issue APPLICATION_ICON;
    @JvmField
    @NotNull
    public static final Issue DEVICE_ADMIN;
    @JvmField
    @NotNull
    public static final Issue MOCK_LOCATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_OVERRIDES;
    @JvmField
    @NotNull
    public static final Issue MIPMAP;
    @JvmField
    @NotNull
    public static final Issue WEARABLE_BIND_LISTENER;
    @JvmField
    @NotNull
    public static final Issue APP_INDEXING_SERVICE;
    @NotNull
    public static final String MOCK_LOCATION_PERMISSION = "android.permission.ACCESS_MOCK_LOCATION";
    @NotNull
    public static final String MISSING_FULL_BACKUP_CONTENT_RESOURCE = "Missing `<full-backup-content>` resource";
    private static final GradleCoordinate MIN_WEARABLE_GMS_VERSION;
    @NotNull
    private static final String PLAY_SERVICES_WEARABLE = "com.google.android.gms:play-services-wearable";

    @Override
    public void beforeCheckFile(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.seenApplication = false;
        this.seenUsesSdk = 0;
        this.activities = null;
        this.usesFeatures = null;
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Element element;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        XmlContext xmlContext = (XmlContext)context2;
        Element element2 = element = xmlContext.document.getDocumentElement();
        if (element2 != null) {
            Element element3 = element2;
            boolean bl2 = false;
            boolean bl3 = false;
            Element it2 = element3;
            boolean bl4 = false;
            this.checkDocumentElement(xmlContext, it2);
        }
        if (this.seenUsesSdk == 0 && context2.isEnabled(USES_SDK) && !context2.getProject().isGradleProject()) {
            XmlContext.report$default(xmlContext, USES_SDK, element, Location.Companion.create(context2.file), "Manifest should specify a minimum API level with `<uses-sdk android:minSdkVersion=\"?\" />`; if it really supports all versions of Android set it to 1", null, 16, null);
        }
    }

    private final boolean onlyCheckSourceManifest(Context context2) {
        return context2.getDriver().isIsolated();
    }

    private final void checkApplication(Context context2) {
        if (this.onlyCheckSourceManifest(context2)) {
            return;
        }
        Project mainProject = context2.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
        if (application == null || application.getFirstChild() == null && application.getAttributes().getLength() == 0) {
            return;
        }
        this.checkApplication(context2, application);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkApplication(Context context, Element application) {
        block14: {
            block15: {
                if (context.getProject().isLibrary()) {
                    return;
                }
                if (!context.isEnabled(ManifestDetector.ALLOW_BACKUP)) break block14;
                allowBackup = application.getAttributeNS("http://schemas.android.com/apk/res/android", "allowBackup");
                fullBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
                client = context.getClient();
                if (fullBackupNode == null) ** GOTO lbl-1000
                var6_6 = fullBackupNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)var6_6, (String)"fullBackupNode.value");
                if (StringsKt.startsWith$default((String)var6_6, (String)"@", (boolean)false, (int)2, null)) {
                    full = context.isGlobalAnalysis();
                    project = full != false ? context.getMainProject() : context.getProject();
                    resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                    url = ResourceUrl.parse((String)fullBackupNode.getValue());
                    if (url != null && !url.isFramework() && !resources.hasResources(ResourceNamespace.TODO(), url.type, url.name)) {
                        sourceFullBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
                        if (sourceFullBackupNode != null) {
                            fullBackupNode = sourceFullBackupNode;
                        }
                        ManifestDetector.reportFromManifest$default(this, context, ManifestDetector.ALLOW_BACKUP, fullBackupNode, "Missing `<full-backup-content>` resource", LocationType.VALUE, null, 32, null);
                    }
                } else if (fullBackupNode == null && !Intrinsics.areEqual((Object)"false", (Object)allowBackup) && !application.hasAttributeNS("http://schemas.android.com/apk/res/android", "fullBackupOnly") && context.getMainProject().getTargetSdk() >= 23) {
                    scope = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "allowBackup");
                    if (scope == null) {
                        scope = application;
                    }
                    if (this.hasGcmReceiver(application)) {
                        ManifestDetector.reportFromManifest$default(this, context, ManifestDetector.ALLOW_BACKUP, scope, "On SDK version 23 and up, your app data will be automatically backed up, and restored on app install. Your GCM regid will not work across restores, so you must ensure that it is excluded from the back-up set. Use the attribute `android:fullBackupContent` to specify an `@xml` resource which configures which files to backup. More info: https://developer.android.com/guide/topics/data/autobackup", LocationType.NAME, null, 32, null);
                    } else {
                        ManifestDetector.reportFromManifest$default(this, context, ManifestDetector.ALLOW_BACKUP, scope, "On SDK version 23 and up, your app data will be automatically backed up and restored on app install. Consider adding the attribute `android:fullBackupContent` to specify an `@xml` resource which configures which files to backup, or just set `android:fullBackupOnly=true`. More info: https://developer.android.com/guide/topics/data/autobackup", LocationType.NAME, null, 32, null);
                    }
                }
                if (allowBackup == null) break block15;
                var6_8 = allowBackup;
                var7_10 = false;
                if (!(var6_8.length() == 0)) break block14;
            }
            ManifestDetector.reportFromManifest$default(this, context, ManifestDetector.ALLOW_BACKUP, application, "Should explicitly set `android:allowBackup` to `true` or `false` (it's `true` by default, and that can have some security implications for the application's data)", LocationType.NAME, null, 32, null);
        }
        if (!application.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon") && context.isEnabled(ManifestDetector.APPLICATION_ICON)) {
            fix = this.fix().set("http://schemas.android.com/apk/res/android", "icon", "@mipmap/").caretEnd().build();
            this.reportFromManifest(context, ManifestDetector.APPLICATION_ICON, application, "Should explicitly set `android:icon`, there is no default", LocationType.NAME, fix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDocumentElement(XmlContext context, Element element) {
        codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionCode");
        if (codeNode == null) ** GOTO lbl-1000
        var4_4 = codeNode.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)var4_4, (String)"codeNode.value");
        if (StringsKt.startsWith$default((String)var4_4, (String)"@", (boolean)false, (int)2, null) && context.isEnabled(ManifestDetector.ILLEGAL_REFERENCE)) {
            XmlContext.report$default(context, ManifestDetector.ILLEGAL_REFERENCE, element, context.getLocation(codeNode), "The `android:versionCode` cannot be a resource url, it must be a literal integer", null, 16, null);
        } else if (codeNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "versionCode", null, null, 12, null).build();
            context.report(ManifestDetector.SET_VERSION, element, context.getNameLocation(element), "Should set `android:versionCode` to specify the application version", fix);
        }
        nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionName");
        if (nameNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "versionName", null, null, 12, null).build();
            context.report(ManifestDetector.SET_VERSION, element, context.getNameLocation(element), "Should set `android:versionName` to specify the application version", fix);
        }
        if ((pkgNode = element.getAttributeNode("package")) != null) {
            pkg = pkgNode.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)pkg, (String)"pkg");
            if (StringsKt.contains$default((CharSequence)pkg, (CharSequence)"${", (boolean)false, (int)2, null) && context.getProject().isGradleProject()) {
                XmlContext.report$default(context, ManifestDetector.GRADLE_OVERRIDES, pkgNode, context.getLocation(pkgNode), "Cannot use placeholder for the package in the manifest; set `applicationId` in `build.gradle` instead", null, 16, null);
            }
        }
    }

    private final void reportFromManifest(Context context2, Issue issue, Node node, String message2, LocationType type, LintFix fix) {
        Location location = context2.getLocation(node, type);
        if (location.getStart() == null) {
            return;
        }
        Incident incident = new Incident(issue, message2, location, fix);
        context2.report(incident);
    }

    static /* synthetic */ void reportFromManifest$default(ManifestDetector manifestDetector, Context context2, Issue issue, Node node, String string, LocationType locationType, LintFix lintFix, int n10, Object object) {
        if ((n10 & 0x20) != 0) {
            lintFix = null;
        }
        manifestDetector.reportFromManifest(context2, issue, node, string, locationType, lintFix);
    }

    private final void checkOverride(XmlContext context2, Element element, String attributeName) {
        LintModelVariant variant;
        Project project = context2.getProject();
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (attribute != null && context2.isEnabled(GRADLE_OVERRIDES) && (variant = project.getBuildVariant()) != null) {
            String string;
            AndroidVersion androidVersion;
            if (Intrinsics.areEqual((Object)"minSdkVersion", (Object)attributeName)) {
                if (element.hasAttributeNS("http://schemas.android.com/tools", "overrideLibrary")) {
                    return;
                }
                AndroidVersion minSdkVersion = variant.getMinSdkVersion();
                androidVersion = minSdkVersion;
                string = androidVersion == null ? null : androidVersion.getApiString();
            } else if (Intrinsics.areEqual((Object)"targetSdkVersion", (Object)attributeName)) {
                AndroidVersion targetSdkVersion = variant.getTargetSdkVersion();
                androidVersion = targetSdkVersion;
                string = androidVersion == null ? null : androidVersion.getApiString();
            } else {
                boolean targetSdkVersion = false;
                boolean bl2 = false;
                if (_Assertions.ENABLED) {
                    boolean bl3 = false;
                    String string2 = attributeName;
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                return;
            }
            String gradleValue = string;
            if (gradleValue != null) {
                String manifestValue = attribute.getValue();
                String message2 = "This `" + attributeName + "` value (`" + manifestValue + "`) is not used; it is always overridden by the value specified in the Gradle build script (`" + gradleValue + "`)";
                XmlContext.report$default(context2, GRADLE_OVERRIDES, attribute, context2.getLocation(attribute), message2, null, 16, null);
            }
        }
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture", "uses-library", "activity", "service", "provider", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Attr name;
        Attr nameNode;
        int highest2;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String tag = element.getTagName();
        Node parentNode = element.getParentNode();
        boolean isReceiver = Intrinsics.areEqual((Object)tag, (Object)"receiver");
        if (isReceiver) {
            this.checkDeviceAdmin(context2, element);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-library") || Intrinsics.areEqual((Object)tag, (Object)"activity") || Intrinsics.areEqual((Object)tag, (Object)"service") || isReceiver) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the <application> element", null, 16, null);
            }
            if (Intrinsics.areEqual((Object)tag, (Object)"activity")) {
                Attr nameNode2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameNode2 != null) {
                    String name2 = nameNode2.getValue();
                    CharSequence charSequence = name2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"name");
                    charSequence = charSequence;
                    boolean bl2 = false;
                    if (charSequence.length() > 0) {
                        Set set;
                        String pkg = context2.getProject().getPackage();
                        if (name2.charAt(0) == '.') {
                            name2 = Intrinsics.stringPlus((String)pkg, (Object)name2);
                        } else {
                            String string = name2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                            if (StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                                name2 = pkg + '.' + name2;
                            }
                        }
                        Object object = this.activities;
                        if (object == null) {
                            boolean bl3 = false;
                            Set set2 = new LinkedHashSet();
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Set it2 = set2;
                            boolean bl6 = false;
                            this.activities = it2;
                            set = set2;
                        } else {
                            set = object;
                        }
                        Set activities = set;
                        object = name2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"name");
                        if (!activities.add((String)object)) {
                            String message2 = "Duplicate registration for activity `" + name2 + '`';
                            XmlContext.report$default(context2, DUPLICATE_ACTIVITY, element, context2.getLocation(nameNode2), message2, null, 16, null);
                        }
                    }
                }
                this.checkMipmapIcon(context2, element);
            } else if (Intrinsics.areEqual((Object)tag, (Object)"service") && context2.getProject().isGradleProject()) {
                if (context2.getProject().getTargetSdk() >= 26) {
                    block2: for (Object child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                        for (Object innerChild : XmlUtils.getSubTagsByName((Node)((Node)child), (String)"action")) {
                            Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                            if (attr == null || !Intrinsics.areEqual((Object)"com.google.firebase.appindexing.UPDATE_INDEX", (Object)attr.getValue())) continue;
                            String message3 = "`UPDATE_INDEX` is configured as a service in your app, which is no longer supported for the API level you're targeting. Use a `BroadcastReceiver` instead.";
                            Incident incident = new Incident(APP_INDEXING_SERVICE, attr, context2.getLocation(attr), message3);
                            context2.report(incident, Constraints.targetSdkAtLeast(26));
                            continue block2;
                        }
                    }
                }
                Attr bindListenerAttr = null;
                block4: for (Element child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                    for (Element innerChild : XmlUtils.getSubTagsByName((Node)child, (String)"action")) {
                        Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (attr == null || !Intrinsics.areEqual((Object)"com.google.android.gms.wearable.BIND_LISTENER", (Object)attr.getValue())) continue;
                        bindListenerAttr = attr;
                        continue block4;
                    }
                }
                if (bindListenerAttr == null) {
                    return;
                }
                LintModelVariant variant = context2.getProject().getBuildVariant();
                if (variant != null && this.hasWearableGmsDependency(variant)) {
                    XmlContext.report$default(context2, WEARABLE_BIND_LISTENER, bindListenerAttr, context2.getLocation(bindListenerAttr), "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated", null, 16, null);
                    return;
                }
                File sdkHome = context2.getClient().getSdkHome();
                if (context2.getProject().getBuildSdk() >= 24 && sdkHome != null) {
                    GradleCoordinate max;
                    Path repository2 = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome.toPath(), true);
                    String message4 = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest version of play-services-wearable 8.2.0 or later";
                    if (repository2 != null && (max = MavenRepositories.getHighestInstalledVersion((String)"com.google.android.gms", (String)"play-services-wearable", (Path)repository2, null, (boolean)false)) != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(max, MIN_WEARABLE_GMS_VERSION) > 0) {
                        message4 = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest available version of play-services-wearable: `" + max.getRevision() + '`';
                    }
                    Location location = context2.getLocation(bindListenerAttr);
                    XmlContext.report$default(context2, WEARABLE_BIND_LISTENER, bindListenerAttr, location, message4, null, 16, null);
                }
            }
            return;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"provider")) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && !Intrinsics.areEqual((Object)"queries", (Object)parentNode.getNodeName()) && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the `<application>` element or the `<queries>` element", null, 16, null);
            }
            return;
        }
        if (parentNode != element.getOwnerDocument().getDocumentElement()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
            if (StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null) == -1 && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the `<manifest>` root element", null, 16, null);
            }
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-sdk")) {
            ManifestDetector bindListenerAttr = this;
            int variant = bindListenerAttr.seenUsesSdk;
            bindListenerAttr.seenUsesSdk = variant + 1;
            if (this.seenUsesSdk == 2) {
                Location location = context2.getNameLocation(element);
                NodeList elements = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location secondary = null;
                int repository2 = elements.getLength() - 1;
                if (0 <= repository2) {
                    do {
                        int i10;
                        Node incident;
                        if ((incident = elements.item(i10 = repository2--)) == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                        }
                        Element e10 = (Element)incident;
                        if (e10 == element) continue;
                        Location l10 = context2.getNameLocation(e10);
                        l10.setSecondary(secondary);
                        l10.setMessage("Also appears here");
                        secondary = l10;
                    } while (0 <= repository2);
                }
                location.setSecondary(secondary);
                if (context2.isEnabled(MULTIPLE_USES_SDK)) {
                    XmlContext.report$default(context2, MULTIPLE_USES_SDK, element, location, "There should only be a single `<uses-sdk>` element in the manifest: merge these together", null, 16, null);
                }
                return;
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                if (context2.isEnabled(USES_SDK) && !context2.getProject().isGradleProject()) {
                    XmlContext.report$default(context2, USES_SDK, element, context2.getNameLocation(element), "`<uses-sdk>` tag should specify a minimum API level with `android:minSdkVersion=\"?\"`", null, 16, null);
                }
            } else {
                Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                if (codeNode != null) {
                    String elements = codeNode.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"codeNode.value");
                    if (StringsKt.startsWith$default((String)elements, (String)"@", (boolean)false, (int)2, null) && context2.isEnabled(ILLEGAL_REFERENCE)) {
                        XmlContext.report$default(context2, ILLEGAL_REFERENCE, element, context2.getLocation(codeNode), "The `android:minSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, 16, null);
                    }
                }
                this.checkOverride(context2, element, "minSdkVersion");
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                if (context2.isEnabled(USES_SDK) && !context2.getProject().isGradleProject()) {
                    XmlContext.report$default(context2, USES_SDK, element, context2.getNameLocation(element), "`<uses-sdk>` tag should specify a target API level (the highest verified version; when running on later versions, compatibility behaviors may be enabled) with `android:targetSdkVersion=\"?\"`", null, 16, null);
                }
            } else {
                Attr targetSdkVersionNode;
                this.checkOverride(context2, element, "targetSdkVersion");
                if (context2.isEnabled(TARGET_NEWER) && (targetSdkVersionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                    String target2 = targetSdkVersionNode.getValue();
                    try {
                        Intrinsics.checkExpressionValueIsNotNull((Object)target2, (String)"target");
                        String repository2 = target2;
                        boolean i10 = false;
                        int api = Integer.parseInt(repository2);
                        highest2 = context2.getClient().getHighestKnownApiLevel();
                        if (api < highest2) {
                            LintFix fix = this.fix().name(Intrinsics.stringPlus((String)"Update targetSdkVersion to ", (Object)highest2)).replace().pattern("targetSdkVersion\\s*=\\s*[\"'](.*)[\"']").with(String.valueOf(highest2)).build();
                            Location location = context2.getLocation(targetSdkVersionNode);
                            context2.report(TARGET_NEWER, element, location, "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the `android.os.Build.VERSION_CODES` javadoc for details.", fix);
                        }
                    }
                    catch (NumberFormatException api) {
                        // empty catch block
                    }
                }
            }
            if ((nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                String target2 = nameNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)target2, (String)"nameNode.value");
                if (StringsKt.startsWith$default((String)target2, (String)"@", (boolean)false, (int)2, null) && context2.isEnabled(ILLEGAL_REFERENCE)) {
                    XmlContext.report$default(context2, ILLEGAL_REFERENCE, element, context2.getLocation(nameNode), "The `android:targetSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, 16, null);
                }
            }
        }
        if ((Intrinsics.areEqual((Object)tag, (Object)"permission") || Intrinsics.areEqual((Object)tag, (Object)"permission-group")) && context2.isGlobalAnalysis()) {
            this.ensureUniquePermission(context2);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-permission") && (name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && Intrinsics.areEqual((Object)name.getValue(), (Object)MOCK_LOCATION_PERMISSION) && context2.getProject().getBuildModule() != null && !this.isDebugOrTestManifest(context2, context2.file) && context2.isEnabled(MOCK_LOCATION)) {
            String message5 = "Mock locations should only be requested in a test or debug-specific manifest file (typically `src/debug/AndroidManifest.xml`)";
            Location location = context2.getLocation(name);
            XmlContext.report$default(context2, MOCK_LOCATION, element, location, message5, null, 16, null);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"application")) {
            this.seenApplication = true;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon")) {
                this.checkMipmapIcon(context2, element);
            }
            if (this.onlyCheckSourceManifest(context2)) {
                this.checkApplication(context2, element);
            }
        } else if (this.seenApplication) {
            if (context2.isEnabled(ORDER)) {
                XmlContext.report$default(context2, ORDER, element, context2.getNameLocation(element), "`<" + tag + ">` tag appears after `<application>` tag", null, 16, null);
            }
            this.seenApplication = false;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-feature") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            String name3 = nameNode.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
            CharSequence location = name3;
            highest2 = 0;
            if (location.length() > 0) {
                Set usesFeatures;
                Set set;
                Set highest2 = this.usesFeatures;
                if (highest2 == null) {
                    boolean bl7 = false;
                    Set set3 = new LinkedHashSet();
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Set it3 = set3;
                    boolean bl10 = false;
                    this.usesFeatures = it3;
                    set = set3;
                } else {
                    set = usesFeatures = highest2;
                }
                if (!usesFeatures.add((String)name3)) {
                    String message6 = "Duplicate declaration of uses-feature `" + name3 + '`';
                    XmlContext.report$default(context2, DUPLICATE_USES_FEATURE, element, context2.getLocation(nameNode), message6, null, 16, null);
                }
            }
        }
    }

    private final void ensureUniquePermission(Context context2) {
        if (this.checkedUniquePermissions) {
            return;
        }
        this.checkedUniquePermissions = true;
        Project mainProject = context2.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        this.lookForNonUniqueNames(context2, mainProject, mergedManifest, "permission", "permission");
        this.lookForNonUniqueNames(context2, mainProject, mergedManifest, "permission group", "permission-group");
    }

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.ensureUniquePermission(context2);
        this.checkApplication(context2);
    }

    private final void lookForNonUniqueNames(Context context2, Project mainProject, Document mergedManifest, String humanReadableName, String tagName) {
        Map nameToFull = null;
        Object object = mergedManifest.getDocumentElement();
        if (object == null) {
            return;
        }
        Element root = object;
        object = DomExtensions.iterator((Element)root);
        while (object.hasNext()) {
            Map map;
            boolean bl2;
            Map map2;
            String base;
            String name;
            Attr attr;
            Element element = (Element)object.next();
            if (!Intrinsics.areEqual((Object)element.getTagName(), (Object)tagName) || this.manifestMergerSkips(element) || (attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null) continue;
            Attr nameNode = attr;
            String string = name = nameNode.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            int n10 = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n10), (String)"(this as java.lang.String).substring(startIndex)");
            String pkg = mainProject.getPackage();
            if (!mainProject.isLibrary() && pkg != null) {
                String string3 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"${applicationId}", (boolean)false, (int)2, null)) {
                    string3 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                    name = StringsKt.replace$default((String)string3, (String)"${applicationId}", (String)pkg, (boolean)false, (int)4, null);
                }
            }
            string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"${", (boolean)false, (int)2, null)) continue;
            if (nameToFull != null) {
                if (nameToFull.containsKey(base) && !Intrinsics.areEqual((Object)name, nameToFull.get(base))) {
                    Node node;
                    String prevName = (String)nameToFull.get(base);
                    Location location = context2.getLocation(nameNode, LocationType.ALL);
                    NodeList siblings = element.getParentNode().getChildNodes();
                    int i10 = 0;
                    int n11 = siblings.getLength();
                    while (i10 < n11 && (node = siblings.item(i10)) != element) {
                        if (node.getNodeType() == 1) {
                            if (node == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                            }
                            Element sibling = (Element)node;
                            if (Intrinsics.areEqual((Object)sibling.getTagName(), (Object)tagName) && Intrinsics.areEqual((Object)prevName, (Object)sibling.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) {
                                Attr no2 = sibling.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                                Location prevLocation = context2.getLocation(no2, LocationType.VALUE);
                                prevLocation.setMessage("Previous " + humanReadableName + " here");
                                location.setSecondary(prevLocation);
                                break;
                            }
                        }
                        int sibling = i10;
                        i10 = sibling + 1;
                    }
                    String message2 = StringHelper.usLocaleCapitalize((String)humanReadableName) + " name `" + base + "` is not unique (appears in both `" + prevName + "` and `" + name + "`)";
                    Incident incident = new Incident(UNIQUE_PERMISSION, element, location, message2);
                    context2.report(incident);
                }
                map2 = nameToFull;
            } else {
                bl3 = false;
                Map map3 = new LinkedHashMap();
                boolean bl4 = false;
                bl2 = false;
                Map it2 = map3;
                boolean bl5 = false;
                nameToFull = it2;
                map2 = map3;
            }
            Map map4 = map = map2;
            String string4 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
            bl2 = false;
            map4.put(base, string4);
        }
    }

    private final boolean manifestMergerSkips(Element element) {
        Attr operation = element.getAttributeNodeNS("http://schemas.android.com/tools", "node");
        if (operation != null) {
            String action = operation.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"action");
            if (StringsKt.startsWith$default((String)action, (String)"remove", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)action, (Object)"replace")) {
                return true;
            }
        }
        return false;
    }

    private final boolean hasWearableGmsDependency(LintModelVariant variant) {
        LintModelExternalLibrary lintModelExternalLibrary;
        LintModelLibrary lintModelLibrary = variant.getMainArtifact().findCompileDependency(PLAY_SERVICES_WEARABLE);
        LintModelExternalLibrary lintModelExternalLibrary2 = lintModelExternalLibrary = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
        if (lintModelExternalLibrary == null) {
            return false;
        }
        LintModelExternalLibrary library2 = lintModelExternalLibrary;
        LintModelMavenName mc2 = library2.getResolvedCoordinates();
        GradleCoordinate gc2 = GradleCoordinate.parseVersionOnly((String)mc2.getVersion());
        return GradleCoordinate.COMPARE_PLUS_HIGHER.compare(gc2, MIN_WEARABLE_GMS_VERSION) >= 0;
    }

    private final boolean hasGcmReceiver(Element application) {
        NodeList applicationChildren = application.getChildNodes();
        int i12 = 0;
        int n12 = applicationChildren.getLength();
        while (i12 < n12) {
            Node applicationChild = applicationChildren.item(i12);
            if (applicationChild.getNodeType() == 1 && Intrinsics.areEqual((Object)"receiver", (Object)applicationChild.getNodeName())) {
                NodeList receiverChildren = applicationChild.getChildNodes();
                int i22 = 0;
                int n22 = receiverChildren.getLength();
                while (i22 < n22) {
                    Node receiverChild = receiverChildren.item(i22);
                    if (receiverChild.getNodeType() == 1 && Intrinsics.areEqual((Object)"intent-filter", (Object)receiverChild.getNodeName())) {
                        NodeList filterChildren = receiverChild.getChildNodes();
                        int i32 = 0;
                        int n32 = filterChildren.getLength();
                        while (i32 < n32) {
                            Node filterChild = filterChildren.item(i32);
                            if (filterChild.getNodeType() == 1 && Intrinsics.areEqual((Object)"action", (Object)filterChild.getNodeName())) {
                                if (filterChild == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                                }
                                Element action = (Element)filterChild;
                                String name = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                                if (Intrinsics.areEqual((Object)"com.google.android.c2dm.intent.RECEIVE", (Object)name)) {
                                    return true;
                                }
                            }
                            int n10 = i32;
                            i32 = n10 + 1;
                        }
                    }
                    int n11 = i22;
                    i22 = n11 + 1;
                }
            }
            int n13 = i12;
            i12 = n13 + 1;
        }
        return false;
    }

    private final void checkMipmapIcon(XmlContext context2, Element element) {
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "icon");
        if (attr == null) {
            return;
        }
        Attr attribute = attr;
        String icon = attribute.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"icon");
        if (StringsKt.startsWith$default((String)icon, (String)"@drawable/", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)"activity", (Object)element.getTagName()) && !Companion.isLaunchableActivity(element)) {
                return;
            }
            if (context2.isEnabled(MIPMAP) && context2.getProject().getApplicableDensities() != null) {
                XmlContext.report$default(context2, MIPMAP, element, context2.getLocation(attribute), "Should use `@mipmap` instead of `@drawable` for launcher icons", null, 16, null);
            }
        }
    }

    private final boolean isDebugOrTestManifest(XmlContext context2, File manifestFile) {
        LintModelVariant variant = context2.getProject().getBuildVariant();
        if (variant != null) {
            for (LintModelSourceProvider provider : variant.getSourceProviders()) {
                if (!provider.isDebugOnly() && !provider.isTest() || !Intrinsics.areEqual((Object)manifestFile, (Object)provider.getManifestFile())) continue;
                return true;
            }
        }
        return false;
    }

    private final void checkDeviceAdmin(XmlContext context2, Element element) {
        boolean requiredIntentFilterFound = false;
        boolean deviceAdmin = false;
        Attr locationNode = null;
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr valueNode;
            String tagName = child.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"intent-filter") && !requiredIntentFilterFound) {
                boolean dataFound = false;
                boolean actionFound = false;
                for (Element filterChild : XmlUtils.getSubTags((Node)child)) {
                    String filterTag = filterChild.getTagName();
                    if (Intrinsics.areEqual((Object)filterTag, (Object)"action")) {
                        String name2 = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!Intrinsics.areEqual((Object)"android.app.action.DEVICE_ADMIN_ENABLED", (Object)name2)) continue;
                        actionFound = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)filterTag, (Object)"data")) continue;
                    dataFound = true;
                }
                if (!actionFound || dataFound) continue;
                requiredIntentFilterFound = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)tagName, (Object)"meta-data") || (valueNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)"android.app.device_admin", (Object)(name = valueNode.getValue()))) continue;
            deviceAdmin = true;
            locationNode = valueNode;
        }
        if (deviceAdmin && !requiredIntentFilterFound && context2.isEnabled(DEVICE_ADMIN)) {
            XmlContext.report$default(context2, DEVICE_ADMIN, locationNode, Context.getLocation$default(context2, locationNode, null, 2, null), "You must have an intent filter for action `android.app.action.DEVICE_ADMIN_ENABLED`", null, 16, null);
        }
    }

    @JvmStatic
    public static final boolean isLaunchableActivity(@NotNull Element activity) {
        return Companion.isLaunchableActivity(activity);
    }

    @JvmStatic
    @Nullable
    public static final Attr findLaunchableCategoryNode(@NotNull Element activity) {
        return Companion.findLaunchableCategoryNode(activity);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        USES_SDK = Issue.Companion.create$default(companion, "UsesMinSdkAttributes", "Minimum SDK and target SDK attributes not defined", "\n                The manifest should contain a `<uses-sdk>` element which defines the minimum API Level \\\n                required for the application to run, as well as the target version (the highest API level \\\n                you have tested the version for).\n                ", implementation, "https://developer.android.com/guide/topics/manifest/uses-sdk-element.html", category, 9, severity, false, null, null, null, 3840, null);
        TARGET_NEWER = Issue.Companion.create("OldTargetApi", "Target SDK attribute is not targeting latest version", "\n                When your application runs on a version of Android that is more recent than your \\\n                `targetSdkVersion` specifies that it has been tested with, various compatibility modes \\\n                kick in. This ensures that your application continues to work, but it may look out of \\\n                place. For example, if the `targetSdkVersion` is less than 14, your app may get an \\\n                option button in the UI.\n\n                To fix this issue, set the `targetSdkVersion` to the highest available value. Then test \\\n                your app to make sure everything works correctly. You may want to consult the \\\n                compatibility notes to see what changes apply to each version you are adding support \\\n                for: https://developer.android.com/reference/android/os/Build.VERSION_CODES.html as well \\\n                as follow this guide:\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html").addMoreInfo("https://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        MULTIPLE_USES_SDK = Issue.Companion.create$default(companion, "MultipleUsesSdk", "Multiple `<uses-sdk>` elements in the manifest", "\n                The `<uses-sdk>` element should appear just once; the tools will **not** merge the contents \\\n                of all the elements so if you split up the attributes across multiple elements, only one of \\\n                them will take effect. To fix this, just merge all the attributes from the various elements \\\n                into a single <uses-sdk> element.\n                ", implementation, "https://developer.android.com/guide/topics/manifest/uses-sdk-element.html", category, 6, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WRONG_PARENT = Issue.Companion.create$default(companion, "WrongManifestParent", "Wrong manifest parent", "\n                The `<uses-library>` element should be defined as a direct child of the `<application>` \\\n                tag, not the `<manifest>` tag or an `<activity>` tag. Similarly, a `<uses-sdk>` tag must \\\n                be declared at the root level, and so on. This check looks for incorrect declaration \\\n                locations in the manifest, and complains if an element is found in the wrong place.\n                ", implementation, "https://developer.android.com/guide/topics/manifest/manifest-intro.html", category, 6, severity, false, null, null, null, 3840, null);
        DUPLICATE_ACTIVITY = Issue.Companion.create("DuplicateActivity", "Activity registered more than once", "\n                An activity should only be registered once in the manifest. If it is accidentally \\\n                registered more than once, then subtle errors can occur, since attribute declarations \\\n                from the two elements are not merged, so you may accidentally remove previous \\\n                declarations.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
        ALLOW_BACKUP = Issue.Companion.create("AllowBackup", "AllowBackup/FullBackupContent Problems", "\n                The `allowBackup` attribute determines if an application's data can be backed up and restored. \\\n                It is documented at https://developer.android.com/reference/android/R.attr.html#allowBackup\n\n                By default, this flag is set to `true` which means application data can be backed up and \\\n                restored by the OS. Setting `allowBackup=\"false\"` opts the application out of being backed up \\\n                and so users can't restore data related to it when they go through the device setup wizard.\n\n                Allowing backups may have security consequences for an application. Currently `adb backup` \\\n                allows users who have enabled USB debugging to copy application data off of the device. Once \\\n                backed up, all application data can be read by the user. `adb restore` allows creation of \\\n                application data from a source specified by the user. Following a restore, applications should \\\n                not assume that the data, file permissions, and directory permissions were created by the \\\n                application itself.\n\n                To fix this warning, decide whether your application should support backup, and explicitly set \\\n                `android:allowBackup=(true|false)\"`.\n\n                If not set to false, and if targeting API 23 or later, lint will also warn that you should set \\\n                `android:fullBackupContent` or `android:fullBackupOnly` to configure auto backup.\n                ", Category.SECURITY, 3, Severity.WARNING, IMPLEMENTATION).addMoreInfo(BACKUP_DOCUMENTATION_URL).addMoreInfo("https://developer.android.com/reference/android/R.attr.html#allowBackup");
        UNIQUE_PERMISSION = Issue.Companion.create("UniquePermission", "Permission names are not unique", "\n                The unqualified names or your permissions must be unique. The reason for this is that at \\\n                build time, the `aapt` tool will generate a class named `Manifest` which contains a field \\\n                for each of your permissions. These fields are named using your permission unqualified names \\\n                (i.e. the name portion after the last dot).\n\n                If more than one permission maps to the same field name, that field will arbitrarily name \\\n                just one of them.\n                ", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SET_VERSION = Issue.Companion.create$default(companion, "MissingVersion", "Missing application name/version", "\n                You should define the version information for your application.\n\n                `android:versionCode`: An integer value that represents the version of the application code, \\\n                relative to other versions.\n\n                `android:versionName`: A string value that represents the release version of the application \\\n                code, as it should be shown to users.\n                ", implementation, "https://developer.android.com/studio/publish/versioning#appversioning", category, 2, severity, false, null, null, null, 3840, null);
        ILLEGAL_REFERENCE = Issue.Companion.create("IllegalResourceRef", "Name and version must be integer or string, not resource", "\n                For the `versionCode` attribute, you have to specify an actual integer literal; you cannot \\\n                use an indirection with a `@dimen/name` resource. Similarly, the `versionName` attribute \\\n                should be an actual string, not a string resource url.\n                ", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
        DUPLICATE_USES_FEATURE = Issue.Companion.create("DuplicateUsesFeature", "Feature declared more than once", "A given feature should only be declared once in the manifest.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.ICONS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APPLICATION_ICON = Issue.Companion.create$default(companion, "MissingApplicationIcon", "Missing application icon", "\n                You should set an icon for the application as whole because there is no default. This \\\n                attribute must be set as a reference to a drawable resource containing the image (for \\\n                example `@drawable/icon`).\n                ", implementation, "https://developer.android.com/studio/publish/preparing#publishing-configure", category, 5, severity, false, null, null, null, 3840, null);
        DEVICE_ADMIN = Issue.Companion.create("DeviceAdmin", "Malformed Device Admin", "\n                If you register a broadcast receiver which acts as a device admin, you must also register \\\n                an `<intent-filter>` for the action `android.app.action.DEVICE_ADMIN_ENABLED`, without any \\\n                `<data>`, such that the device admin can be activated/deactivated.\n\n                To do this, add\n                ```xml\n                `<intent-filter>`\n                    `<action android:name=\"android.app.action.DEVICE_ADMIN_ENABLED\" />`\n                `</intent-filter>`\n                ```\n                to your `<receiver>`.\n                ", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
        MOCK_LOCATION = Issue.Companion.create("MockLocation", "Using mock location provider in production", "\n                Using a mock location provider (by requiring the permission `android.permission.ACCESS_MOCK_LOCATION`) should **only** be done in debug builds (or from tests). In Gradle projects, that means you should only request this permission in a test or debug source set specific manifest file.\n\n                To fix this, create a new manifest file in the debug folder and move the `<uses-permission>` element there. A typical path to a debug manifest override file in a Gradle project is src/debug/AndroidManifest.xml.\n                ", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        GRADLE_OVERRIDES = Issue.Companion.create("GradleOverrides", "Value overridden by Gradle build script", "\n                The value of (for example) `minSdkVersion` is only used if it is not specified in the \\\n                `build.gradle` build scripts. When specified in the Gradle build scripts, the manifest \\\n                value is ignored and can be misleading, so should be removed to avoid ambiguity.\n                ", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        MIPMAP = Issue.Companion.create("MipmapIcons", "Use Mipmap Launcher Icons", "\n                Launcher icons should be provided in the `mipmap` resource directory. This is the same as \\\n                the `drawable` resource directory, except resources in the `mipmap` directory will not get \\\n                stripped out when creating density-specific APKs.\n\n                In certain cases, the Launcher app may use a higher resolution asset (than would normally \\\n                be computed for the device) to display large app shortcuts. If drawables for densities \\\n                other than the device's resolution have been stripped out, then the app shortcut could \\\n                appear blurry.\n\n                To fix this, move your launcher icons from `drawable-`dpi to `mipmap-`dpi and change \\\n                references from @drawable/ and R.drawable to @mipmap/ and R.mipmap.\n\n                In Android Studio this lint warning has a quickfix to perform this automatically.\n                ", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WEARABLE_BIND_LISTENER = Issue.Companion.create$default(companion, "WearableBindListener", "Usage of Android Wear BIND_LISTENER is deprecated", "\n                BIND_LISTENER receives all Android Wear events whether the application needs them or not. \\\n                This can be inefficient and cause applications to wake up unnecessarily. With Google Play \\\n                Services 8.2.0 or later it is recommended to use a more efficient combination of manifest \\\n                listeners and api-based live listeners filtered by action, path and/or path prefix.\n                ", implementation, "https://android-developers.googleblog.com/2016/04/deprecation-of-bindlistener.html", category, 6, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APP_INDEXING_SERVICE = Issue.Companion.create$default(companion, "AppIndexingService", "App Indexing Background Services", "\n                Apps targeting Android 8.0 or higher can no longer rely on background services while \\\n                listening for updates to the on-device index. Use a `BroadcastReceiver` for the \\\n                `UPDATE_INDEX` intent to continue supporting indexing in your app.\n                ", implementation, "https://firebase.google.com/docs/app-indexing/android/personal-content#add-a-broadcast-receiver-to-your-app", category, 4, severity, false, null, null, null, 3840, null);
        MIN_WEARABLE_GMS_VERSION = GradleCoordinate.parseVersionOnly((String)"8.2.0");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector$Companion;", "", "()V", "ALLOW_BACKUP", "Lcom/android/tools/lint/detector/api/Issue;", "APPLICATION_ICON", "APP_INDEXING_SERVICE", "BACKUP_DOCUMENTATION_URL", "", "DEVICE_ADMIN", "DUPLICATE_ACTIVITY", "DUPLICATE_USES_FEATURE", "GRADLE_OVERRIDES", "ILLEGAL_REFERENCE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MIN_WEARABLE_GMS_VERSION", "Lcom/android/ide/common/repository/GradleCoordinate;", "kotlin.jvm.PlatformType", "MIPMAP", "MISSING_FULL_BACKUP_CONTENT_RESOURCE", "MOCK_LOCATION", "MOCK_LOCATION_PERMISSION", "MULTIPLE_USES_SDK", "ORDER", "PLAY_SERVICES_WEARABLE", "SET_VERSION", "TARGET_NEWER", "UNIQUE_PERMISSION", "USES_SDK", "WEARABLE_BIND_LISTENER", "WRONG_PARENT", "findLaunchableCategoryNode", "Lorg/w3c/dom/Attr;", "activity", "Lorg/w3c/dom/Element;", "isLaunchableActivity", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isLaunchableActivity(@NotNull Element activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            return this.findLaunchableCategoryNode(activity) != null;
        }

        @JvmStatic
        @Nullable
        public final Attr findLaunchableCategoryNode(@NotNull Element activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            if (!Intrinsics.areEqual((Object)"activity", (Object)activity.getTagName())) {
                return null;
            }
            Iterator iterator = DomExtensions.iterator((Element)activity);
            while (iterator.hasNext()) {
                Element filter = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)filter.getTagName(), (Object)"intent-filter")) continue;
                Iterator iterator2 = DomExtensions.iterator((Element)filter);
                while (iterator2.hasNext()) {
                    Attr attribute;
                    Element category = (Element)iterator2.next();
                    if (!Intrinsics.areEqual((Object)category.getTagName(), (Object)"category") || (attribute = category.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)"android.intent.category.LAUNCHER")) continue;
                    return attribute;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

