/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "cachedQueryPermissions", "Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "getApplicableMethodNames", "", "getQueryPermissions", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "QueryPermissions", "android.sdktools.lint-checks"})
public final class PackageVisibilityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QueryPermissions cachedQueryPermissions;
    private static final int INITIAL_API = 30;
    @NotNull
    private static final String KEY_REQ_QUERY_ALL = "queryAll";
    @JvmField
    @NotNull
    public static final Issue QUERY_ALL_PACKAGES_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue QUERY_PERMISSIONS_NEEDED;

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr permission = attr;
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.QUERY_ALL_PACKAGES")) {
            Incident incident = new Incident(QUERY_ALL_PACKAGES_PERMISSION, context2.getLocation(permission), "A `<queries>` declaration should generally be used instead of QUERY_ALL_PACKAGES; \\\nsee https://g.co/dev/packagevisibility for details");
            context2.report(incident, Constraints.targetSdkAtLeast(30));
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getInstalledPackages", "getInstalledApplications", "queryBroadcastReceivers", "queryContentProviders", "queryIntentServices", "queryIntentActivities", "resolveActivity", "resolveActivityInfo"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!context.isEnabled(PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED)) {
            return;
        }
        methodName = node.getMethodName();
        var6_5 = methodName;
        if (var6_5 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var6_5.hashCode()) {
            case -150905391: {
                if (var6_5.equals("getInstalledPackages")) {
                    tmp = 1;
                }
                break;
            }
            case 1700882705: {
                if (var6_5.equals("queryContentProviders")) {
                    tmp = 1;
                }
                break;
            }
            case 1600494599: {
                if (var6_5.equals("getInstalledApplications")) {
                    tmp = 1;
                }
                break;
            }
            case -1721890933: {
                if (var6_5.equals("queryBroadcastReceivers")) {
                    tmp = 1;
                }
                break;
            }
            case -109758974: {
                if (var6_5.equals("queryIntentServices")) {
                    tmp = 1;
                }
                break;
            }
            case 1374193809: {
                if (var6_5.equals("queryIntentActivities")) {
                    tmp = 1;
                }
                break;
            }
            case -1219166103: {
                if (var6_5.equals("resolveActivityInfo")) {
                    tmp = 2;
                }
                break;
            }
            case 630467867: {
                if (var6_5.equals("resolveActivity")) {
                    tmp = 2;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v0 = "android.content.pm.PackageManager";
                break;
            }
            case 2: {
                v0 = "android.content.Intent";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var7_6 = Intrinsics.stringPlus((String)"Unexpected method name: ", (Object)methodName);
                var8_9 = false;
                throw (Throwable)new IllegalStateException(var7_6.toString());
            }
        }
        intendedOwner = v0;
        if (!JavaEvaluator.isMemberInSubClassOf$default(context.getEvaluator(), (PsiMember)method, intendedOwner, false, 4, null)) {
            return;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"getInstalledPackages") || Intrinsics.areEqual((Object)methodName, (Object)"getInstalledApplications")) {
            var7_7 = node.getMethodIdentifier();
            v1 = var7_7 == null ? (UElement)node : (UElement)var7_7;
            var7_7 = node.getMethodIdentifier();
            incident = new Incident(PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED, v1, context.getLocation(var7_7 == null ? (UElement)node : (UElement)var7_7), "As of Android 11, this method no longer returns information about all apps; \\\nsee https://g.co/dev/packagevisibility for details");
            context.report(incident, this.map().put("queryAll", true));
        } else {
            var7_8 = node.getMethodIdentifier();
            v2 = var7_8 == null ? (UElement)node : (UElement)var7_8;
            var7_8 = node.getMethodIdentifier();
            incident = new Incident(PackageVisibilityDetector.QUERY_PERMISSIONS_NEEDED, v2, context.getLocation(var7_8 == null ? (UElement)node : (UElement)var7_8), "Consider adding a `<queries>` declaration to your manifest when calling this \\\nmethod; see https://g.co/dev/packagevisibility for details");
            context.report(incident, this.map().put("queryAll", false));
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        if (context2.getMainProject().getTargetSdk() >= 30) {
            Boolean bl2 = map.getBoolean(KEY_REQ_QUERY_ALL, null);
            if (bl2 == null) {
                return true;
            }
            boolean requirePermissions = bl2;
            QueryPermissions queryPermissions = this.getQueryPermissions(context2);
            if (queryPermissions == null) {
                return false;
            }
            QueryPermissions permissions = queryPermissions;
            return !(requirePermissions ? permissions.getCanQueryAllPackages() : permissions.getCanQuerySomePackages());
        }
        return false;
    }

    private final QueryPermissions getQueryPermissions(Context context2) {
        QueryPermissions queryPermissions = this.cachedQueryPermissions;
        if (queryPermissions != null) {
            QueryPermissions queryPermissions2 = queryPermissions;
            boolean bl2 = false;
            boolean bl3 = false;
            QueryPermissions it2 = queryPermissions2;
            boolean bl4 = false;
            return it2;
        }
        Document document = context2.getMainProject().getMergedManifest();
        if (document == null) {
            return null;
        }
        Document manifest = document;
        boolean canQuerySomePackages = false;
        boolean canQueryAllPackages = false;
        Element it2 = manifest.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)it2, (String)"manifest.documentElement");
        Object object = DomExtensions.iterator((Element)it2);
        while (object.hasNext()) {
            Attr permission;
            Attr attr;
            Element tag = (Element)object.next();
            String string = tag.getNodeName();
            if (Intrinsics.areEqual((Object)string, (Object)"queries")) {
                canQuerySomePackages = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"uses-permission") || !Intrinsics.areEqual((Object)((attr = (permission = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name"))) == null ? null : attr.getValue()), (Object)"android.permission.QUERY_ALL_PACKAGES")) continue;
            canQuerySomePackages = true;
            canQueryAllPackages = true;
        }
        object = new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        boolean bl5 = false;
        boolean bl6 = false;
        Object it3 = object;
        boolean bl7 = false;
        this.cachedQueryPermissions = it3;
        return object;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.COMPLIANCE;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(PackageVisibilityDetector.class, Scope.MANIFEST_SCOPE);
        QUERY_ALL_PACKAGES_PERMISSION = Issue.Companion.create$default(companion, "QueryAllPackagesPermission", "Using the QUERY_ALL_PACKAGES permission", "\n            If you need to query or interact with other installed apps, you should be using a \\\n            `<queries>` declaration in your manifest. Using the QUERY_ALL_PACKAGES permission in \\\n            order to see all installed apps is rarely necessary, and most apps on Google Play are \\\n            not allowed to have this permission.\n            ", implementation, "https://g.co/dev/packagevisibility", category, 8, severity, false, true, null, null, 3328, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        implementation = new Implementation(PackageVisibilityDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        QUERY_PERMISSIONS_NEEDED = Issue.Companion.create$default(companion, "QueryPermissionsNeeded", "Using APIs affected by query permissions", "\n            Apps that target Android 11 cannot query or interact with other installed apps \\\n            by default. If you need to query or interact with other installed apps, you may need \\\n            to add a `<queries>` declaration in your manifest.\n\n            As a corollary, the methods `PackageManager#getInstalledPackages` and \\\n            `PackageManager#getInstalledApplications` will no longer return information about all \\\n            installed apps. To query specific apps or types of apps, you can use methods like \\\n            `PackageManager#getPackageInfo` or `PackageManager#queryIntentActivities`.\n            ", implementation, "https://g.co/dev/packagevisibility", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "", "canQuerySomePackages", "", "canQueryAllPackages", "(ZZ)V", "getCanQueryAllPackages", "()Z", "getCanQuerySomePackages", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    private static final class QueryPermissions {
        private final boolean canQuerySomePackages;
        private final boolean canQueryAllPackages;

        public QueryPermissions(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            this.canQuerySomePackages = canQuerySomePackages;
            this.canQueryAllPackages = canQueryAllPackages;
        }

        public final boolean getCanQuerySomePackages() {
            return this.canQuerySomePackages;
        }

        public final boolean getCanQueryAllPackages() {
            return this.canQueryAllPackages;
        }

        public final boolean component1() {
            return this.canQuerySomePackages;
        }

        public final boolean component2() {
            return this.canQueryAllPackages;
        }

        @NotNull
        public final QueryPermissions copy(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            return new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        }

        public static /* synthetic */ QueryPermissions copy$default(QueryPermissions queryPermissions, boolean bl2, boolean bl3, int n10, Object object) {
            if ((n10 & 1) != 0) {
                bl2 = queryPermissions.canQuerySomePackages;
            }
            if ((n10 & 2) != 0) {
                bl3 = queryPermissions.canQueryAllPackages;
            }
            return queryPermissions.copy(bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "QueryPermissions(canQuerySomePackages=" + this.canQuerySomePackages + ", canQueryAllPackages=" + this.canQueryAllPackages + ')';
        }

        public int hashCode() {
            int n10;
            int result2;
            int n11 = this.canQuerySomePackages ? 1 : 0;
            if (n11 != 0) {
                n11 = result2 = 1;
            }
            if ((n10 = this.canQueryAllPackages) != 0) {
                n10 = 1;
            }
            result2 = result2 * 31 + n10;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QueryPermissions)) {
                return false;
            }
            QueryPermissions queryPermissions = (QueryPermissions)other;
            if (this.canQuerySomePackages != queryPermissions.canQuerySomePackages) {
                return false;
            }
            return this.canQueryAllPackages == queryPermissions.canQueryAllPackages;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$Companion;", "", "()V", "INITIAL_API", "", "KEY_REQ_QUERY_ALL", "", "QUERY_ALL_PACKAGES_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "QUERY_PERMISSIONS_NEEDED", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

