/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;

public abstract class PermissionRequirement {
    public static final String ATTR_PROTECTION_LEVEL = "protectionLevel";
    public static final String VALUE_DANGEROUS = "dangerous";
    private final int firstApi;
    private final int lastApi;
    private final boolean conditional;
    public static final PermissionRequirement NONE = new PermissionRequirement(false, 1, Integer.MAX_VALUE){

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return true;
        }

        @Override
        public boolean appliesTo(PermissionHolder available) {
            return false;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return false;
        }

        public String toString() {
            return "None";
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> result2) {
        }

        @Override
        protected void addRevocablePermissions(Set<String> result2, PermissionHolder revocable) {
        }

        @Override
        public IElementType getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }
    };
    @VisibleForTesting
    static final String[] REVOCABLE_PERMISSION_NAMES = new String[]{"android.permission.ACCEPT_HANDOVER", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ANSWER_PHONE_CALLS", "android.permission.BODY_SENSORS", "android.permission.CALL_PHONE", "android.permission.CAMERA", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CELL_BROADCASTS", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_NUMBERS", "android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.SEND_SMS", "android.permission.USE_SIP", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "com.android.voicemail.permission.ADD_VOICEMAIL"};

    private PermissionRequirement(boolean conditional, int firstApi, int lastApi) {
        this.conditional = conditional;
        this.firstApi = firstApi;
        this.lastApi = lastApi;
    }

    public static PermissionRequirement create(UAnnotation annotation) {
        String[] allOf;
        String value;
        int index;
        boolean conditional = UastLintUtils.getAnnotationBooleanValue(annotation, "conditional", false);
        int firstApi = 1;
        int lastApi = Integer.MAX_VALUE;
        String range = UastLintUtils.getAnnotationStringValue(annotation, "apis");
        if (range != null && (index = range.indexOf("..")) != -1) {
            try {
                if (index > 0) {
                    firstApi = Integer.parseInt(range.substring(0, index));
                }
                if (index + 2 < range.length()) {
                    lastApi = Integer.parseInt(range.substring(index + 2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((value = UastLintUtils.getAnnotationStringValue(annotation, "value")) != null && !value.isEmpty()) {
            return new Single(value, conditional, firstApi, lastApi);
        }
        String[] anyOf = UastLintUtils.getAnnotationStringValues(annotation, "anyOf");
        if (anyOf != null) {
            if (anyOf.length > 1) {
                return new Many(JavaTokenType.OROR, anyOf, conditional, firstApi, lastApi);
            }
            if (anyOf.length == 1) {
                return new Single(anyOf[0], conditional, firstApi, lastApi);
            }
        }
        if ((allOf = UastLintUtils.getAnnotationStringValues(annotation, "allOf")) != null) {
            if (allOf.length > 1) {
                return new Many(JavaTokenType.ANDAND, allOf, conditional, firstApi, lastApi);
            }
            if (allOf.length == 1) {
                return new Single(allOf[0], conditional, firstApi, lastApi);
            }
        }
        return NONE;
    }

    protected boolean appliesTo(PermissionHolder available) {
        AndroidVersion minSdkVersion = available.getMinSdkVersion();
        if (minSdkVersion.getFeatureLevel() > this.lastApi) {
            return false;
        }
        AndroidVersion targetSdkVersion = available.getTargetSdkVersion();
        return targetSdkVersion.getFeatureLevel() >= this.firstApi;
    }

    public int getLastApplicableApi() {
        return this.lastApi;
    }

    public int getFirstApplicableApi() {
        return this.firstApi;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isSingle() {
        return true;
    }

    public abstract boolean isSatisfied(PermissionHolder var1);

    public String serialize() {
        return PermissionRequirement.serialize(this);
    }

    public String describeMissingPermissions(PermissionHolder available) {
        return "";
    }

    public Set<String> getMissingPermissions(PermissionHolder available) {
        HashSet result2 = Sets.newHashSet();
        this.addMissingPermissions(available, result2);
        return result2;
    }

    protected abstract void addMissingPermissions(PermissionHolder var1, Set<String> var2);

    public Set<String> getRevocablePermissions(PermissionHolder revocable) {
        HashSet result2 = Sets.newHashSet();
        this.addRevocablePermissions(result2, revocable);
        return result2;
    }

    protected abstract void addRevocablePermissions(Set<String> var1, PermissionHolder var2);

    public abstract boolean isRevocable(PermissionHolder var1);

    public abstract IElementType getOperator();

    public abstract Iterable<PermissionRequirement> getChildren();

    protected static void appendOperator(StringBuilder sb2, IElementType operator) {
        sb2.append(' ');
        if (operator == JavaTokenType.ANDAND) {
            sb2.append("and");
        } else if (operator == JavaTokenType.OROR) {
            sb2.append("or");
        } else {
            assert (operator == JavaTokenType.XOR) : operator;
            sb2.append("xor");
        }
        sb2.append(' ');
    }

    private static String getSerializationPrefix(PermissionRequirement requirement) {
        boolean conditional = requirement.conditional;
        int firstApi = requirement.getFirstApplicableApi();
        int lastApi = requirement.getLastApplicableApi();
        if (firstApi != 1 || lastApi != Integer.MAX_VALUE) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append(firstApi);
            sb2.append("..");
            if (lastApi != Integer.MAX_VALUE) {
                sb2.append(lastApi);
            }
            sb2.append(';');
            if (conditional) {
                sb2.append('?');
            }
            return sb2.toString();
        }
        if (conditional) {
            return "?";
        }
        return null;
    }

    public static String serialize(PermissionRequirement requirement) {
        String prefix = PermissionRequirement.getSerializationPrefix(requirement);
        if (requirement instanceof Single) {
            String name = ((Single)requirement).name;
            if (prefix != null) {
                return prefix + name;
            }
            return name;
        }
        if (requirement instanceof Many) {
            IElementType operator;
            Many r10 = (Many)requirement;
            StringBuilder sb2 = new StringBuilder(100);
            if (prefix != null) {
                sb2.append(prefix);
            }
            if ((operator = r10.operator) == JavaTokenType.ANDAND) {
                sb2.append('&');
            } else if (operator == JavaTokenType.OROR) {
                sb2.append('|');
            } else {
                assert (operator == JavaTokenType.XOR) : operator;
                sb2.append('^');
            }
            boolean first = true;
            for (PermissionRequirement single : r10.permissions) {
                assert (single instanceof Single);
                if (first) {
                    first = false;
                } else {
                    sb2.append(',');
                }
                sb2.append(single.serialize());
            }
            return sb2.toString();
        }
        assert (requirement == NONE);
        return "";
    }

    public static PermissionRequirement deserialize(String s10) {
        IElementType operator;
        char operatorChar;
        if (s10.isEmpty()) {
            return NONE;
        }
        int firstApi = 1;
        int lastApi = Integer.MAX_VALUE;
        boolean conditional = false;
        int start = 0;
        if (Character.isDigit(operatorChar = s10.charAt(start++))) {
            int firstEnd = s10.indexOf(46);
            int lastStart = firstEnd + 2;
            int lastEnd = s10.indexOf(59, lastStart);
            firstApi = Integer.parseInt(s10.substring(0, firstEnd));
            if (lastStart != lastEnd) {
                lastApi = Integer.parseInt(s10.substring(lastStart, lastEnd));
            }
            start = lastEnd + 1;
            operatorChar = s10.charAt(start++);
        }
        if (operatorChar == '?') {
            conditional = true;
            operatorChar = s10.charAt(start++);
        }
        if (operatorChar == '&') {
            operator = JavaTokenType.ANDAND;
        } else if (operatorChar == '|') {
            operator = JavaTokenType.OROR;
        } else if (operatorChar == '^') {
            operator = JavaTokenType.XOR;
        } else {
            String name = --start > 0 ? s10.substring(start) : s10;
            return new Single(name, conditional, firstApi, lastApi);
        }
        ArrayList<String> names = new ArrayList<String>();
        while (true) {
            int end;
            if ((end = s10.indexOf(44, start)) == -1) break;
            names.add(s10.substring(start, end));
            start = end + 1;
        }
        names.add(s10.substring(start));
        return new Many(operator, names.toArray(new String[0]), conditional, firstApi, lastApi);
    }

    public static boolean isRevocableSystemPermission(String name) {
        return Arrays.binarySearch(REVOCABLE_PERMISSION_NAMES, name) >= 0;
    }

    private static class Many
    extends PermissionRequirement {
        public final IElementType operator;
        public final List<PermissionRequirement> permissions;

        public Many(IElementType operator, String[] names, boolean conditional, int firstApi, int lastApi) {
            super(conditional, firstApi, lastApi);
            assert (operator == JavaTokenType.OROR || operator == JavaTokenType.ANDAND) : operator;
            assert (names.length >= 2);
            this.operator = operator;
            this.permissions = Lists.newArrayListWithExpectedSize((int)names.length);
            for (String name : names) {
                this.permissions.add(new Single(name, conditional, firstApi, lastApi));
            }
        }

        @Override
        public boolean isSingle() {
            return false;
        }

        public String toString() {
            StringBuilder sb2 = new StringBuilder();
            sb2.append(this.permissions.get(0));
            for (int i10 = 1; i10 < this.permissions.size(); ++i10) {
                Many.appendOperator(sb2, this.operator);
                sb2.append(this.permissions.get(i10));
            }
            return sb2.toString();
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            if (this.operator == JavaTokenType.ANDAND) {
                for (PermissionRequirement requirement : this.permissions) {
                    if (requirement.isSatisfied(available) || !requirement.appliesTo(available)) continue;
                    return false;
                }
                return true;
            }
            assert (this.operator == JavaTokenType.OROR) : this.operator;
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isSatisfied(available) && requirement.appliesTo(available)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            StringBuilder sb2 = new StringBuilder();
            boolean first = true;
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                if (first) {
                    first = false;
                } else {
                    Many.appendOperator(sb2, this.operator);
                }
                sb2.append(requirement.describeMissingPermissions(available));
            }
            return sb2.toString();
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            for (PermissionRequirement requirement : this.permissions) {
                if (requirement.isSatisfied(available)) continue;
                requirement.addMissingPermissions(available, missing);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result2, PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                requirement.addRevocablePermissions(result2, revocable);
            }
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            for (PermissionRequirement requirement : this.permissions) {
                if (!requirement.isRevocable(revocable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IElementType getOperator() {
            return this.operator;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return this.permissions;
        }
    }

    private static class Single
    extends PermissionRequirement {
        public final String name;

        public Single(String name, boolean conditional, int firstApi, int lastApi) {
            super(conditional, firstApi, lastApi);
            this.name = name;
        }

        @Override
        public boolean isRevocable(PermissionHolder revocable) {
            return revocable.isRevocable(this.name) || Single.isRevocableSystemPermission(this.name);
        }

        @Override
        public IElementType getOperator() {
            return null;
        }

        @Override
        public Iterable<PermissionRequirement> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public boolean isSingle() {
            return true;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public boolean isSatisfied(PermissionHolder available) {
            return available.hasPermission(this.name) || !this.appliesTo(available);
        }

        @Override
        public String describeMissingPermissions(PermissionHolder available) {
            return this.isSatisfied(available) ? "" : this.name;
        }

        @Override
        protected void addMissingPermissions(PermissionHolder available, Set<String> missing) {
            if (!this.isSatisfied(available)) {
                missing.add(this.name);
            }
        }

        @Override
        protected void addRevocablePermissions(Set<String> result2, PermissionHolder revocable) {
            if (this.isRevocable(revocable)) {
                result2.add(this.name);
            }
        }
    }
}

