/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WrongIdDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private final Set<String> mGlobalIds = new HashSet<String>(100);
    private Set<String> mFileIds;
    private Set<String> mDeclaredIds;
    private Map<String, Location.Handle> mHandles;
    private Map<String, String> mPendingNotSibling;
    private List<Element> mRelativeLayouts;
    public static final Issue UNKNOWN_ID = Issue.create("UnknownId", "Reference to an unknown id", "The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand. This check catches errors where you have renamed an id without updating all of the references to it.", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(WrongIdDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue NOT_SIBLING = Issue.create("NotSibling", "Invalid Constraints", "Layout constraints in a given `ConstraintLayout` or `RelativeLayout` should reference other views within the same relative layout (but not itself!)", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue INVALID = Issue.create("InvalidId", "Invalid ID declaration", "An id definition **must** be of the form `@+id/yourname`. The tools have not rejected strings of the form `@+foo/bar` in the past, but that was an error, and could lead to tricky errors because of the way the id integers are assigned.\n\nIf you really want to have different \"scopes\" for your id's, use prefixes instead, such as `login_button1` and `login_button2`.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue UNKNOWN_ID_LAYOUT = Issue.create("UnknownIdInLayout", "Reference to an id that is not in the current layout", "The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand.\n\nThis is sometimes intentional, for example where you are referring to a view which is provided in a different layout via an include. However, it is usually an accident where you have a typo or you have renamed a view without updating all the references to it.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ImmutableSet.of((Object)"RelativeLayout", (Object)"item", (Object)"android.support.percent.PercentRelativeLayout", (Object)SdkConstants.CLASS_CONSTRAINT_LAYOUT.oldName(), (Object)SdkConstants.CLASS_CONSTRAINT_LAYOUT.newName());
    }

    @Override
    public void beforeCheckFile(Context context2) {
        this.mFileIds = new HashSet<String>();
        this.mRelativeLayouts = null;
    }

    @Override
    public void afterCheckFile(Context context2) {
        if (this.mRelativeLayouts != null) {
            if (!context2.getProject().getReportIssues()) {
                return;
            }
            for (Element layout : this.mRelativeLayouts) {
                this.checkLayout(context2, layout);
            }
        }
        this.mFileIds = null;
        if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context2);
        }
    }

    private void checkLayout(Context context2, Element layout) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)20);
        for (Element child : XmlUtils.getSubTags((Node)layout)) {
            String included;
            String id2 = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id2 != null && !id2.isEmpty()) {
                ids.add(id2);
                continue;
            }
            if (!"include".equals(child.getTagName()) || WrongIdDetector.addIncludedIds(context2, ids, included = child.getAttribute("layout"))) continue;
            this.mHandles = null;
            return;
        }
        boolean isConstraintLayout = SdkConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(layout.getTagName());
        for (Element element : XmlUtils.getSubTags((Node)layout)) {
            String selfId = Lint.stripIdPrefix(element.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            NamedNodeMap attributes = element.getAttributes();
            int n10 = attributes.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                Attr attr = (Attr)attributes.item(i10);
                String value = attr.getValue();
                if (value.startsWith("@+id/") || value.startsWith("@id/")) {
                    String localName = attr.getLocalName();
                    if (localName == null || !localName.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && !"http://schemas.android.com/apk/res-auto".equals(attr.getNamespaceURI())) continue;
                    this.checkIdReference(context2, layout, ids, isConstraintLayout, selfId, attr, value);
                    continue;
                }
                if (!isConstraintLayout || !"constraint_referenced_ids".equals(attr.getLocalName())) continue;
                Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
                for (String id3 : splitter.split((CharSequence)value)) {
                    this.checkIdReference(context2, layout, ids, true, selfId, attr, id3);
                }
            }
        }
    }

    private static boolean addIncludedIds(Context context2, Set<String> ids, String included) {
        boolean full;
        Project project;
        if (included.isEmpty()) {
            return true;
        }
        LintClient client = context2.getClient();
        ResourceRepository resources = client.getResources(project = (full = context2.isGlobalAnalysis()) ? context2.getMainProject() : context2.getProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List layouts = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, included);
        if (layouts.isEmpty()) {
            return false;
        }
        ResourceItem layout = (ResourceItem)layouts.get(0);
        PathString source = layout.getSource();
        if (source == null) {
            return false;
        }
        try {
            XmlPullParser parser = client.createXmlPullParser(source);
            if (parser != null) {
                WrongIdDetector.addIncludedIds(parser, ids);
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return true;
    }

    private static void addIncludedIds(XmlPullParser parser, Set<String> ids) throws XmlPullParserException, IOException {
        int depth = -1;
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String id2;
                if (++depth == 0 && !"merge".equals(parser.getName())) {
                    id2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                    if (!id2.isEmpty()) {
                        ids.add(id2);
                    }
                    return;
                }
                if (depth != 1 || (id2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id")).isEmpty()) continue;
                ids.add(id2);
                continue;
            }
            if (event == 3) {
                --depth;
                continue;
            }
            if (event == 1) break;
        }
    }

    private void checkIdReference(Context context2, Element layout, Set<String> siblingIds, boolean isConstraintLayout, String selfId, Attr attr, String id2) {
        String parentId;
        String message2;
        if (!WrongIdDetector.idDefined(this.mFileIds, id2)) {
            XmlContext xmlContext = (XmlContext)context2;
            Location.Handle handle = xmlContext.createLocationHandle(attr);
            handle.setClientData(attr);
            if (this.mHandles == null) {
                this.mHandles = new LinkedHashMap<String, Location.Handle>();
                this.mPendingNotSibling = new HashMap<String, String>();
            }
            this.mHandles.put(id2, handle);
        }
        if (siblingIds.contains(id2)) {
            if (!"id".equals(attr.getLocalName()) && !selfId.isEmpty() && id2.endsWith(selfId) && Lint.stripIdPrefix(id2).equals(selfId)) {
                message2 = String.format("Cannot be relative to self: id=%1$s, %2$s=%3$s", selfId, attr.getLocalName(), selfId);
                this.reportNotSiblingIfKnownId(context2, id2, attr, message2);
            }
            return;
        }
        if (id2.startsWith("@+id/") ? siblingIds.contains("@id/" + Lint.stripIdPrefix(id2)) : (id2.startsWith("@id/") ? siblingIds.contains("@+id/" + Lint.stripIdPrefix(id2)) : siblingIds.contains("@+id/" + id2) || siblingIds.contains("@id/" + id2))) {
            return;
        }
        if (isConstraintLayout && (parentId = Lint.stripIdPrefix(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "id"))).equals(Lint.stripIdPrefix(id2))) {
            return;
        }
        if (context2.isEnabled(NOT_SIBLING)) {
            message2 = String.format("`%1$s` is not a sibling in the same `%2$s`", id2, isConstraintLayout ? "ConstraintLayout" : "RelativeLayout");
            this.reportNotSiblingIfKnownId(context2, id2, attr, message2);
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context2);
        }
    }

    private void reportNotSiblingIfKnownId(Context context2, String id2, Node attr, String message2) {
        if (this.mHandles != null && this.mHandles.containsKey(id2)) {
            this.mPendingNotSibling.put(id2, message2);
        } else {
            XmlContext xmlContext = (XmlContext)context2;
            Location location = xmlContext.getLocation(attr);
            xmlContext.report(NOT_SIBLING, attr, location, message2);
        }
    }

    private void checkHandles(Context context2) {
        if (this.mHandles != null) {
            boolean checkSameLayout = context2.isEnabled(UNKNOWN_ID_LAYOUT);
            boolean checkExists = context2.isEnabled(UNKNOWN_ID);
            boolean projectScope = context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES);
            for (Map.Entry<String, Location.Handle> pair : this.mHandles.entrySet()) {
                String id2 = pair.getKey();
                Location.Handle handle = pair.getValue();
                boolean isBound = projectScope ? WrongIdDetector.idDefined(this.mGlobalIds, id2) : this.idDefined(context2, id2, context2.file);
                LintClient client = context2.getClient();
                if (!isBound && checkExists) {
                    List<String> suggestions;
                    boolean isDeclared = WrongIdDetector.idDefined(this.mDeclaredIds, id2);
                    id2 = Lint.stripIdPrefix(id2);
                    HashSet spellingDictionary = this.createSpellingDictionary();
                    if (!projectScope) {
                        Project project = context2.getProject();
                        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                        spellingDictionary = Sets.newHashSet((Iterable)resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
                        spellingDictionary.remove(id2);
                    }
                    String suggestionMessage = (suggestions = WrongIdDetector.getSpellingSuggestions(id2, spellingDictionary)).size() > 1 ? String.format(" Did you mean one of {%2$s} ?", id2, Joiner.on((String)", ").join(suggestions)) : (!suggestions.isEmpty() ? String.format(" Did you mean %2$s ?", id2, suggestions.get(0)) : "");
                    String message2 = isDeclared ? String.format("The id \"`%1$s`\" is defined but not assigned to any views.%2$s", id2, suggestionMessage) : String.format("The id \"`%1$s`\" is not defined anywhere.%2$s", id2, suggestionMessage);
                    WrongIdDetector.report(context2, UNKNOWN_ID, handle, message2);
                    continue;
                }
                if (checkSameLayout && (!projectScope || isBound) && id2.startsWith("@+id/")) {
                    WrongIdDetector.report(context2, UNKNOWN_ID_LAYOUT, handle, String.format("The id \"`%1$s`\" is not referring to any views in this layout", Lint.stripIdPrefix(id2)));
                    continue;
                }
                if (!this.mPendingNotSibling.containsKey(id2)) continue;
                String message3 = this.mPendingNotSibling.get(id2);
                context2.report(NOT_SIBLING, handle.resolve(), message3);
            }
        }
    }

    private Set<String> createSpellingDictionary() {
        HashSet<String> dictionary = new HashSet<String>();
        this.mGlobalIds.stream().filter(id2 -> id2.startsWith("@+id/")).forEach(id2 -> dictionary.add(Lint.stripIdPrefix(id2)));
        if (this.mDeclaredIds != null) {
            this.mDeclaredIds.forEach(id2 -> dictionary.add(Lint.stripIdPrefix(id2)));
        }
        return dictionary;
    }

    private static void report(Context context2, Issue issue, Location.Handle handle, String message2) {
        Location location = handle.resolve();
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context2.getDriver().isSuppressed(null, issue, (Node)clientData)) {
            return;
        }
        context2.report(issue, location, message2);
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String name;
            String type = element.getAttribute("type");
            if ("id".equals(type) && !(name = element.getAttribute("name")).isEmpty()) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add("@+id/" + name);
                this.mGlobalIds.add("@+id/" + name);
            }
        } else {
            assert (tagName.equals("RelativeLayout") || tagName.equals("android.support.percent.PercentRelativeLayout") || SdkConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(tagName));
            if (this.mRelativeLayouts == null) {
                this.mRelativeLayouts = new ArrayList<Element>();
            }
            this.mRelativeLayouts.add(element);
        }
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        assert (attribute.getName().equals("id") || attribute.getLocalName().equals("id"));
        String id2 = attribute.getValue();
        this.mFileIds.add(id2);
        this.mGlobalIds.add(id2);
        if (id2.equals("@+id/") || id2.equals("@id/")) {
            String message2 = "Invalid id: missing value";
            context2.report(INVALID, attribute, context2.getLocation(attribute), message2);
        } else if (id2.startsWith("@+") && !id2.startsWith("@+id/") && !id2.startsWith("@+android:id/") || id2.startsWith("@+id/") && id2.indexOf(47, "@+id/".length()) != -1) {
            int nameStart = id2.startsWith("@+id/") ? "@+id/".length() : 2;
            String suggested = "@+id/" + id2.substring(nameStart).replace('/', '_');
            String message3 = String.format("ID definitions **must** be of the form `@+id/name`; try using `%1$s`", suggested);
            context2.report(INVALID, attribute, context2.getLocation(attribute), message3);
        }
    }

    private static boolean idDefined(Set<String> ids, String id2) {
        if (ids == null) {
            return false;
        }
        boolean definedLocally = ids.contains(id2);
        if (!definedLocally) {
            if (id2.startsWith("@+id/")) {
                return ids.contains("@id/" + id2.substring("@+id/".length()));
            }
            if (id2.startsWith("@id/")) {
                return ids.contains("@+id/" + id2.substring("@id/".length()));
            }
            return ids.contains("@+id/" + id2);
        }
        return true;
    }

    private boolean idDefined(Context context2, String id2, File notIn) {
        LintClient client = context2.getClient();
        Project project = context2.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, Lint.stripIdPrefix(id2));
        for (ResourceItem item : items) {
            PathString source = item.getSource();
            if (source == null) continue;
            String parentName = source.getParentFileName();
            if (parentName != null && parentName.startsWith("values")) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add(id2);
                continue;
            }
            if (Lint.isSameResourceFile(source.toFile(), notIn)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getSpellingSuggestions(String id2, Collection<String> ids) {
        int maxDistance = id2.length() >= 4 ? 2 : 1;
        ArrayListMultimap matches = ArrayListMultimap.create((int)2, (int)10);
        int count = 0;
        if (!ids.isEmpty()) {
            for (String matchWith : ids) {
                int distance = Lint.editDistance(id2, matchWith = Lint.stripIdPrefix(matchWith), maxDistance);
                if (distance <= maxDistance) {
                    matches.put((Object)distance, (Object)matchWith);
                }
                if (count++ <= 100) continue;
                break;
            }
        }
        for (int i10 = 0; i10 < maxDistance; ++i10) {
            Collection strings = matches.get((Object)i10);
            if (strings == null || strings.isEmpty()) continue;
            ArrayList<String> suggestions = new ArrayList<String>(strings);
            Collections.sort(suggestions);
            return suggestions;
        }
        return Collections.emptyList();
    }
}

