/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J|\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002J \u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002JB\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010%\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002JV\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010!\u001a\u00020\"2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J5\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010-\u001a\u00020.2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002000/2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u00101J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010-\u001a\u00020.2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J:\u00102\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a032\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J\u0016\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u001bJ\u0016\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00107\u001a\u000208J\u0016\u00109\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;J\u0016\u0010<\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"J\u0016\u0010=\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020AJ\u0016\u0010B\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010C\u001a\u00020DJ\u0016\u0010E\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020FJ\u0016\u0010G\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010:\u001a\u00020HJ\u0016\u0010I\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010J\u001a\u00020KR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/android/tools/lint/client/api/AnnotationHandler;", "", "scanners", "Lcom/google/common/collect/Multimap;", "", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "(Lcom/google/common/collect/Multimap;)V", "annotationLookup", "Lcom/android/tools/lint/client/api/AnnotationLookup;", "relevantAnnotations", "", "getRelevantAnnotations", "()Ljava/util/Set;", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "packageAnnotations", "annotated", "checkCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkCallUnresolved", "checkContextAnnotations", "origCall", "doCheckCall", "methodAnnotations", "classAnnotations", "pkgAnnotations", "containingClass", "Lcom/intellij/psi/PsiClass;", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/uast/UElement;)Ljava/util/List;", "getClassAndPkgAnnotations", "Lkotlin/Pair;", "visitAnnotation", "annotation", "visitArrayAccessExpression", "expression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitBinaryExpression", "node", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitCallableReferenceExpression", "methodReference", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitEnumConstant", "constant", "Lorg/jetbrains/uast/UEnumConstant;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitVariable", "variable", "Lorg/jetbrains/uast/UVariable;", "android.sdktools.lint-api"})
public final class AnnotationHandler {
    @NotNull
    private final Multimap<String, SourceCodeScanner> scanners;
    @NotNull
    private final Set<String> relevantAnnotations;
    @NotNull
    private final AnnotationLookup annotationLookup;

    public AnnotationHandler(@NotNull Multimap<String, SourceCodeScanner> scanners) {
        Intrinsics.checkParameterIsNotNull(scanners, (String)"scanners");
        this.scanners = scanners;
        this.relevantAnnotations = new HashSet((Collection)this.scanners.keys());
        this.annotationLookup = new AnnotationLookup();
    }

    @NotNull
    public final Set<String> getRelevantAnnotations() {
        return this.relevantAnnotations;
    }

    private final void checkContextAnnotations(JavaContext context2, PsiMethod method, PsiElement referenced, UElement origCall, List<? extends UAnnotation> allMethodAnnotations, PsiElement annotated) {
        UElement call = origCall;
        UElement uElement = Lint.skipParentheses(call.getUastParent());
        if (uElement == null) {
            return;
        }
        UElement p10 = uElement;
        if (p10 instanceof UQualifiedReferenceExpression) {
            call = p10;
            uElement = p10.getUastParent();
            if (uElement == null) {
                return;
            }
            p10 = uElement;
        }
        if (p10 instanceof UBinaryExpression) {
            UExpression check = null;
            UElement binary = p10;
            if (call == ((UBinaryExpression)binary).getLeftOperand()) {
                check = ((UBinaryExpression)binary).getRightOperand();
            } else if (call == ((UBinaryExpression)binary).getRightOperand()) {
                check = ((UBinaryExpression)binary).getLeftOperand();
            }
            if (check != null) {
                UastBinaryOperator uastBinaryOperator = ((UBinaryExpression)p10).getOperator();
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)check, Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.ASSIGN) ? AnnotationUsageType.ASSIGNMENT_LHS : ((((Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS)) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) ? AnnotationUsageType.EQUALITY : AnnotationUsageType.BINARY), method, referenced, allMethodAnnotations, null, null, null, annotated, 448, null);
            }
        } else if (p10 instanceof UQualifiedReferenceExpression) {
            List arguments;
            UExpression selector;
            UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)p10;
            UQualifiedReferenceExpression binary = ref;
            if (Intrinsics.areEqual((Object)"equals", (Object)binary.getResolvedName()) && (selector = ref.getSelector()) instanceof UCallExpression && (arguments = ((UCallExpression)selector).getValueArguments()).size() == 1) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)arguments.get(0), AnnotationUsageType.EQUALITY, method, referenced, allMethodAnnotations, null, null, null, annotated, 448, null);
            }
        } else if (call instanceof UVariable) {
            UElement variable = call;
            PsiVariable variablePsi = ((UVariable)call).getPsi();
            UMethod arguments = UastUtils.getContainingUMethod((UElement)call);
            if (arguments != null) {
                arguments.accept((UastVisitor)new AbstractUastVisitor(variable, variablePsi, this, context2, method, referenced, allMethodAnnotations, annotated){
                    final /* synthetic */ UElement $variable;
                    final /* synthetic */ PsiVariable $variablePsi;
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ PsiMethod $method;
                    final /* synthetic */ PsiElement $referenced;
                    final /* synthetic */ List<UAnnotation> $allMethodAnnotations;
                    final /* synthetic */ PsiElement $annotated;
                    {
                        this.$variable = $variable;
                        this.$variablePsi = $variablePsi;
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$method = $method;
                        this.$referenced = $referenced;
                        this.$allMethodAnnotations = $allMethodAnnotations;
                        this.$annotated = $annotated;
                    }

                    public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                        UExpression expression;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        PsiElement referencedVariable = node.resolve();
                        if ((Intrinsics.areEqual((Object)this.$variable, (Object)referencedVariable) || Intrinsics.areEqual((Object)this.$variablePsi, (Object)referencedVariable)) && (expression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)true)) != null) {
                            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)false);
                            if (uExpression == null) {
                                return false;
                            }
                            UExpression inner = uExpression;
                            AnnotationHandler.checkAnnotations$default(this.this$0, this.$context, (UElement)inner, AnnotationUsageType.VARIABLE_REFERENCE, this.$method, this.$referenced, this.$allMethodAnnotations, null, null, null, this.$annotated, 448, null);
                            return false;
                        }
                        return super.visitSimpleNameReferenceExpression(node);
                    }
                });
            }
            UExpression initializer = ((UVariable)variable).getUastInitializer();
            if (initializer != null) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)initializer, AnnotationUsageType.ASSIGNMENT_RHS, null, referenced, allMethodAnnotations, null, null, null, annotated, 448, null);
            }
        }
    }

    public final void visitBinaryExpression(@NotNull JavaContext context2, @NotNull UBinaryExpression node) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (UastExpressionUtils.isAssignment((UElement)((UElement)node))) {
            PsiField psiField;
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            PsiField psiField2 = psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
            if (psiField == null) {
                return;
            }
            PsiField resolved = psiField;
            JavaEvaluator evaluator = context2.getEvaluator();
            List annotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)resolved, true), null, 4, null);
            UExpression uExpression = node.getRightOperand();
            AnnotationUsageType annotationUsageType = AnnotationUsageType.ASSIGNMENT_RHS;
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)uExpression, annotationUsageType, null, (PsiElement)resolved, annotations, null, null, null, (PsiElement)resolved, 448, null);
        }
    }

    private final void checkAnnotations(JavaContext context2, UElement argument, AnnotationUsageType type, PsiMethod method, PsiElement referenced, List<? extends UAnnotation> annotations, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, List<? extends UAnnotation> packageAnnotations, PsiElement annotated) {
        for (UAnnotation uAnnotation : annotations) {
            String signature;
            Collection uastScanners;
            String string = uAnnotation.getQualifiedName();
            if (string == null || (uastScanners = this.scanners.get((Object)(signature = string))) == null) continue;
            List<UAnnotation> uAnnotations = null;
            PsiAnnotation[] psiAnnotations = null;
            for (SourceCodeScanner scanner : uastScanners) {
                if (!scanner.isApplicableAnnotationUsage(type)) continue;
                if (annotated != null && !scanner.inheritAnnotation(signature)) {
                    Object object;
                    PsiModifierListOwner owner;
                    PsiElement psiElement = uAnnotation.getSourcePsi();
                    PsiAnnotation psiAnnotation = psiElement instanceof PsiAnnotation ? (PsiAnnotation)psiElement : null;
                    PsiAnnotationOwner annotationOwner = psiAnnotation == null ? null : psiAnnotation.getOwner();
                    PsiModifierListOwner psiModifierListOwner = owner = annotationOwner instanceof PsiElement ? (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)annotationOwner), PsiModifierListOwner.class) : (PsiModifierListOwner)null;
                    if (owner != null) {
                        PsiElement psiElement2;
                        PsiElement annotatedPsi;
                        Object object2 = object = annotated instanceof UElement ? (UElement)annotated : null;
                        PsiElement psiElement3 = object == null ? annotated : (annotatedPsi = (psiElement2 = object.getSourcePsi()) == null ? annotated : psiElement2);
                        if (!Intrinsics.areEqual((Object)owner, (Object)annotatedPsi)) {
                            continue;
                        }
                    } else {
                        boolean bl2;
                        boolean bl3;
                        AnnotationHandler annotationHandler;
                        if (annotated instanceof UAnnotated) {
                            List<UAnnotation> list2;
                            boolean found = false;
                            List<UAnnotation> list3 = uAnnotations;
                            if (list3 == null) {
                                List<UAnnotation> list4;
                                annotationHandler = this;
                                bl3 = false;
                                bl2 = false;
                                AnnotationHandler $this$checkAnnotations_u24lambda_u2d0 = annotationHandler;
                                boolean bl4 = false;
                                uAnnotations = list4 = context2.getEvaluator().getAllAnnotations((UAnnotated)annotated, false);
                                list2 = list4;
                            } else {
                                list2 = list3;
                            }
                            object = list2.iterator();
                            while (object.hasNext()) {
                                UAnnotation uAnnotation2 = (UAnnotation)object.next();
                                String qualifiedName = uAnnotation2.getQualifiedName();
                                if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        if (annotated instanceof PsiModifierListOwner) {
                            PsiAnnotation[] psiAnnotationArray;
                            boolean found = false;
                            PsiAnnotation[] psiAnnotationArray2 = psiAnnotations;
                            if (psiAnnotationArray2 == null) {
                                PsiAnnotation[] array;
                                annotationHandler = this;
                                bl3 = false;
                                bl2 = false;
                                AnnotationHandler $this$checkAnnotations_u24lambda_u2d1 = annotationHandler;
                                boolean bl5 = false;
                                psiAnnotations = array = context2.getEvaluator().getAllAnnotations((PsiModifierListOwner)annotated, false);
                                psiAnnotationArray = array;
                            } else {
                                psiAnnotationArray = psiAnnotationArray2;
                            }
                            object = psiAnnotationArray;
                            int n10 = ((Object)object).length;
                            for (int i10 = 0; i10 < n10; ++i10) {
                                Object psiAnnotation2 = object[i10];
                                String qualifiedName = psiAnnotation2.getQualifiedName();
                                if (!Intrinsics.areEqual((Object)qualifiedName, (Object)signature)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                    }
                }
                scanner.visitAnnotationUsage(context2, argument, type, uAnnotation, signature, method, referenced, annotations, allMethodAnnotations, allClassAnnotations, packageAnnotations);
            }
        }
    }

    static /* synthetic */ void checkAnnotations$default(AnnotationHandler annotationHandler, JavaContext javaContext, UElement uElement, AnnotationUsageType annotationUsageType, PsiMethod psiMethod, PsiElement psiElement, List list2, List list3, List list4, List list5, PsiElement psiElement2, int n10, Object object) {
        if ((n10 & 0x40) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n10 & 0x80) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n10 & 0x100) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        annotationHandler.checkAnnotations(javaContext, uElement, annotationUsageType, psiMethod, psiElement, list2, list3, list4, list5, psiElement2);
    }

    public final void visitMethod(@NotNull JavaContext context2, @NotNull UMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((UAnnotated)method, true));
        Collection collection = methodAnnotations;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            UExpression body = method.getUastBody();
            if (body != null && !(body instanceof UBlockExpression) && !(body instanceof UReturnExpression)) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)body, AnnotationUsageType.METHOD_RETURN, (PsiMethod)method, (PsiElement)method, methodAnnotations, methodAnnotations, null, null, (PsiElement)method, 384, null);
            } else {
                method.accept((UastVisitor)new AbstractUastVisitor(this, context2, method, methodAnnotations){
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ UMethod $method;
                    final /* synthetic */ List<UAnnotation> $methodAnnotations;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$method = $method;
                        this.$methodAnnotations = $methodAnnotations;
                    }

                    public boolean visitClass(@NotNull UClass node) {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        UExpression returnValue = node.getReturnExpression();
                        if (returnValue != null) {
                            AnnotationHandler.checkAnnotations$default(this.this$0, this.$context, (UElement)returnValue, AnnotationUsageType.METHOD_RETURN, (PsiMethod)this.$method, (PsiElement)this.$method, this.$methodAnnotations, this.$methodAnnotations, null, null, (PsiElement)this.$method, 384, null);
                        }
                        return super.visitReturnExpression(node);
                    }
                });
            }
        }
    }

    public final void visitClass(@NotNull JavaContext context2, @NotNull UClass node) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        for (UTypeReferenceExpression superType : node.getUastSuperTypes()) {
            PsiClass psiClass;
            PsiType type = superType.getType();
            PsiClass psiClass2 = PsiTypesUtil.getPsiClass((PsiType)type);
            if (psiClass2 == null) continue;
            PsiClass resolved = psiClass = psiClass2;
            JavaEvaluator evaluator = context2.getEvaluator();
            List annotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)resolved, true), null, 4, null);
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)superType, AnnotationUsageType.EXTENDS, null, (PsiElement)resolved, annotations, null, null, null, (PsiElement)resolved, 448, null);
        }
    }

    public final void visitSimpleNameReferenceExpression(@NotNull JavaContext context2, @NotNull USimpleNameReferenceExpression node) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PsiElement field = node.resolve();
        if (field instanceof PsiField || field instanceof PsiMethod) {
            JavaEvaluator evaluator = context2.getEvaluator();
            List annotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)((PsiMember)field), true), null, 4, null);
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)node, AnnotationUsageType.FIELD_REFERENCE, null, field, annotations, null, null, null, field, 448, null);
        }
    }

    public final void visitCallExpression(@NotNull JavaContext context2, @NotNull UCallExpression call) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        PsiMethod method = call.resolve();
        if (method == null) {
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call))) {
                this.checkCallUnresolved(context2, call);
            }
        } else {
            this.checkCall(context2, method, call);
        }
    }

    public final void visitCallableReferenceExpression(@NotNull JavaContext context2, @NotNull UCallableReferenceExpression methodReference) {
        PsiMethod psiMethod;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)methodReference, (String)"methodReference");
        PsiElement psiElement = methodReference.resolve();
        PsiMethod psiMethod2 = psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiAnnotation[] allMethodAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true);
        List methodAnnotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, allMethodAnnotations, null, 4, null);
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(method.getContainingClass(), evaluator, (UElement)methodReference);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.checkAnnotations(context2, (UElement)methodReference, AnnotationUsageType.METHOD_REFERENCE, method, (PsiElement)method, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)method);
    }

    public final void visitAnnotation(@NotNull JavaContext context2, @NotNull UAnnotation annotation) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null || StringsKt.startsWith$default((String)qualifiedName, (String)"java.", (boolean)false, (int)2, null) || SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName)) {
            return;
        }
        List attributeValues = annotation.getAttributeValues();
        if (attributeValues.isEmpty()) {
            return;
        }
        PsiClass psiClass = annotation.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        for (UNamedExpression expression : attributeValues) {
            String string = expression.getName();
            String name = string == null ? "value" : string;
            PsiMethod[] methods = resolved.findMethodsByName(name, false);
            if (methods.length != 1) continue;
            PsiMethod method = methods[0];
            JavaEvaluator evaluator = context2.getEvaluator();
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"method");
            List methodAnnotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)method, true), null, 4, null);
            Collection collection = methodAnnotations;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            UExpression value = expression.getExpression();
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)value, AnnotationUsageType.ANNOTATION_REFERENCE, method, (PsiElement)method, methodAnnotations, methodAnnotations, null, null, (PsiElement)method, 384, null);
        }
    }

    public final void visitEnumConstant(@NotNull JavaContext context2, @NotNull UEnumConstant constant) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)constant, (String)"constant");
        PsiMethod method = constant.resolveMethod();
        if (method != null) {
            this.checkCall(context2, method, (UCallExpression)constant);
        }
    }

    public final void visitArrayAccessExpression(@NotNull JavaContext context2, @NotNull UArrayAccessExpression expression) {
        PsiElement resolved;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        UExpression arrayExpression = expression.getReceiver();
        if (arrayExpression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arrayExpression).resolve()) instanceof PsiModifierListOwner) {
            JavaEvaluator evaluator = context2.getEvaluator();
            PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)resolved, true);
            List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations, (UElement)expression);
            Collection collection = methodAnnotations;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                this.checkContextAnnotations(context2, null, resolved, (UElement)expression, methodAnnotations, resolved);
            }
        }
    }

    public final void visitVariable(@NotNull JavaContext context2, @NotNull UVariable variable) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        JavaEvaluator evaluator = context2.getEvaluator();
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((UAnnotated)variable, true));
        Collection collection = methodAnnotations;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.checkContextAnnotations(context2, null, null, (UElement)variable, methodAnnotations, (PsiElement)variable);
        }
    }

    private final void checkCall(JavaContext context2, PsiMethod method, UCallExpression call) {
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations, (UElement)call);
        PsiClass containingClass = method.getContainingClass();
        Pair<List<UAnnotation>, List<UAnnotation>> pair = this.getClassAndPkgAnnotations(containingClass, evaluator, (UElement)call);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckCall(context2, method, methodAnnotations, classAnnotations, pkgAnnotations, call, containingClass);
    }

    private final void checkCallUnresolved(JavaContext context2, UCallExpression call) {
        JavaEvaluator evaluator = context2.getEvaluator();
        List<UAnnotation> allAnnotations = evaluator.getAllAnnotations((UAnnotated)call, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations);
        Pair<List<UAnnotation>, List<UAnnotation>> pair = call.getClassReference();
        PsiClass containingClass = (PsiClass)(pair == null ? null : pair.resolve());
        pair = this.getClassAndPkgAnnotations(containingClass, evaluator, (UElement)call);
        List classAnnotations = (List)pair.component1();
        List pkgAnnotations = (List)pair.component2();
        this.doCheckCall(context2, null, methodAnnotations, classAnnotations, pkgAnnotations, call, containingClass);
    }

    private final Pair<List<UAnnotation>, List<UAnnotation>> getClassAndPkgAnnotations(PsiClass containingClass, JavaEvaluator evaluator, UElement context2) {
        List<UAnnotation> classAnnotations = null;
        List pkgAnnotations = null;
        if (containingClass != null) {
            List list2;
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations, context2);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                list2 = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, annotations2, null, 4, null);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            pkgAnnotations = list2;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        return new Pair((Object)classAnnotations, (Object)pkgAnnotations);
    }

    private final void doCheckCall(JavaContext context2, PsiMethod method, List<? extends UAnnotation> methodAnnotations, List<? extends UAnnotation> classAnnotations, List<? extends UAnnotation> pkgAnnotations, UCallExpression call, PsiClass containingClass) {
        boolean bl2;
        Collection collection;
        if (method != null) {
            collection = methodAnnotations;
            bl2 = false;
            if (!collection.isEmpty()) {
                this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL, method, (PsiElement)method, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)method);
                this.checkContextAnnotations(context2, method, (PsiElement)method, (UElement)call, methodAnnotations, (PsiElement)method);
            }
        }
        if (containingClass != null) {
            collection = classAnnotations;
            bl2 = false;
            if (!collection.isEmpty()) {
                this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL_CLASS, method, (PsiElement)method, classAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)containingClass);
            }
        }
        collection = pkgAnnotations;
        bl2 = false;
        if (!collection.isEmpty()) {
            this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL_PACKAGE, method, (PsiElement)method, pkgAnnotations, methodAnnotations, classAnnotations, pkgAnnotations, null);
        }
        if (method != null) {
            JavaEvaluator evaluator = context2.getEvaluator();
            Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping(call, method);
            Object object = mapping;
            boolean bl3 = false;
            Iterator<Map.Entry<UExpression, PsiParameter>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl4 = false;
                UExpression argument = (UExpression)object2.getKey();
                Object object3 = object;
                boolean bl5 = false;
                PsiParameter parameter = (PsiParameter)object3.getValue();
                PsiAnnotation[] allParameterAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)parameter, true);
                List<UAnnotation> filtered = this.filterRelevantAnnotations(evaluator, allParameterAnnotations, (UElement)call);
                if (filtered.isEmpty()) continue;
                this.checkAnnotations(context2, (UElement)argument, AnnotationUsageType.METHOD_CALL_PARAMETER, method, (PsiElement)method, filtered, methodAnnotations, classAnnotations, pkgAnnotations, (PsiElement)method);
            }
        }
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations, UElement context2) {
        List result2 = null;
        int length = annotations.length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        Object object = annotations;
        int n10 = 0;
        int n11 = ((PsiAnnotation[])object).length;
        while (n10 < n11) {
            PsiAnnotation[] innerAnnotations;
            int n12;
            int n13;
            PsiElement psiElement;
            PsiElement cls;
            PsiElement psiElement2;
            PsiElement psiElement3;
            PsiAnnotation annotation = object[n10];
            ++n10;
            String signature = annotation.getQualifiedName();
            if (signature == null || (StringsKt.startsWith$default((String)signature, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null)) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result2 == null) {
                    result2 = new ArrayList(2);
                }
                result2.add(uAnnotation);
                continue;
            }
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annotation.getNameReferenceElement();
            PsiElement psiElement4 = psiElement3 = psiJavaCodeReferenceElement == null ? null : psiJavaCodeReferenceElement.resolve();
            if (psiElement3 == null) {
                AnnotationHandler annotationHandler = this;
                boolean bl2 = false;
                boolean bl3 = false;
                AnnotationHandler $this$filterRelevantAnnotations_u24lambda_u2d2 = annotationHandler;
                boolean bl4 = false;
                Project project = annotation.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"annotation.project");
                Project project2 = project;
                psiJavaCodeReferenceElement = (PsiElement)JavaPsiFacade.getInstance((Project)project2).findClass(signature, GlobalSearchScope.projectScope((Project)project2));
                if (psiJavaCodeReferenceElement == null) continue;
                psiElement2 = psiJavaCodeReferenceElement;
            } else {
                psiElement2 = psiElement3;
            }
            if (!((cls = (psiElement = psiElement2)) instanceof PsiClass) || !((PsiClass)cls).isAnnotationType() || (n13 = 0) > (n12 = (innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)).length + -1)) continue;
            do {
                int j10;
                PsiAnnotation inner;
                String a10;
                if ((a10 = (inner = innerAnnotations[j10 = n13++]).getQualifiedName()) == null || !this.relevantAnnotations.contains(a10)) continue;
                if (result2 == null) {
                    result2 = new ArrayList(2);
                }
                UAnnotation innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context2);
                result2.add(innerU);
            } while (n13 <= n12);
        }
        object = result2;
        return object == null ? CollectionsKt.emptyList() : object;
    }

    static /* synthetic */ List filterRelevantAnnotations$default(AnnotationHandler annotationHandler, JavaEvaluator javaEvaluator, PsiAnnotation[] psiAnnotationArray, UElement uElement, int n10, Object object) {
        if ((n10 & 4) != 0) {
            uElement = null;
        }
        return annotationHandler.filterRelevantAnnotations(javaEvaluator, psiAnnotationArray, uElement);
    }

    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, List<? extends UAnnotation> annotations) {
        List result2 = null;
        int length = annotations.size();
        if (length == 0) {
            return annotations;
        }
        for (UAnnotation annotation : annotations) {
            PsiAnnotation[] innerAnnotations;
            int n10;
            int n11;
            String signature = annotation.getQualifiedName();
            if (signature == null || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                if (length == 1) {
                    return annotations;
                }
                if (result2 == null) {
                    result2 = new ArrayList(2);
                }
                result2.add(annotation);
                continue;
            }
            PsiClass cls = annotation.resolve();
            if (cls == null || !cls.isAnnotationType() || (n11 = 0) > (n10 = (innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)).length + -1)) continue;
            do {
                int j10;
                PsiAnnotation inner;
                String a10;
                if ((a10 = (inner = innerAnnotations[j10 = n11++]).getQualifiedName()) == null || !this.relevantAnnotations.contains(a10)) continue;
                if (result2 == null) {
                    result2 = new ArrayList(2);
                }
                UAnnotation innerU = AnnotationLookup.findRealAnnotation$default(this.annotationLookup, inner, cls, null, 4, null);
                result2.add(innerU);
            } while (n11 <= n10);
        }
        List list2 = result2;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }
}

