/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

@Beta
public class Implementation {
    private final Class<? extends Detector> detectorClass;
    private final EnumSet<Scope> scope;
    private final EnumSet<Scope>[] analysisScopes;
    private static final EnumSet<Scope>[] EMPTY = new EnumSet[0];

    public Implementation(Class<? extends Detector> detectorClass, EnumSet<Scope> scope) {
        this(detectorClass, scope, EMPTY);
    }

    @SafeVarargs
    public Implementation(Class<? extends Detector> detectorClass, EnumSet<Scope> scope, EnumSet<Scope> ... analysisScopes) {
        this.detectorClass = detectorClass;
        this.scope = scope;
        this.analysisScopes = analysisScopes;
    }

    public Class<? extends Detector> getDetectorClass() {
        return this.detectorClass;
    }

    public String toString() {
        return this.detectorClass.toString();
    }

    public EnumSet<Scope> getScope() {
        return this.scope;
    }

    public EnumSet<Scope>[] getAnalysisScopes() {
        return this.analysisScopes;
    }

    public boolean isAdequate(EnumSet<Scope> scope) {
        if (scope.containsAll(this.scope)) {
            return true;
        }
        if (this.analysisScopes != null) {
            for (EnumSet<Scope> analysisScope : this.analysisScopes) {
                if (!scope.containsAll(analysisScope)) continue;
                return true;
            }
        }
        return this.scope.size() == scope.size() + 1 && !scope.contains((Object)Scope.TEST_SOURCES) && this.scope.contains((Object)Scope.TEST_SOURCES);
    }
}

