/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import com.android.tools.lint.detector.api.interprocedural.ClassHierarchy;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluator;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluatorKt;
import com.android.tools.lint.detector.api.interprocedural.MutableCallGraph;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u0018H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "receiverEval", "Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;", "classHierarchy", "Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;", "conservative", "", "(Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;Z)V", "callGraph", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "getCallGraph", "()Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "mutableCallGraph", "Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph;", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lorg/jetbrains/uast/UElement;", "constructors", "", "Lorg/jetbrains/uast/UMethod;", "isCallable", "isStaticallyDispatched", "ExplicitSuperConstructorCallFinder", "android.sdktools.lint-api"})
public final class CallGraphVisitor
extends AbstractUastVisitor {
    @NotNull
    private final DispatchReceiverEvaluator receiverEval;
    @NotNull
    private final ClassHierarchy classHierarchy;
    private final boolean conservative;
    @NotNull
    private final MutableCallGraph mutableCallGraph;

    public CallGraphVisitor(@NotNull DispatchReceiverEvaluator receiverEval, @NotNull ClassHierarchy classHierarchy, boolean conservative) {
        Intrinsics.checkParameterIsNotNull((Object)receiverEval, (String)"receiverEval");
        Intrinsics.checkParameterIsNotNull((Object)classHierarchy, (String)"classHierarchy");
        this.receiverEval = receiverEval;
        this.classHierarchy = classHierarchy;
        this.conservative = conservative;
        this.mutableCallGraph = new MutableCallGraph();
    }

    public /* synthetic */ CallGraphVisitor(DispatchReceiverEvaluator dispatchReceiverEvaluator, ClassHierarchy classHierarchy, boolean bl2, int n10, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n10 & 4) != 0) {
            bl2 = false;
        }
        this(dispatchReceiverEvaluator, classHierarchy, bl2);
    }

    @NotNull
    public final CallGraph getCallGraph() {
        return this.mutableCallGraph;
    }

    public boolean visitElement(@NotNull UElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UElement uElement = node;
        if (uElement instanceof UMethod ? true : uElement instanceof ULambdaExpression) {
            this.mutableCallGraph.getNode(node);
        }
        return super.visitElement(node);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitClass(@NotNull UClass node) {
        PsiClass psiClass;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UClass uClass = node.getSuperClass();
        PsiElement $this$toUElementOfType$iv = uClass == null ? null : ((psiClass = uClass.getJavaPsi()) == null ? null : psiClass.getNavigationElement());
        boolean $i$f$toUElementOfType = false;
        UClass superClass = (UClass)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UClass.class);
        if (superClass != null) {
            Object v02;
            boolean bl2;
            Collection callers;
            block4: {
                Object it2;
                void $this$filterTo$iv$iv;
                List<UMethod> constructors = this.constructors(node);
                Iterable $this$filter$iv = constructors;
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (UMethod)element$iv$iv;
                    boolean bl3 = false;
                    ExplicitSuperConstructorCallFinder explicitSuperFinder = new ExplicitSuperConstructorCallFinder();
                    it2.accept((UastVisitor)explicitSuperFinder);
                    if (!(!explicitSuperFinder.getFoundExplicitCall())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List thoseWithoutExplicitSuper = (List)destination$iv$iv;
                Collection $i$f$filter22 = constructors;
                boolean bl4 = false;
                callers = !$i$f$filter22.isEmpty() ? (Collection)thoseWithoutExplicitSuper : (Collection)CollectionsKt.listOf((Object)node);
                Iterable iterable2 = this.constructors(superClass);
                bl2 = false;
                Iterable iterable3 = iterable2;
                boolean element$iv$iv = false;
                it2 = iterable3.iterator();
                while (it2.hasNext()) {
                    Object bl3 = it2.next();
                    UMethod it3 = (UMethod)bl3;
                    boolean bl5 = false;
                    if (!it3.getUastParameters().isEmpty()) continue;
                    v02 = bl3;
                    break block4;
                }
                v02 = null;
            }
            Object object = v02;
            UElement callee = object == null ? (UElement)superClass : (UElement)object;
            object = this.mutableCallGraph;
            boolean bl6 = false;
            bl2 = false;
            Object $this$visitClass_u24lambda_u2d3 = object;
            boolean bl7 = false;
            MutableCallGraph.MutableNode calleeNode = ((MutableCallGraph)$this$visitClass_u24lambda_u2d3).getNode(callee);
            Iterable $this$forEach$iv = callers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UElement it4 = (UElement)element$iv;
                boolean bl8 = false;
                ((MutableCallGraph)$this$visitClass_u24lambda_u2d3).getNode(it4).getEdges().add(new CallGraph.Edge(calleeNode, null, CallGraph.Edge.Kind.DIRECT));
            }
        }
        return super.visitClass(node);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Object v22;
        Object it2;
        boolean isFunctionalCall;
        boolean throughSuper;
        boolean staticallyDispatched;
        List overrides;
        UMethod baseCallee;
        List callerNodes;
        MutableCallGraph.MutableNode mutableNode;
        Collection collection;
        block27: {
            void $this$mapTo$iv$iv;
            List ctors;
            Collection collection2;
            UAnnotated parent;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Class[] classArray = new Class[]{ULambdaExpression.class, UClassInitializer.class, UField.class};
            UAnnotated uAnnotated = parent = (UAnnotated)UastUtils.getParentOfType((UElement)((UElement)node), (boolean)true, UMethod.class, (Class[])classArray);
            if (uAnnotated instanceof UMethod ? true : uAnnotated instanceof ULambdaExpression) {
                collection2 = CollectionsKt.listOf((Object)parent);
            } else if (uAnnotated instanceof UClassInitializer ? true : uAnnotated instanceof UField) {
                if (parent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UDeclaration");
                }
                UDeclaration decl = (UDeclaration)parent;
                if (decl.isStatic()) {
                    return super.visitCallExpression(node);
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)decl));
                if (uClass == null) {
                    return super.visitCallExpression(node);
                }
                UClass containingClass = uClass;
                ctors = this.constructors(containingClass);
                Collection collection3 = ctors;
                boolean bl2 = false;
                collection2 = !collection3.isEmpty() ? ctors : CollectionsKt.listOf((Object)containingClass);
            } else {
                return super.visitCallExpression(node);
            }
            Collection callers = collection2;
            List $this$map$iv = (List)callers;
            boolean $i$f$map = false;
            ctors = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            PsiElement psiElement = $this$mapTo$iv$iv.iterator();
            while (psiElement.hasNext()) {
                void it3;
                Object item$iv$iv = psiElement.next();
                UElement uElement = (UElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                mutableNode = this.mutableCallGraph.getNode((UElement)it3);
                collection.add(mutableNode);
            }
            callerNodes = (List)destination$iv$iv;
            PsiElement $this$toUElementOfType$iv = (PsiElement)node.resolve();
            boolean $i$f$toUElementOfType = false;
            baseCallee = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (baseCallee == null) {
                if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    UReferenceExpression $i$f$mapTo2 = node.getClassReference();
                    destination$iv$iv = UastContextKt.toUElement($i$f$mapTo2 == null ? null : ((psiElement = $i$f$mapTo2.resolve()) == null ? null : psiElement.getNavigationElement()));
                    UClass uClass = $i$f$toUElementOfType = destination$iv$iv instanceof UClass ? (UClass)destination$iv$iv : null;
                    if ($i$f$toUElementOfType == null) {
                        return super.visitCallExpression(node);
                    }
                    UClass constructedClass = $i$f$toUElementOfType;
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)constructedClass, CallGraph.Edge.Kind.DIRECT);
                } else if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"invoke")) {
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, null, CallGraph.Edge.Kind.INVOKE);
                    Iterable $this$forEach$iv = DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CallTarget it4 = (CallTarget)element$iv;
                        boolean bl4 = false;
                        CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, it4.getElement(), CallGraph.Edge.Kind.TYPE_EVIDENCED);
                    }
                }
                return super.visitCallExpression(node);
            }
            overrides = SequencesKt.toList(this.classHierarchy.allOverridesOf(baseCallee));
            staticallyDispatched = this.isStaticallyDispatched(baseCallee);
            throughSuper = node.getReceiver() instanceof USuperExpression;
            isFunctionalCall = Intrinsics.areEqual((Object)baseCallee.getJavaPsi(), (Object)LambdaUtil.getFunctionalInterfaceMethod((PsiType)node.getReceiverType()));
            Iterable $this$singleOrNull$iv = CollectionsKt.plus((Collection)overrides, (Object)baseCallee);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                it2 = (UMethod)element$iv;
                boolean bl5 = false;
                if (!this.isCallable((UMethod)it2)) continue;
                if (found$iv) {
                    v22 = null;
                    break block27;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v22 = !found$iv ? null : single$iv;
        }
        UMethod uniqueImpl = v22;
        if (staticallyDispatched || throughSuper) {
            CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.DIRECT);
        } else if (uniqueImpl != null && !isFunctionalCall) {
            if (!Intrinsics.areEqual((Object)uniqueImpl, (Object)baseCallee)) {
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)uniqueImpl, CallGraph.Edge.Kind.UNIQUE);
        } else {
            UMethod it5;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
            boolean $i$f$map = false;
            Iterable found$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            it2 = $this$mapTo$iv$iv.iterator();
            while (it2.hasNext()) {
                Object item$iv$iv = it2.next();
                CallTarget callTarget = (CallTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                mutableNode = it5.getElement();
                collection.add(mutableNode);
            }
            List evidencedTargets = (List)destination$iv$iv;
            Iterable $this$forEach$iv = evidencedTargets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UElement it6 = (UElement)element$iv;
                boolean bl7 = false;
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, it6, CallGraph.Edge.Kind.TYPE_EVIDENCED);
            }
            if (!evidencedTargets.contains(baseCallee)) {
                CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            if (this.conservative) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$forEach$iv = overrides;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it5 = (UMethod)element$iv$iv;
                    boolean bl8 = false;
                    if (!(!evidencedTargets.contains(it5) && this.isCallable(it5))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UMethod it7 = (UMethod)element$iv;
                    boolean bl9 = false;
                    CallGraphVisitor.visitCallExpression$addEdge(node, callerNodes, this, (UElement)it7, CallGraph.Edge.Kind.NON_UNIQUE_OVERRIDE);
                }
            }
        }
        return super.visitCallExpression(node);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UMethod> constructors(UClass $this$constructors) {
        void $this$filterTo$iv$iv;
        UMethod[] $this$filter$iv = $this$constructors.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n10 = ((void)var7_7).length;
        for (int i10 = 0; i10 < n10; ++i10) {
            void element$iv$iv;
            void it2 = element$iv$iv = var7_7[i10];
            boolean bl2 = false;
            if (!it2.isConstructor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isCallable(UMethod $this$isCallable) {
        PsiClass psiClass;
        return $this$isCallable.getJavaPsi().hasModifierProperty("abstract") ? false : (((psiClass = $this$isCallable.getJavaPsi().getContainingClass()) == null ? false : psiClass.isInterface()) ? $this$isCallable.getJavaPsi().hasModifierProperty("default") : true);
    }

    private final boolean isStaticallyDispatched(UMethod $this$isStaticallyDispatched) {
        PsiClass psiClass;
        PsiClass psiClass2 = $this$isStaticallyDispatched.getJavaPsi().getContainingClass();
        if (psiClass2 == null) {
            return true;
        }
        PsiClass parentClass = psiClass = psiClass2;
        return $this$isStaticallyDispatched.isConstructor() || $this$isStaticallyDispatched.isStatic() || $this$isStaticallyDispatched.isFinal() || $this$isStaticallyDispatched.getVisibility() == UastVisibility.PRIVATE || parentClass instanceof PsiAnonymousClass || parentClass.hasModifierProperty("final");
    }

    private static final void visitCallExpression$addEdge(UCallExpression $node, List<MutableCallGraph.MutableNode> callerNodes, CallGraphVisitor this$0, UElement callee, CallGraph.Edge.Kind kind) {
        MutableCallGraph.MutableNode mutableNode;
        UElement uElement = callee;
        if (uElement == null) {
            mutableNode = null;
        } else {
            UElement uElement2 = uElement;
            boolean bl2 = false;
            boolean bl3 = false;
            UElement it2 = uElement2;
            boolean bl4 = false;
            mutableNode = this$0.mutableCallGraph.getNode(it2);
        }
        MutableCallGraph.MutableNode calleeNode = mutableNode;
        CallGraph.Edge edge = new CallGraph.Edge(calleeNode, $node, kind);
        Iterable $this$forEach$iv = callerNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableCallGraph.MutableNode it3 = (MutableCallGraph.MutableNode)element$iv;
            boolean bl5 = false;
            it3.getEdges().add(edge);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor$ExplicitSuperConstructorCallFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "()V", "foundExplicitCall", "", "getFoundExplicitCall", "()Z", "setFoundExplicitCall", "(Z)V", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "android.sdktools.lint-api"})
    private static final class ExplicitSuperConstructorCallFinder
    extends AbstractUastVisitor {
        private boolean foundExplicitCall;

        public final boolean getFoundExplicitCall() {
            return this.foundExplicitCall;
        }

        public final void setFoundExplicitCall(boolean bl2) {
            this.foundExplicitCall = bl2;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"super")) {
                this.foundExplicitCall = true;
                bl2 = true;
            } else {
                bl2 = false;
            }
            return bl2;
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return true;
        }
    }
}

